/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depretask;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.depretask.DepreSplitResult;
import kd.fi.fa.business.enums.SplitMode;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.common.util.Fa;

public class DepreSplitDetailUtils {
    protected static final String ALGOKEY = "DepreSplitDetailUtils";
    private static final String DEPRESPLITSCHEME = "fa_depresplitschema";
    private static final BigDecimal HUNDRED = new BigDecimal(100);

    protected static void genDepreDetailCards(Long orgId, Long depreUseId, Long periodId, DynamicObject assetBook, Set<Long> realCardIds, Long splitSumId, SortedMap<String, String> dimSumFields, SortedMap<String, String> dimDetailFields, String dimSumSql, String dimDetailSql, String schemaSql, List<String> schemaFields, boolean generaSum, DepreSplitResult depreSplitResult, String billno, boolean reGenerateAll, boolean generateAll, boolean splitSchemaChanged, Set<Long> reverseSumIds, SplitMode splitMode, Set<Long> splitSumIds) {
        String dimSql;
        DynamicObject dyCurrency = assetBook.getDynamicObject("basecurrency");
        int amtPrecision = dyCurrency == null ? 2 : dyCurrency.getInt("amtprecision");
        SortedMap<String, String> dimFields = generaSum ? dimSumFields : dimDetailFields;
        String string = dimSql = generaSum ? dimSumSql : dimDetailSql;
        if (splitMode.name().equals(SplitMode.DELEINCOUCHER.name())) {
            if (generaSum) {
                DepreSplitDetailUtils.onlyDetail(orgId, depreUseId, periodId, assetBook, splitSumId, realCardIds, dimFields, dimSql, schemaSql, schemaFields, depreSplitResult, billno, amtPrecision, reGenerateAll, generateAll, generaSum, splitSchemaChanged, reverseSumIds, splitMode);
            } else {
                for (Long tempSplitSumId : splitSumIds) {
                    DepreSplitDetailUtils.onlyDetail(orgId, depreUseId, periodId, assetBook, tempSplitSumId, realCardIds, dimFields, dimSql, schemaSql, schemaFields, depreSplitResult, billno, amtPrecision, reGenerateAll, generateAll, generaSum, splitSchemaChanged, reverseSumIds, splitMode);
                }
            }
        } else {
            DepreSplitDetailUtils.onlyDetail(orgId, depreUseId, periodId, assetBook, splitSumId, realCardIds, dimFields, dimSql, schemaSql, schemaFields, depreSplitResult, billno, amtPrecision, reGenerateAll, generateAll, generaSum, splitSchemaChanged, reverseSumIds, splitMode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void onlyDetail(Long orgId, Long depreUseId, Long periodId, DynamicObject assetBook, Long splitSumId, Set<Long> realCardIds, SortedMap<String, String> dimFields, String dimSql, String schemaSql, List<String> schemaFields, DepreSplitResult depreSplitResult, String billno, int amtPrecision, boolean reGenerateAll, boolean generateAll, boolean generaSum, boolean splitSchemaChanged, Set<Long> reverseSumIds, SplitMode splitMode) {
        Serializable orgdutyMap;
        Row rowData;
        Object prevEntry;
        Throwable sb;
        Long reversesplitdetailid;
        DataSet finDS;
        SqlBuilder sbSql;
        HashSet<Long> reversesplitdetailidSet;
        HashSet<Long> detailIds;
        BigDecimal oldTotalAmount = BigDecimal.ZERO;
        BigDecimal newTotalAmount = BigDecimal.ZERO;
        SqlBuilder queryRealMasterSql = new SqlBuilder();
        queryRealMasterSql.append("SELECT fid,fmasterid ", new Object[0]);
        queryRealMasterSql.append("FROM t_fa_card_real WHERE ", new Object[0]);
        queryRealMasterSql.appendIn("fid", realCardIds.toArray());
        try (DataSet dsReal = DB.queryDataSet((String)"DepreSplitDetailUtilsgetCanReverseSplitDetails_fa_card_real_Master", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryRealMasterSql);){
            for (Row rowReal : dsReal) {
                realCardIds.add(rowReal.getLong("fmasterid"));
            }
        }
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfDepreuse = new QFilter("depreuse", "=", (Object)depreUseId);
        QFilter qfPeriod = new QFilter("period", "=", (Object)periodId);
        QFilter qfRealCard = new QFilter("realcard", "in", realCardIds);
        HashMap<Long, Long> allRealId2MasterIDMap = new HashMap<Long, Long>(realCardIds.size() * 2);
        if (!generaSum) {
            SqlBuilder queryRealSql = new SqlBuilder();
            queryRealSql.append("SELECT fid,fmasterid ", new Object[0]);
            queryRealSql.append("FROM t_fa_card_real WHERE ", new Object[0]);
            queryRealSql.appendIn("fmasterid", realCardIds.toArray());
            try (DataSet dsReal = DB.queryDataSet((String)"DepreSplitDetailUtilsgetCanReverseSplitDetails_fa_card_real", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryRealSql);){
                for (Object rowReal : dsReal) {
                    Long realId = rowReal.getLong("fid");
                    Long masterid = rowReal.getLong("fmasterid");
                    allRealId2MasterIDMap.put(realId, masterid);
                }
            }
        }
        for (Long realId : realCardIds) {
            if (allRealId2MasterIDMap.get(realId) != null) continue;
            allRealId2MasterIDMap.put(realId, realId);
        }
        if (reGenerateAll || generateAll || splitSchemaChanged) {
            if (generaSum) {
                DeleteServiceHelper.delete((String)"fa_depresplitdetail", (QFilter[])new QFilter[]{qfOrg, qfDepreuse, qfPeriod, qfRealCard});
            } else {
                Object rowReal;
                detailIds = new HashSet<Long>(1000);
                reversesplitdetailidSet = new HashSet<Long>(1000);
                sbSql = new SqlBuilder();
                sbSql.append("SELECT fdetailsid detailsid,fsplitamount splitamount,freversesplitdetailid FROM t_fa_depredetailentry WHERE ", new Object[0]).append("fid = ? ", new Object[]{splitSumId}).appendIn(" and frealcardid ", allRealId2MasterIDMap.keySet().toArray());
                finDS = DB.queryDataSet((String)"querySplitDetailEntry", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbSql);
                rowReal = null;
                try {
                    for (Row row3 : finDS) {
                        detailIds.add(row3.getLong("detailsid"));
                        oldTotalAmount = oldTotalAmount.add(row3.getBigDecimal("splitamount"));
                        reversesplitdetailid = row3.getLong("freversesplitdetailid");
                        if (reversesplitdetailid == 0L) continue;
                        reversesplitdetailidSet.add(reversesplitdetailid);
                    }
                }
                catch (Throwable realId) {
                    rowReal = realId;
                    throw realId;
                }
                finally {
                    if (finDS != null) {
                        if (rowReal != null) {
                            try {
                                finDS.close();
                            }
                            catch (Throwable realId) {
                                ((Throwable)rowReal).addSuppressed(realId);
                            }
                        } else {
                            finDS.close();
                        }
                    }
                }
                if (detailIds.size() > 0) {
                    depreSplitResult.addAmount(oldTotalAmount.negate());
                    QFilter[] deleteFilteres = new QFilter[]{new QFilter("id", "in", (Object)detailIds.toArray())};
                    DeleteServiceHelper.delete((String)"fa_depresplitdetail", (QFilter[])deleteFilteres);
                }
                if (reversesplitdetailidSet.size() > 0) {
                    sb = new SqlBuilder();
                    sb.append("update t_fa_depredetailentry set ", new Object[0]).append("fisreversesd = '0' ", new Object[0]).append(" where ", new Object[0]).appendIn("fdetailsid", reversesplitdetailidSet.toArray());
                    DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
                }
            }
        } else {
            Object row22;
            detailIds = new HashSet(realCardIds.size(), 1.0f);
            if (generaSum) {
                ArrayList<QFilter> detailFilteres = new ArrayList<QFilter>(3);
                detailFilteres.add(qfOrg);
                detailFilteres.add(qfDepreuse);
                detailFilteres.add(qfPeriod);
                detailFilteres.add(qfRealCard);
                sb = null;
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"fa_depresplitdetail", (String)"id, assentry.splitamount amount", (QFilter[])detailFilteres.toArray(new QFilter[1]), null);){
                    while (ds.hasNext()) {
                        row22 = ds.next();
                        detailIds.add(row22.getLong("id"));
                        BigDecimal amount = row22.getBigDecimal("amount") == null ? BigDecimal.ZERO : row22.getBigDecimal("amount");
                        oldTotalAmount = oldTotalAmount.add(amount);
                    }
                }
                catch (Throwable row22) {
                    sb = row22;
                    throw row22;
                }
            }
            reversesplitdetailidSet = new HashSet(1000);
            sbSql = new SqlBuilder();
            sbSql.append("SELECT fdetailsid detailsid,fsplitamount splitamount,freversesplitdetailid FROM t_fa_depredetailentry WHERE ", new Object[0]).append("fid = ? ", new Object[]{splitSumId}).appendIn(" and frealcardid ", allRealId2MasterIDMap.keySet().toArray());
            finDS = DB.queryDataSet((String)"querySplitDetailEntry", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbSql);
            row22 = null;
            try {
                for (Row row : finDS) {
                    detailIds.add(row.getLong("detailsid"));
                    oldTotalAmount = oldTotalAmount.add(row.getBigDecimal("splitamount"));
                    reversesplitdetailid = row.getLong("freversesplitdetailid");
                    if (reversesplitdetailid == 0L) continue;
                    reversesplitdetailidSet.add(reversesplitdetailid);
                }
            }
            catch (Throwable amount) {
                row22 = amount;
                throw amount;
            }
            finally {
                if (finDS != null) {
                    if (row22 != null) {
                        try {
                            finDS.close();
                        }
                        catch (Throwable amount) {
                            ((Throwable)row22).addSuppressed(amount);
                        }
                    } else {
                        finDS.close();
                    }
                }
            }
            if (reversesplitdetailidSet.size() > 0) {
                sb = new SqlBuilder();
                sb.append("update t_fa_depredetailentry set ", new Object[0]).append("fisreversesd = '0' ", new Object[0]).append(" where ", new Object[0]).appendIn("fdetailsid", reversesplitdetailidSet.toArray());
                DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
            }
            if (detailIds.size() > 0) {
                depreSplitResult.addAmount(oldTotalAmount.negate());
                DeleteServiceHelper.delete((String)"fa_depresplitdetail", (QFilter[])new QFilter("id", "in", detailIds).toArray());
            }
        }
        HashSet<Long> setupRealCardIds = new HashSet<Long>(50);
        DynamicObject depreSplitDetail = null;
        StringBuilder speSQL = new StringBuilder();
        if (StringUtils.isNotEmpty((String)dimSql)) {
            speSQL.append(",").append(dimSql);
        }
        if (StringUtils.isNotEmpty((String)schemaSql)) {
            speSQL.append(",").append(schemaSql);
        }
        StringBuilder querySql = new StringBuilder("SELECT T3.FID REALCARDID,T3.fmasterid REALCARDMASTERID,T3.FASSETCATID,T4.FID FINCARDID");
        querySql.append(",T3.FHEADUSEDEPTID,T2.FORGDUTYID,T2.FASSINFO,T2.FPERCENT,T4.FMONTHDEPRE,T1.FSTATUS SETUPSTATUS");
        querySql.append((CharSequence)speSQL);
        querySql.append(" FROM T_FA_DEPRESPLITSETUP T1 ");
        querySql.append("INNER JOIN T_FA_DEPRESPLITENTRY T2 ON T1.FID=T2.FID ");
        querySql.append("INNER JOIN T_FA_CARD_REAL T3 ON T1.FREALCARDID=T3.FMASTERID ");
        querySql.append("INNER JOIN T_FA_CARD_FIN T4 ON T3.FID=T4.FREALCARDID ");
        querySql.append("WHERE (T1.FSTATUS IS NULL OR T1.FORGID = ? AND T1.FDEPREUSEID= ? AND T1.FBEGINPERIODID <= ? AND T1.FENDPERIODID > ?) ");
        querySql.append("AND T4.FORG= ? AND T4.FDEPREUSEID= ? AND T4.FBIZPERIODID = ? AND T4.FENDPERIODID > ? AND T1.FSTATUS = 'C' ");
        StringBuilder inSb = new StringBuilder();
        inSb.append(" AND T3.FMASTERID in (");
        for (int count = 0; count < realCardIds.size() - 1; ++count) {
            inSb.append("?").append(",");
        }
        inSb.append("?) ");
        querySql.append((CharSequence)inSb).append(" ORDER BY T3.FID, T2.FSEQ ASC");
        StringBuilder sb2 = new StringBuilder(realCardIds.size() * 19);
        ArrayList<Long> params = new ArrayList<Long>(realCardIds.size());
        params.add(orgId);
        params.add(depreUseId);
        params.add(periodId);
        params.add(periodId);
        params.add(orgId);
        params.add(depreUseId);
        params.add(periodId);
        params.add(periodId);
        params.addAll(realCardIds);
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(1000);
        try (DataSet dataSet = DB.queryDataSet((String)"DepreSplitDetailUtilssetupDataSet", (DBRoute)new DBRoute("fa"), (String)querySql.toString(), (Object[])params.toArray(new Object[0]));){
            long prevRealCardId = -999999L;
            BigDecimal monthDepre_left = BigDecimal.ZERO;
            prevEntry = null;
            int seq = 1;
            rowData = null;
            orgdutyMap = new HashMap<Long, Long>(1);
            while (dataSet.hasNext()) {
                rowData = dataSet.next();
                Long finCardId = rowData.getLong("FINCARDID");
                Long realcardId = rowData.getLong("REALCARDMASTERID");
                setupRealCardIds.add(realcardId);
                BigDecimal monthDepre = rowData.getBigDecimal("FMONTHDEPRE");
                if (prevRealCardId != realcardId) {
                    newTotalAmount = newTotalAmount.add(monthDepre);
                    if (monthDepre_left.compareTo(BigDecimal.ZERO) != 0 && prevEntry != null) {
                        prevEntry.set("splitamount", (Object)prevEntry.getBigDecimal("splitamount").add(monthDepre_left));
                    }
                    depreSplitDetail = DepreSplitDetailUtils.newDepreSplitDetail(orgId, depreUseId, periodId, realcardId, finCardId, generaSum ? dimFields : new TreeMap<String, String>(), billno, rowData);
                    monthDepre_left = monthDepre;
                    prevRealCardId = realcardId;
                    detailList.add(depreSplitDetail);
                    seq = 1;
                }
                Object[] newEntry = DepreSplitDetailUtils.buildEntry(splitSumId, depreSplitDetail, prevEntry, rowData, generaSum ? new TreeMap<String, String>() : dimFields, realcardId, finCardId, monthDepre_left, amtPrecision, seq, schemaFields, false, orgdutyMap, generaSum);
                monthDepre_left = (BigDecimal)newEntry[0];
                prevEntry = (DynamicObject)newEntry[1];
                ++seq;
            }
            if (monthDepre_left.compareTo(BigDecimal.ZERO) != 0 && prevEntry != null) {
                prevEntry.set("splitamount", (Object)prevEntry.getBigDecimal("splitamount").add(monthDepre_left));
            }
        }
        HashSet<Long> delSetUpRealCardIds = new HashSet<Long>(realCardIds.size() - setupRealCardIds.size(), 1.0f);
        delSetUpRealCardIds.addAll(realCardIds);
        delSetUpRealCardIds.removeAll(setupRealCardIds);
        if (delSetUpRealCardIds.size() > 0) {
            void var38_64;
            StringBuilder querySchemeSql = new StringBuilder("SELECT T3.FID REALCARDID, T3.FASSETCATID, T4.FID FINCARDID, T4.FMONTHDEPRE, T3.FHEADUSEDEPTID ");
            querySchemeSql.append((CharSequence)speSQL);
            querySchemeSql.append(" FROM T_FA_CARD_REAL T3 ");
            querySchemeSql.append("INNER JOIN T_FA_CARD_FIN T4 ON T3.FID=T4.FREALCARDID ");
            querySchemeSql.append("WHERE T4.FORG = ? AND T4.FDEPREUSEID = ? AND T4.FBIZPERIODID = ? AND T4.FENDPERIODID > ? AND T4.FBILLSTATUS = 'C' ");
            querySchemeSql.append(" AND T3.FMASTERID in (");
            for (int count = 0; count < delSetUpRealCardIds.size() - 1; ++count) {
                querySchemeSql.append("?").append(",");
            }
            querySchemeSql.append("?) ");
            sb2 = new StringBuilder(delSetUpRealCardIds.size() * 19);
            for (Long l : delSetUpRealCardIds) {
                sb2.append(l);
                sb2.append(",");
            }
            if (sb2.length() > 0) {
                sb2.setLength(sb2.length() - 1);
            }
            params = new ArrayList(delSetUpRealCardIds.size() + 4);
            params.add(orgId);
            params.add(depreUseId);
            params.add(periodId);
            params.add(periodId);
            params.addAll(delSetUpRealCardIds);
            StringBuilder getOrgSQL = new StringBuilder("SELECT T3.FHEADUSEDEPTID FROM T_FA_CARD_REAL T3 INNER JOIN T_FA_CARD_FIN T4 ON T3.FID=T4.FREALCARDID WHERE T4.FORG = ? AND T4.FDEPREUSEID = ? AND T4.FBIZPERIODID = ? AND T4.FENDPERIODID > ?  ");
            getOrgSQL.append(" AND T3.FMASTERID in (");
            boolean bl = false;
            while (var38_64 < delSetUpRealCardIds.size() - 1) {
                getOrgSQL.append("?").append(",");
                ++var38_64;
            }
            getOrgSQL.append("?) ");
            sb2 = new StringBuilder(delSetUpRealCardIds.size() * 19);
            for (Long p : delSetUpRealCardIds) {
                sb2.append(p);
                sb2.append(",");
            }
            if (sb2.length() > 0) {
                sb2.setLength(sb2.length() - 1);
            }
            HashSet<Long> hashSet = new HashSet<Long>();
            DataSet dataSet = DB.queryDataSet((String)"DepreSplitDetailUtilsnosetupDataSet", (DBRoute)new DBRoute("fa"), (String)getOrgSQL.toString(), (Object[])params.toArray(new Object[0]));
            prevEntry = null;
            try {
                GroupbyDataSet ds = dataSet.groupBy(new String[]{"FHEADUSEDEPTID"});
                DataSet ds2 = ds.finish();
                orgdutyMap = null;
                try {
                    while (ds2.hasNext()) {
                        hashSet.add(ds2.next().getLong("FHEADUSEDEPTID"));
                    }
                }
                catch (Throwable finCardId) {
                    orgdutyMap = finCardId;
                    throw finCardId;
                }
                finally {
                    if (ds2 != null) {
                        if (orgdutyMap != null) {
                            try {
                                ds2.close();
                            }
                            catch (Throwable finCardId) {
                                ((Throwable)orgdutyMap).addSuppressed(finCardId);
                            }
                        } else {
                            ds2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                prevEntry = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (prevEntry != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)prevEntry).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            Map<Long, Long> orgdutyMap2 = DepreSplitDetailUtils.getOrgDuty(hashSet);
            try (DataSet dataSet2 = DB.queryDataSet((String)"DepreSplitDetailUtilsnosetupDataSet", (DBRoute)new DBRoute("fa"), (String)querySchemeSql.toString(), (Object[])params.toArray(new Object[0]));){
                rowData = null;
                while (dataSet2.hasNext()) {
                    rowData = dataSet2.next();
                    Long finCardId = rowData.getLong("FINCARDID");
                    Long realcardId = rowData.getLong("REALCARDID");
                    newTotalAmount = newTotalAmount.add(rowData.getBigDecimal("FMONTHDEPRE"));
                    depreSplitDetail = DepreSplitDetailUtils.newDepreSplitDetail(orgId, depreUseId, periodId, realcardId, finCardId, generaSum ? dimFields : new TreeMap<String, String>(), billno, rowData);
                    detailList.add(depreSplitDetail);
                    DepreSplitDetailUtils.buildEntry(splitSumId, depreSplitDetail, null, rowData, generaSum ? new TreeMap<String, String>() : dimFields, realcardId, finCardId, BigDecimal.ZERO, amtPrecision, 1, schemaFields, true, orgdutyMap2, generaSum);
                }
            }
        }
        if (!generaSum && reverseSumIds.size() > 0 && splitMode.name().equals(SplitMode.DETAILADDREVERSE.name())) {
            BigDecimal reverseTotalAmount = DepreSplitDetailUtils.detailAddReverseList(orgId, depreUseId, periodId, splitSumId, realCardIds, reverseSumIds, detailList, dimFields, allRealId2MasterIDMap);
            newTotalAmount = newTotalAmount.add(reverseTotalAmount);
        }
        ArrayList<DynamicObject> detailList4splitamount0 = new ArrayList<DynamicObject>(16);
        for (DynamicObject dynamicObject : detailList) {
            DynamicObjectCollection detailEntry = dynamicObject.getDynamicObjectCollection("assentry");
            boolean splitamountis0 = true;
            for (DynamicObject detailEntryDo : detailEntry) {
                BigDecimal splitamount = detailEntryDo.getBigDecimal("splitamount");
                if (splitamount.compareTo(BigDecimal.ZERO) == 0) continue;
                splitamountis0 = false;
                break;
            }
            if (!splitamountis0) continue;
            detailList4splitamount0.add(dynamicObject);
        }
        detailList.removeAll(detailList4splitamount0);
        SaveServiceHelper.save((DynamicObject[])detailList.toArray(new DynamicObject[0]));
        if (detailList.size() > 0) {
            HashSet<Long> newReversesdDetailIdSet2 = new HashSet<Long>(16);
            for (DynamicObject detailDy : detailList) {
                Long reversesplitdetailid2 = detailDy.getLong("reversesplitdetailid");
                if (reversesplitdetailid2 == 0L) continue;
                newReversesdDetailIdSet2.add(reversesplitdetailid2);
            }
            if (newReversesdDetailIdSet2.size() > 0) {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("update t_fa_depredetailentry set ", new Object[0]).append("fisreversesd = '1' ", new Object[0]).append(" where ", new Object[0]).appendIn("fdetailsid", newReversesdDetailIdSet2.toArray());
                DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sqlBuilder);
            }
        }
        BigDecimal diffTotalAmount = newTotalAmount.subtract(oldTotalAmount);
        if (!generaSum && diffTotalAmount.compareTo(BigDecimal.ZERO) != 0) {
            String string = "update t_fa_depre set ftotaldepreamount = ftotaldepreamount + " + diffTotalAmount + " where fid = " + splitSumId;
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)string);
        }
        depreSplitResult.addAmount(newTotalAmount);
    }

    private static BigDecimal detailAddReverseList(Long orgId, Long depreUseId, Long periodId, Long splitSumId, Set<Long> realCardIds, Set<Long> reverseSumIds, List<DynamicObject> detailList, SortedMap<String, String> dimFields, Map<Long, Long> allRealId2MasterIDMap) {
        MainEntityType depreSumEntityType = EntityMetadataCache.getDataEntityType((String)"fa_depre_sum");
        if (detailList.size() == 0) {
            return BigDecimal.ZERO;
        }
        Map<Long, List<DynamicObject>> realID2CanReverseDetails = DepreSplitDetailUtils.getCanReverseSplitDetails(orgId, depreUseId, periodId, splitSumId, realCardIds, reverseSumIds, allRealId2MasterIDMap);
        if (realID2CanReverseDetails.size() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal newTotalAmount = BigDecimal.ZERO;
        HashSet<DynamicObject> toReverseDetailList = new HashSet<DynamicObject>(detailList.size());
        HashSet<DynamicObject> toDelNewDetailList = new HashSet<DynamicObject>(detailList.size());
        for (DynamicObject newDetail : detailList) {
            HashMap<String, BigDecimal> newDetailEntryMap = new HashMap<String, BigDecimal>(8, 1.0f);
            DynamicObjectCollection newDetailEntry = newDetail.getDynamicObjectCollection("assentry");
            if (newDetailEntry == null || newDetailEntry.size() == 0) continue;
            for (DynamicObject newDetailEntryDn : newDetailEntry) {
                String orgdutyDoId = "0";
                String orgdutyStr = newDetailEntryDn.getString("orgduty");
                if (orgdutyStr != null) {
                    orgdutyDoId = orgdutyStr;
                }
                String copyassetcatDoId = "0";
                String copyassetcatStr = newDetailEntryDn.getString("copyassetcat");
                if (copyassetcatStr != null) {
                    copyassetcatDoId = copyassetcatStr;
                }
                StringBuilder keySb = new StringBuilder();
                keySb.append(orgdutyDoId).append("_").append(copyassetcatDoId).append("_").append(newDetailEntryDn.getString("assinfo")).append("_");
                for (Map.Entry<String, String> field : dimFields.entrySet()) {
                    Object value = newDetailEntryDn.get(field.getKey());
                    keySb.append(value).append("_");
                }
                String key = keySb.toString();
                BigDecimal splitAmount = newDetailEntryDn.getBigDecimal("splitamount");
                newDetailEntryMap.put(key, splitAmount);
            }
            Long realId = newDetail.getLong("realcard");
            Long masterId = allRealId2MasterIDMap.get(realId);
            List<DynamicObject> needReverseDetails = realID2CanReverseDetails.get(masterId);
            if (needReverseDetails == null || needReverseDetails.size() == 0) continue;
            for (DynamicObject needReverseDetail : needReverseDetails) {
                DynamicObject newReverseDetail = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)needReverseDetail);
                newReverseDetail.set("reversesplitdetailid", (Object)needReverseDetail.getLong("id"));
                newReverseDetail.set("createtime", (Object)new Date());
                newReverseDetail.set("modifytime", (Object)new Date());
                HashMap<String, BigDecimal> newReveseDetailEntryMap = new HashMap<String, BigDecimal>(8, 1.0f);
                DynamicObjectCollection newReveseDetailEntry = newReverseDetail.getDynamicObjectCollection("assentry");
                if (newReveseDetailEntry == null || newReveseDetailEntry.size() == 0) continue;
                for (DynamicObject newReveseDetailEntryDn : newReveseDetailEntry) {
                    BigDecimal negativeSplitAmount = newReveseDetailEntryDn.getBigDecimal("splitamount").negate();
                    newReveseDetailEntryDn.set("splitamount", (Object)negativeSplitAmount);
                    newTotalAmount = newTotalAmount.add(negativeSplitAmount);
                    newReveseDetailEntryDn.set("sumid", (Object)splitSumId);
                    newReveseDetailEntryDn.set("copyreversesplitdetailid", (Object)needReverseDetail.getLong("id"));
                    newReveseDetailEntryDn.set("isreversesd", (Object)Character.valueOf('1'));
                    String orgdutyDoId = "0";
                    String orgdutyStr = newReveseDetailEntryDn.getString("orgduty.id");
                    if (orgdutyStr != null) {
                        orgdutyDoId = orgdutyStr;
                    }
                    String copyassetcatDoId = "0";
                    String copyassetcatStr = newReveseDetailEntryDn.getString("copyassetcat.id");
                    if (copyassetcatStr != null) {
                        copyassetcatDoId = copyassetcatStr;
                    }
                    StringBuilder keySb = new StringBuilder();
                    keySb.append(orgdutyDoId).append("_").append(copyassetcatDoId).append("_").append(newReveseDetailEntryDn.getString("assinfo")).append("_");
                    for (Map.Entry<String, String> field : dimFields.entrySet()) {
                        Object value = null;
                        Map allEntityMap = depreSumEntityType.getAllEntities();
                        EntityType assentryType = (EntityType)allEntityMap.get("assentry");
                        DynamicProperty property = assentryType.getProperty(field.getKey());
                        if (property instanceof BasedataProp) {
                            value = newReveseDetailEntryDn.get(field.getKey() + ".id");
                            if (value == null) {
                                value = 0;
                            }
                        } else {
                            value = newReveseDetailEntryDn.get(field.getKey());
                        }
                        keySb.append(value).append("_");
                    }
                    String key = keySb.toString();
                    newReveseDetailEntryMap.put(key, negativeSplitAmount.negate());
                }
                if (newDetailEntryMap.size() != newReveseDetailEntryMap.size()) {
                    toReverseDetailList.add(newReverseDetail);
                    continue;
                }
                boolean isDelNewDetail = true;
                for (Map.Entry newDetailEntryEntry : newDetailEntryMap.entrySet()) {
                    String key = (String)newDetailEntryEntry.getKey();
                    BigDecimal newDetailEntryEntryValue = (BigDecimal)newDetailEntryEntry.getValue();
                    BigDecimal newReverseDetailEntryEntryValue = (BigDecimal)newReveseDetailEntryMap.get(key);
                    if (newReverseDetailEntryEntryValue == null) {
                        isDelNewDetail = false;
                        break;
                    }
                    if (newDetailEntryEntryValue.compareTo(newReverseDetailEntryEntryValue) == 0) continue;
                    isDelNewDetail = false;
                    break;
                }
                if (isDelNewDetail) {
                    toDelNewDetailList.add(newDetail);
                    continue;
                }
                toReverseDetailList.add(newReverseDetail);
            }
        }
        detailList.addAll(toReverseDetailList);
        detailList.removeAll(toDelNewDetailList);
        return newTotalAmount;
    }

    private static Map<Long, List<DynamicObject>> getCanReverseSplitDetails(Long orgId, Long depreUseId, Long periodId, Long splitSumId, Set<Long> realCardIds, Set<Long> reverseSumIds, Map<Long, Long> allRealId2MasterIDMap) {
        DynamicObject[] canReverseDetails;
        int mapSize = realCardIds.size() == 0 ? 16 : realCardIds.size();
        HashMap<Long, List<DynamicObject>> realID2CanReverseDetails = new HashMap<Long, List<DynamicObject>>(mapSize, 1.0f);
        if (realCardIds == null || realCardIds.size() == 0) {
            return realID2CanReverseDetails;
        }
        String selectDetailRevFields = "id,reversesplitdetailid";
        QFilter[] reverseFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("period", "=", (Object)periodId), new QFilter("realcard", "in", allRealId2MasterIDMap.keySet()), new QFilter("assentry.sumid", "in", reverseSumIds)};
        DynamicObjectCollection detailRevBills = QueryServiceHelper.query((String)"fa_depresplitdetail", (String)selectDetailRevFields, (QFilter[])reverseFilters);
        if (detailRevBills.size() == 0) {
            return realID2CanReverseDetails;
        }
        HashSet<Long> splitDetailidSet = new HashSet<Long>(detailRevBills.size());
        HashSet<Long> reverseDetailidSet = new HashSet<Long>(detailRevBills.size());
        HashSet<Long> reversedSplitDetailidSet = new HashSet<Long>(detailRevBills.size());
        for (DynamicObject detailRev : detailRevBills) {
            Long id = detailRev.getLong("id");
            Long reversesplitdetailid = detailRev.getLong("reversesplitdetailid");
            splitDetailidSet.add(id);
            if (reversesplitdetailid == 0L) continue;
            reverseDetailidSet.add(id);
            reversedSplitDetailidSet.add(reversesplitdetailid);
        }
        splitDetailidSet.removeAll(reverseDetailidSet);
        splitDetailidSet.removeAll(reversedSplitDetailidSet);
        for (DynamicObject splitDetail : canReverseDetails = BusinessDataServiceHelper.load((Object[])splitDetailidSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_depresplitdetail"))) {
            Long realId = splitDetail.getLong("realcard.id");
            Long masterId = allRealId2MasterIDMap.get(realId);
            List<DynamicObject> canReverseDetails2RealId = null;
            if (realID2CanReverseDetails.get(masterId) == null) {
                canReverseDetails2RealId = new ArrayList(2);
                realID2CanReverseDetails.put(masterId, canReverseDetails2RealId);
            } else {
                canReverseDetails2RealId = (List)realID2CanReverseDetails.get(masterId);
            }
            canReverseDetails2RealId.add(splitDetail);
        }
        return realID2CanReverseDetails;
    }

    private static DynamicObject newDepreSplitDetail(long orgId, long depreuseId, long curperiodId, long realcardId, long fincardId, SortedMap<String, String> dimFields, String billno, Row rowData) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_depresplitdetail");
        DynamicObject depreSplitDetail = new DynamicObject((DynamicObjectType)dataEntityType);
        depreSplitDetail.set("org", (Object)orgId);
        depreSplitDetail.set("depreuse", (Object)depreuseId);
        depreSplitDetail.set("period", (Object)curperiodId);
        depreSplitDetail.set("realcard", (Object)realcardId);
        depreSplitDetail.set("fincard", (Object)fincardId);
        depreSplitDetail.set("splitdept", (Object)rowData.getLong("FHEADUSEDEPTID"));
        depreSplitDetail.set("assetcat", (Object)rowData.getLong("FASSETCATID"));
        depreSplitDetail.set("billno", (Object)billno);
        for (Map.Entry<String, String> entry : dimFields.entrySet()) {
            depreSplitDetail.set(entry.getKey(), rowData.get(entry.getValue()));
        }
        return depreSplitDetail;
    }

    private static Object[] buildEntry(long splitSumId, DynamicObject depreSplitDetail, DynamicObject prevEntry, Row rowData, SortedMap<String, String> dimFields, long realcardId, long finCardId, BigDecimal monthDepre_left, int amtPrecision, int seq, List<String> schemaFields, boolean onlyOne, Map<Long, Long> orgdutyMap, boolean generaSum) {
        assert (depreSplitDetail != null);
        DynamicObjectCollection entries = depreSplitDetail.getDynamicObjectCollection("assentry");
        DynamicObject entry = entries.addNew();
        if (!generaSum) {
            entry.set("sumid", (Object)splitSumId);
        }
        entry.set("seq", (Object)seq);
        if (onlyOne) {
            entry.set("orgduty", (Object)orgdutyMap.get(rowData.getLong("FHEADUSEDEPTID")));
        } else {
            entry.set("orgduty", (Object)rowData.getLong("FORGDUTYID"));
        }
        entry.set("copyrealcard", (Object)realcardId);
        entry.set("copyfincard", (Object)finCardId);
        long orgId = depreSplitDetail.getLong("org");
        entry.set("copyorg", (Object)orgId);
        long depreUseId = depreSplitDetail.getLong("depreuse");
        entry.set("copydepreuse", (Object)depreUseId);
        long periodId = depreSplitDetail.getLong("period");
        entry.set("copyperiod", (Object)periodId);
        long assetCatId = depreSplitDetail.getLong("assetcat");
        entry.set("copyassetcat", (Object)assetCatId);
        for (Map.Entry<String, String> entrys : dimFields.entrySet()) {
            entry.set(entrys.getKey(), rowData.get(entrys.getValue()));
        }
        BigDecimal monthDepre = rowData.getBigDecimal("FMONTHDEPRE");
        if (onlyOne) {
            entry.set("percent", (Object)new BigDecimal(100));
            BigDecimal totalSplitAmout = rowData.getBigDecimal("FMONTHDEPRE").setScale(amtPrecision, 4);
            entry.set("splitamount", (Object)totalSplitAmout);
        } else {
            BigDecimal percent = rowData.getBigDecimal("FPERCENT");
            entry.set("percent", (Object)percent);
            BigDecimal splitAmount = monthDepre.multiply(percent).divide(HUNDRED, amtPrecision, RoundingMode.HALF_UP);
            entry.set("splitamount", (Object)splitAmount);
            monthDepre_left = monthDepre_left.subtract(splitAmount);
        }
        DepreSplitDetailUtils.buildSubEntry(entry, rowData, schemaFields, onlyOne);
        prevEntry = entry;
        return new Object[]{monthDepre_left, prevEntry};
    }

    private static Map<Long, Long> getOrgDuty(Set<Long> orgIds) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(orgIds.size(), 1.0f);
        String selectFields = "id,org.id orgId, orgduty.id dutyId";
        QFilter groupFilter = new QFilter("orgduty.group", "=", (Object)1);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{groupFilter, orgFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"faOrgDuty", (String)"bos_org_dutyrelation", (String)selectFields, (QFilter[])filters, null);){
            Row row = null;
            while (ds.hasNext()) {
                row = ds.next();
                map.put(row.getLong("orgId"), row.getLong("dutyId"));
            }
        }
        return map;
    }

    public static DynamicObject priproGet(Long orgId, Long depreUseId) {
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)DEPRESPLITSCHEME, (Long)orgId);
        QFilter[] filters = new QFilter[]{orgFilter, new QFilter("basedatafield", "=", (Object)depreUseId), new QFilter("enable", "=", (Object)true)};
        DynamicObject[] load = BusinessDataServiceHelper.load((String)DEPRESPLITSCHEME, (String)"text,org,number", (QFilter[])filters, (String)"org");
        if (load.length == 0) {
            return null;
        }
        Long parorg = orgId;
        Long masterorg = null;
        ArrayList<Long> orgs = new ArrayList<Long>(load.length);
        for (DynamicObject plan : load) {
            Long tmpOrgId = plan.getLong("org.id");
            if (tmpOrgId - orgId == 0L) {
                return plan;
            }
            orgs.add(tmpOrgId);
        }
        do {
            QFilter f3;
            QFilter f2;
            DynamicObject loadSingle;
            DynamicObject porg;
            if (!orgs.contains(parorg = Long.valueOf((porg = (loadSingle = BusinessDataServiceHelper.loadSingle((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{f2 = new QFilter("view.number", "=", (Object)"10"), f3 = new QFilter("org", "=", (Object)parorg)})) != null ? loadSingle.getDynamicObject("parent") : null) != null ? porg.getLong("id") : 0L))) continue;
            masterorg = parorg;
        } while (parorg != 0L && masterorg == null);
        if (masterorg == null) {
            return load[0];
        }
        DynamicObject os = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DEPRESPLITSCHEME));
        for (DynamicObject entry : load) {
            long cc = entry.getLong("org.id");
            if (cc != masterorg) continue;
            os = entry;
        }
        return os;
    }

    protected static List<String> parsedepreScheme(DynamicObject depreScheme) {
        String[] ss;
        if (depreScheme == null) {
            return null;
        }
        String depreText = depreScheme.getString("text");
        if (depreText == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : ss = depreText.split(";")) {
            String sbr = null;
            String[] cc = s.split(":");
            Long id = cc[0] == null ? 0L : Long.parseLong(cc[0]);
            String[] value = cc[1].split("\\.");
            DynamicObject loadSingle = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"valuetype,valuesource.number,assistanttype.id", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
            if (loadSingle != null) {
                if (loadSingle.get("valuetype").equals("1")) {
                    sbr = loadSingle.getString("valuesource.number") + ":" + value[0] + value[1];
                } else if (loadSingle.get("valuetype").equals("2")) {
                    sbr = loadSingle.getString("assistanttype.id") + ":" + value[0] + value[1];
                }
                if (sbr == null) continue;
                result.add(sbr);
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u644a\u65b9\u6848[%s]\u4e2d\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u3002", (String)"DepreSplitDetailUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), depreScheme.getString("number")));
        }
        return result;
    }

    public static Map<DynamicObject, String> queryDepreSplitSchema(long orgId, long depreUseId) {
        QFilter[] filters;
        HashMap<DynamicObject, String> splitSchemaMap = new HashMap<DynamicObject, String>(10);
        String selectFields = Fa.join((String)",", (String[])new String[]{"text", "org"});
        DynamicObject[] splitSchemaArr = BusinessDataServiceHelper.load((String)DEPRESPLITSCHEME, (String)selectFields, (QFilter[])(filters = new QFilter[]{new QFilter("basedatafield", "=", (Object)depreUseId), BaseDataServiceHelper.getBaseDataFilter((String)DEPRESPLITSCHEME, (Long)orgId)}));
        if (splitSchemaArr == null || splitSchemaArr.length <= 0) {
            return null;
        }
        DynamicObject splitSchema = null;
        for (DynamicObject dynamicObject : splitSchemaArr) {
            DynamicObject org = dynamicObject.getDynamicObject("org");
            if (org.getLong("id") != orgId) continue;
            splitSchema = dynamicObject;
            break;
        }
        if (splitSchema == null) {
            splitSchema = DepreSplitDetailUtils.priproGet(orgId, depreUseId);
        }
        if (splitSchema == null) {
            return splitSchemaMap;
        }
        String text = splitSchema.getString("text");
        String[] assRelationArr = text.split(";");
        HashSet<Long> assIdSet = new HashSet<Long>(assRelationArr.length);
        for (String assRelation : assRelationArr) {
            String[] split = assRelation.split(":");
            assIdSet.add(Long.parseLong(split[0]));
        }
        Map map = BusinessDataServiceHelper.loadFromCache((Object[])assIdSet.toArray(), (String)"bd_asstacttype");
        ArrayList assList = new ArrayList(map.values());
        HashMap assMap = new HashMap(assList.size(), 1.0f);
        assList.forEach(v -> assMap.put(v.getLong("id"), v));
        for (String assRelation : assRelationArr) {
            String[] split = assRelation.split(":");
            String assIdStr = split[0];
            DynamicObject ass = (DynamicObject)assMap.get(Long.parseLong(assIdStr));
            String field = split[1];
            splitSchemaMap.put(ass, field);
        }
        return splitSchemaMap;
    }

    protected static String getDimSql(Map<String, String> dimFieldMap, String alias) {
        Collection<String> fields = dimFieldMap.values();
        return fields.stream().map(v -> String.format("%s.%s %s", alias, v, v)).collect(Collectors.joining(","));
    }

    protected static String getDepreScheme(DynamicObject splitScheme, String realTable, String finTable) {
        String[] ss;
        if (splitScheme == null) {
            return null;
        }
        String text = splitScheme.getString("text");
        if (text == null) {
            return null;
        }
        MainEntityType detfin = EntityMetadataCache.getDataEntityType((String)"fa_card_fin_base");
        MainEntityType detreal = EntityMetadataCache.getDataEntityType((String)"fa_card_real_base");
        StringBuilder params = new StringBuilder();
        for (String s : ss = text.split(";")) {
            String pro;
            String[] kv = s.split(":");
            String[] value = kv[1].split("\\.");
            if (value[0].equals("realcard")) {
                pro = detreal.getProperty(value[1]).getAlias().toUpperCase();
                String rs = realTable + "." + pro + " " + value[0] + value[1] + ",";
                params.append(rs);
                continue;
            }
            if (!value[0].equals("fincard")) continue;
            pro = detfin.getProperty(value[1]).getAlias().toUpperCase();
            String fs = finTable + "." + pro + " " + value[0] + value[1] + ",";
            params.append(fs);
        }
        String str = params.deleteCharAt(params.length() - 1).toString();
        return str;
    }

    private static void buildSubEntry(DynamicObject entry, Row rowData, List<String> schemaFields, boolean onlyOne) {
        String lastChar;
        DynamicObjectCollection subentries = entry.getDynamicObjectCollection("subentryentity");
        subentries.clear();
        if (schemaFields == null) {
            schemaFields = new ArrayList<String>(1);
        }
        String assInfo = "";
        if (!onlyOne) {
            assInfo = rowData.getString("FASSINFO");
        }
        String[] assCol = assInfo.split(";");
        int seq = 1;
        HashSet<String> assTypes = new HashSet<String>();
        long costCenterValue = 0L;
        long productLineValue = 0L;
        for (String ass : assCol) {
            String[] arrass = ass.split("\\|");
            if (arrass.length != 2) continue;
            DynamicObject depreassDy = subentries.addNew();
            depreassDy.set("seq", (Object)seq++);
            depreassDy.set("asstype", (Object)arrass[0]);
            depreassDy.set("assid", (Object)arrass[1]);
            assTypes.add(arrass[0]);
            if ("bos_costcenter".equals(arrass[0])) {
                costCenterValue = Long.parseLong(arrass[1]);
            }
            if (!"bd_productline".equals(arrass[0])) continue;
            productLineValue = Long.parseLong(arrass[1]);
        }
        StringBuilder sb = new StringBuilder();
        String[] types = null;
        for (String field : schemaFields) {
            types = field.split(":");
            if (assTypes.contains(types[0])) continue;
            DynamicObject depreassDy = subentries.addNew();
            depreassDy.set("seq", (Object)seq++);
            depreassDy.set("asstype", (Object)types[0]);
            depreassDy.set("assid", rowData.get(types[1]));
            sb.append(types[0]).append("|").append(rowData.get(types[1])).append(";");
            if ("bos_costcenter".equals(types[0])) {
                costCenterValue = rowData.getLong(types[1]);
            }
            if (!"bd_productline".equals(types[0])) continue;
            productLineValue = rowData.getLong(types[1]);
        }
        sb.append(assInfo);
        int sBlength = sb.length();
        if (sBlength > 1 && (lastChar = sb.substring(sBlength - 1, sBlength)).equals(";")) {
            sb.delete(sBlength - 1, sBlength);
        }
        entry.set("assinfo", (Object)sb.toString());
        entry.set("costcentrer", (Object)costCenterValue);
        entry.set("productline", (Object)productLineValue);
    }

    protected static SortedMap<String, String> getDimFields() {
        TreeMap<String, String> detailDimFields = new TreeMap<String, String>();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        EntityType depreSplitSum = (EntityType)EntityMetadataCache.getDataEntityType((String)"fa_depresplitdetail").getAllEntities().get("assentry");
        if (depreSplitSum != null) {
            Map fields = depreSplitSum.getFields();
            for (String key : fields.keySet()) {
                if (met.getProperty(key) == null) continue;
                DynamicProperty prop = met.getProperty(key);
                detailDimFields.put(prop.getName(), prop.getAlias());
            }
        }
        return detailDimFields;
    }
}

