/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depretask;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ArrayBlockingQueue;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.fa.business.depreciation.ObjectPool;
import kd.fi.fa.business.depretask.DepreSplitDetailUtils;
import kd.fi.fa.business.depretask.DepreSplitResult;
import kd.fi.fa.business.depretask.DepreSplitSumUtils;
import kd.fi.fa.business.depretask.DepreSplitThread;
import kd.fi.fa.business.enums.SplitMode;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaOperationLogUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;

public class DepreSplitTask
implements Serializable {
    private final Log logger = LogFactory.getLog(DepreSplitTask.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"kd.fi.fa.business.depretask.DepreSplitTask", (int)3);
    private static final long serialVersionUID = 5572804628069170149L;
    protected static final String ALGOKEY = "DepreSplitTask";
    private static final int DATA_SIZE = 999;
    private static final String querySql = "SELECT T.frealcardmasterid masterId FROM T_FA_CARD_FIN T WHERE T.FORG = ? AND T.FDEPREUSEID = ? AND T.FENDPERIODID > ? AND T.FBIZPERIODID = ? ";
    private static final String checkSQL = "select top 1 t1.fid from t_fa_depresplitdetail t1 where not exists (select 1 from t_fa_card_fin t2 where t1.ffincardid = t2.fid and t2.forg=? and t2.fdepreuseid=?) and t1.forgid=? and t1.fdepreuseid=? and t1.fperiodid=?";
    protected String version;
    protected boolean generateAll;
    protected boolean reGenerateAll;
    protected boolean splitSchemaChanged = false;
    protected boolean generaSum;
    protected DynamicObject assetBook;
    protected DynamicObject depreSum;
    protected DynamicObject depreSchema;
    protected String schemaSql;
    protected List<String> schemaFields = new ArrayList<String>(5);
    protected Long depreUseId;
    protected Long periodId;
    protected Long orgId;
    protected boolean generateSum;
    protected SortedMap<String, String> sumDimFieldMap;
    protected SortedMap<String, String> detailDimFieldMap;
    protected String dimDetailSql;
    protected String dimSumSql;
    protected DepreSplitResult depreSplitResult;
    protected int finishThreadCount = 0;
    private final long beginTime;
    private int execCount;
    private boolean isFromSplitSetup;
    private Date beginDate;
    private boolean isFromDepre = false;
    private Set<Long> existedVouncherSumIds = new HashSet<Long>(1);
    private Set<Long> unGenVouncherSumIds = new HashSet<Long>(1);
    private boolean existedVouncherNotMulSplit = false;
    private SplitMode splitMode;
    protected Set<Long> splitSumIds = new HashSet<Long>(1);
    protected Set<Long> reverseSumIds = new HashSet<Long>(1);
    private boolean enableSumMutilVoucher = false;
    private boolean enabledisdepre = false;
    private final boolean enablePlatformThreadPool;

    public DepreSplitTask(Long orgId, Long depreUseId, Long periodId, Boolean generateSum, boolean isFromDepre, SplitMode splitMode) {
        this.orgId = orgId;
        this.depreUseId = depreUseId;
        this.periodId = periodId;
        this.generateSum = generateSum;
        this.beginTime = System.currentTimeMillis();
        this.isFromDepre = isFromDepre;
        this.beginDate = new Date();
        this.splitMode = splitMode;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter depreuseFilter = new QFilter("depreuse", "=", (Object)depreUseId);
        this.assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)"id,curperiod.id,basecurrency", (QFilter[])new QFilter[]{orgFilter, depreuseFilter});
        if (this.periodId == null) {
            this.periodId = (Long)this.assetBook.get("curperiod.id");
        }
        this.enablePlatformThreadPool = FaBillParamUtils.getBooleanValue(null, null, null, "enableplatformthreadpool");
        this.enableSumMutilVoucher = SystemParamHelper.getBooleanParam("enable_sum_mutil_voucher", orgId, false);
        if (!this.enableSumMutilVoucher) {
            this.check();
        }
        this.init();
    }

    private void check() {
        if (FaDepreUtil.hasVoucher(this.orgId, this.depreUseId, this.periodId, true)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DepreSplitTask_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    public void execute(Set<Long> realCardIds) {
        if (this.reGenerateAll || this.splitSchemaChanged || this.depreSum == null) {
            this.logger.info(String.format("DepreSplitTask.execute\u8fd4\u56de\uff0c\u539f\u56e0,:reGenerateAll=%s,splitSchemaChanged=%S,depreSum=NULL", this.reGenerateAll, this.splitSchemaChanged));
            return;
        }
        long beginTime = System.currentTimeMillis();
        if (this.isGenerateAll() && realCardIds != null && realCardIds.size() > 0) {
            this.generatePartCards(realCardIds);
        } else if (this.isGenerateAll() || realCardIds == null || realCardIds.size() == 0) {
            this.generateAllCards();
        } else if (!this.isGenerateAll() && realCardIds != null && realCardIds.size() > 0) {
            this.generatePartCards(realCardIds);
        }
        this.logger.info("\u5206\u644a\u6267\u884c\u5230\u7b2c\uff1a" + this.execCount++ + "\u6279\u3002\u8017\u65f6\uff1a" + (System.currentTimeMillis() - beginTime) + "ms");
    }

    public void execute4Repair() {
        this.reGenerateAll = true;
        try (TXHandle tx = TX.requiresNew();){
            try {
                QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
                QFilter depreuseFilter = new QFilter("depreuse", "=", (Object)this.depreUseId);
                QFilter periodFilter = new QFilter("period", "=", (Object)this.periodId);
                DeleteServiceHelper.delete((String)"fa_depresplitdetail", (QFilter[])new QFilter[]{orgFilter, depreuseFilter, periodFilter});
                this.depreSum.set("totaldepreamount", (Object)0L);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.depreSum});
                tx.commit();
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        var2_2 = null;
        try (TXHandle h = TX.required((String)"fa_execute4Repair_close");){
            try {
                this.close();
                h.commit();
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        String params = "DepreSplitTask.execute4Repair -> " + String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7: %1$s, \u6298\u65e7\u7528\u9014\uff1a%2$s, \u671f\u95f4\uff1a%3$s", (String)"DepreSplitTask_1", (String)"fi-fa-business", (Object[])new Object[0]), this.orgId, this.depreUseId, this.periodId);
        FaOperationLogInsertPo insertPo = new FaOperationLogInsertPo(this.orgId, this.depreUseId, this.assetBook.getLong("id"), this.periodId, (Integer)0, "fa_fetchdepredata", params, FaOperationOpTypeEnum.RESPLIT);
        FaOperationLogUtils.insertOperationLog(insertPo, FaOperationStatusEnum.SUCCESS, null);
    }

    public void executeRepair4Muti() {
        this.splitSchemaChanged = true;
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (this.generaSum) {
                    QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
                    QFilter depreuseFilter = new QFilter("depreuse", "=", (Object)this.depreUseId);
                    QFilter periodFilter = new QFilter("period", "=", (Object)this.periodId);
                    DeleteServiceHelper.delete((String)"fa_depresplitdetail", (QFilter[])new QFilter[]{orgFilter, depreuseFilter, periodFilter});
                } else {
                    HashSet<Long> detailIds = new HashSet<Long>(1000);
                    HashSet<Long> reversesplitdetailidSet = new HashSet<Long>(1000);
                    SqlBuilder sbSql = new SqlBuilder();
                    sbSql.append("SELECT fdetailsid detailsid,fsplitamount splitamount,freversesplitdetailid FROM t_fa_depredetailentry WHERE ", new Object[0]).append("fid = ? ", new Object[]{this.depreSum.getLong("id")});
                    try (DataSet finDS = DB.queryDataSet((String)"executeRepair4Muti", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbSql);){
                        for (Row row : finDS) {
                            detailIds.add(row.getLong("detailsid"));
                            Long reversesplitdetailid = row.getLong("freversesplitdetailid");
                            if (reversesplitdetailid == 0L) continue;
                            reversesplitdetailidSet.add(reversesplitdetailid);
                        }
                    }
                    if (detailIds.size() > 0) {
                        QFilter[] deleteFilteres = new QFilter[]{new QFilter("id", "in", (Object)detailIds.toArray())};
                        DeleteServiceHelper.delete((String)"fa_depresplitdetail", (QFilter[])deleteFilteres);
                    }
                    if (reversesplitdetailidSet.size() > 0) {
                        SqlBuilder sb = new SqlBuilder();
                        sb.append("update t_fa_depredetailentry set ", new Object[0]).append("fisreversesd = '0' ", new Object[0]).append(" where ", new Object[0]).appendIn("fdetailsid", reversesplitdetailidSet.toArray());
                        DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
                    }
                }
                this.depreSum.set("totaldepreamount", (Object)0L);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.depreSum});
                tx.commit();
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        var2_2 = null;
        try (TXHandle h = TX.required((String)"fa_execute4Repair_close");){
            try {
                this.close();
                h.commit();
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        String params = "DepreSplitTask.executeRepair4Muti -> " + String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7: %1$s, \u6298\u65e7\u7528\u9014\uff1a%2$s, \u671f\u95f4\uff1a%3$s", (String)"DepreSplitTask_1", (String)"fi-fa-business", (Object[])new Object[0]), this.orgId, this.depreUseId, this.periodId);
        FaOperationLogInsertPo insertPo = new FaOperationLogInsertPo(this.orgId, this.depreUseId, this.assetBook.getLong("id"), this.periodId, (Integer)0, "fa_fetchdepredata", params, FaOperationOpTypeEnum.LATESTDEPRERESPLIT);
        FaOperationLogUtils.insertOperationLog(insertPo, FaOperationStatusEnum.SUCCESS, null);
    }

    public void close() {
        List<Throwable> exceptions2 = this.depreSplitResult.getExceptions();
        if (exceptions2.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u644a\u5931\u8d25\u3002", (String)"DepreSplitTask_2", (String)"fi-fa-business", (Object[])new Object[0]), new Object[0]));
        }
        if (this.existedVouncherNotMulSplit) {
            this.logger.info(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7ID[%1$s]\u6298\u65e7\u7528\u9014ID[%2$s]\u671f\u95f4[%3$s]\u5b58\u5728\u5df2\u751f\u6210\u7684\u51ed\u8bc1\u8bb0\u5f55\uff0c\u4e0d\u80fd\u91cd\u5206\u644a\u3002", (String)"DepreSplitTask_4", (String)"fi-fa-business", (Object[])new Object[0]), this.orgId, this.depreUseId, this.periodId));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u7684\u51ed\u8bc1\u8bb0\u5f55\uff0c\u4e0d\u80fd\u91cd\u5206\u644a\u3002", (String)"DepreSplitTask_3", (String)"fi-fa-business", (Object[])new Object[0]), new Object[0]));
        }
        if (!this.generateSum) {
            return;
        }
        if (this.isFromSplitSetup && this.generateAll) {
            return;
        }
        this.logger.info("\u5206\u644a\u660e\u7ec6\u5b8c\u6210\u8017\u65f6\uff1a" + (System.currentTimeMillis() - this.beginTime) / 1000L + "s");
        if (this.reGenerateAll || this.splitSchemaChanged) {
            this.generateAllCards();
        }
        if (this.reGenerateAll) {
            this.unGenVouncherSumIds.remove(this.depreSum.getLong("id"));
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fa_depre_sum"), (Object[])this.unGenVouncherSumIds.toArray());
        }
        if (this.generaSum) {
            DepreSplitSumUtils.genDepreSumEntry(this.depreSum, this.depreSplitResult, this.sumDimFieldMap, this.orgId, this.depreUseId, this.periodId, this.reverseSumIds, this.generaSum);
        } else {
            try {
                DynamicObject depre = QueryServiceHelper.queryOne((String)"fa_depre_sum", (String)"totaldepreamount", (QFilter[])new QFilter[]{new QFilter("id", "=", this.depreSum.getPkValue())});
                this.depreSum.set("totaldepreamount", (Object)depre.getBigDecimal("totaldepreamount"));
            }
            catch (Exception e) {
                this.depreSplitResult.addException(e);
            }
        }
        if (this.isFromDepre) {
            this.depreSum.set("auditor", (Object)ContextUtil.getUserId());
            this.depreSum.set("auditdate", (Object)new Date());
        }
        DepreSplitSumUtils.save(this.depreSum, this.generaSum);
        String ss = (System.currentTimeMillis() - this.beginTime) / 1000L + "s";
        this.logger.info("\u5206\u644a\u603b\u8017\u65f6\uff1a" + ss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAllCards() {
        this.depreSplitResult.resetAmount();
        Object lock = new Object();
        ArrayBlockingQueue<DepreSplitThread> queue = new ArrayBlockingQueue<DepreSplitThread>(3);
        ObjectPool<Object> objPool = new ObjectPool<Object>();
        Object[] params = new Object[]{this.orgId, this.depreUseId, this.periodId, this.periodId};
        Set allCardIds = (Set)DB.query((DBRoute)DBRoute.of((String)"fa"), (String)querySql, (Object[])params, rs -> {
            HashSet<Long> ids = new HashSet<Long>(200);
            while (rs.next()) {
                ids.add(rs.getLong("masterId"));
            }
            return ids;
        });
        int totalSize = allCardIds.size();
        if (totalSize == 0) {
            return;
        }
        int pageSize = (totalSize - 1) / 999 + 1;
        HashSet<Long> cardIds = new HashSet<Long>(1);
        try {
            int i = 0;
            Object object = lock;
            synchronized (object) {
                Iterator ite = allCardIds.iterator();
                while (ite.hasNext()) {
                    if (i == 999) {
                        DepreSplitThread t = new DepreSplitThread(this.depreSplitResult, queue, lock, pageSize, objPool, this, cardIds, this.reverseSumIds, this.splitMode);
                        queue.put(t);
                        if (this.enablePlatformThreadPool) {
                            ThreadService.execute((Runnable)t, (TaskType)TaskType.FA_DEPRE_SPLIT);
                        } else {
                            threadPool.executeIncludeRequestContext((Runnable)t);
                        }
                        cardIds = new HashSet();
                        i = 0;
                        continue;
                    }
                    cardIds.add((Long)ite.next());
                    ++i;
                }
                if (!cardIds.isEmpty()) {
                    DepreSplitThread t = new DepreSplitThread(this.depreSplitResult, queue, lock, pageSize, objPool, this, cardIds, this.reverseSumIds, this.splitMode);
                    queue.put(t);
                    if (this.enablePlatformThreadPool) {
                        ThreadService.execute((Runnable)t, (TaskType)TaskType.FA_DEPRE_SPLIT);
                    } else {
                        threadPool.executeIncludeRequestContext((Runnable)t);
                    }
                }
                while (pageSize > 0) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        this.logger.error("DepreTask Split Threads Error:", (Throwable)e);
                    }
                    pageSize = -1;
                }
            }
        }
        catch (Throwable e) {
            this.depreSplitResult.addException(e);
        }
    }

    private void generatePartCards(Set<Long> realCardIds) {
        DepreSplitDetailUtils.genDepreDetailCards(this.orgId, this.depreUseId, this.periodId, this.assetBook, realCardIds, this.depreSum.getLong("id"), this.sumDimFieldMap, this.detailDimFieldMap, this.dimSumSql, this.dimDetailSql, this.schemaSql, this.schemaFields, this.generaSum, this.depreSplitResult, this.depreSum.getString("billno"), this.reGenerateAll, this.generateAll, this.splitSchemaChanged, this.reverseSumIds, this.splitMode, this.splitSumIds);
    }

    private void init() {
        this.sumDimFieldMap = DepreSplitSumUtils.getDimFields();
        this.detailDimFieldMap = DepreSplitDetailUtils.getDimFields();
        this.dimSumSql = DepreSplitDetailUtils.getDimSql(this.sumDimFieldMap, "T3");
        this.dimDetailSql = DepreSplitDetailUtils.getDimSql(this.detailDimFieldMap, "T3");
        this.depreSchema = DepreSplitDetailUtils.priproGet(this.orgId, this.depreUseId);
        this.schemaSql = DepreSplitDetailUtils.getDepreScheme(this.depreSchema, "T3", "T4");
        this.schemaFields = DepreSplitDetailUtils.parsedepreScheme(this.depreSchema);
        this.generaSum = SystemParamHelper.getBooleanParam("isuse_depredetail", this.orgId, false);
        this.initSplitSum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSplitSum() {
        DynamicObject[] depres;
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        QFilter depreuseFilter = new QFilter("depreuse", "=", (Object)this.depreUseId);
        QFilter periodFilter = new QFilter("period", "=", (Object)this.periodId);
        String sumFields = "";
        if (this.generaSum) {
            ArrayList<String> fields = new ArrayList<String>(10);
            EntityType depreSplitSum = (EntityType)EntityMetadataCache.getDataEntityType((String)"fa_depre_sum").getAllEntities().get("depresplitsum");
            if (depreSplitSum != null) {
                DynamicObject[] tt = depreSplitSum.getFields();
                for (String key : tt.keySet()) {
                    fields.add("depresplitsum." + key);
                }
            }
            fields.add("depresplitsum.seq");
            fields.add("depresplitsubentry.seq");
            fields.add("depresplitsubentry.asstype");
            fields.add("depresplitsubentry.assid");
            sumFields = "," + Fa.join(fields, (String)",");
        }
        if ((depres = BusinessDataServiceHelper.load((String)"fa_depre_sum", (String)("id,billno,totaldepreamount,version,deprestatus,billstatus,org,period,modifier,modifytime,auditor,auditdate,sumassentry.sumentryasstype" + sumFields), (QFilter[])new QFilter[]{orgFilter, depreuseFilter, periodFilter}, (String)"createtime")).length > 0) {
            ArrayList<String> tempSumIds = new ArrayList<String>(depres.length);
            for (DynamicObject depre : depres) {
                tempSumIds.add(depre.getString("id"));
                this.splitSumIds.add(depre.getLong("id"));
            }
            this.existedVouncherSumIds = FaDepreUtil.getIds4HaveVouncher(tempSumIds, "fa_depre_sum");
        }
        ArrayList<DynamicObject> unGenVouncherDepres = new ArrayList<DynamicObject>(depres.length);
        for (DynamicObject depre : depres) {
            Long id = depre.getLong("id");
            if (this.existedVouncherSumIds.contains(id)) continue;
            unGenVouncherDepres.add(depre);
            this.unGenVouncherSumIds.add(id);
        }
        if (unGenVouncherDepres == null || unGenVouncherDepres.size() == 0) {
            this.generateAll = true;
            this.depreSum = DepreSplitSumUtils.initDepresplitSum(this.orgId, this.depreUseId, this.periodId, this.assetBook);
            if (!this.enabledisdepre) {
                if (!this.isFromDepre) {
                    this.depreSum.set("auditor", (Object)0L);
                    this.depreSum.set("auditdate", null);
                    this.depreSum.set("billstatus", (Object)"A");
                }
                this.depreSum.set("deprestatus", (Object)"1");
            }
        } else if (unGenVouncherDepres.size() == 1) {
            this.depreSum = (DynamicObject)unGenVouncherDepres.get(0);
            if (!this.enabledisdepre) {
                this.depreSum.set("modifier", (Object)ContextUtil.getUserId());
                this.depreSum.set("modifytime", (Object)new Date());
                this.depreSum.set("deprestatus", (Object)"1");
            }
        } else {
            int size = unGenVouncherDepres.size();
            this.depreSum = (DynamicObject)unGenVouncherDepres.get(size - 1);
            if (!this.enabledisdepre) {
                this.depreSum.set("modifier", (Object)ContextUtil.getUserId());
                this.depreSum.set("modifytime", (Object)new Date());
                this.depreSum.set("deprestatus", (Object)"1");
            }
        }
        this.reverseSumIds.addAll(this.splitSumIds);
        this.reverseSumIds.remove(this.depreSum.getLong("id"));
        if (!this.enabledisdepre) {
            try (TXHandle handle = null;){
                handle = TX.requiresNew();
                if (!this.depreSum.getDataEntityState().getFromDatabase()) {
                    DynamicObject[] dynamicObjects = new DynamicObject[]{this.depreSum};
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                } else if (this.isFromDepre && !"B".equals(this.depreSum.getString("billstatus"))) {
                    this.depreSum.set("billstatus", (Object)"B");
                    this.depreSum.set("deprestatus", (Object)"1");
                    SaveServiceHelper.update((DynamicObject)this.depreSum);
                }
                handle.commit();
            }
            DepreSplitSumUtils.initSumAssEntry(this.orgId, this.depreUseId, this.periodId, this.depreSum, this.schemaFields);
        }
        if (this.generaSum) {
            DynamicObjectCollection depreSumEntries = this.depreSum.getDynamicObjectCollection("depresplitsum");
            depreSumEntries.clear();
        }
        BigDecimal oldTatal = this.reGenerateAll || this.generateAll ? BigDecimal.ZERO : this.depreSum.getBigDecimal("totaldepreamount");
        this.depreSplitResult = new DepreSplitResult(oldTatal);
    }

    private boolean innerNeedReSplit() {
        String newVersion = DepreSplitSumUtils.isSameVersion(this.generaSum ? this.sumDimFieldMap : this.detailDimFieldMap, this.depreSchema, this.depreSum.getString("version"));
        if (newVersion != null) {
            this.depreSum.set("version", (Object)newVersion);
            this.splitSchemaChanged = true;
            this.depreSum.set("totaldepreamount", (Object)BigDecimal.ZERO);
            this.reGenerateAll = true;
        }
        return this.splitSchemaChanged;
    }

    public String getVersion() {
        return this.version;
    }

    private boolean isGenerateAll() {
        return this.generateAll;
    }

    protected synchronized void threadCountAdd() {
        ++this.finishThreadCount;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public boolean isEnabledisdepre() {
        return this.enabledisdepre;
    }

    public void setEnabledisdepre(boolean enabledisdepre) {
        this.enabledisdepre = enabledisdepre;
    }
}

