/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depretask;

import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.depreciation.ObjectPool;
import kd.fi.fa.business.depretask.DepreSplitDetailUtils;
import kd.fi.fa.business.depretask.DepreSplitResult;
import kd.fi.fa.business.depretask.DepreSplitTask;
import kd.fi.fa.business.enums.SplitMode;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.business.utils.FaOperationLogUtils;
import kd.fi.fa.common.util.ThrowableHelper;
import org.apache.log4j.Logger;

class DepreSplitThread
implements Runnable {
    private static Logger logger = Logger.getLogger(DepreSplitThread.class);
    private final ArrayBlockingQueue<DepreSplitThread> queue;
    private final Object lock;
    private final int threadCount;
    private final DepreSplitTask splitTask;
    private final Set<Long> realCardIds;
    private final Set<Long> reverseSumIds;
    private final SplitMode splitMode;

    DepreSplitThread(DepreSplitResult depreSplitResult, ArrayBlockingQueue<DepreSplitThread> queue, Object lock, int listsize, ObjectPool<Object> objPool, DepreSplitTask splitTask, Set<Long> realCardIds, Set<Long> reverseSumIds, SplitMode splitMode) {
        this.queue = queue;
        this.lock = lock;
        this.threadCount = listsize;
        this.splitTask = splitTask;
        this.realCardIds = realCardIds;
        this.reverseSumIds = reverseSumIds;
        this.splitMode = splitMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (Object tx = TX.requiresNew();){
            try {
                DepreSplitDetailUtils.genDepreDetailCards(this.splitTask.orgId, this.splitTask.depreUseId, this.splitTask.periodId, this.splitTask.assetBook, this.realCardIds, this.splitTask.depreSum.getLong("id"), this.splitTask.sumDimFieldMap, this.splitTask.detailDimFieldMap, this.splitTask.dimSumSql, this.splitTask.dimDetailSql, this.splitTask.schemaSql, this.splitTask.schemaFields, this.splitTask.generaSum, this.splitTask.depreSplitResult, this.splitTask.depreSum.getString("billno"), this.splitTask.reGenerateAll, this.splitTask.generateAll, this.splitTask.splitSchemaChanged, this.reverseSumIds, this.splitMode, this.splitTask.splitSumIds);
                tx.commit();
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            this.splitTask.depreSplitResult.addException(e);
            logger.error((Object)"DepreSplitThread:", (Throwable)e);
            String detailResult = "DepreSplitThread:" + ThrowableHelper.toString((Throwable)e);
            String params = "DepreSplitThread.run -> " + String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7: %1$s, \u6298\u65e7\u7528\u9014\uff1a%2$s, \u671f\u95f4\uff1a%3$s", (String)"DepreSplitThread_0", (String)"fi-fa-business", (Object[])new Object[0]), this.splitTask.orgId, this.splitTask.depreUseId, this.splitTask.periodId);
            FaOperationLogInsertPo insertPo = new FaOperationLogInsertPo(this.splitTask.orgId, this.splitTask.depreUseId, this.splitTask.assetBook.getLong("id"), this.splitTask.periodId, (Integer)0, "DepreSplitThread", params, FaOperationOpTypeEnum.RESPLIT);
            FaOperationLogUtils.insertOperationLog(insertPo, FaOperationStatusEnum.FAILED, detailResult);
        }
        finally {
            this.splitTask.threadCountAdd();
            if (!this.queue.remove(this)) {
                this.splitTask.depreSplitResult.addException(new KDBizException("DepreSplitThread remove queue error." + RequestContext.get().getTraceId() + ",Thread:" + Thread.currentThread().getId()));
            }
            if (this.threadCount == this.splitTask.finishThreadCount) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
        }
    }
}

