/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

public class FaRentSettleWhitelistUpgradeHandler {
    private static final Log log = LogFactory.getLog(FaRentSettleWhitelistUpgradeHandler.class);
    private static final int MAX_SIZE_ONE_BATCH = 20000;
    private static final String TABLE_NAME = "t_fa_lease_rent_settle_dapw";
    private static final String INSERT_SQL = "INSERT INTO t_fa_lease_rent_settle_dapw(fid, fcreatetime, fsourcebillid, forgid, fbilltype, foper) VALUES(?, ?, ?, ?, 'fa_lease_rent_settle', 'audit');";

    public void doHandler() {
        try {
            if (!DB.exitsTable((DBRoute)DBRoute.of((String)"fa"), (String)TABLE_NAME)) {
                log.info("FaRentSettleWhitelistUpgradeHandler -> \u8868[{}]\u4e0d\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u5347\u7ea7\u64cd\u4f5c\uff01", (Object)TABLE_NAME);
                return;
            }
            long startTime = System.currentTimeMillis();
            Set<Long> oldWhitelistEntityIds = this.queryOldWhitelist();
            Set<Long> newWhitelistEntityIds = this.queryNewWhitelist();
            Set<Long> needUpgradeIds = oldWhitelistEntityIds;
            needUpgradeIds.removeAll(newWhitelistEntityIds);
            if (CollectionUtils.isEmpty(needUpgradeIds)) {
                log.info("needUpgradeIds\u4e3a\u7a7a\uff0c\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u5230\u65b0\u767d\u540d\u5355\u7684\u644a\u9500\u8ba1\u606f\u6570\u636e\u3002");
                return;
            }
            this.addNewWhitelist(needUpgradeIds);
            log.info("FaRentSettleWhitelistUpgradeHandler.doHandler cost [{}] ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            log.error("FaRentSettleWhitelistUpgradeHandler error is :", (Throwable)e);
            throw e;
        }
    }

    private Set<Long> queryOldWhitelist() {
        HashSet<Long> oldWhitelistEntityIds = new HashSet<Long>(16);
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fentityid from t_gl_businesstask where fbusiness = ?;", new Object[]{"fa_lease_rent_settle"});
        try (DataSet dataSet = DB.queryDataSet((String)"FaRentSettleWhitelistUpgradeHandler.queryOldWhitelist", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                oldWhitelistEntityIds.add(row.getLong("fentityid"));
            }
        }
        log.info("queryOldWhitelist -> oldWhitelistEntityIds size is : {}", (Object)oldWhitelistEntityIds.size());
        return oldWhitelistEntityIds;
    }

    private Set<Long> queryNewWhitelist() {
        HashSet<Long> newWhitelistEntityIds = new HashSet<Long>(16);
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fsourcebillid from t_fa_lease_rent_settle_dapw;", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"FaRentSettleWhitelistUpgradeHandler.queryNewWhitelist", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                newWhitelistEntityIds.add(row.getLong("fsourcebillid"));
            }
        }
        log.info("queryNewWhitelist -> newWhitelistEntityIds size is : {}", (Object)newWhitelistEntityIds.size());
        return newWhitelistEntityIds;
    }

    private void addNewWhitelist(Set<Long> needAddIds) {
        List partitions = ListUtils.partition(needAddIds.stream().collect(Collectors.toList()), (int)20000);
        log.info("needAddIds size:[{}]; \u5206\u4e3a[{}]\u7ec4\u8fdb\u884c\u5904\u7406\u3002", (Object)needAddIds.size(), (Object)partitions.size());
        for (List partList : partitions) {
            this.addOneBatch(partList);
        }
    }

    private void addOneBatch(Collection<Long> needAddIds) {
        if (CollectionUtils.isEmpty(needAddIds)) {
            log.info("addOneBatch -> needAddIds\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u65b0\u589e\u65b0\u767d\u540d\u5355\u64cd\u4f5c\u3002");
            return;
        }
        Map<Long, Long> billId2OrgIdMap = this.queryBillId2OrgIdMap(needAddIds);
        if (billId2OrgIdMap == null || billId2OrgIdMap.isEmpty()) {
            log.info("addOneBatch -> billId2OrgIdMap\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u65b0\u589e\u65b0\u767d\u540d\u5355\u64cd\u4f5c\u3002");
            return;
        }
        long[] ids = DB.genLongIds((String)TABLE_NAME, (int)billId2OrgIdMap.size());
        Date nowTime = new Date();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(billId2OrgIdMap.size());
        int i = 0;
        for (Map.Entry<Long, Long> bill : billId2OrgIdMap.entrySet()) {
            Long billId = bill.getKey();
            Long orgId = bill.getValue();
            paramsList.add(new Object[]{ids[i], nowTime, billId, orgId});
            ++i;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)INSERT_SQL, paramsList);
    }

    private Map<Long, Long> queryBillId2OrgIdMap(Collection<Long> billIds) {
        HashMap<Long, Long> billId2OrgIdMap = new HashMap<Long, Long>(billIds.size());
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fid,forgid from t_fa_lease_rent_settle where ", new Object[0]);
        querySql.appendIn(" fid ", (Object[])billIds.toArray(new Long[0]));
        try (DataSet dataSet = DB.queryDataSet((String)"FaRentSettleWhitelistUpgradeHandler.queryBillId2OrgIdMap", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                Long id = row.getLong("fid");
                Long orgId = row.getLong("forgid");
                billId2OrgIdMap.put(id, orgId);
            }
        }
        return billId2OrgIdMap;
    }
}

