/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.enums.lease.InterestAmortizeSchema;
import kd.fi.fa.business.enums.lease.InterestDetailSourceType;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.enums.lease.PayFrequency;
import kd.fi.fa.business.lease.RealDailyIntRateCalculator;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaBigDecimalUtil;
import kd.fi.fa.business.utils.FaFindPeriodHelper;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.po.GenInterestDetailParamPo;

public class InterestDetailGenerator {
    private static final Log logger = LogFactory.getLog(InterestDetailGenerator.class);
    private static final String DATE_FORMAT = "yyyyMMdd";
    private final List<GenInterestDetailParamPo> paramPos;
    private Map<Object, DynamicObject> interestDetailMap;
    private final Map<Long, DynamicObject> leaseInitMap = new HashMap<Long, DynamicObject>(32);
    private final Map<Long, FaFindPeriodHelper> findPeriodHelperMap = new HashMap<Long, FaFindPeriodHelper>(32);

    public InterestDetailGenerator(List<GenInterestDetailParamPo> paramPos) {
        this.paramPos = paramPos;
    }

    public List<DynamicObject> generate() {
        Object[] leaseContractIds = this.paramPos.stream().map(GenInterestDetailParamPo::getLeaseContractId).toArray();
        Map leaseContractMap = BusinessDataServiceHelper.loadFromCache((Object[])leaseContractIds, (String)"fa_lease_contract");
        ArrayList<DynamicObject> interestDetailList = new ArrayList<DynamicObject>(this.paramPos.size());
        for (GenInterestDetailParamPo param : this.paramPos) {
            DynamicObject leaseContract = (DynamicObject)leaseContractMap.get(param.getLeaseContractId());
            interestDetailList.add(this.generateByLeaseContract(leaseContract));
        }
        return interestDetailList;
    }

    public List<DynamicObject> reverse() {
        Object[] leaseContractIds = this.paramPos.stream().map(GenInterestDetailParamPo::getLeaseContractId).toArray();
        String selectFields = Fa.comma((String[])new String[]{"org", "leasecontract", Fa.dot((String[])new String[]{"detailentry", "seq"}), Fa.dot((String[])new String[]{"detailentry", "date"}), Fa.dot((String[])new String[]{"detailentry", "leaseliabpay"}), Fa.dot((String[])new String[]{"detailentry", "beginbalance"}), Fa.dot((String[])new String[]{"detailentry", "leaseliabint"}), Fa.dot((String[])new String[]{"detailentry", "endbalance"}), Fa.dot((String[])new String[]{"detailentry", "realdailyrate"}), Fa.dot((String[])new String[]{"detailentry", "sourcetype"}), Fa.dot((String[])new String[]{"detailentry", "latestdata"}), Fa.dot((String[])new String[]{"detailentry", "amortizationperiod"}), Fa.dot((String[])new String[]{"detailentry", "contractversion"}), "dailyrate", "currency"});
        QFilter filter = new QFilter("leasecontract", "in", (Object)leaseContractIds);
        DynamicObject[] interestDetails = BusinessDataServiceHelper.load((String)"fa_interest_detail", (String)selectFields, (QFilter[])filter.toArray());
        this.interestDetailMap = Stream.of(interestDetails).collect(Collectors.toMap(v -> v.getDynamicObject("leasecontract").getPkValue(), v -> v));
        for (GenInterestDetailParamPo param : this.paramPos) {
            this.generateReversal(param);
        }
        return new ArrayList<DynamicObject>(this.interestDetailMap.values());
    }

    protected DynamicObject generateByLeaseContract(DynamicObject leaseContract) {
        boolean isExempt = leaseContract.getBoolean("isexempt");
        if (isExempt) {
            return this.generateForExemptContract(leaseContract);
        }
        return this.generateForNotExemptContract(leaseContract);
    }

    private DynamicObject generateForNotExemptContract(DynamicObject leaseContract) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        String contractVersion = leaseContract.getString("version");
        DynamicObject currency = leaseContract.getDynamicObject("currency");
        int amtPrecision = currency.getInt("amtprecision");
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(128);
        this.getLeaseLiabPayAmountMap(leaseContract, amountMap);
        long orgId = org.getLong("id");
        DynamicObject leaseInit = this.getLeaseInitFromLocalCache(orgId);
        DynamicObject curPeriod = leaseInit.getDynamicObject("curperiod");
        Date curPeriodEndDate = curPeriod.getDate("enddate");
        FaFindPeriodHelper findPeriodHelper = this.getFindPeriodHelperFromLocalCache(orgId);
        DynamicObject interestDetail = this.createInterestDetail();
        interestDetail.set("org", (Object)org);
        interestDetail.set("leasecontract", (Object)leaseContract);
        interestDetail.set("currency", (Object)currency);
        DynamicObjectCollection detailEntry = interestDetail.getDynamicObjectCollection("detailentry");
        detailEntry.clear();
        Date detailBeginDate = this.getDetailBeginDate(leaseContract);
        Date detailEndDate = this.getDetailEndDate(leaseContract, amountMap);
        BigDecimal beginBalance = this.getDetailBeginBalance(leaseContract);
        BigDecimal dailyRate = this.getDailyRate(leaseContract, amountMap);
        BigDecimal dailyRate4Show = dailyRate.multiply(FaBigDecimalUtil.HUNDRED).setScale(6, LeaseUtil.getRoundingMode4CalAmount());
        interestDetail.set("dailyrate", (Object)dailyRate4Show);
        BigDecimal sumInterest = BigDecimal.ZERO;
        BigDecimal notConfirmFinCost = this.getNotConfirmFinCost(leaseContract);
        String dealTailDiffDate = this.getDealTailDiffDate(amountMap);
        int seq = 1;
        Date rowDate = detailBeginDate;
        while (DateUtil.compareDate((Date)rowDate, (Date)detailEndDate) <= 0) {
            DynamicObject amortizationPeriod;
            DynamicObject row = detailEntry.addNew();
            row.set("seq", (Object)seq++);
            row.set("date", (Object)rowDate);
            row.set("beginbalance", (Object)beginBalance);
            String dateStr = this.formatDate(rowDate);
            BigDecimal leaseLiabPay = (BigDecimal)amountMap.get(dateStr);
            leaseLiabPay = leaseLiabPay == null ? BigDecimal.ZERO : leaseLiabPay;
            row.set("leaseliabpay", (Object)leaseLiabPay);
            BigDecimal leaseLiabInt = dealTailDiffDate.equals(this.formatDate(rowDate)) ? notConfirmFinCost.subtract(sumInterest) : beginBalance.subtract(leaseLiabPay).multiply(dailyRate);
            leaseLiabInt = leaseLiabInt.setScale(amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
            row.set("leaseliabint", (Object)leaseLiabInt);
            sumInterest = sumInterest.add(leaseLiabInt);
            BigDecimal endBalance = beginBalance.subtract(leaseLiabPay).add(leaseLiabInt);
            row.set("endbalance", (Object)endBalance);
            if (BigDecimal.ZERO.compareTo(leaseLiabInt) == 0) {
                row.set("realdailyrate", (Object)BigDecimal.ZERO);
            } else {
                row.set("realdailyrate", (Object)dailyRate4Show);
            }
            if (DateUtil.compareDate((Date)rowDate, (Date)curPeriodEndDate) <= 0) {
                amortizationPeriod = curPeriod;
            } else {
                amortizationPeriod = findPeriodHelper.findPeriodObjByDate(rowDate);
                if (amortizationPeriod == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u7ed3\u675f\u65e5/\u6700\u665a\u8ba1\u5212\u4ed8\u6b3e\u65e5[%s]\u5bf9\u5e94\u4f1a\u8ba1\u671f\u95f4\u672a\u7ef4\u62a4\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"InterestDetailGenerator_0", (String)"fi-fa-business", (Object[])new Object[0]), DateUtil.formatToString((Date)detailEndDate)));
                }
            }
            row.set("amortizationperiod", (Object)amortizationPeriod);
            row.set("sourcetype", (Object)InterestDetailSourceType.A.name());
            row.set("latestdata", (Object)Boolean.TRUE);
            row.set("contractversion", (Object)contractVersion);
            beginBalance = endBalance;
            rowDate = DateUtil.addDay((Date)rowDate, (int)1);
        }
        return interestDetail;
    }

    private DynamicObject generateForExemptContract(DynamicObject leaseContract) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        String contractVersion = leaseContract.getString("version");
        DynamicObject currency = leaseContract.getDynamicObject("currency");
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(128);
        this.getLeaseLiabPayAmountMap(leaseContract, amountMap);
        long orgId = org.getLong("id");
        DynamicObject leaseInit = this.getLeaseInitFromLocalCache(orgId);
        DynamicObject curPeriod = leaseInit.getDynamicObject("curperiod");
        Date curPeriodEndDate = curPeriod.getDate("enddate");
        FaFindPeriodHelper findPeriodHelper = this.getFindPeriodHelperFromLocalCache(orgId);
        DynamicObject interestDetail = this.createInterestDetail();
        interestDetail.set("org", (Object)org);
        interestDetail.set("leasecontract", (Object)leaseContract);
        interestDetail.set("currency", (Object)currency);
        DynamicObjectCollection detailEntry = interestDetail.getDynamicObjectCollection("detailentry");
        detailEntry.clear();
        Date detailBeginDate = this.getDetailBeginDate(leaseContract);
        Date detailEndDate = this.getDetailEndDate(leaseContract, amountMap);
        interestDetail.set("dailyrate", (Object)BigDecimal.ZERO);
        int seq = 1;
        Date rowDate = detailBeginDate;
        while (DateUtil.compareDate((Date)rowDate, (Date)detailEndDate) <= 0) {
            String dateStr = this.formatDate(rowDate);
            if (amountMap.containsKey(dateStr)) {
                DynamicObject amortizationPeriod;
                DynamicObject row = detailEntry.addNew();
                row.set("seq", (Object)seq++);
                row.set("date", (Object)rowDate);
                row.set("beginbalance", (Object)BigDecimal.ZERO);
                BigDecimal leaseLiabPay = (BigDecimal)amountMap.get(dateStr);
                leaseLiabPay = leaseLiabPay == null ? BigDecimal.ZERO : leaseLiabPay;
                row.set("leaseliabpay", (Object)leaseLiabPay);
                row.set("leaseliabint", (Object)BigDecimal.ZERO);
                row.set("endbalance", (Object)BigDecimal.ZERO);
                row.set("realdailyrate", (Object)BigDecimal.ZERO);
                if (DateUtil.compareDate((Date)rowDate, (Date)curPeriodEndDate) <= 0) {
                    amortizationPeriod = curPeriod;
                } else {
                    amortizationPeriod = findPeriodHelper.findPeriodObjByDate(rowDate);
                    if (amortizationPeriod == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u7ed3\u675f\u65e5/\u6700\u665a\u8ba1\u5212\u4ed8\u6b3e\u65e5[%s]\u5bf9\u5e94\u4f1a\u8ba1\u671f\u95f4\u672a\u7ef4\u62a4\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"InterestDetailGenerator_0", (String)"fi-fa-business", (Object[])new Object[0]), DateUtil.formatToString((Date)detailEndDate)));
                    }
                }
                row.set("amortizationperiod", (Object)amortizationPeriod);
                row.set("sourcetype", (Object)InterestDetailSourceType.A.name());
                row.set("latestdata", (Object)Boolean.TRUE);
                row.set("contractversion", (Object)contractVersion);
            }
            rowDate = DateUtil.addDay((Date)rowDate, (int)1);
        }
        return interestDetail;
    }

    private DynamicObject createInterestDetail() {
        DynamicObject interestDetail = BusinessDataServiceHelper.newDynamicObject((String)"fa_interest_detail");
        interestDetail.set("billstatus", (Object)BillStatus.C);
        return interestDetail;
    }

    protected BigDecimal getDailyRate(DynamicObject leaseContract, Map<String, BigDecimal> amountMap) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        String interestAmortizeSchema = SystemParamHelper.getStringParam("interest_amortize_schema", (Long)org.getPkValue(), InterestAmortizeSchema.A.name());
        String sourceType = leaseContract.getString("sourcetype");
        if (InterestAmortizeSchema.A.name().equals(interestAmortizeSchema) && LeaseContractSourceType.A.name().equals(sourceType)) {
            BigDecimal dailyDiscountRate = leaseContract.getBigDecimal("dailydiscountrate");
            return dailyDiscountRate.divide(FaBigDecimalUtil.HUNDRED, 8, LeaseUtil.getRoundingMode4CalAmount());
        }
        return new RealDailyIntRateCalculator(leaseContract, this.getDetailBeginDate(leaseContract), amountMap).calculate();
    }

    private String getDealTailDiffDate(Map<String, BigDecimal> amountMap) {
        Date lastPayDate;
        if (amountMap.isEmpty()) {
            logger.info("amountMap\u4e3a\u7a7a\uff0c\u65e0\u9700\u5904\u7406\u5c3e\u5dee\uff0c\u8fd4\u56de\u7a7a\u4e32\u3002");
            return "";
        }
        String lastPayDateStr = (String)amountMap.keySet().stream().max(Comparator.naturalOrder()).get();
        try {
            lastPayDate = new SimpleDateFormat(DATE_FORMAT).parse(lastPayDateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u5904\u7406\u5c3e\u5dee\u7684\u65e5\u671f\u65f6\u51fa\u73b0\u9519\u8bef\u201c%s\u201d\u3002", (String)"InterestDetailGenerator_1", (String)"fi-fa-business", (Object[])new Object[0]), lastPayDateStr));
        }
        Date dealTailDate = DateUtil.addDay((Date)lastPayDate, (int)-1);
        return this.formatDate(dealTailDate);
    }

    private boolean getLeaseLiabPayAmountMap(DynamicObject leaseContract, Map<String, BigDecimal> allAmountMap) {
        boolean sameDateExistedMultiPay = false;
        DynamicObject org = leaseContract.getDynamicObject("org");
        DynamicObject currency = leaseContract.getDynamicObject("currency");
        int amtPrecision = currency.getInt("amtprecision");
        String interestAmortizeSchema = SystemParamHelper.getStringParam("interest_amortize_schema", (Long)org.getPkValue(), InterestAmortizeSchema.A.name());
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        Date detailBeginDate = this.getDetailBeginDate(leaseContract);
        for (DynamicObject row : planEntry) {
            Date planPayDate;
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            String acctClass = payItem.getString("accountingclass");
            if (!"A".equals(acctClass) || DateUtil.compareDate((Date)(planPayDate = row.getDate("planpaydate")), (Date)detailBeginDate) < 0) continue;
            BigDecimal amount = row.getBigDecimal("unpaidrent");
            Date planStartDate = row.getDate("plan_startdate");
            Date planEndDate = row.getDate("plan_enddate");
            DynamicObject payRuleRow = LeaseUtil.getPayRuleRow(leaseContract, payItem.getLong("id"), planStartDate);
            String frequency = payRuleRow.getString("frequency");
            HashMap<String, BigDecimal> amMap = new HashMap<String, BigDecimal>(8);
            if (InterestAmortizeSchema.A.name().equals(interestAmortizeSchema) || PayFrequency.F.name().equals(frequency)) {
                String dateStr = this.formatDate(planPayDate);
                amMap.put(dateStr, amount);
                boolean sameDateExistedMultiPayTemp = this.amMapMergeAllAmountMap(amMap, allAmountMap);
                if (!sameDateExistedMultiPayTemp || sameDateExistedMultiPay) continue;
                sameDateExistedMultiPay = true;
                continue;
            }
            String payPoint = payRuleRow.getString("paypoint");
            int relativePayDate = payRuleRow.getInt("relativepaydate");
            Date startDate = planStartDate;
            ArrayList<String> payDateList = new ArrayList<String>();
            while (DateUtil.compareDate((Date)startDate, (Date)planEndDate) <= 0) {
                Date endDate = DateUtil.addNaturalMonth((Date)startDate, (int)1);
                if (DateUtil.compareDate((Date)(endDate = DateUtil.addDay((Date)endDate, (int)-1)), (Date)planEndDate) > 0) {
                    endDate = planEndDate;
                }
                Date payDate = LeaseUtil.calPlanPayDate(startDate, endDate, payPoint, relativePayDate);
                startDate = DateUtil.addDay((Date)endDate, (int)1);
                if (DateUtil.compareDate((Date)payDate, (Date)detailBeginDate) < 0) continue;
                String payDateStr = this.formatDate(payDate);
                payDateList.add(payDateStr);
            }
            int payTimes = payDateList.size();
            if (payTimes == 0) {
                logger.info(String.format("\u4ed8\u6b3e\u8ba1\u5212[%s]\u6309\u6708\u644a\u9500\u65f6\uff0c\u672a\u627e\u5230\u4ed8\u6b3e\u65e5\u671f\u3002", row.getString("plannumber")));
                continue;
            }
            BigDecimal tempAmount = amount.divide(new BigDecimal(payTimes), amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
            BigDecimal sumAmount = tempAmount.multiply(new BigDecimal(payTimes - 1)).setScale(amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
            BigDecimal tailDiff = amount.subtract(sumAmount);
            for (int i = 0; i < payTimes; ++i) {
                String payDateStr = (String)payDateList.get(i);
                if (i == payTimes - 1) {
                    amMap.put(payDateStr, tailDiff);
                    continue;
                }
                amMap.put(payDateStr, tempAmount);
            }
            boolean sameDateExistedMultiPayTemp = this.amMapMergeAllAmountMap(amMap, allAmountMap);
            if (!sameDateExistedMultiPayTemp || sameDateExistedMultiPay) continue;
            sameDateExistedMultiPay = true;
        }
        return sameDateExistedMultiPay;
    }

    private boolean amMapMergeAllAmountMap(Map<String, BigDecimal> amountMap, Map<String, BigDecimal> allAmountMap) {
        boolean sameDateExistedMultiPay = false;
        for (Map.Entry<String, BigDecimal> amountMapEntry : amountMap.entrySet()) {
            BigDecimal exitAmnout = allAmountMap.get(amountMapEntry.getKey());
            if (exitAmnout == null) {
                allAmountMap.put(amountMapEntry.getKey(), amountMapEntry.getValue());
                continue;
            }
            BigDecimal exitAmnoutAddNew = exitAmnout.add(amountMapEntry.getValue());
            allAmountMap.put(amountMapEntry.getKey(), exitAmnoutAddNew);
            sameDateExistedMultiPay = true;
        }
        return sameDateExistedMultiPay;
    }

    private void generateReversal(GenInterestDetailParamPo param) {
        Date detailBeginDate;
        DynamicObject interestDetail = this.interestDetailMap.get(param.getLeaseContractId());
        Date terminationDate = param.getTerminationDate();
        DynamicObject leaseContract = interestDetail.getDynamicObject("leasecontract");
        leaseContract = BusinessDataServiceHelper.loadSingleFromCache((Object)leaseContract.getPkValue(), (String)"fa_lease_contract");
        Date leaseStartDate = leaseContract.getDate("leasestartdate");
        boolean invalidContract = DateUtil.isSameDay((Date)terminationDate, (Date)leaseStartDate);
        Date leaseTermStartDate = leaseContract.getDate("leasetermstartdate");
        DynamicObjectCollection detailEntry = interestDetail.getDynamicObjectCollection("detailentry");
        detailEntry.sort(Comparator.comparingInt(v -> v.getInt("seq")));
        Date lastPayDate = null;
        for (int i = detailEntry.size() - 1; i >= 0; --i) {
            BigDecimal leaseLiabPay;
            DynamicObject row = (DynamicObject)detailEntry.get(i);
            boolean latestData = row.getBoolean("latestdata");
            if (!latestData || BigDecimal.ZERO.compareTo(leaseLiabPay = row.getBigDecimal("leaseliabpay")) >= 0) continue;
            lastPayDate = row.getDate("date");
            break;
        }
        if (lastPayDate == null || DateUtil.compareShortDate((Date)param.getTerminationDate(), lastPayDate) >= 0) {
            return;
        }
        Date reversalBeginDate = invalidContract ? leaseTermStartDate : param.getTerminationDate();
        if (DateUtil.compareDate((Date)reversalBeginDate, (Date)(detailBeginDate = this.getDetailBeginDate(leaseContract))) < 0) {
            reversalBeginDate = detailBeginDate;
        }
        String contractVersion = leaseContract.getString("version");
        long orgId = leaseContract.getLong(Fa.id((String)"org"));
        DynamicObject leaseInit = this.getLeaseInitFromLocalCache(orgId);
        DynamicObject curPeriod = leaseInit.getDynamicObject("curperiod");
        Date curPeriodEndDate = curPeriod.getDate("enddate");
        FaFindPeriodHelper findPeriodHelper = this.getFindPeriodHelperFromLocalCache(orgId);
        int entrySize = detailEntry.size();
        int seq = entrySize + 1;
        for (int i = 0; i < entrySize; ++i) {
            Date date;
            DynamicObject row = (DynamicObject)detailEntry.get(i);
            boolean latestData = row.getBoolean("latestdata");
            if (!latestData || DateUtil.compareDate((Date)(date = row.getDate("date")), (Date)reversalBeginDate) < 0) continue;
            if (DateUtil.compareDate((Date)date, (Date)lastPayDate) > 0) break;
            BigDecimal beginBalance = row.getBigDecimal("beginbalance");
            BigDecimal leaseLiabPay = row.getBigDecimal("leaseliabpay");
            BigDecimal leaseLiabInt = row.getBigDecimal("leaseliabint");
            BigDecimal endBalance = row.getBigDecimal("endbalance");
            BigDecimal realDailyRate = row.getBigDecimal("realdailyrate");
            DynamicObject reversalDetail = detailEntry.addNew();
            reversalDetail.set("seq", (Object)seq++);
            reversalDetail.set("date", (Object)date);
            reversalDetail.set("beginbalance", (Object)beginBalance.negate());
            reversalDetail.set("leaseliabpay", (Object)leaseLiabPay.negate());
            reversalDetail.set("leaseliabint", (Object)leaseLiabInt.negate());
            reversalDetail.set("endbalance", (Object)endBalance.negate());
            reversalDetail.set("realdailyrate", (Object)realDailyRate);
            if (DateUtil.compareDate((Date)date, (Date)curPeriodEndDate) <= 0) {
                reversalDetail.set("amortizationperiod", (Object)curPeriod);
            } else {
                reversalDetail.set("amortizationperiod", (Object)findPeriodHelper.findPeriodObjByDate(date));
            }
            reversalDetail.set("sourcetype", (Object)InterestDetailSourceType.B.name());
            reversalDetail.set("latestdata", (Object)Boolean.TRUE);
            reversalDetail.set("contractversion", (Object)contractVersion);
        }
    }

    protected Date getDetailBeginDate(DynamicObject leaseContract) {
        String sourceType = leaseContract.getString("sourcetype");
        Date initConfirmDate = leaseContract.getDate("initconfirmdate");
        Date sysSwitchDate = leaseContract.getDate("sysswitchdate");
        return LeaseContractSourceType.A.name().equals(sourceType) ? initConfirmDate : sysSwitchDate;
    }

    protected BigDecimal getDetailBeginBalance(DynamicObject leaseContract) {
        return leaseContract.getBigDecimal("leaseliab");
    }

    protected BigDecimal getNotConfirmFinCost(DynamicObject leaseContract) {
        BigDecimal leaseLiabOri = leaseContract.getBigDecimal("leaseliabori");
        BigDecimal leaseLiab = leaseContract.getBigDecimal("leaseliab");
        return leaseLiabOri.subtract(leaseLiab);
    }

    private Date getDetailEndDate(DynamicObject leaseContract, Map<String, BigDecimal> amountMap) {
        Date leaseEndDate;
        Date detailEndDate = leaseEndDate = leaseContract.getDate("leaseenddate");
        if (!amountMap.isEmpty()) {
            String lastPayDateStr = (String)amountMap.keySet().stream().max(Comparator.naturalOrder()).get();
            try {
                Date lastPayDate = new SimpleDateFormat(DATE_FORMAT).parse(lastPayDateStr);
                if (DateUtil.compareDate((Date)lastPayDate, (Date)leaseEndDate) > 0) {
                    detailEndDate = lastPayDate;
                }
            }
            catch (ParseException e) {
                logger.error(String.format("\u751f\u6210\u8ba1\u606f\u660e\u7ec6\u8868\u5931\u8d25\uff0c\u65e5\u671f\u8f6c\u6362\u5f02\u5e38[%s]", lastPayDateStr), (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u606f\u660e\u7ec6\u8868\u5931\u8d25\uff0c\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\u201c%s\u201d\u3002", (String)"InterestDetailGenerator_2", (String)"fi-fa-business", (Object[])new Object[0]), lastPayDateStr));
            }
        }
        return detailEndDate;
    }

    private DynamicObject getLeaseInitFromLocalCache(long orgId) {
        DynamicObject leaseInit = this.leaseInitMap.get(orgId);
        if (leaseInit == null) {
            String select = Fa.comma((String[])new String[]{"curperiod", "periodtype"});
            leaseInit = BusinessDataServiceHelper.loadSingle((String)"fa_lease_init", (String)select, (QFilter[])new QFilter("org", "=", (Object)orgId).toArray());
            if (leaseInit == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u7ec4\u7ec7\uff08ID\uff1a%s\uff09\u7684\u79df\u8d41\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"InterestDetailGenerator_3", (String)"fi-fa-business", (Object[])new Object[0]), orgId));
            }
            this.leaseInitMap.put(orgId, leaseInit);
        }
        return leaseInit;
    }

    private FaFindPeriodHelper getFindPeriodHelperFromLocalCache(long orgId) {
        DynamicObject leaseInit = this.getLeaseInitFromLocalCache(orgId);
        long periodTypeId = leaseInit.getLong(Fa.id((String)"periodtype"));
        FaFindPeriodHelper helper = this.findPeriodHelperMap.get(periodTypeId);
        if (helper == null) {
            helper = new FaFindPeriodHelper(periodTypeId);
            this.findPeriodHelperMap.put(periodTypeId, helper);
        }
        return helper;
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }
}

