/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.enums.lease.InterestAmortizeSchema;
import kd.fi.fa.business.lease.InterestDetailGenerator;
import kd.fi.fa.business.lease.RealDailyIntRateCalculator4LeaseChange;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaBigDecimalUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;

public class InterestDetailGenerator4LeaseChange
extends InterestDetailGenerator {
    private final DynamicObject leaseContract;
    private final Date effectiveDate;

    public InterestDetailGenerator4LeaseChange(DynamicObject leaseContract, Date effectiveDate) {
        super(null);
        this.leaseContract = leaseContract;
        this.effectiveDate = effectiveDate;
    }

    @Override
    public List<DynamicObject> generate() {
        throw new KDBizException(ResManager.loadKDString((String)"\u7528\u4e8e\u79df\u8d41\u53d8\u66f4\u7684\u8ba1\u606f\u660e\u7ec6\u751f\u6210\u5668\u4e0d\u652f\u6301\u6b63\u5e38\u751f\u6210\u8ba1\u606f\u660e\u7ec6\u3002", (String)"InterestDetailGenerator4LeaseChange_0", (String)"fi-fa-business", (Object[])new Object[0]));
    }

    @Override
    public List<DynamicObject> reverse() {
        throw new KDBizException(ResManager.loadKDString((String)"\u7528\u4e8e\u79df\u8d41\u53d8\u66f4\u7684\u8ba1\u606f\u660e\u7ec6\u751f\u6210\u5668\u4e0d\u652f\u6301\u53cd\u51b2\u3002", (String)"InterestDetailGenerator4LeaseChange_1", (String)"fi-fa-business", (Object[])new Object[0]));
    }

    public DynamicObject generate4LeaseChange() {
        return super.generateByLeaseContract(this.leaseContract);
    }

    @Override
    protected BigDecimal getDailyRate(DynamicObject leaseContract, Map<String, BigDecimal> amountMap) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        String interestAmortizeSchema = SystemParamHelper.getStringParam("interest_amortize_schema", (Long)org.getPkValue(), InterestAmortizeSchema.A.name());
        if (InterestAmortizeSchema.A.name().equals(interestAmortizeSchema)) {
            BigDecimal dailyDiscountRate = leaseContract.getBigDecimal("dailydiscountrate");
            return dailyDiscountRate.divide(FaBigDecimalUtil.HUNDRED, 8, LeaseUtil.getRoundingMode4CalAmount());
        }
        if (amountMap.size() == 0) {
            return BigDecimal.ZERO;
        }
        Date detailBeginDate = this.getDetailBeginDate(leaseContract);
        BigDecimal detailBeginBalance = this.getDetailBeginBalance(leaseContract);
        BigDecimal notConfirmFinCost = this.getNotConfirmFinCost(leaseContract);
        return new RealDailyIntRateCalculator4LeaseChange(leaseContract, detailBeginDate, amountMap, detailBeginBalance, notConfirmFinCost).calculate();
    }

    @Override
    protected Date getDetailBeginDate(DynamicObject leaseContract) {
        return this.effectiveDate;
    }

    @Override
    protected BigDecimal getDetailBeginBalance(DynamicObject leaseContract) {
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        BigDecimal totalLeaseLiab = BigDecimal.ZERO;
        for (DynamicObject row : planEntry) {
            Date planPayDate = row.getDate("planpaydate");
            if (DateUtil.compareDate((Date)planPayDate, (Date)this.effectiveDate) < 0) continue;
            BigDecimal liabPresentValue = row.getBigDecimal("presentvalue");
            totalLeaseLiab = totalLeaseLiab.add(liabPresentValue);
        }
        return totalLeaseLiab;
    }

    @Override
    protected BigDecimal getNotConfirmFinCost(DynamicObject leaseContract) {
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        BigDecimal notConfirmFinCost = BigDecimal.ZERO;
        for (DynamicObject row : planEntry) {
            Date planPayDate = row.getDate("planpaydate");
            if (DateUtil.compareDate((Date)planPayDate, (Date)this.effectiveDate) < 0) continue;
            BigDecimal unPaidRent = row.getBigDecimal("unpaidrent");
            BigDecimal liabPresentValue = row.getBigDecimal("presentvalue");
            notConfirmFinCost = notConfirmFinCost.add(unPaidRent.subtract(liabPresentValue));
        }
        return notConfirmFinCost;
    }
}

