/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.enums.lease.DailyDiscountRateFormula;
import kd.fi.fa.business.enums.lease.LeaseContractDepreTypeEnum;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.enums.lease.TransitionPlan;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaBigDecimalUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class LeaseContractCal {
    public static void setLeaseMonths(IObjWrapper wrapper) {
        Date leaseStartDate = (Date)wrapper.getValue("leasestartdate");
        Date leaseEndDate = (Date)wrapper.getValue("leaseenddate");
        if (leaseStartDate != null && leaseEndDate != null) {
            boolean monthRoundUp = LeaseContractCal.getLeaseMonthRoundUpFromSysParam(wrapper);
            int diffMonths = DateUtil.getDiffMonthsByLocalDate((Date)leaseStartDate, (Date)leaseEndDate, (boolean)true, (boolean)monthRoundUp);
            wrapper.setValue("leasemonths", diffMonths);
        } else {
            wrapper.setValue("leasemonths", 0);
        }
    }

    public static void setInitConfirmDate(IObjWrapper wrapper) {
        Date freeLeaseStartDate = (Date)wrapper.getValue("freeleasestartdate");
        Date leaseStartDate = (Date)wrapper.getValue("leasestartdate");
        DynamicObject org = (DynamicObject)wrapper.getValue("org");
        if (org == null) {
            return;
        }
        Date dateFlag = LeaseUtil.getFirstExecDateFromSysParam(org.getLong("id"));
        if (freeLeaseStartDate != null) {
            wrapper.setValue("initconfirmdate", DateUtil.maxDate((Date[])new Date[]{freeLeaseStartDate, dateFlag}));
        } else if (leaseStartDate != null) {
            wrapper.setValue("initconfirmdate", DateUtil.maxDate((Date[])new Date[]{leaseStartDate, dateFlag}));
        } else {
            wrapper.setValue("initconfirmdate", null);
        }
    }

    public static void setLeaseTermStartDate(IObjWrapper wrapper) {
        Date freeLeaseStartDate = (Date)wrapper.getValue("freeleasestartdate");
        Date leaseStartDate = (Date)wrapper.getValue("leasestartdate");
        if (freeLeaseStartDate != null) {
            wrapper.setValue("leasetermstartdate", freeLeaseStartDate);
        } else {
            wrapper.setValue("leasetermstartdate", leaseStartDate);
        }
    }

    public static void setIsExempt(IObjWrapper wrapper) {
        Date initConfirmDate = (Date)wrapper.getValue("initconfirmdate");
        Date leaseEndDate = (Date)wrapper.getValue("leaseenddate");
        boolean monthRoundUp = LeaseContractCal.getLeaseMonthRoundUpFromSysParam(wrapper);
        if (initConfirmDate != null && leaseEndDate != null && DateUtil.getDiffMonthsByLocalDate((Date)initConfirmDate, (Date)leaseEndDate, (boolean)true, (boolean)monthRoundUp) <= 12) {
            wrapper.setValue("isexempt", Boolean.TRUE);
        } else {
            wrapper.setValue("isexempt", Boolean.FALSE);
        }
    }

    public static void setDiscountRate(IObjWrapper wrapper) {
        DynamicObject org = (DynamicObject)wrapper.getValue("org");
        DynamicObject currency = (DynamicObject)wrapper.getValue("currency");
        String transitionPlan = (String)wrapper.getValue("transitionplan");
        Date date = TransitionPlan.C.name().equals(transitionPlan) ? (Date)wrapper.getValue("leasetermstartdate") : (Date)wrapper.getValue("initconfirmdate");
        int depreMonths = (Integer)wrapper.getValue("depremonths");
        boolean isExempt = (Boolean)wrapper.getValue("isexempt");
        if (org == null || currency == null || date == null || 0 == depreMonths || isExempt) {
            return;
        }
        long orgId = org.getLong("id");
        long currencyId = currency.getLong("id");
        BigDecimal discountRate = LeaseContractCal.getDiscountRate(orgId, currencyId, date, depreMonths);
        wrapper.setValue("discountrate", discountRate);
    }

    public static void setDailyDiscountRate(IObjWrapper wrapper) {
        BigDecimal discountRate = (BigDecimal)wrapper.getValue("discountrate");
        if (discountRate == null) {
            return;
        }
        discountRate = discountRate.divide(FaBigDecimalUtil.HUNDRED, 4, 4);
        DynamicObject org = (DynamicObject)wrapper.getValue("org");
        String dailyDiscountRateFormula = DailyDiscountRateFormula.COMPOUND_INTEREST.getValue();
        if (org != null) {
            dailyDiscountRateFormula = SystemParamHelper.getStringParam("dailydiscountrateformula", org.getLong("id"), DailyDiscountRateFormula.COMPOUND_INTEREST.getValue());
        }
        BigDecimal dailyDiscountRate = DailyDiscountRateFormula.COMPOUND_INTEREST.getValue().equals(dailyDiscountRateFormula) ? LeaseContractCal.calDailyRateByCompoundInterest(discountRate) : LeaseContractCal.calDailyRateBySimpleInterest(discountRate);
        dailyDiscountRate = dailyDiscountRate.multiply(FaBigDecimalUtil.HUNDRED).setScale(6, 4);
        wrapper.setValue("dailydiscountrate", dailyDiscountRate);
    }

    public static void setDepreMonths(IObjWrapper wrapper) {
        String sourceType = (String)wrapper.getValue("sourcetype");
        Date leaseEndDate = (Date)wrapper.getValue("leaseenddate");
        String transitionPlan = (String)wrapper.getValue("transitionplan");
        Date tempDate = (Date)wrapper.getValue("initconfirmdate");
        if (LeaseContractSourceType.A.name().equals(sourceType) && (TransitionPlan.A.name().equals(transitionPlan) || TransitionPlan.C.name().equals(transitionPlan))) {
            tempDate = (Date)wrapper.getValue("leasetermstartdate");
        }
        if (tempDate == null || leaseEndDate == null) {
            wrapper.setValue("depremonths", 0);
            return;
        }
        boolean monthRoundUp = LeaseContractCal.getLeaseMonthRoundUpFromSysParam(wrapper);
        int depreMonths = DateUtil.getDiffMonthsByLocalDate((Date)tempDate, (Date)leaseEndDate, (boolean)true, (boolean)monthRoundUp);
        LeaseContractDepreTypeEnum depreTypeEnum = LeaseContractDepreTypeEnum.getByValue((String)wrapper.getValue("depretype"));
        if (LeaseContractDepreTypeEnum.DAY == depreTypeEnum) {
            Date initConfirmDate = (Date)wrapper.getValue("initconfirmdate");
            depreMonths = DateUtil.getDiffDays((Date)initConfirmDate, (Date)leaseEndDate, (boolean)true, (boolean)true);
        }
        wrapper.setValue("depremonths", depreMonths);
    }

    public static void setFreeLeaseMonths(IObjWrapper wrapper) {
        Date freeLeaseStartDate = (Date)wrapper.getValue("freeleasestartdate");
        Date leaseStartDate = (Date)wrapper.getValue("leasestartdate");
        if (freeLeaseStartDate != null && leaseStartDate != null) {
            boolean monthRoundUp = LeaseContractCal.getLeaseMonthRoundUpFromSysParam(wrapper);
            int diffMonths = DateUtil.getDiffMonthsByLocalDate((Date)freeLeaseStartDate, (Date)leaseStartDate, (boolean)false, (boolean)monthRoundUp);
            wrapper.setValue("freeleasemonths", diffMonths);
        } else {
            wrapper.setValue("freeleasemonths", 0);
        }
    }

    public static void setTransitionPlan(IObjWrapper wrapper) {
        DynamicObject org = (DynamicObject)wrapper.getValue("org");
        Date initConfirmDate = (Date)wrapper.getValue("initconfirmdate");
        Date leaseTermStartDate = (Date)wrapper.getValue("leasetermstartdate");
        boolean isExempt = (Boolean)wrapper.getValue("isexempt");
        String transitionPlan = (String)wrapper.getValue("transitionplan");
        if (org == null || initConfirmDate == null || leaseTermStartDate == null) {
            wrapper.setValue("transitionplan", null);
            return;
        }
        boolean isStock = LeaseUtil.isStockContract(leaseTermStartDate, isExempt);
        if (isStock && StringUtils.isEmpty((CharSequence)transitionPlan)) {
            transitionPlan = SystemParamHelper.getStringParam("transitionplan", org.getLong("id"), "B");
        } else if (!isStock && StringUtils.isNotEmpty((CharSequence)transitionPlan)) {
            transitionPlan = null;
        }
        wrapper.setValue("transitionplan", transitionPlan);
    }

    private static BigDecimal getDiscountRate(long orgId, long currencyId, Date date, int depreMonths) {
        QFilter[] filters;
        String selectFields;
        DynamicObject[] discountRateList;
        BigDecimal rate = BigDecimal.ZERO;
        if (date == null) {
            return rate;
        }
        QFilter[] usedDiscountRateFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), BaseDataServiceHelper.getBaseDataFilter((String)"fa_discount_rate", (Long)orgId)};
        DynamicObjectCollection usedDiscountRate = QueryServiceHelper.query((String)"fa_discount_rate", (String)"org", (QFilter[])usedDiscountRateFilters);
        Set orgIdSet = usedDiscountRate.stream().map(v -> v.getLong("org")).collect(Collectors.toSet());
        if (!orgIdSet.contains(orgId)) {
            List allSupOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)orgId);
            boolean findOrg = false;
            for (int i = allSupOrgIds.size() - 1; i >= 0; --i) {
                if (!orgIdSet.contains(allSupOrgIds.get(i))) continue;
                orgId = (Long)allSupOrgIds.get(i);
                findOrg = true;
                break;
            }
            if (!findOrg) {
                return rate;
            }
        }
        if ((discountRateList = BusinessDataServiceHelper.load((String)"fa_discount_rate", (String)(selectFields = Fa.comma((String[])new String[]{"entryentity.term", "entryentity.annualizedrate"})), (QFilter[])(filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("currency", "=", (Object)currencyId), new QFilter("effectivedate", "<=", (Object)date), new QFilter("enable", "=", (Object)"1"), BaseDataServiceHelper.getBaseDataFilter((String)"fa_discount_rate", (Long)orgId)}), (String)"effectivedate desc", (int)1)) == null || discountRateList.length == 0) {
            return rate;
        }
        DynamicObject discountRate = discountRateList[0];
        DynamicObjectCollection entry = discountRate.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entry) {
            int term = row.getInt("term");
            if (depreMonths > term) continue;
            rate = row.getBigDecimal("annualizedrate");
            break;
        }
        return rate;
    }

    private static BigDecimal calDailyRateByCompoundInterest(BigDecimal discountRate) {
        BigDecimal number = BigDecimal.ONE.add(discountRate);
        int n = 365;
        BigDecimal root = FaBigDecimalUtil.rooting(number, n, 8, 4);
        return root.subtract(BigDecimal.ONE);
    }

    private static BigDecimal calDailyRateBySimpleInterest(BigDecimal discountRate) {
        return discountRate.divide(new BigDecimal("365"), 8, 4);
    }

    private static boolean getLeaseMonthRoundUpFromSysParam(IObjWrapper wrapper) {
        DynamicObject org = (DynamicObject)wrapper.getValue("org");
        long orgId = 0L;
        if (org != null) {
            orgId = org.getLong("id");
        }
        return SystemParamHelper.getBooleanParam("leasemonthroundup", orgId, false);
    }

    public static Boolean getIsExempt(IObjWrapper wrapper) {
        Date initConfirmDate = (Date)wrapper.getValue("initconfirmdate");
        Date leaseEndDate = (Date)wrapper.getValue("leaseenddate");
        boolean monthRoundUp = LeaseContractCal.getLeaseMonthRoundUpFromSysParam(wrapper);
        if (initConfirmDate != null && leaseEndDate != null && DateUtil.getDiffMonthsByLocalDate((Date)initConfirmDate, (Date)leaseEndDate, (boolean)true, (boolean)monthRoundUp) <= 12) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

