/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class LeaseFutureBizChecker {
    public static boolean existFutureLeaseChangeBill(Object billPk, Object leaseContractId, Date date) {
        return LeaseFutureBizChecker.existFutureLeaseChangeBill(billPk, leaseContractId, date, null);
    }

    public static boolean existFutureLeaseChangeBill(Object billPk, Object leaseContractId, Date date, Set<String> includeItemNumbers) {
        return !LeaseFutureBizChecker.existFutureLeaseChangeBill(billPk, Collections.singleton(leaseContractId), date, includeItemNumbers).isEmpty();
    }

    public static Map<Long, String> existFutureLeaseChangeBill(Object billPk, Set<Object> leaseContractIds, Date date, Set<String> includeItemNumbers) {
        QFilter[] changeItemFilters;
        Map leaseChangeItemMap;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("leasecontract", "in", leaseContractIds));
        if (billPk != null) {
            filters.add(new QFilter("id", "!=", billPk));
        }
        if (date != null) {
            filters.add(new QFilter("effectivedate", ">=", (Object)date));
        }
        if (includeItemNumbers != null && !includeItemNumbers.isEmpty() && (leaseChangeItemMap = BusinessDataServiceHelper.loadFromCache((String)"fa_change_item", (String)"id", (QFilter[])(changeItemFilters = new QFilter[]{new QFilter("topic", "=", (Object)"fa_lease_contract"), new QFilter("number", "in", includeItemNumbers)}))) != null) {
            filters.add(new QFilter("changeitems.fbasedataid", "in", leaseChangeItemMap.keySet()));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fa_lease_change_bill", (String)Fa.comma((String[])new String[]{"billno", "leasecontract"}), (QFilter[])filters.toArray(new QFilter[0]));
        HashMap<Long, String> result = new HashMap<Long, String>(query.size());
        for (DynamicObject leaseChangeDy : query) {
            Long leaseContractId = leaseChangeDy.getLong("leasecontract");
            if (result.containsKey(leaseContractId)) {
                String number = (String)result.get(leaseContractId);
                number = number + " \u3001" + leaseChangeDy.getString("billno");
                result.put(leaseContractId, number);
                continue;
            }
            result.put(leaseContractId, leaseChangeDy.getString("billno"));
        }
        return result;
    }
}

