/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.clear.ClearBillGenerateFacade;
import kd.fi.fa.business.enums.lease.InterestDetailSourceType;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.lease.LeaseContractGenerator;
import kd.fi.fa.business.lease.LeaseTerminationPcLockServiceUtils;
import kd.fi.fa.business.lease.RentSettleGenerator;
import kd.fi.fa.business.lease.convert.LeaseContract2LeaseContractConverter;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.model.LeaseTerminationParam;
import kd.fi.fa.business.pclock.PcLockUtils;
import kd.fi.fa.business.pclock.inter.PcParentLock;
import kd.fi.fa.business.pclock.po.PcParentLockParameter;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;
import kd.fi.fa.po.GenInterestDetailParamPo;

public class LeaseTerminationHandler {
    private static final Log logger = LogFactory.getLog(LeaseTerminationHandler.class);
    private final List<LeaseTerminationParam> params;
    private final Map<Long, DynamicObject> contract4Save = new HashMap<Long, DynamicObject>(16);

    public LeaseTerminationHandler(List<LeaseTerminationParam> params) {
        this.params = params;
    }

    public void handle() {
        this.prepareContractDate();
        Collection<DynamicObject> collection = this.contract4Save.values();
        PcParentLockParameter parentLockParameter = null;
        try {
            parentLockParameter = LeaseTerminationPcLockServiceUtils.getPcLockTryLock(collection);
            try (TXHandle h = TX.required();){
                try {
                    this.generateClearBill();
                    this.generateRenewalContract();
                    this.generateReversalRentSettle();
                    this.updateLeaseContractBaseInfo();
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_lease_contract", (DynamicObject[])this.contract4Save.values().toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    FaCommonUtils.handleOperationResult(result);
                    this.generateTerminationRecords();
                }
                catch (Throwable e) {
                    h.markRollback();
                    logger.error("handle", e);
                    throw e;
                }
            }
        }
        catch (Exception e) {
            logger.error("PcLockOperationServiceHelper", (Throwable)e);
            throw e;
        }
        finally {
            if (parentLockParameter != null) {
                PcParentLockParameter parentunLockParameter = LeaseTerminationPcLockServiceUtils.getPcParentUnLockParameter(parentLockParameter);
                PcParentLock pcParentUnLock = PcLockUtils.createParentLock(parentunLockParameter);
                pcParentUnLock.unlock();
            }
        }
    }

    private void prepareContractDate() {
        Object[] contractIds = this.params.stream().map(LeaseTerminationParam::getContractId).toArray();
        DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"));
        Stream.of(contracts).forEach(v -> this.contract4Save.put(v.getLong("id"), (DynamicObject)v));
    }

    private void generateClearBill() {
        for (LeaseTerminationParam param : this.params) {
            long contractId = param.getContractId();
            DynamicObject leaseContract = this.contract4Save.get(contractId);
            boolean isExempt = leaseContract.getBoolean("isexempt");
            if (isExempt) continue;
            Date leaseTerminationDate = param.getTerminationDate();
            long changeModeId = param.getChangeModeId();
            new ClearBillGenerateFacade().generateClearBillByLease(contractId, changeModeId, leaseTerminationDate);
        }
    }

    private void generateRenewalContract() {
        HashMap<Object, Date> contractDateMap = new HashMap<Object, Date>(this.params.size());
        for (LeaseTerminationParam param : this.params) {
            Date renewalEndDate;
            Date leaseTerminationDate;
            long contractId = param.getContractId();
            DynamicObject leaseContract = this.contract4Save.get(contractId);
            Date leaseEndDate = leaseContract.getDate("leaseenddate");
            boolean isExpiration = LeaseUtil.isExpirationTermination(leaseEndDate, leaseTerminationDate = param.getTerminationDate());
            if (!isExpiration || (renewalEndDate = param.getRenewalEndDate()) == null) continue;
            contractDateMap.put(contractId, renewalEndDate);
        }
        if (contractDateMap.isEmpty()) {
            return;
        }
        LeaseContract2LeaseContractConverter converter = new LeaseContract2LeaseContractConverter(contractDateMap);
        LeaseContractGenerator generator = new LeaseContractGenerator(converter);
        List<DynamicObject> newContractList = generator.generate(true);
        this.writeBackSrcContract(newContractList);
        OperateOption option = OperateOption.create();
        option.setVariableValue("save4Renewal", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_lease_contract", (DynamicObject[])newContractList.toArray(new DynamicObject[0]), (OperateOption)option);
        FaCommonUtils.handleOperationResult(result);
    }

    private void generateReversalRentSettle() {
        Set contractIds = this.params.stream().map(LeaseTerminationParam::getContractId).collect(Collectors.toSet());
        QFilter rentSettleFilter = new QFilter("leasecontract", "in", contractIds);
        DataSet rentSettleDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"fa_lease_rent_settle", (String)"leasecontract", (QFilter[])rentSettleFilter.toArray(), null);
        HashSet<Long> hasRentSettleContractIds = new HashSet<Long>(contractIds.size());
        for (Row row : rentSettleDataSet) {
            Long contractId = row.getLong("leasecontract");
            hasRentSettleContractIds.add(contractId);
        }
        ArrayList<GenInterestDetailParamPo> paramPos = new ArrayList<GenInterestDetailParamPo>(this.params.size());
        for (LeaseTerminationParam param : this.params) {
            Date leaseTerminationDate;
            DynamicObject leaseContract;
            Date leaseEndDate;
            boolean isExpiration;
            long contractId = param.getContractId();
            if (!hasRentSettleContractIds.contains(contractId) || (isExpiration = LeaseUtil.isExpirationTermination(leaseEndDate = (leaseContract = this.contract4Save.get(contractId)).getDate("leaseenddate"), leaseTerminationDate = param.getTerminationDate()))) continue;
            paramPos.add(new GenInterestDetailParamPo(contractId).buildTerminationDate(leaseTerminationDate));
        }
        if (!paramPos.isEmpty()) {
            new RentSettleGenerator(paramPos).reverse();
        }
    }

    private void updateLeaseContractBaseInfo() {
        Map<Long, Tuple<BigDecimal, BigDecimal>> balanceMap = this.getLeaseLiabBalance();
        Set contractIds = this.params.stream().map(LeaseTerminationParam::getContractId).collect(Collectors.toSet());
        QFilter clearBillFilter = new QFilter("srcbill", "in", contractIds);
        Map clearBillMap = BusinessDataServiceHelper.loadFromCache((String)"fa_clearbill", (String)"srcbill", (QFilter[])clearBillFilter.toArray());
        Map<Long, DynamicObject> contractClearMap = clearBillMap.values().stream().collect(Collectors.toMap(v -> v.getLong("srcbill"), v -> v));
        for (LeaseTerminationParam param : this.params) {
            long contractId = param.getContractId();
            DynamicObject leaseContract = this.contract4Save.get(contractId);
            Date leaseTerminationDate = param.getTerminationDate();
            leaseContract.set("bizstatus", (Object)LeaseContractBizStatus.B.name());
            leaseContract.set("leaseterminationdate", (Object)leaseTerminationDate);
            leaseContract.set("clearbill", (Object)contractClearMap.get(contractId));
            if (!balanceMap.containsKey(contractId)) continue;
            Tuple<BigDecimal, BigDecimal> tuple = balanceMap.get(contractId);
            leaseContract.set("leaseliaboribalance", tuple.item1);
            leaseContract.set("leaseliabbalance", tuple.item2);
        }
    }

    private void writeBackSrcContract(List<DynamicObject> newContract) {
        for (DynamicObject dyn : newContract) {
            DynamicObject srcContract = dyn.getDynamicObject("srccontract");
            if (srcContract == null) {
                logger.info(String.format("renewal contract\u3010%s\u3011: srcContract is null\u3002", dyn.getPkValue()));
                continue;
            }
            long srcContractId = srcContract.getLong("id");
            srcContract = this.contract4Save.get(srcContractId);
            srcContract.set("renewalcontractid", dyn.getPkValue());
        }
    }

    private Map<Long, Tuple<BigDecimal, BigDecimal>> getLeaseLiabBalance() {
        DynamicObject[] interestDetails;
        HashMap<Long, Date> terminationDateMap = new HashMap<Long, Date>(this.params.size());
        for (LeaseTerminationParam param : this.params) {
            long contractId = param.getContractId();
            DynamicObject leaseContract = this.contract4Save.get(contractId);
            Date leaseEndDate = leaseContract.getDate("leaseenddate");
            Date terminationDate = param.getTerminationDate();
            boolean isExpiration = LeaseUtil.isExpirationTermination(leaseEndDate, terminationDate);
            boolean isExempt = leaseContract.getBoolean("isexempt");
            if (isExpiration || isExempt) continue;
            terminationDateMap.put(contractId, terminationDate);
        }
        HashMap<Long, Tuple<BigDecimal, BigDecimal>> balanceMap = new HashMap<Long, Tuple<BigDecimal, BigDecimal>>(terminationDateMap.size());
        if (terminationDateMap.isEmpty()) {
            return balanceMap;
        }
        QFilter interestDetailFilter = new QFilter("leasecontract", "in", terminationDateMap.keySet());
        String selectFields = Fa.comma((String[])new String[]{"leasecontract", Fa.dot((String[])new String[]{"detailentry", "date"}), Fa.dot((String[])new String[]{"detailentry", "leaseliabint"}), Fa.dot((String[])new String[]{"detailentry", "endbalance"}), Fa.dot((String[])new String[]{"detailentry", "beginbalance"}), Fa.dot((String[])new String[]{"detailentry", "sourcetype"}), Fa.dot((String[])new String[]{"detailentry", "latestdata"})});
        for (DynamicObject detail : interestDetails = BusinessDataServiceHelper.load((String)"fa_interest_detail", (String)selectFields, (QFilter[])interestDetailFilter.toArray())) {
            DynamicObject leaseContract = detail.getDynamicObject("leasecontract");
            Date terminationDate = (Date)terminationDateMap.get(leaseContract.getLong("id"));
            BigDecimal leaseLiabOriBalance = BigDecimal.ZERO;
            BigDecimal leaseLiabBalance = BigDecimal.ZERO;
            DynamicObjectCollection detailEntry = detail.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : detailEntry) {
                boolean latestData;
                Date date = row.getDate("date");
                if (DateUtil.compareDate((Date)date, (Date)terminationDate) < 0) continue;
                String sourceType = row.getString("sourcetype");
                if (InterestDetailSourceType.B.name().equals(sourceType) || !(latestData = row.getBoolean("latestdata"))) continue;
                if (DateUtil.isSameDay((Date)date, (Date)terminationDate)) {
                    BigDecimal beginBalance = row.getBigDecimal("beginbalance");
                    leaseLiabOriBalance = beginBalance.add(row.getBigDecimal("leaseliabint"));
                    leaseLiabBalance = beginBalance;
                    continue;
                }
                BigDecimal leaseLiabInt = row.getBigDecimal("leaseliabint");
                leaseLiabOriBalance = leaseLiabOriBalance.add(leaseLiabInt);
            }
            balanceMap.put(leaseContract.getLong("id"), (Tuple<BigDecimal, BigDecimal>)new Tuple((Object)leaseLiabOriBalance, (Object)leaseLiabBalance));
        }
        return balanceMap;
    }

    private void generateTerminationRecords() {
        ArrayList<DynamicObject> termRecordsList = new ArrayList<DynamicObject>(this.params.size());
        Collection<DynamicObject> contracts = this.contract4Save.values();
        Set orgIdSet = contracts.stream().map(v -> v.getLong(Fa.id((String)"org"))).collect(Collectors.toSet());
        QFilter leaseInitFilter = new QFilter("org", "in", orgIdSet);
        String selectFields = Fa.comma((String[])new String[]{"org", "curperiod", "periodtype"});
        Map<Object, DynamicObject> leaseInitMap = BusinessDataServiceHelper.loadFromCache((String)"fa_lease_init", (String)selectFields, (QFilter[])leaseInitFilter.toArray());
        leaseInitMap = leaseInitMap.values().stream().collect(Collectors.toMap(v -> v.getLong(Fa.id((String)"org")), v -> v));
        Long curUserId = RequestContext.get().getCurrUserId();
        Date termOperationDate = new Date();
        for (LeaseTerminationParam param : this.params) {
            long contractId = param.getContractId();
            DynamicObject contract = this.contract4Save.get(contractId);
            long orgId = contract.getLong(Fa.id((String)"org"));
            DynamicObject leaseInit = leaseInitMap.get(orgId);
            DynamicObject curPeriod = leaseInit.getDynamicObject("curperiod");
            Date beginDate = curPeriod.getDate("begindate");
            Date endDate = curPeriod.getDate("enddate");
            Date terminationDate = param.getTerminationDate();
            Date amortizationDate = DateUtil.compareShortDate((Date)terminationDate, (Date)beginDate) >= 0 && DateUtil.compareShortDate((Date)terminationDate, (Date)endDate) <= 0 ? terminationDate : beginDate;
            DynamicObject records = BusinessDataServiceHelper.newDynamicObject((String)"fa_lease_term_records");
            records.set(Fa.id((String)"leasecontract"), (Object)contractId);
            records.set("leaseterminationdate", (Object)terminationDate);
            records.set(Fa.id((String)"changemode"), (Object)param.getChangeModeId());
            records.set("renewalenddate", (Object)param.getRenewalEndDate());
            records.set("amortizationdate", (Object)amortizationDate);
            records.set("amortizationperiod", (Object)curPeriod);
            records.set(Fa.id((String)"termoperuser"), (Object)curUserId);
            records.set("termoperdate", (Object)termOperationDate);
            records.set("undotermination", (Object)Boolean.FALSE);
            records.set("undotermoperuser", null);
            records.set("undotermoperdate", null);
            termRecordsList.add(records);
        }
        SaveServiceHelper.save((DynamicObject[])termRecordsList.toArray(new DynamicObject[0]));
        Map<Long, Long> termRecordsMap = termRecordsList.stream().collect(Collectors.toMap(v -> v.getLong(Fa.id((String)"leasecontract")), v -> v.getLong(Fa.id((String)"amortizationperiod"))));
        LeaseUtil.updateRentSettleBillStatus(termRecordsMap, "D");
    }
}

