/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.enums.lease.InterestDetailSourceType;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.enums.lease.RentSettleSourceType;
import kd.fi.fa.business.lease.LeaseTerminationPcLockServiceUtils;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.pclock.PcLockUtils;
import kd.fi.fa.business.pclock.inter.PcParentLock;
import kd.fi.fa.business.pclock.po.PcParentLockParameter;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.common.util.Fa;

public class LeaseUndoTerminationHandler {
    private static final Log logger = LogFactory.getLog(LeaseUndoTerminationHandler.class);
    private final List<Long> contractIds;
    private DynamicObject[] contract4Update;

    public LeaseUndoTerminationHandler(List<Long> contractIds) {
        this.contractIds = contractIds;
    }

    public void handle() {
        this.prepareContractDate();
        PcParentLockParameter parentLockParameter = null;
        try {
            parentLockParameter = LeaseTerminationPcLockServiceUtils.getPcLockTryLockForNoTer(Arrays.asList(this.contract4Update));
            try (TXHandle h = TX.required();){
                try {
                    this.deleteClearBillAndRestoresCard();
                    this.deleteRenewalContract();
                    this.deleteReversalRentSettle();
                    this.updateLeaseContractBaseInfo();
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_lease_contract", (DynamicObject[])this.contract4Update, (OperateOption)OperateOption.create());
                    FaCommonUtils.handleOperationResult(result);
                    this.updateTerminationRecords();
                }
                catch (Throwable e) {
                    h.markRollback();
                    logger.error("handle", e);
                    throw e;
                }
            }
        }
        catch (Exception e) {
            logger.error("LeaseUndoTerminationHandler", (Throwable)e);
            throw e;
        }
        finally {
            if (parentLockParameter != null) {
                PcParentLockParameter parentunLockParameter = LeaseTerminationPcLockServiceUtils.getPcParentUnLockParameterForNoTer(parentLockParameter);
                PcParentLock pcParentUnLock = PcLockUtils.createParentLock(parentunLockParameter);
                pcParentUnLock.unlock();
            }
        }
    }

    private void prepareContractDate() {
        this.contract4Update = BusinessDataServiceHelper.load((Object[])this.contractIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"));
    }

    private void deleteClearBillAndRestoresCard() {
        ArrayList<Long> clearBillIdList = new ArrayList<Long>(this.contractIds.size());
        for (DynamicObject contract : this.contract4Update) {
            DynamicObject clearBill = contract.getDynamicObject("clearbill");
            if (clearBill == null) continue;
            clearBillIdList.add(clearBill.getLong("id"));
        }
        if (clearBillIdList.isEmpty()) {
            return;
        }
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("unAuditFromLease", "true");
        operate.setVariableValue("ignoreSourceFlagValidate", "true");
        operate.setVariableValue("ishasright", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"fa_clearbill", (Object[])clearBillIdList.toArray(new Long[0]), (OperateOption)operate);
        FaCommonUtils.handleOperationResult(result);
        operate = OperateOption.create();
        operate.setVariableValue("deleteClearBillByUnAudit", "true");
        operate.setVariableValue("ishasright", String.valueOf(true));
        result = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_clearbill", (Object[])clearBillIdList.toArray(new Long[0]), (OperateOption)operate);
        FaCommonUtils.handleOperationResult(result);
    }

    private void deleteRenewalContract() {
        ArrayList<Long> contractId4Delete = new ArrayList<Long>(this.contractIds.size());
        for (DynamicObject contract : this.contract4Update) {
            long renewalContractId = contract.getLong("renewalcontractid");
            if (renewalContractId == 0L) continue;
            contractId4Delete.add(renewalContractId);
        }
        if (!contractId4Delete.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("deleteFromUndoTermination", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_lease_contract", (Object[])contractId4Delete.toArray(new Object[0]), (OperateOption)option);
            FaCommonUtils.handleOperationResult(result);
        }
    }

    private void deleteReversalRentSettle() {
        DynamicObject[] interestDetails;
        ArrayList<Long> earlyTerminationContractIds = new ArrayList<Long>(this.contractIds.size());
        for (DynamicObject dynamicObject : this.contract4Update) {
            Date leaseTerminationDate;
            Date leaseEndDate = dynamicObject.getDate("leaseenddate");
            boolean isExpiration = LeaseUtil.isExpirationTermination(leaseEndDate, leaseTerminationDate = dynamicObject.getDate("leaseterminationdate"));
            if (isExpiration) continue;
            earlyTerminationContractIds.add(dynamicObject.getLong("id"));
        }
        if (earlyTerminationContractIds.isEmpty()) {
            return;
        }
        QFilter interestDetailsFilter = new QFilter("leasecontract", "in", earlyTerminationContractIds);
        String selectFields = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"detailentry", "sourcetype"})});
        for (DynamicObject detail : interestDetails = BusinessDataServiceHelper.load((String)"fa_interest_detail", (String)selectFields, (QFilter[])interestDetailsFilter.toArray())) {
            DynamicObjectCollection detailEntry = detail.getDynamicObjectCollection("detailentry");
            Iterator iterator = detailEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                String sourceType = row.getString("sourcetype");
                if (!InterestDetailSourceType.B.name().equals(sourceType)) continue;
                iterator.remove();
            }
        }
        SaveServiceHelper.save((DynamicObject[])interestDetails);
        QFilter[] qFilterArray = new QFilter[]{new QFilter("leasecontract", "in", earlyTerminationContractIds), new QFilter("sourcetype", "=", (Object)RentSettleSourceType.B.name())};
        LeaseUtil.deleteRentSettle(qFilterArray, true);
    }

    private void updateLeaseContractBaseInfo() {
        for (DynamicObject contract : this.contract4Update) {
            contract.set("bizstatus", (Object)LeaseContractBizStatus.A.name());
            contract.set("leaseterminationdate", null);
            contract.set("clearbill", null);
            contract.set("renewalcontractid", null);
            contract.set("leaseliaboribalance", (Object)BigDecimal.ZERO);
            contract.set("leaseliabbalance", (Object)BigDecimal.ZERO);
        }
    }

    private void updateTerminationRecords() {
        QFilter[] filters = new QFilter[]{new QFilter("leasecontract", "in", this.contractIds), new QFilter("undotermination", "=", (Object)Boolean.FALSE)};
        String selectFields = Fa.comma((String[])new String[]{"id", Fa.id((String)"leasecontract"), Fa.id((String)"amortizationperiod"), "undotermination", "undotermoperuser", "undotermoperdate"});
        DynamicObject[] recordsArr = BusinessDataServiceHelper.load((String)"fa_lease_term_records", (String)selectFields, (QFilter[])filters);
        Long curUserId = RequestContext.get().getCurrUserId();
        Date undoTermOperationDate = new Date();
        for (DynamicObject records : recordsArr) {
            records.set("undotermination", (Object)Boolean.TRUE);
            records.set(Fa.id((String)"undotermoperuser"), (Object)curUserId);
            records.set("undotermoperdate", (Object)undoTermOperationDate);
        }
        SaveServiceHelper.save((DynamicObject[])recordsArr);
        Map<Long, Long> termRecordsMap = Arrays.stream(recordsArr).collect(Collectors.toMap(v -> v.getLong(Fa.id((String)"leasecontract")), v -> v.getLong(Fa.id((String)"amortizationperiod"))));
        LeaseUtil.updateRentSettleBillStatus(termRecordsMap, "C");
    }
}

