/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaBigDecimalUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.po.InterestDetailRowPo;

public class RealDailyIntRateCalculator {
    private static final Log logger = LogFactory.getLog(RealDailyIntRateCalculator.class);
    private final DynamicObject leaseContract;
    private final Date beginDate;
    private final Map<String, BigDecimal> amountMap;
    private final Date lastPayDate;
    private final Date endDate;
    private final List<InterestDetailRowPo> detailRowList = new ArrayList<InterestDetailRowPo>(256);

    public RealDailyIntRateCalculator(DynamicObject leaseContract, Date beginDate, Map<String, BigDecimal> amountMap) {
        if (amountMap.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b9e\u9645\u65e5\u5229\u7387\u51fa\u73b0\u9519\u8bef\uff1a\u6ca1\u6709\u4ed8\u6b3e\u4fe1\u606f\uff0c\u65e0\u9700\u8ba1\u606f\u3002", (String)"RealDailyIntRateCalculator_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        this.leaseContract = leaseContract;
        this.beginDate = beginDate;
        this.amountMap = amountMap;
        String lastPayDateStr = (String)amountMap.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()).get(0);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            this.lastPayDate = format.parse(lastPayDateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b9e\u9645\u65e5\u5229\u7387\u51fa\u73b0\u9519\u8bef\uff1a\u65e5\u671f[%s]\u8f6c\u6362\u65f6\u53d1\u751f\u9519\u8bef\u3002", (String)"fi-fa-business", (String)"fi-fa-business", (Object[])new Object[0]), lastPayDateStr));
        }
        Date leaseEndDate = leaseContract.getDate("leaseenddate");
        this.endDate = DateUtil.compareDate((Date)this.lastPayDate, (Date)leaseEndDate) > 0 ? this.lastPayDate : leaseEndDate;
    }

    protected BigDecimal getDetailBeginBalance() {
        return this.leaseContract.getBigDecimal("leaseliab");
    }

    protected BigDecimal getNotConfirmFinCost() {
        BigDecimal leaseLiab = this.leaseContract.getBigDecimal("leaseliab");
        BigDecimal leaseLiabOri = this.leaseContract.getBigDecimal("leaseliabori");
        return leaseLiabOri.subtract(leaseLiab);
    }

    private void initData() {
        Date rowDate = this.beginDate;
        while (DateUtil.compareDate((Date)rowDate, (Date)this.endDate) <= 0) {
            String rowDateStr;
            BigDecimal amount;
            InterestDetailRowPo detailRow = new InterestDetailRowPo(rowDate);
            if (DateUtil.compareDate((Date)rowDate, (Date)this.beginDate) == 0) {
                BigDecimal detailBeginBalance = this.getDetailBeginBalance();
                detailRow.setBeginBalance(detailBeginBalance.doubleValue());
            }
            if ((amount = this.amountMap.get(rowDateStr = this.formatDate(rowDate))) != null) {
                detailRow.setLeaseLiabPay(amount.doubleValue());
            }
            this.detailRowList.add(detailRow);
            rowDate = DateUtil.addDay((Date)rowDate, (int)1);
        }
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return dateFormat.format(date);
    }

    public BigDecimal calculate() {
        this.initData();
        BigDecimal dailyDiscountRate = this.leaseContract.getBigDecimal("dailydiscountrate");
        if (dailyDiscountRate.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5e74\u6298\u73b0\u7387\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"RealDailyIntRateCalculator_2", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        BigDecimal dailyDiscountRate4Cal = dailyDiscountRate.divide(FaBigDecimalUtil.HUNDRED, 8, LeaseUtil.getRoundingMode4CalAmount());
        double notConfirmFinCost = this.getNotConfirmFinCost().doubleValue();
        if (notConfirmFinCost == 0.0) {
            return BigDecimal.ZERO;
        }
        double initRate = dailyDiscountRate4Cal.doubleValue();
        double interestTotal = this.calculateInterestTotal(initRate);
        double difference = interestTotal - notConfirmFinCost;
        double intTotalTemp = interestTotal;
        double dailyRateTemp = initRate;
        double lastPositiveDailyRate = initRate;
        double lastNegativeDailyRate = initRate;
        double lastPositiveIntTotal = interestTotal;
        double lastNegativeIntTotal = interestTotal;
        if (difference > 0.0) {
            while (difference > 0.0) {
                lastPositiveDailyRate = dailyRateTemp;
                lastPositiveIntTotal = intTotalTemp;
                intTotalTemp = this.calculateInterestTotal(dailyRateTemp *= 0.98);
                difference = intTotalTemp - notConfirmFinCost;
                logger.info(String.format("\u51cf\u5c11\u65e5\u5229\u7387\uff0c\u903c\u8fd1\u672a\u786e\u8ba4\u878d\u8d44\u8d39\u7528\uff1a\u65e5\u5229\u7387\u4e34\u65f6\u53d6\u503c\uff1a[%s]\uff0c\u201c\u79df\u8d41\u8d1f\u503a-\u5229\u606f\u201d\u603b\u548c\uff1a[%s]\uff0c\u5dee\u503c\uff1a[%s]", dailyRateTemp, intTotalTemp, difference));
                this.checkTempDailyRate(dailyRateTemp);
            }
            while (difference < 0.0) {
                lastNegativeDailyRate = dailyRateTemp;
                lastNegativeIntTotal = intTotalTemp;
                intTotalTemp = this.calculateInterestTotal(dailyRateTemp *= 1.01);
                difference = intTotalTemp - notConfirmFinCost;
                logger.info(String.format("\u589e\u5927\u65e5\u5229\u7387\uff0c\u903c\u8fd1\u672a\u786e\u8ba4\u878d\u8d44\u8d39\u7528\uff1a\u65e5\u5229\u7387\u4e34\u65f6\u53d6\u503c\uff1a[%s]\uff0c\u201c\u79df\u8d41\u8d1f\u503a-\u5229\u606f\u201d\u603b\u548c\uff1a[%s]\uff0c\u5dee\u503c\uff1a[%s]", dailyRateTemp, intTotalTemp, difference));
                this.checkTempDailyRate(dailyRateTemp);
            }
            if (intTotalTemp < lastPositiveIntTotal) {
                lastPositiveDailyRate = dailyRateTemp;
                lastPositiveIntTotal = intTotalTemp;
            }
        } else if (difference < 0.0) {
            while (difference < 0.0) {
                lastNegativeDailyRate = dailyRateTemp;
                lastNegativeIntTotal = intTotalTemp;
                intTotalTemp = this.calculateInterestTotal(dailyRateTemp *= 1.02);
                difference = intTotalTemp - notConfirmFinCost;
                logger.info(String.format("\u589e\u5927\u65e5\u5229\u7387\uff0c\u903c\u8fd1\u672a\u786e\u8ba4\u878d\u8d44\u8d39\u7528\uff1a\u65e5\u5229\u7387\u4e34\u65f6\u53d6\u503c\uff1a[%s]\uff0c\u201c\u79df\u8d41\u8d1f\u503a-\u5229\u606f\u201d\u603b\u548c\uff1a[%s]\uff0c\u5dee\u503c\uff1a[%s]", dailyRateTemp, intTotalTemp, difference));
                this.checkTempDailyRate(dailyRateTemp);
            }
            while (difference > 0.0) {
                lastPositiveDailyRate = dailyRateTemp;
                lastPositiveIntTotal = intTotalTemp;
                intTotalTemp = this.calculateInterestTotal(dailyRateTemp *= 0.99);
                difference = intTotalTemp - notConfirmFinCost;
                logger.info(String.format("\u51cf\u5c11\u65e5\u5229\u7387\uff0c\u903c\u8fd1\u672a\u786e\u8ba4\u878d\u8d44\u8d39\u7528\uff1a\u65e5\u5229\u7387\u4e34\u65f6\u53d6\u503c\uff1a[%s]\uff0c\u201c\u79df\u8d41\u8d1f\u503a-\u5229\u606f\u201d\u603b\u548c\uff1a[%s]\uff0c\u5dee\u503c\uff1a[%s]", dailyRateTemp, intTotalTemp, difference));
                this.checkTempDailyRate(dailyRateTemp);
            }
            if (intTotalTemp > lastNegativeIntTotal) {
                lastNegativeDailyRate = dailyRateTemp;
                lastNegativeIntTotal = intTotalTemp;
            }
        } else {
            logger.info("\u5dee\u503c\u4e3a0\uff0c\u76f4\u63a5\u7528\u5408\u540c\u7684\u65e5\u6298\u73b0\u7387");
            return new BigDecimal(String.valueOf(dailyRateTemp));
        }
        double dailyRate = (notConfirmFinCost - lastPositiveIntTotal) / (lastNegativeIntTotal - lastPositiveIntTotal) * (lastNegativeDailyRate - lastPositiveDailyRate) + lastPositiveDailyRate;
        BigDecimal realDailyRate = new BigDecimal(String.valueOf(dailyRate)).setScale(8, LeaseUtil.getRoundingMode4CalAmount());
        logger.info(String.format("\u6700\u540e\u4e00\u4e2a\u6b63\u6570\u65e5\u5229\u7387\uff1a%s\uff0c\u6700\u540e\u4e00\u4e2a\u6b63\u6570\u65e5\u5229\u7387\u7684\u5229\u606f\u6c47\u603b\uff1a%s\uff0c\u6700\u540e\u4e00\u4e2a\u8d1f\u6570\u65e5\u5229\u7387\uff1a%s\uff0c\u6700\u540e\u4e00\u4e2a\u8d1f\u6570\u65e5\u5229\u7387\u7684\u5229\u606f\u6c47\u603b\uff1a%s\uff0c\u6700\u540e\u7b97\u51fa\u6765\u7684\u5b9e\u9645\u65e5\u5229\u7387\uff1a%s", lastPositiveDailyRate, lastPositiveIntTotal, lastNegativeDailyRate, lastNegativeIntTotal, realDailyRate));
        return realDailyRate;
    }

    private double calculateInterestTotal(double r) {
        InterestDetailRowPo dailyRentPo;
        Date date;
        double lastEndBalance = 0.0;
        double interestTotal = 0.0;
        for (int i = 0; i < this.detailRowList.size() && DateUtil.compareDate((Date)(date = (dailyRentPo = this.detailRowList.get(i)).getDate()), (Date)this.lastPayDate) < 0; ++i) {
            double intTemp;
            if (i == 0) {
                lastEndBalance = dailyRentPo.getBeginBalance();
                intTemp = (dailyRentPo.getBeginBalance() - dailyRentPo.getLeaseLiabPay()) * r;
            } else {
                intTemp = (lastEndBalance - dailyRentPo.getLeaseLiabPay()) * r;
            }
            intTemp = (double)Math.round(intTemp * 100.0) / 100.0;
            lastEndBalance = lastEndBalance - dailyRentPo.getLeaseLiabPay() + intTemp;
            interestTotal += intTemp;
        }
        if (interestTotal < 0.0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b9e\u9645\u65e5\u5229\u7387\u51fa\u73b0\u9519\u8bef\uff1a\u5229\u606f\u603b\u989d\u5c0f\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u4ed8\u6b3e\u89c4\u5219\u6216\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u3002", (String)"RealDailyIntRateCalculator_3", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return interestTotal;
    }

    private void checkTempDailyRate(double rate) {
        if (Double.isInfinite(rate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b9e\u9645\u65e5\u5229\u7387\u51fa\u73b0\u9519\u8bef\uff1a\u65e5\u5229\u7387\u8d8b\u8fd1\u4e8e\u65e0\u7a77\u5927\u3002", (String)"RealDailyIntRateCalculator_4", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (Double.isNaN(rate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b9e\u9645\u65e5\u5229\u7387\u51fa\u73b0\u9519\u8bef\uff1a\u65e5\u5229\u7387\u8d8b\u8fd1\u4e8e\u65e0\u7a77\u5c0f\u3002", (String)"RealDailyIntRateCalculator_5", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }
}

