/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.enums.lease.InterestDetailSourceType;
import kd.fi.fa.business.enums.lease.RentSettleSourceType;
import kd.fi.fa.business.lease.InterestDetailGenerator;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Tuple;
import kd.fi.fa.po.GenInterestDetailParamPo;

public class RentSettleGenerator {
    private final List<GenInterestDetailParamPo> paramPos;
    protected final String BILL_NO_CONNECTOR = "-";

    public RentSettleGenerator(List<GenInterestDetailParamPo> paramPos) {
        this.paramPos = paramPos;
    }

    public void generate() {
        InterestDetailGenerator generator = new InterestDetailGenerator(this.paramPos);
        List<DynamicObject> interestDetails = generator.generate();
        ArrayList<DynamicObject> rentSettles = new ArrayList<DynamicObject>(this.paramPos.size());
        for (DynamicObject interestDetail : interestDetails) {
            DynamicObject leaseContract = interestDetail.getDynamicObject("leasecontract");
            rentSettles.addAll(this.generateByInterestDetail(interestDetail, leaseContract));
        }
        SaveServiceHelper.save((DynamicObject[])interestDetails.toArray(new DynamicObject[0]));
        LeaseUtil.saveRentSettle(rentSettles.toArray(new DynamicObject[0]), true);
    }

    protected List<DynamicObject> generateByInterestDetail(DynamicObject interestDetail, DynamicObject leaseContract) {
        ArrayList<DynamicObject> rentSettleList = new ArrayList<DynamicObject>(32);
        boolean isExempt = leaseContract.getBoolean("isexempt");
        DynamicObject org = interestDetail.getDynamicObject("org");
        String contractNumber = leaseContract.getString("number");
        DynamicObject currency = interestDetail.getDynamicObject("currency");
        DynamicObjectCollection detailEntry = interestDetail.getDynamicObjectCollection("detailentry");
        int seq = this.getBeginIndex4Generate();
        BigDecimal rent = BigDecimal.ZERO;
        int interestDays = 0;
        BigDecimal interestSum = BigDecimal.ZERO;
        long lastAmortizationPeriodId = 0L;
        DynamicObject lastAmortizationPeriod = null;
        BigDecimal lastEndBalance = BigDecimal.ZERO;
        BigDecimal lastRealDailyRate = BigDecimal.ZERO;
        Date lastData = null;
        for (DynamicObject detail : detailEntry) {
            DynamicObject amortizationPeriod = detail.getDynamicObject("amortizationperiod");
            if (amortizationPeriod == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u644a\u9500\u4e0e\u8ba1\u606f\u53d1\u751f\u5f02\u5e38\uff1a\u8ba1\u606f\u660e\u7ec6\u8868\u7b2c[%s]\u884c\u644a\u9500\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"RentSettleGenerator_0", (String)"fi-fa-business", (Object[])new Object[0]), detail.getInt("seq")));
            }
            long amortizationPeriodId = amortizationPeriod.getLong("id");
            if (!this.isBeginGenerate(amortizationPeriodId)) continue;
            if (lastAmortizationPeriodId != 0L && amortizationPeriodId != lastAmortizationPeriodId) {
                String suffix = this.formatRentSettleNo(seq++);
                String billNo = contractNumber + "-" + suffix;
                Tuple<Integer, Integer> tupleMonth = this.getFormatMonthAndNextMonth(lastData);
                DynamicObject rentSettle = this.generateRentSettle(org, leaseContract, billNo, lastAmortizationPeriod, rent, interestDays, lastRealDailyRate, interestSum, lastEndBalance, (Integer)tupleMonth.item1, (Integer)tupleMonth.item2, currency);
                rentSettleList.add(rentSettle);
                rent = BigDecimal.ZERO;
                interestDays = 0;
                interestSum = BigDecimal.ZERO;
            }
            BigDecimal leaseLiabPay = detail.getBigDecimal("leaseliabpay");
            rent = rent.add(leaseLiabPay);
            BigDecimal leaseLiabInt = detail.getBigDecimal("leaseliabint");
            interestSum = interestSum.add(leaseLiabInt);
            boolean latestData = detail.getBoolean("latestdata");
            if (latestData && !isExempt) {
                ++interestDays;
            }
            lastAmortizationPeriod = amortizationPeriod;
            lastAmortizationPeriodId = amortizationPeriodId;
            lastEndBalance = detail.getBigDecimal("endbalance");
            lastRealDailyRate = detail.getBigDecimal("realdailyrate");
            lastData = detail.getDate("date");
        }
        String suffix = this.formatRentSettleNo(seq);
        String billNo = contractNumber + "-" + suffix;
        Tuple<Integer, Integer> tupleMonth = this.getFormatMonthAndNextMonth(lastData);
        DynamicObject rentSettle = this.generateRentSettle(org, leaseContract, billNo, lastAmortizationPeriod, rent, interestDays, lastRealDailyRate, interestSum, lastEndBalance, (Integer)tupleMonth.item1, (Integer)tupleMonth.item2, currency);
        rentSettleList.add(rentSettle);
        return rentSettleList;
    }

    protected int getBeginIndex4Generate() {
        return 1;
    }

    protected boolean isBeginGenerate(long amortizationPeriodId) {
        return true;
    }

    public void reverse() {
        InterestDetailGenerator generator = new InterestDetailGenerator(this.paramPos);
        List<DynamicObject> interestDetails = generator.reverse();
        ArrayList<DynamicObject> rentSettles = new ArrayList<DynamicObject>(this.paramPos.size());
        Map<Long, Integer> rentSettleNumMap = this.queryRentSettleNum();
        for (DynamicObject detail : interestDetails) {
            DynamicObject leaseContract = detail.getDynamicObject("leasecontract");
            long leaseContractId = leaseContract.getLong("id");
            Integer rentSettleCnt = rentSettleNumMap.get(leaseContractId);
            List<DynamicObject> reverseRentSettleList = this.generate4TerminationReverse(detail, rentSettleCnt + 1);
            rentSettles.addAll(reverseRentSettleList);
        }
        SaveServiceHelper.save((DynamicObject[])interestDetails.toArray(new DynamicObject[0]));
        LeaseUtil.saveRentSettle(rentSettles.toArray(new DynamicObject[0]), true);
    }

    private List<DynamicObject> generate4TerminationReverse(DynamicObject interestDetail, int rentSettleBeginSeq) {
        ArrayList<DynamicObject> reverseRentSettleList = new ArrayList<DynamicObject>(10);
        DynamicObject org = interestDetail.getDynamicObject("org");
        DynamicObject leaseContract = interestDetail.getDynamicObject("leasecontract");
        String contractNumber = leaseContract.getString("number");
        DynamicObject currency = interestDetail.getDynamicObject("currency");
        DynamicObjectCollection detailEntry = interestDetail.getDynamicObjectCollection("detailentry");
        int seq = rentSettleBeginSeq;
        BigDecimal rent = BigDecimal.ZERO;
        int interestDays = 0;
        BigDecimal interestSum = BigDecimal.ZERO;
        long lastAmortizationPeriodId = 0L;
        DynamicObject lastAmortizationPeriod = null;
        BigDecimal lastRealDailyRate = BigDecimal.ZERO;
        boolean hasReversalDetail = false;
        for (DynamicObject detail : detailEntry) {
            String sourceType = detail.getString("sourcetype");
            if (!InterestDetailSourceType.B.name().equals(sourceType)) continue;
            hasReversalDetail = true;
            DynamicObject amortizationPeriod = detail.getDynamicObject("amortizationperiod");
            long amortizationPeriodId = amortizationPeriod.getLong("id");
            if (lastAmortizationPeriodId != 0L && amortizationPeriodId != lastAmortizationPeriodId) {
                String suffix = this.formatRentSettleNo(seq++);
                String billNo = contractNumber + "-" + suffix;
                DynamicObject rentSettle = this.generateReverseRentSettle(org, leaseContract, billNo, lastAmortizationPeriod, rent, interestDays, lastRealDailyRate, interestSum, currency);
                reverseRentSettleList.add(rentSettle);
                rent = BigDecimal.ZERO;
                interestDays = 0;
                interestSum = BigDecimal.ZERO;
            }
            BigDecimal leaseLiabPay = detail.getBigDecimal("leaseliabpay");
            rent = rent.add(leaseLiabPay);
            BigDecimal leaseLiabInt = detail.getBigDecimal("leaseliabint");
            interestSum = interestSum.add(leaseLiabInt);
            if (BigDecimal.ZERO.compareTo(leaseLiabInt) != 0) {
                ++interestDays;
            }
            lastAmortizationPeriod = amortizationPeriod;
            lastAmortizationPeriodId = amortizationPeriodId;
            lastRealDailyRate = detail.getBigDecimal("realdailyrate");
        }
        if (hasReversalDetail) {
            String suffix = this.formatRentSettleNo(seq);
            String billNo = contractNumber + "-" + suffix;
            DynamicObject rentSettle = this.generateReverseRentSettle(org, leaseContract, billNo, lastAmortizationPeriod, rent, interestDays, lastRealDailyRate, interestSum, currency);
            reverseRentSettleList.add(rentSettle);
        }
        return reverseRentSettleList;
    }

    private Map<Long, Integer> queryRentSettleNum() {
        List contractIds = this.paramPos.stream().map(GenInterestDetailParamPo::getLeaseContractId).collect(Collectors.toList());
        QFilter filter = new QFilter("leasecontract", "in", contractIds);
        DataSet rentSettleDataSet = QueryServiceHelper.queryDataSet((String)RentSettleGenerator.class.toString(), (String)"fa_lease_rent_settle", (String)"leasecontract", (QFilter[])filter.toArray(), null);
        rentSettleDataSet = rentSettleDataSet.groupBy(new String[]{"leasecontract"}).count("cnt").finish();
        HashMap<Long, Integer> rentSettleNumMap = new HashMap<Long, Integer>(this.paramPos.size());
        for (Row row : rentSettleDataSet) {
            Long contractId = row.getLong("leasecontract");
            Integer cnt = row.getInteger("cnt");
            rentSettleNumMap.put(contractId, cnt);
        }
        return rentSettleNumMap;
    }

    private Tuple<Integer, Integer> getFormatMonthAndNextMonth(Date date) {
        if (date == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u644a\u9500\u4e0e\u8ba1\u606f\u53d1\u751f\u5f02\u5e38\uff1a\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RentSettleGenerator_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        int month = this.formatDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        int nextMonth = this.formatDate(calendar.getTime());
        return new Tuple((Object)month, (Object)nextMonth);
    }

    private int formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        String formatDateStr = format.format(date);
        return Integer.parseInt(formatDateStr + "00");
    }

    private String formatRentSettleNo(int seq) {
        DecimalFormat format = new DecimalFormat("000");
        return format.format(seq);
    }

    private DynamicObject generateReverseRentSettle(DynamicObject org, DynamicObject leaseContract, String billNo, DynamicObject amortizationPeriod, BigDecimal rent, int interestDays, BigDecimal dailyRate, BigDecimal interestSum, DynamicObject currency) {
        DynamicObject rentSettle = this.generateRentSettle(org, leaseContract, billNo, amortizationPeriod, rent, interestDays, dailyRate, interestSum, BigDecimal.ZERO, 0, 0, currency);
        rentSettle.set("sourcetype", (Object)RentSettleSourceType.B.name());
        return rentSettle;
    }

    private DynamicObject generateRentSettle(DynamicObject org, DynamicObject leaseContract, String billNo, DynamicObject amortizationPeriod, BigDecimal rent, int interestDays, BigDecimal dailyRate, BigDecimal interestSum, BigDecimal endLeaseLiab, int settleMonth, int nextSettleMonth, DynamicObject currency) {
        DynamicObject rentSettle = BusinessDataServiceHelper.newDynamicObject((String)"fa_lease_rent_settle");
        rentSettle.set("org", (Object)org);
        rentSettle.set("leasecontract", (Object)leaseContract);
        rentSettle.set("billno", (Object)billNo);
        rentSettle.set("amortizationperiod", (Object)amortizationPeriod);
        if (amortizationPeriod != null) {
            Date endDate = amortizationPeriod.getDate("enddate");
            rentSettle.set("settledate", (Object)endDate);
        }
        rentSettle.set("rent", (Object)rent);
        rentSettle.set("interestdays", (Object)interestDays);
        rentSettle.set("irr", (Object)dailyRate);
        rentSettle.set("interest", (Object)interestSum);
        rentSettle.set("endleaseliab", (Object)endLeaseLiab);
        rentSettle.set("settledatemonth", (Object)settleMonth);
        rentSettle.set("nextsettledatemonth", (Object)nextSettleMonth);
        rentSettle.set("currency", (Object)currency);
        rentSettle.set("sourcetype", (Object)RentSettleSourceType.A.name());
        rentSettle.set("billstatus", (Object)BillStatus.C.name());
        rentSettle.set("createtime", (Object)new Date());
        rentSettle.set("creator", (Object)ContextUtil.getUserId());
        rentSettle.set("modifytime", (Object)new Date());
        rentSettle.set("modifier", (Object)ContextUtil.getUserId());
        rentSettle.set("auditdate", (Object)new Date());
        rentSettle.set("auditor", (Object)ContextUtil.getUserId());
        return rentSettle;
    }
}

