/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease.backup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.lease.backup.inter.ILeaseContractCopy;

public abstract class AbstractLeaseContractCopy
implements ILeaseContractCopy {
    List<Long> curContrIdList;
    List<DynamicObject> curContractList;
    Map<String, DynamicObject> previousBackIdMap = new HashMap<String, DynamicObject>(16);
    List<DynamicObject> newBackupContractList;
    static final String preCopyFields = "id,PREVIOUSBACKID,SETTLESHARESRCID";

    @Override
    public List<DynamicObject> copy(List<Long> contractIds) {
        this.curContrIdList = contractIds;
        this.curContractList = this.select(contractIds);
        if (this.curContractList == null || this.curContractList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5907\u4efdID\u6ca1\u6709\u5bf9\u5e94\u7684\u5408\u540c\uff0c\u5907\u4efd\u5931\u8d25", (String)"AbstractLeaseContractCopy_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        this.preCopy();
        this.newBackupContractList = new ArrayList<DynamicObject>(contractIds.size());
        for (DynamicObject curContract : this.curContractList) {
            this.addBackupInfo(curContract);
            DynamicObject backupContract = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)curContract);
            this.newBackupContractList.add(backupContract);
        }
        SaveServiceHelper.save((DynamicObject[])this.newBackupContractList.toArray(new DynamicObject[1]));
        this.handleRentSettleForCopy();
        this.handleInterestDetailForCopy();
        return this.newBackupContractList;
    }

    List<DynamicObject> select(List<Long> contractIds) {
        DynamicObject[] contractList = BusinessDataServiceHelper.load((Object[])contractIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"));
        return Arrays.asList(contractList);
    }

    void preCopy() {
        if (this.curContractList == null || this.curContractList.size() == 0) {
            return;
        }
        if (this.curContrIdList.size() != this.curContractList.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570ID%s\u4e2d\u5b58\u5728\u6ca1\u6709\u5bf9\u5e94\u5408\u540c,\u5907\u4efd\u5931\u8d25", (String)"AbstractLeaseContractCopy_1", (String)"fi-fa-business", (Object[])new Object[0]), this.curContrIdList.toString()));
        }
        ArrayList<String> numberList = new ArrayList<String>(this.curContractList.size());
        ArrayList<String> isbackNumList = new ArrayList<String>(this.curContractList.size());
        for (DynamicObject dynamicObject : this.curContractList) {
            boolean isBack;
            Long id = dynamicObject.getLong("id");
            Long masterId = dynamicObject.getLong("masterid");
            if (id.longValue() != masterId.longValue()) {
                numberList.add(dynamicObject.getString("number"));
            }
            if (!(isBack = dynamicObject.getBoolean("isbak"))) continue;
            isbackNumList.add(dynamicObject.getString("number"));
        }
        if (isbackNumList.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570%s\u7684\u5bf9\u5e94\u5408\u540c\u662f\u5907\u4efd\u5408\u540c,\u5907\u4efd\u5931\u8d25", (String)"AbstractLeaseContractCopy_2", (String)"fi-fa-business", (Object[])new Object[0]), ((Object)isbackNumList).toString()));
        }
        if (numberList.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c%s\u7684ID\u4e0d\u7b49\u4e8emasterID,\u5907\u4efd\u5931\u8d25", (String)"AbstractLeaseContractCopy_3", (String)"fi-fa-business", (Object[])new Object[0]), ((Object)numberList).toString()));
        }
        ArrayList<Long> previousBackIdList = new ArrayList<Long>(this.curContractList.size());
        for (DynamicObject curContract : this.curContractList) {
            previousBackIdList.add(curContract.getLong("previousbackid"));
        }
        QFilter[] qFilterArray = new QFilter[]{new QFilter("id", "in", previousBackIdList)};
        DynamicObjectCollection previousBackContrList = QueryServiceHelper.query((String)"fa_lease_contract", (String)preCopyFields, (QFilter[])qFilterArray);
        for (DynamicObject previousBackContr : previousBackContrList) {
            this.previousBackIdMap.put(previousBackContr.getString("id"), previousBackContr);
        }
    }

    public abstract void addBackupInfo(DynamicObject var1);

    public abstract void deleteOldBackupVersion();

    abstract void handleRentSettleForCopy();

    abstract void handleInterestDetailForCopy();
}

