/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.fa.business.lease.convert.AbstractLeaseContractConverter;
import kd.fi.fa.business.lease.convert.LeaseContractData;
import kd.fi.fa.common.util.DateUtil;

public class LeaseContract2LeaseContractConverter
extends AbstractLeaseContractConverter {
    private final Map<Object, Date> contractDateMap;

    public LeaseContract2LeaseContractConverter(Map<Object, Date> contractDateMap) {
        super(contractDateMap.keySet().toArray(), "fa_lease_contract");
        this.contractDateMap = contractDateMap;
    }

    @Override
    public List<LeaseContractData> convert() {
        ArrayList<LeaseContractData> contractDataList = new ArrayList<LeaseContractData>(this.srcBills.size());
        for (DynamicObject srcBill : this.srcBills) {
            LeaseContractData data = new LeaseContractData();
            this.buildHead(data, srcBill);
            contractDataList.add(data);
        }
        return contractDataList;
    }

    private void buildHead(LeaseContractData data, DynamicObject srcBill) {
        DynamicObject assetUnit = srcBill.getDynamicObject("assetunit");
        data.setAssetUnit(assetUnit);
        DynamicObject org = srcBill.getDynamicObject("org");
        data.setOrg(org);
        DynamicObject currency = srcBill.getDynamicObject("currency");
        data.setCurrency(currency);
        String contractName = srcBill.getString("name");
        data.setContractName(contractName);
        DynamicObject leaser = srcBill.getDynamicObject("leaser");
        data.setLeaser(leaser);
        DynamicObject assetCat = srcBill.getDynamicObject("assetcat");
        data.setAssetCat(assetCat);
        String assetName = srcBill.getString("assetname");
        data.setAssetName(assetName);
        DynamicObject storePlace = srcBill.getDynamicObject("storeplace");
        data.setStorePlace(storePlace);
        DynamicObject unit = srcBill.getDynamicObject("unit");
        data.setUnit(unit);
        BigDecimal assetAmount = srcBill.getBigDecimal("assetamount");
        data.setAssetAmount(assetAmount);
        Date srcLeaseEndDate = srcBill.getDate("leaseenddate");
        Date leaseStartDate = DateUtil.addDay((Date)srcLeaseEndDate, (int)1);
        data.setLeaseStartDate(leaseStartDate);
        Date leaseEndDate = this.contractDateMap.get(srcBill.getPkValue());
        data.setLeaseEndDate(leaseEndDate);
        data.setSrcContract(srcBill);
        data.setSrcEntityNumber("fa_lease_contract");
        data.setSrcBillId(srcBill.getPkValue());
    }
}

