/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.lease.model.PayPlanCompareObject;
import kd.fi.fa.business.lease.model.PayRuleCompareResult;
import kd.fi.fa.business.lease.utils.Change2ContrServiceHelper;
import kd.fi.fa.common.util.DateUtil;

public class LeaseChangeUtil {
    private static final Log logger = LogFactory.getLog(LeaseChangeUtil.class);

    public static void updateChangeBakContract(OperateOption option, BeginOperationTransactionArgs e) {
        String pageId = LeaseChangeUtil.getAftContractPageId(option);
        if (pageId == null) {
            return;
        }
        DynamicObject bill = e.getDataEntities()[0];
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        if (leaseContract == null) {
            logger.info("\u539f\u5408\u540c\u4e3a\u7a7a");
            return;
        }
        DynamicObject curBakContract = bill.getDynamicObject("changebakcontract");
        DynamicObject changeBakContract = LeaseChangeUtil.buildChangeBakContract(pageId, curBakContract == null);
        bill.set("changebakcontract", (Object)changeBakContract);
    }

    public static DynamicObject getAftContractForValidate(OperateOption option, AddValidatorsEventArgs e) {
        String pageId = LeaseChangeUtil.getAftContractPageId(option);
        if (pageId == null) {
            return null;
        }
        DynamicObject bill = e.getDataEntities()[0];
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        if (leaseContract == null) {
            logger.info("\u539f\u5408\u540c\u4e3a\u7a7a");
            return null;
        }
        return LeaseChangeUtil.getAftContractByPageId(pageId);
    }

    private static String getAftContractPageId(OperateOption option) {
        if (!option.containsVariable("aftPageId")) {
            logger.info("\u4e0d\u5b58\u5728\u53c2\u6570\uff1aFaOperationConstants.LEASE_CHANGE_AFT_PAGE_ID");
            return null;
        }
        String pageId = option.getVariableValue("aftPageId");
        if (pageId == null) {
            logger.info("\u53d8\u66f4\u540e\u5408\u540cpageId\u4e3a\u7a7a");
            return null;
        }
        return pageId;
    }

    private static DynamicObject getAftContractByPageId(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u53d8\u66f4\u540e\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u91cd\u8bd5\u3002", (String)"LeaseChangeUtil_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return view.getModel().getDataEntity(true);
    }

    private static DynamicObject buildChangeBakContract(String pageId, boolean isFirst) {
        DynamicObject aftContract = LeaseChangeUtil.getAftContractByPageId(pageId);
        DynamicObject changeBakContract = !isFirst ? aftContract : LeaseChangeUtil.buildChangeBakContract(aftContract);
        Change2ContrServiceHelper.save(new DynamicObject[]{changeBakContract});
        return changeBakContract;
    }

    public static DynamicObject buildChangeBakContract(DynamicObject leaseContract) {
        DynamicObject changeBakContract = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)leaseContract);
        changeBakContract.set("isbak", (Object)true);
        changeBakContract.set("isinitdata", (Object)false);
        changeBakContract.set("sourcetype", (Object)LeaseContractSourceType.C.name());
        changeBakContract.set("backtime", (Object)new Date());
        String oldVersion = changeBakContract.getString("version");
        String newVersion = oldVersion + "_chg";
        changeBakContract.set("version", (Object)newVersion);
        return changeBakContract;
    }

    public static void batchUpdateContractBizStatus(DynamicObject[] bills, LeaseContractBizStatus aftStatus) {
        Arrays.stream(bills).forEach(v -> LeaseChangeUtil.updateContractBizStatus(v, aftStatus));
    }

    private static void updateContractBizStatus(DynamicObject bill, LeaseContractBizStatus aftStatus) {
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        if (leaseContract == null) {
            return;
        }
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)leaseContract.getPkValue(), (String)"fa_lease_contract", (String)"bizstatus");
        contract.set("bizstatus", (Object)aftStatus.name());
        SaveServiceHelper.update((DynamicObject)contract);
    }

    public static void deleteChangeBakContract(DynamicObject[] bills) {
        ArrayList<Long> ids = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObject changeBakContract = bill.getDynamicObject("changebakcontract");
            if (changeBakContract == null) continue;
            ids.add(changeBakContract.getLong("id"));
        }
        Change2ContrServiceHelper.delete("fa_lease_contract", new QFilter("id", "in", ids).toArray());
    }

    public static PayRuleCompareResult comparePayRule(DynamicObject befContract, DynamicObject aftContract, Date effectiveDate) {
        Set<PayPlanCompareObject> befPayPlan = LeaseChangeUtil.buildPayPlanCompareObjects(befContract, effectiveDate);
        Set<PayPlanCompareObject> aftPayPlan = LeaseChangeUtil.buildPayPlanCompareObjects(aftContract, effectiveDate);
        PayRuleCompareResult result = new PayRuleCompareResult();
        HashMap<String, PayPlanCompareObject> number2ObjMap = new HashMap<String, PayPlanCompareObject>(aftPayPlan.size(), 1.0f);
        for (PayPlanCompareObject aftPayPlanObj : aftPayPlan) {
            if (!"C".contains(aftPayPlanObj.getPayItemClass())) continue;
            number2ObjMap.put(aftPayPlanObj.getNumber(), aftPayPlanObj);
        }
        for (PayPlanCompareObject plan : befPayPlan) {
            PayPlanCompareObject aftPlanObj;
            boolean isRemove = aftPayPlan.remove(plan);
            if (isRemove) continue;
            result.addChangedPayItemIds(plan.getPayItemId());
            result.addChangedPayItemClass(plan.getPayItemClass());
            if ("C".contains(plan.getPayItemClass()) && (aftPlanObj = (PayPlanCompareObject)number2ObjMap.get(plan.getNumber())) != null && plan.equalsExcludeEndDate(aftPlanObj)) {
                aftPayPlan.remove(aftPlanObj);
                continue;
            }
            logger.info(String.format("\u6bd4\u8f83\u4ed8\u6b3e\u8ba1\u5212\uff1a\u5b58\u5728\u5dee\u5f02\uff08\u53d8\u66f4\u524d\u6709\uff0c\u53d8\u66f4\u540e\u6ca1\u6709\uff09\uff1a\u53d8\u66f4\u9879id\uff1a[%s]\uff0c\u53d8\u66f4\u9879\u7c7b\u578b\uff1a[%s]\uff0c\u4ed8\u6b3e\u8ba1\u5212\u7f16\u7801\uff1a[%s]", plan.getPayItemId(), plan.getPayItemClass(), plan.getNumber()));
            if (!plan.isBeforeEffectiveDate()) continue;
            result.setChangedBeforeEffective(true);
            result.addChangedPlanNumberBeforeEffective(plan.getNumber());
            logger.info(String.format("\u6bd4\u8f83\u4ed8\u6b3e\u8ba1\u5212\uff1a\u751f\u6548\u65e5\u4e4b\u524d\u53d1\u751f\u4e86\u53d8\u5316\u7684\u6570\u636e\uff08\u53d8\u66f4\u524d\u6709\uff0c\u53d8\u66f4\u540e\u6ca1\u6709\uff09\uff1a\u53d8\u66f4\u9879id\uff1a[%s]\uff0c\u53d8\u66f4\u9879\u7c7b\u578b\uff1a[%s]\uff0c\u4ed8\u6b3e\u8ba1\u5212\u7f16\u7801\uff1a[%s]", plan.getPayItemId(), plan.getPayItemClass(), plan.getNumber()));
        }
        if (!aftPayPlan.isEmpty()) {
            for (PayPlanCompareObject plan : aftPayPlan) {
                result.addChangedPayItemIds(plan.getPayItemId());
                result.addChangedPayItemClass(plan.getPayItemClass());
                logger.info(String.format("\u6bd4\u8f83\u4ed8\u6b3e\u8ba1\u5212\uff1a\u5b58\u5728\u5dee\u5f02\uff08\u53d8\u66f4\u524d\u6ca1\u6709\uff0c\u53d8\u66f4\u540e\u6709\uff09\uff1a\u53d8\u66f4\u9879id\uff1a[%s]\uff0c\u53d8\u66f4\u9879\u7c7b\u578b\uff1a[%s]\uff0c\u4ed8\u6b3e\u8ba1\u5212\u7f16\u7801\uff1a[%s]", plan.getPayItemId(), plan.getPayItemClass(), plan.getNumber()));
                if (!plan.isBeforeEffectiveDate()) continue;
                result.setChangedBeforeEffective(true);
                result.addChangedPlanNumberBeforeEffective(plan.getNumber());
                logger.info(String.format("\u6bd4\u8f83\u4ed8\u6b3e\u8ba1\u5212\uff1a\u751f\u6548\u65e5\u4e4b\u524d\u53d1\u751f\u4e86\u53d8\u5316\u7684\u6570\u636e\uff08\u53d8\u66f4\u524d\u6ca1\u6709\uff0c\u53d8\u66f4\u540e\u6709\uff09\uff1a\u53d8\u66f4\u9879id\uff1a[%s]\uff0c\u53d8\u66f4\u9879\u7c7b\u578b\uff1a[%s]\uff0c\u4ed8\u6b3e\u8ba1\u5212\u7f16\u7801\uff1a[%s]", plan.getPayItemId(), plan.getPayItemClass(), plan.getNumber()));
            }
        }
        logger.info(String.format("\u6bd4\u8f83\u4ed8\u6b3e\u8ba1\u5212\uff1a\u7ed3\u679c\uff1a%s", result));
        return result;
    }

    public static String parsePropValue(DynamicObject leaseContract, String field) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"fa_lease_contract");
        DynamicProperty property = entityType.getProperty(field);
        String strValue = "";
        if (property == null) {
            logger.info(String.format("\u8f6c\u6362\u5408\u540c\u5b57\u6bb5\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u6307\u5b9a\u7684\u5c5e\u6027\uff1a%s\u3002", field));
            return strValue;
        }
        if (property instanceof EntryProp) {
            return strValue;
        }
        if (property instanceof DateProp) {
            Date date = leaseContract.getDate(field);
            strValue = DateUtil.getShortDate().format(date);
        } else if (property instanceof BasedataProp) {
            DynamicObject dyn = leaseContract.getDynamicObject(field);
            if (dyn != null) {
                strValue = dyn.getLocaleString("name").toString();
            }
        } else if (property instanceof TextProp) {
            strValue = leaseContract.getString(field);
        } else if (property instanceof AmountProp) {
            BigDecimal amount;
            DynamicObject currency = leaseContract.getDynamicObject("currency");
            int amtPrecision = 2;
            String sign = "";
            if (currency != null) {
                amtPrecision = currency.getInt("amtprecision");
                sign = currency.getString("sign");
            }
            if ((amount = leaseContract.getBigDecimal(field)) != null) {
                strValue = sign + amount.setScale(amtPrecision, 4).toPlainString();
            }
        } else if (property instanceof QtyProp) {
            BigDecimal qty;
            DynamicObject unit = leaseContract.getDynamicObject("unit");
            int precision = 2;
            if (unit != null) {
                precision = unit.getInt("precision");
            }
            if ((qty = leaseContract.getBigDecimal(field)) != null) {
                strValue = qty.setScale(precision, 4).toPlainString();
            }
        } else if (property instanceof DecimalProp) {
            BigDecimal decimal = leaseContract.getBigDecimal(field);
            if (decimal != null) {
                strValue = decimal.stripTrailingZeros().toPlainString();
            }
        } else if (property instanceof LongProp) {
            long longValue = leaseContract.getLong(field);
            strValue = String.valueOf(longValue);
        }
        return strValue;
    }

    public static boolean isEffectPayPlan(DynamicObject bill) {
        Set<String> changeFields = LeaseChangeUtil.getChangeFields(bill);
        return changeFields.contains("payruleentryentity") || changeFields.contains("discountrate");
    }

    public static Set<String> getChangeFields(DynamicObject bill) {
        DynamicObjectCollection changeItems = bill.getDynamicObjectCollection("changeitems");
        HashSet<String> changeFields = new HashSet<String>(changeItems.size());
        for (DynamicObject data : changeItems) {
            DynamicObject item = data.getDynamicObject("fbasedataid");
            String number = item.getString("number");
            changeFields.add(number);
        }
        return changeFields;
    }

    private static Set<PayPlanCompareObject> buildPayPlanCompareObjects(DynamicObject leaseContract, Date effectiveDate) {
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        HashSet<PayPlanCompareObject> payPlanCompareObjects = new HashSet<PayPlanCompareObject>(planEntry.size());
        for (DynamicObject row : planEntry) {
            String planNumber = row.getString("plannumber");
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            long payItemId = payItem.getLong("id");
            String payItemClass = payItem.getString("accountingclass");
            Date startDate = row.getDate("plan_startdate");
            Date endDate = row.getDate("plan_enddate");
            Date planPayDate = row.getDate("planpaydate");
            String invoiceType = row.getString("plan_invoicetype");
            boolean deductible = row.getBoolean("plan_deductible");
            BigDecimal taxRate = row.getBigDecimal("plan_taxrate");
            BigDecimal rentNoTax = row.getBigDecimal("rentnotax");
            BigDecimal tax = row.getBigDecimal("tax");
            BigDecimal rent = row.getBigDecimal("rent");
            BigDecimal unPaidRent = row.getBigDecimal("unpaidrent");
            PayPlanCompareObject obj = new PayPlanCompareObject();
            obj.setBeforeEffectiveDate(DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) < 0);
            obj.setNumber(planNumber);
            obj.setPayItemId(payItemId);
            obj.setPayItemClass(payItemClass);
            obj.setStartDate(startDate);
            obj.setEndDate(endDate);
            obj.setPlanPayDate(planPayDate);
            obj.setInvoiceType(invoiceType);
            obj.setDeductible(deductible);
            obj.setTaxRate(taxRate);
            obj.setRentNoTax(rentNoTax);
            obj.setTax(tax);
            obj.setRent(rent);
            obj.setUnPaidRent(unPaidRent);
            payPlanCompareObjects.add(obj);
        }
        return payPlanCompareObjects;
    }
}

