/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.model;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import kd.bos.entity.plugin.support.util.ReflectionUtils;

public abstract class FaBaseObject {
    private Field[] fieldsCache;

    public Object get(String key) {
        try {
            Field declaredField = this.getFieldIgnoreCase(key);
            ReflectionUtils.makeAccessible((Field)declaredField);
            return declaredField.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Field getFieldIgnoreCase(String key) throws NoSuchFieldException {
        if (this.fieldsCache == null) {
            this.fieldsCache = this.getClass().getDeclaredFields();
        }
        for (Field field : this.fieldsCache) {
            if (!key.equalsIgnoreCase(field.getName())) continue;
            return field;
        }
        throw new NoSuchFieldException("no such field which names [" + key + "]");
    }

    public void set(String key, Object value) {
        try {
            Field declaredField = this.getFieldIgnoreCase(key);
            ReflectionUtils.makeAccessible((Field)declaredField);
            declaredField.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BigDecimal getBigDecimal(String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return new BigDecimal(obj.toString());
        }
        return null;
    }

    public BigDecimal getBigDecimalDefaultZero(String key) {
        BigDecimal val = this.getBigDecimal(key);
        if (val != null) {
            return val;
        }
        return BigDecimal.ZERO;
    }
}

