/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.fi.fa.business.model.FaBaseObject;
import kd.fi.fa.business.model.FaUseDepartment;

public class FaCard
extends FaBaseObject {
    @JsonIgnore
    private Long id;
    private Long useStatus;
    @JsonProperty(value="assetName")
    private String assetName;
    @JsonProperty(value="number")
    private String number;
    private String billNo;
    @JsonProperty(value="finAccountDate")
    private Date finAccountDate;
    @JsonProperty(value="originalVal")
    private BigDecimal originalVal;
    @JsonProperty(value="preResidualVal")
    private BigDecimal preResidualVal;
    @JsonProperty(value="networth")
    private BigDecimal netWorth;
    @JsonProperty(value="netAmount")
    private BigDecimal netAmount;
    @JsonProperty(value="storePlace")
    private Long storePlace;
    @JsonProperty(value="assetcat")
    private Long assetcat;
    @JsonProperty(value="useDepartment")
    private List<FaUseDepartment> useDepartment;
    private BigDecimal accumDepre = null;
    private BigDecimal decVal = null;
    @JsonProperty(value="preUsingAmount")
    private BigDecimal preUsingAmount;
    private BigDecimal depredAmount = null;
    @JsonIgnore
    private Long depreMethodId;
    @JsonIgnore
    private String depreMethodNumber;
    @JsonIgnore
    private boolean depreMethodIsSystem;
    private BigDecimal sumWorkload = null;
    private BigDecimal totalWorkload = null;
    private Long periodId = null;
    private Long clearPeriodId = null;
    private Long realCardId;
    private Long assetBookId;
    private String assetCategoryLongNumber;

    public String toString() {
        return "id:" + this.id + " billNo:" + this.billNo + " number:" + this.number;
    }

    public static String pojo2Json(FaCard card) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper.writeValueAsString((Object)card);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FaCard json2Pojo(String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return (FaCard)objectMapper.readValue(json, FaCard.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> findDiff(FaCard other) {
        try {
            Field[] declaredFields;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : declaredFields = this.getClass().getDeclaredFields()) {
                String name = field.getName();
                if ("id".equals(name) || "depreMethod".equals(name)) continue;
                if ("useDepartment".equals(name) && this.getUseDepartment() != null) {
                    List<FaUseDepartment> ownUseDepartments = this.getUseDepartment();
                    List<FaUseDepartment> oppUseDepartments = other.getUseDepartment();
                    if (ownUseDepartments.size() != oppUseDepartments.size()) {
                        throw new Exception("the count of useDepartments is not same!");
                    }
                    Comparator<FaUseDepartment> c = new Comparator<FaUseDepartment>(){

                        @Override
                        public int compare(FaUseDepartment o1, FaUseDepartment o2) {
                            return o1.getEntryId().compareTo(o2.getEntryId());
                        }
                    };
                    ownUseDepartments.sort(c);
                    oppUseDepartments.sort(c);
                    for (int i = 0; i < ownUseDepartments.size(); ++i) {
                        FaUseDepartment own = ownUseDepartments.get(i);
                        FaUseDepartment opp = oppUseDepartments.get(i);
                        if (own.getEntryId().equals(opp.getEntryId())) continue;
                        throw new Exception("the entryId of useDepartments is not same!");
                    }
                    int idx = 0;
                    ArrayList<Map> depLst = new ArrayList<Map>();
                    for (FaUseDepartment ownUseDepartment : ownUseDepartments) {
                        Map depDiffMap = ownUseDepartment.findDiff(oppUseDepartments.get(idx));
                        if (!depDiffMap.isEmpty()) {
                            depLst.add(depDiffMap);
                        }
                        ++idx;
                    }
                    if (depLst.size() <= 0) continue;
                    map.put(name, depLst);
                    continue;
                }
                ReflectionUtils.makeAccessible((Field)field);
                Object own = field.get(this);
                Object opp = field.get(other);
                if (own == null && opp == null || !(own == null && opp != null || own != null && opp == null) && own.equals(opp)) continue;
                map.put(name, new Object[]{own, opp});
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAssetcat() {
        return this.assetcat;
    }

    public void setAssetcat(Long assetcat) {
        this.assetcat = assetcat;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public BigDecimal getOriginalVal() {
        return this.originalVal;
    }

    public void setOriginalVal(BigDecimal originalVal) {
        this.originalVal = originalVal;
    }

    public BigDecimal getPreResidualVal() {
        return this.preResidualVal;
    }

    public void setPreResidualVal(BigDecimal preResidualVal) {
        this.preResidualVal = preResidualVal;
    }

    public BigDecimal getNetWorth() {
        return this.netWorth;
    }

    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }

    public BigDecimal getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(BigDecimal netAmount) {
        this.netAmount = netAmount;
    }

    public Long getStorePlace() {
        return this.storePlace;
    }

    public void setStorePlace(Long storePlace) {
        this.storePlace = storePlace;
    }

    public List<FaUseDepartment> getUseDepartment() {
        return this.useDepartment;
    }

    public void setUseDepartment(List<FaUseDepartment> useDepartment) {
        this.useDepartment = useDepartment;
    }

    public BigDecimal getAccumDepre() {
        return this.accumDepre;
    }

    public void setAccumDepre(BigDecimal accumDepre) {
        this.accumDepre = accumDepre;
    }

    public BigDecimal getDecVal() {
        return this.decVal;
    }

    public void setDecVal(BigDecimal decVal) {
        this.decVal = decVal;
    }

    public BigDecimal getPreUsingAmount() {
        return this.preUsingAmount;
    }

    public void setPreUsingAmount(BigDecimal preUsingAmount) {
        this.preUsingAmount = preUsingAmount;
    }

    public BigDecimal getDepredAmount() {
        return this.depredAmount;
    }

    public void setDepredAmount(BigDecimal depredAmount) {
        this.depredAmount = depredAmount;
    }

    public String getDepreMethodNumber() {
        return this.depreMethodNumber;
    }

    public boolean isDepreMethodIsSystem() {
        return this.depreMethodIsSystem;
    }

    public BigDecimal getSumWorkload() {
        return this.sumWorkload;
    }

    public void setSumWorkload(BigDecimal sumWorkload) {
        this.sumWorkload = sumWorkload;
    }

    public BigDecimal getTotalWorkload() {
        return this.totalWorkload;
    }

    public void setTotalWorkload(BigDecimal totalWorkload) {
        this.totalWorkload = totalWorkload;
    }

    public Long getRealCardId() {
        return this.realCardId;
    }

    public void setRealCardId(Long realCardId) {
        this.realCardId = realCardId;
    }

    public Long getAssetBookId() {
        return this.assetBookId;
    }

    public void setAssetBookId(Long assetBookId) {
        this.assetBookId = assetBookId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getClearPeriodId() {
        return this.clearPeriodId;
    }

    public void setClearPeriodId(Long clearPeriodId) {
        this.clearPeriodId = clearPeriodId;
    }

    public String getAssetCategoryLongNumber() {
        return this.assetCategoryLongNumber;
    }

    public void setAssetCategoryLongNumber(String assetCategoryLongNumber) {
        this.assetCategoryLongNumber = assetCategoryLongNumber;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public Date getFinAccountDate() {
        return this.finAccountDate;
    }

    public void setFinAccountDate(Date finAccountDate) {
        this.finAccountDate = finAccountDate;
    }

    public Long getUseStatus() {
        return this.useStatus;
    }

    public void setUseStatus(Long useStatus) {
        this.useStatus = useStatus;
    }
}

