/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.operate;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.operate.IFaOpCmd;

public abstract class AbstractFaOpCmd
implements IFaOpCmd {
    private static final String[] UPDATE_BILLSTATUS_FIELDS = new String[]{"id", "billstatus"};
    protected Object pk;
    protected DynamicObject bill;
    protected Object[] realCardPKs;
    protected Object[] finCardPKs;

    public AbstractFaOpCmd(Object pk) {
        this.pk = pk;
    }

    @Override
    public void doAudit() {
        this.init();
        if (this.updateBillStatusBeforeBusy()) {
            this.updateBillStatus(this.getBillStatusCombo().getBefore());
        }
        this.auditUpdateRealBizStatus();
        this.updateCard();
        if (!this.updateBillStatusBeforeBusy()) {
            this.updateBillStatus(this.getBillStatusCombo().getBefore());
        }
    }

    @Override
    public void doUnaudit() {
        this.init();
        this.updateBillStatus(this.getBillStatusCombo().getAfter());
        this.restoreCard();
        this.unAuditUpdateRealBizStatus();
    }

    private void updateBillStatus(BillStatus billStatus) {
        this.bill.set(UPDATE_BILLSTATUS_FIELDS[0], this.pk);
        this.bill.set(UPDATE_BILLSTATUS_FIELDS[1], (Object)billStatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bill});
    }

    protected boolean updateBillStatusBeforeBusy() {
        return true;
    }

    protected abstract String getEntityName();

    protected abstract BizStatusEnumCombo getBizStatusEnumCombo();

    protected abstract BillStatusCombo getBillStatusCombo();

    protected abstract void auditUpdateRealBizStatus();

    protected abstract void unAuditUpdateRealBizStatus();

    protected void updateCard() {
    }

    protected void restoreCard() {
    }

    protected void init() {
        this.bill = BusinessDataServiceHelper.loadSingle((Object)this.pk, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getEntityName()));
    }

    public static class BillStatusCombo {
        private BillStatus before;
        private BillStatus after;

        public BillStatusCombo(BillStatus before, BillStatus after) {
            this.before = before;
            this.after = after;
        }

        public BillStatus getBefore() {
            return this.before;
        }

        public BillStatus getAfter() {
            return this.after;
        }
    }

    public static class BizStatusEnumCombo {
        private BizStatusEnum before;
        private BizStatusEnum after;

        public BizStatusEnumCombo(BizStatusEnum before, BizStatusEnum after) {
            this.before = before;
            this.after = after;
        }

        public BizStatusEnum getBefore() {
            return this.before;
        }

        public BizStatusEnum getAfter() {
            return this.after;
        }
    }
}

