/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.operate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.DispatchtypeEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.IFaRealCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.dao.impl.ClearBillAuditHandler;
import kd.fi.fa.business.dao.impl.ClearBillUnAuditHandler;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.dataasset.DataAssetBizStatusEnum;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.model.FaClearAjustField;
import kd.fi.fa.business.model.FaPartClearValue;
import kd.fi.fa.business.operate.AbstractFaOpCmd;
import kd.fi.fa.business.operate.IFaOpCmd;
import kd.fi.fa.business.po.FaCardVersionParameter;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.cache.FaBusinessImportCardThreadCacheUtil;

public class FaClearCmd
extends AbstractFaOpCmd
implements IFaOpCmd {
    IFaFinCardDao fCardDao = FaFinCardDaoFactory.getInstance();
    IFaRealCardDao rCardDao = FaRealCardDaoFactory.getInstance();
    private static final String[] SELECTOR = new String[]{"org", "cleardate", "srcbill", "depreuse", "realcard", "fincard", "depreuse", "isclearall", "decval", "clearrate", "netamount", "preresidualval", "assetvalue", "addupdepre", "clearqty", "isclearall", "clearsource"};
    private static final String[] CLEARBILL_CARD_SELECTOR = new String[]{"clearperiod", "originalval", "monthorigvalchg", "yearorigvalchg", "monthdeprechg"};
    private static final List<BizStatusEnum> fromBizStatusAudit = new ArrayList<BizStatusEnum>(2);
    private static final List<BizStatusEnum> fromBizStatusUnaudit = new ArrayList<BizStatusEnum>(2);

    public FaClearCmd(Object pk) {
        super(pk);
    }

    @Override
    protected String getEntityName() {
        return "fa_clearbill";
    }

    @Override
    protected AbstractFaOpCmd.BizStatusEnumCombo getBizStatusEnumCombo() {
        return new AbstractFaOpCmd.BizStatusEnumCombo(BizStatusEnum.DELETE, BizStatusEnum.CLEAR_ALL);
    }

    @Override
    protected AbstractFaOpCmd.BillStatusCombo getBillStatusCombo() {
        return new AbstractFaOpCmd.BillStatusCombo(BillStatus.C, BillStatus.A);
    }

    @Override
    protected void auditUpdateRealBizStatus() {
        FaModiRealStatsUtils.update_oneBill_bizStatus(this.bill, "detail_entry", "realcard", BizStatusEnum.DELETE, fromBizStatusAudit);
        FaModiRealStatsUtils.update_clearBill_partBizStatus(this.bill, BizStatusEnum.READY, BizStatusEnum.DELETE);
        this.updateDataAssetAbandon(BizStatusEnum.CLEAR_ALL, DataAssetBizStatusEnum.DELETE);
    }

    @Override
    protected void unAuditUpdateRealBizStatus() {
        FaModiRealStatsUtils.update_oneBill_bizStatus(this.bill, "detail_entry", "realcard", BizStatusEnum.CLEAR_ALL, fromBizStatusUnaudit);
        FaModiRealStatsUtils.update_clearBill_partBizStatus(this.bill, BizStatusEnum.CLEAR_PART, BizStatusEnum.CLEAR_ALL);
        this.updateDataAssetAbandon(BizStatusEnum.DELETE, DataAssetBizStatusEnum.READY);
    }

    private void updateDataAssetAbandon(BizStatusEnum bizStatus, DataAssetBizStatusEnum bizStatusEnum) {
        DynamicObjectCollection entries = this.bill.getDynamicObjectCollection("detail_entry");
        HashSet<Long> dataAssetIds = new HashSet<Long>(entries.size());
        for (DynamicObject entry : entries) {
            DynamicObject realCard = entry.getDynamicObject("realcard");
            if (!SourceFlagEnum.DATAASSET.name().equals(realCard.getString("sourceflag")) || !bizStatus.name().equals(realCard.getString("bizstatus"))) continue;
            dataAssetIds.add(realCard.getLong("srcbillid"));
        }
        if (dataAssetIds.size() > 0) {
            SqlBuilder updateSqlBuilder = new SqlBuilder();
            updateSqlBuilder.append("UPDATE t_fa_data_asset SET fbizstatus = ?", new Object[]{bizStatusEnum.name()}).appendIn(" where fid ", dataAssetIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateSqlBuilder);
        }
    }

    @Override
    protected void updateCard() {
        DynamicObject bill = this.bill;
        HashMap<Long, FaPartClearValue> partClearObjs = new HashMap<Long, FaPartClearValue>();
        HashMap<Long, FaClearAjustField> clearAllObjs = new HashMap<Long, FaClearAjustField>();
        Long orgId = bill.getLong("org_id");
        DynamicObjectCollection assetBooks = FaBizUtils.getAllBookByOrg(orgId);
        Map<Object, Object> realId2BakIdMap = this.copyPartClearReal(bill, "audit");
        for (DynamicObject assetBook : assetBooks) {
            long periodId = assetBook.getLong("curperiod");
            Long depureId = assetBook.getLong("depreuse");
            Object[] pks = this.getRealCardPKs(bill, depureId, partClearObjs = new HashMap(), clearAllObjs, periodId);
            if (FaCommonUtils.isEmpty(pks)) {
                return;
            }
            ClearBillAuditHandler handle = new ClearBillAuditHandler(periodId, partClearObjs, clearAllObjs);
            Map<Long, Map<Long, Long>> mainRealID2FinID = this.fCardDao.copyFinCards(periodId, depureId, pks, handle, CLEARBILL_CARD_SELECTOR, realId2BakIdMap);
            DynamicObjectCollection enties = bill.getDynamicObjectCollection("detail_entry");
            for (DynamicObject entry : enties) {
                Object realCardId;
                Object bakRealId;
                Map<Long, Long> depreUse2FinID = mainRealID2FinID.get(entry.getDynamicObject("realcard").getPkValue());
                long curDepreuse = entry.getLong("depreuse_id");
                if (curDepreuse != depureId) continue;
                Long finID = depreUse2FinID.get(curDepreuse);
                if (finID != null) {
                    entry.set("fincard", (Object)finID);
                }
                if ((bakRealId = realId2BakIdMap.get(realCardId = entry.get("realcard.id"))) == null) continue;
                entry.set("backrealcard", bakRealId);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            if (assetBook.getInt("periodNumber") == 1) continue;
            this.updateCurPeriodYearDepre(assetBook, orgId);
        }
        String source = bill.getString("clearsource");
        if (source != null && "DISPATCH".equals(source)) {
            this.updateEvaluate(bill);
        }
        this.reSplit(bill);
    }

    @Override
    protected void restoreCard() {
        DynamicObject clearBill = this.bill;
        HashMap<Long, FaPartClearValue> partClearObjs = new HashMap<Long, FaPartClearValue>();
        HashMap<Long, FaClearAjustField> clearAllObjs = new HashMap<Long, FaClearAjustField>();
        Long orgId = clearBill.getLong("org_id");
        DynamicObjectCollection assetBooks = FaBizUtils.getAllBookByOrg(orgId);
        this.restorePartClearReal(this.bill, "unaudit");
        for (DynamicObject assetBook : assetBooks) {
            long periodId = assetBook.getLong("curperiod");
            Long depureId = assetBook.getLong("depreuse");
            Object[] pks = this.getRealCardPKs(clearBill, depureId, partClearObjs, clearAllObjs, periodId);
            if (FaCommonUtils.isEmpty(pks)) {
                return;
            }
            this.fCardDao.restoreCard(periodId, depureId, pks, new ClearBillUnAuditHandler(partClearObjs, clearAllObjs), CLEARBILL_CARD_SELECTOR);
            if (assetBook.getInt("periodNumber") == 1) continue;
            this.updateCurPeriodYearDepre(assetBook, orgId);
        }
        this.reSplit(clearBill);
    }

    private void updateCurPeriodYearDepre(DynamicObject assetBook, Long orgId) {
        Long startPeriodId = assetBook.getLong("startperiod");
        List<Object> lessQualsCurPeriodidsInThisYear = FaPeriodUtils.getLessEqualsCuPeriods(this.bill.getDynamicObject("clearperiod"));
        HashSet<String> allNumbers = new HashSet<String>(16);
        DynamicObjectCollection enties = this.bill.getDynamicObjectCollection("detail_entry");
        for (DynamicObject entry : enties) {
            allNumbers.add(entry.getString("number"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)assetBook.getLong("depreuse")), new QFilter("bizperiod", "=", (Object)assetBook.getLong("curperiod")), new QFilter("number", "in", allNumbers)};
        DynamicObjectCollection fins = QueryServiceHelper.query((String)"fa_card_fin", (String)"number,isneeddepre,networth,preresidualval,preusingamount,depredamount", (QFilter[])filters);
        HashSet<String> numbers = new HashSet<String>(16);
        for (DynamicObject fin : fins) {
            BigDecimal networth = fin.getBigDecimal("networth");
            BigDecimal preresidualval = fin.getBigDecimal("preresidualval");
            BigDecimal preusingamount = fin.getBigDecimal("preusingamount");
            BigDecimal depredamount = fin.getBigDecimal("depredamount");
            if (fin.getString("isneeddepre").equals("0")) {
                numbers.add(fin.getString("number"));
                continue;
            }
            if (networth.compareTo(preresidualval) > 0 && preusingamount.compareTo(depredamount) > 0) continue;
            numbers.add(fin.getString("number"));
        }
        FaDepreUtil.updateLessQualsCurPeriodYearDepre(orgId, assetBook.getLong("depreuse"), startPeriodId, assetBook.getLong("curperiod"), numbers, lessQualsCurPeriodidsInThisYear);
    }

    private void reSplit(DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("detail_entry");
        HashSet<Long> allCardIds = new HashSet<Long>(entrys.size(), 1.0f);
        for (DynamicObject entry : entrys) {
            Long realCardId = entry.getLong("realcard.id");
            allCardIds.add(realCardId);
        }
        Long clearperiodId = bill.getLong("clearperiod.id");
        Long orgId = bill.getLong("org.id");
        SqlBuilder finSbSql = new SqlBuilder();
        finSbSql.append("SELECT frealcardid realcardid FROM T_FA_CARD_FIN WHERE ", new Object[0]);
        finSbSql.appendIn("frealcardid", allCardIds.toArray());
        finSbSql.append("AND FBIZPERIODID = ?", new Object[]{clearperiodId});
        finSbSql.append("AND FENDPERIODID = ?", new Object[]{99999999999L});
        finSbSql.append("AND FORG = ?", new Object[]{orgId});
        finSbSql.append("AND fisneeddepre = ?", new Object[]{Character.valueOf('1')});
        HashSet<Long> notSplitCardIds = new HashSet<Long>(entrys.size(), 1.0f);
        DataSet dsNotSplit = DB.queryDataSet((String)"clearCmd_reSplit", (DBRoute)new DBRoute("fa"), (SqlBuilder)finSbSql);
        Object object = null;
        try {
            for (Row dsNotFin : dsNotSplit) {
                Long realcardid = dsNotFin.getLong("realcardid");
                notSplitCardIds.add(realcardid);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dsNotSplit != null) {
                if (object != null) {
                    try {
                        dsNotSplit.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dsNotSplit.close();
                }
            }
        }
        HashMap<String, HashSet<Long>> needDepreSplit = new HashMap<String, HashSet<Long>>();
        for (DynamicObject entry : entrys) {
            Long depre = entry.getLong("depreuse.id");
            Long realCardId = entry.getLong("realcard.id");
            if (notSplitCardIds.contains(realCardId)) continue;
            String ckey = orgId + "_" + depre.toString();
            HashSet<Long> cardIds = (HashSet<Long>)needDepreSplit.get(ckey);
            if (cardIds == null) {
                cardIds = new HashSet<Long>();
                needDepreSplit.put(ckey, cardIds);
            }
            cardIds.add(realCardId);
        }
        for (Map.Entry next : needDepreSplit.entrySet()) {
            String key = (String)next.getKey();
            Set value = (Set)next.getValue();
            String[] split = key.split("_");
            if (value.size() <= 0) continue;
            new DepreSplitSum().updateDepreSplit4ChangeBill(Long.parseLong(split[0]), Long.parseLong(split[1]), value);
        }
    }

    private void updateNeedDepre(DynamicObject bill) {
        DynamicObject[] fCards;
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("detail_entry");
        Object[] fCardIds = entries.stream().map(v -> v.get("fincard_id")).toArray();
        for (DynamicObject fCard : fCards = BusinessDataServiceHelper.load((Object[])fCardIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"))) {
            fCard.set("isneeddepre", (Object)true);
        }
        SaveServiceHelper.save((DynamicObject[])fCards);
    }

    private void updateEvaluate(DynamicObject bill) {
        DynamicObject realCard;
        long billid;
        DynamicObject org = bill.getDynamicObject("org");
        long orgId = 0L;
        if (org != null) {
            orgId = org.getLong("id");
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter mainFilter = new QFilter("ismainbook", "=", (Object)true);
        String fields = "id,org,depreuse";
        DynamicObject assetbook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)fields, (QFilter[])new QFilter[]{orgFilter, mainFilter});
        long depreuseId = 0L;
        if (assetbook != null) {
            depreuseId = assetbook.getLong("depreuse");
        }
        long dispatchBillId = bill.getLong("srcbill");
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("detail_entry");
        HashMap<Long, BigDecimal> numberAndNetamount = new HashMap<Long, BigDecimal>();
        for (DynamicObject entry : entries) {
            DynamicObject curDepreuse = entry.getDynamicObject("depreuse");
            long curDepreuseId = 0L;
            if (curDepreuse != null) {
                curDepreuseId = curDepreuse.getLong("id");
            }
            if (depreuseId != curDepreuseId) continue;
            billid = 0L;
            realCard = (DynamicObject)entry.get("realcard");
            if (realCard != null) {
                billid = realCard.getLong("id");
            }
            numberAndNetamount.put(billid, entry.getBigDecimal("netamount"));
        }
        DynamicObject dispatchBill = BusinessDataServiceHelper.loadSingle((Object)dispatchBillId, (String)"fa_dispatch");
        DynamicObjectCollection dispatchEntries = null;
        String dispatchtype = "";
        if (dispatchBill != null) {
            dispatchEntries = dispatchBill.getDynamicObjectCollection("dispatchentry");
            dispatchtype = dispatchBill.getString("dispatchtype");
        }
        if (dispatchEntries == null || DispatchtypeEnum.B.name().equals(dispatchtype)) {
            return;
        }
        for (DynamicObject dispatchEntry : dispatchEntries) {
            billid = 0L;
            realCard = dispatchEntry.getDynamicObject("realcard");
            if (realCard != null) {
                billid = realCard.getLong("id");
            }
            dispatchEntry.set("evaluate", numberAndNetamount.get(billid));
        }
        SaveServiceHelper.update((DynamicObject)dispatchBill);
    }

    private Object[] getRealCardPKs(DynamicObject bill, Long depreuseId, Map<Long, FaPartClearValue> partClearObjs, Map<Long, FaClearAjustField> clearAllObjs, Long bookCurperiod) {
        DynamicObjectCollection dynamicObjects = bill.getDynamicObjectCollection("detail_entry");
        List realCardPKList = dynamicObjects.stream().map(v -> v.get("realcard_id")).collect(Collectors.toList());
        HashMap<String, Long> idKeysMap = new HashMap<String, Long>();
        if (bookCurperiod != null) {
            QFilter depreuseQ = new QFilter("depreuse", "=", (Object)depreuseId);
            QFilter bookCurperiodQ = new QFilter("bizperiod", "<=", (Object)bookCurperiod).and(new QFilter("endperiod", ">", (Object)bookCurperiod));
            QFilter realCardQ = new QFilter("realcard", "in", realCardPKList);
            DynamicObjectCollection bookCurientFins = QueryServiceHelper.query((String)"fa_card_fin", (String)"id,realcard,depreuse,bizperiod", (QFilter[])new QFilter[]{depreuseQ, bookCurperiodQ, realCardQ});
            for (DynamicObject bookCurientFin : bookCurientFins) {
                idKeysMap.put(bookCurientFin.getString("realcard") + bookCurientFin.getString("depreuse") + bookCurperiod, bookCurientFin.getLong("id"));
            }
        }
        for (DynamicObject entry : dynamicObjects) {
            Long finCardCurperodid;
            DynamicObject finCard;
            long curDepreuseId = entry.getDynamicObject("depreuse").getLong("id");
            if ((depreuseId <= 0L || curDepreuseId != depreuseId) && depreuseId > 0L) continue;
            if (!"1".equals(entry.getString("isclearall"))) {
                FaPartClearValue faPartClearValue = new FaPartClearValue(entry.getBigDecimal("assetvalue"), entry.getBigDecimal("addupdepre"), entry.getBigDecimal("decval"), entry.getBigDecimal("netamount"), entry.getBigDecimal("preresidualval"), entry.getBigDecimal("clearrate"), entry.getBigDecimal("clearqty"), entry.getString("isclearall"), entry.getBoolean("isadjustdepre"), entry.getBigDecimal("monthadjustdepreforcur"));
                finCard = entry.getDynamicObject("fincard");
                finCardCurperodid = finCard.getLong("bizperiod_id");
                if (bookCurperiod >= finCardCurperodid) {
                    partClearObjs.put((Long)finCard.getPkValue(), faPartClearValue);
                    continue;
                }
                partClearObjs.put((Long)idKeysMap.get(finCard.getString("realcard_id") + finCard.getString("depreuse_id") + bookCurperiod), faPartClearValue);
                continue;
            }
            FaClearAjustField faClearAjustField = new FaClearAjustField(entry.getBoolean("isadjustdepre"), entry.getBigDecimal("monthadjustdepreforcur"));
            faClearAjustField.setAddupdepre(entry.getBigDecimal("addupdepre"));
            faClearAjustField.setDepredamount(entry.getBigDecimal("depredamount"));
            faClearAjustField.setClearPeriodNumber(bill.getInt("clearperiod.periodnumber"));
            faClearAjustField.setClearMethod(entry.getString("clearmethod"));
            finCard = entry.getDynamicObject("fincard");
            finCardCurperodid = finCard.getLong("bizperiod_id");
            if (bookCurperiod >= finCardCurperodid) {
                clearAllObjs.put((Long)finCard.getPkValue(), faClearAjustField);
                continue;
            }
            clearAllObjs.put((Long)idKeysMap.get(finCard.getString("realcard_id") + finCard.getString("depreuse_id") + bookCurperiod), faClearAjustField);
        }
        if (realCardPKList.isEmpty()) {
            return new Object[0];
        }
        return realCardPKList.toArray();
    }

    private Map<Object, Object> copyPartClearReal(DynamicObject bill, String operType) {
        Long orgId = bill.getLong("org_id");
        HashMap<Long, BigDecimal> realCapkClearNums = new HashMap<Long, BigDecimal>();
        this.getPartClearReal(realCapkClearNums, null);
        if (realCapkClearNums.size() > 0) {
            IBizSetCardDataHandler handler = this.getClearPartNumCardHandler(realCapkClearNums, operType);
            FaCardVersionParameter cardVersionParameter = new FaCardVersionParameter();
            cardVersionParameter.setAccountdate(bill.getDate("cleardate"));
            cardVersionParameter.setSrcbillid(bill.getLong("id"));
            cardVersionParameter.setSrcbillentityname("fa_clearbill");
            return this.rCardDao.copyCards(realCapkClearNums.keySet().toArray(), handler, orgId, null, cardVersionParameter);
        }
        return new HashMap<Object, Object>(8);
    }

    private void restorePartClearReal(DynamicObject bill, String operType) {
        HashMap<Long, BigDecimal> realCapkClearNums = new HashMap<Long, BigDecimal>(200);
        HashMap<Object, Object> befAndAftChange = new HashMap<Object, Object>(200);
        this.getPartClearReal(realCapkClearNums, befAndAftChange);
        if (realCapkClearNums.size() > 0) {
            IBizSetCardDataHandler handler = this.getClearPartNumCardHandler(realCapkClearNums, operType);
            FaCardVersionParameter cardVersionParameter = new FaCardVersionParameter();
            cardVersionParameter.setSrcbillid(bill.getLong("id"));
            cardVersionParameter.setSrcbillentityname("fa_clearbill");
            this.rCardDao.restoreCards(befAndAftChange.values().toArray(), befAndAftChange, null, handler, null, cardVersionParameter);
        }
    }

    private void getPartClearReal(Map<Long, BigDecimal> realCapkClearNums, Map<Object, Object> befAndAftChange) {
        DynamicObjectCollection dynamicObjects = this.bill.getDynamicObjectCollection("detail_entry");
        for (DynamicObject entry : dynamicObjects) {
            if ("1".equals(entry.getString("isclearall"))) continue;
            long bookPk = (Long)entry.getDynamicObject("fincard").getDynamicObject("assetbook").getPkValue();
            boolean isMainBook = FaBusinessImportCardThreadCacheUtil.getIsMainBook(bookPk);
            if (!"2".equals(entry.getString("isclearall")) || !isMainBook) continue;
            realCapkClearNums.put(entry.getLong("realcard_id"), entry.getBigDecimal("clearqty"));
            if (befAndAftChange == null) continue;
            long bakRealCardId = entry.getLong("backrealcard_id");
            if (bakRealCardId == 0L) {
                befAndAftChange.put(entry.getLong("realcard_id"), entry.getLong("realcard_id"));
                continue;
            }
            befAndAftChange.put(entry.getLong("backrealcard_id"), entry.getLong("realcard_id"));
        }
    }

    private IBizSetCardDataHandler getClearPartNumCardHandler(Map<Long, BigDecimal> realCapkClearNums, String operType) {
        return card -> this.updateCardHandler(card, realCapkClearNums, operType);
    }

    private void updateCardHandler(DynamicObject fCard, Map<Long, BigDecimal> realCapkClearNums, String operType) {
        if ("audit".equals(operType)) {
            fCard.set("assetamount", (Object)fCard.getBigDecimal("assetamount").subtract(realCapkClearNums.get(fCard.getPkValue())));
        } else if ("unaudit".equals(operType)) {
            fCard.set("assetamount", (Object)fCard.getBigDecimal("assetamount").add(realCapkClearNums.get(fCard.getPkValue())));
        }
    }

    static {
        fromBizStatusAudit.add(BizStatusEnum.CLEAR_ALL);
        fromBizStatusAudit.add(BizStatusEnum.CLEAR_PART);
        fromBizStatusUnaudit.add(BizStatusEnum.READY);
        fromBizStatusUnaudit.add(BizStatusEnum.DELETE);
    }
}

