/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.operate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.cardgenerate.CardGenerateHelper;
import kd.fi.fa.business.clear.ClearBillGenerateFacade;
import kd.fi.fa.business.dao.factory.FaClearBillDaoFactory;
import kd.fi.fa.business.operate.AbstractFaOpCmd;
import kd.fi.fa.business.operate.IFaOpCmd;
import kd.fi.fa.business.utils.FaBizCtrServiceUtils;
import kd.fi.fa.business.utils.FaBizCtrSource;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.common.util.Fa;

public class FaDispatchCmd
extends AbstractFaOpCmd
implements IFaOpCmd {
    public FaDispatchCmd(Object pk) {
        super(pk);
    }

    @Override
    protected String getEntityName() {
        return "fa_dispatch_in";
    }

    @Override
    protected AbstractFaOpCmd.BizStatusEnumCombo getBizStatusEnumCombo() {
        return new AbstractFaOpCmd.BizStatusEnumCombo(BizStatusEnum.CLEAR_ALL, BizStatusEnum.DISPATCH);
    }

    @Override
    protected AbstractFaOpCmd.BillStatusCombo getBillStatusCombo() {
        return new AbstractFaOpCmd.BillStatusCombo(BillStatus.D, BillStatus.C);
    }

    @Override
    protected void updateCard() {
        DynamicObject bill = this.bill;
        Object[] pks = CardGenerateHelper.generateRealCard(bill);
        StringBuilder sql = new StringBuilder();
        sql.append("update t_fa_card_real set fmasterid = fid where fid in ");
        for (int i = 0; i < pks.length; ++i) {
            sql.append(i == 0 ? " (" : ",").append("?");
        }
        sql.append(")");
        DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)sql.toString(), (Object[])pks);
        ClearBillGenerateFacade clearFacade = new ClearBillGenerateFacade();
        clearFacade.generateClearBillByDispt(this.pk);
    }

    protected boolean updateBillStatusBeforeBusyUpdate() {
        return false;
    }

    private void changeDynDepreAlgoAll(DynamicObject bill, Object[] pks) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        ArrayList<DynamicObject> dynamicCards = new ArrayList<DynamicObject>();
        DynamicObjectCollection dispatchEntry = bill.getDynamicObjectCollection("dispatchentry");
        ArrayList<Long> srcRealCardIds = new ArrayList<Long>();
        for (DynamicObject row : dispatchEntry) {
            Object cardId = row.getDynamicObject("realcard").getPkValue();
            srcRealCardIds.add(cardId != null ? Long.parseLong(cardId.toString()) : 0L);
        }
        Object inorgId = bill.get("inorg_id");
        String selectFields = Fa.comma((String[])new String[]{"id", "depreuse"});
        QFilter[] filters = new QFilter("org", "=", inorgId).toArray();
        DynamicObjectCollection inBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])filters);
        selectFields = Fa.comma((String[])new String[]{"id", "sourceentryid", "masterid"});
        filters = new QFilter("id", "in", (Object)pks).toArray();
        DynamicObjectCollection inRealCards = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filters);
        selectFields = Fa.comma((String[])new String[]{"id", "sourceentryid", "realaccountdate"});
        filters = new QFilter("id", "in", srcRealCardIds).toArray();
        DynamicObjectCollection srcrealCardObjCol = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filters);
        for (DynamicObject srcrealCard : srcrealCardObjCol) {
            for (DynamicObject inBook : inBooks) {
                for (DynamicObject inRealCard : inRealCards) {
                    DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)type);
                    dynamicCard.set("realcard", inRealCard.get("masterid"));
                    dynamicCard.set("assetbook", inBook.get("id"));
                    dynamicCard.set("depreuse", inBook.get("depreuse"));
                    dynamicCard.set("date", (Object)srcrealCard.getDate("realaccountdate"));
                    dynamicCard.set("entityname", (Object)"fa_dispatch_in");
                    dynamicCard.set("changebillid", bill.get("id"));
                    dynamicCards.add(dynamicCard);
                }
            }
        }
        if (dynamicCards.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicCards.toArray(new DynamicObject[0]));
        }
    }

    private void changeDynDepreAlgo(DynamicObject bill, Object[] pks) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        ArrayList<DynamicObject> dynamicCards = new ArrayList<DynamicObject>();
        DynamicObjectCollection dispatchEntry = bill.getDynamicObjectCollection("dispatchentry");
        HashSet<Object> srcRealCardIds = new HashSet<Object>();
        for (DynamicObject row : dispatchEntry) {
            Object cardId = row.getDynamicObject("realcard").getPkValue();
            srcRealCardIds.add(cardId);
        }
        String selectFields = Fa.comma((String[])new String[]{"realcard", "depreuse", "realcard.realaccountdate"});
        QFilter[] filters = new QFilter("realcard", "in", srcRealCardIds).toArray();
        DynamicObjectCollection srcDynamicCards = QueryServiceHelper.query((String)"fa_card_dynamic", (String)selectFields, (QFilter[])filters);
        Object inorgId = bill.get("inorg_id");
        selectFields = Fa.comma((String[])new String[]{"id", "depreuse"});
        filters = new QFilter("org", "=", inorgId).toArray();
        DynamicObjectCollection inBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])filters);
        selectFields = Fa.comma((String[])new String[]{"id", "sourceentryid"});
        filters = new QFilter("id", "in", (Object)pks).toArray();
        DynamicObjectCollection inRealCards = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filters);
        block1: for (DynamicObject srcDynCard : srcDynamicCards) {
            Object depreuseId = srcDynCard.get("depreuse");
            Object srcRealCardId = srcDynCard.get("realcard");
            for (DynamicObject inBook : inBooks) {
                if (!inBook.get("depreuse").equals(depreuseId)) continue;
                for (DynamicObject inRealCard : inRealCards) {
                    if (!inRealCard.get("sourceentryid").equals(srcRealCardId)) continue;
                    DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)type);
                    dynamicCard.set("realcard", inRealCard.get("id"));
                    dynamicCard.set("assetbook", inBook.get("id"));
                    dynamicCard.set("depreuse", depreuseId);
                    dynamicCard.set("date", (Object)srcDynCard.getDate("realcard.realaccountdate"));
                    dynamicCard.set("entityname", (Object)"fa_dispatch_in");
                    dynamicCard.set("changebillid", bill.get("id"));
                    dynamicCards.add(dynamicCard);
                    continue block1;
                }
                continue block1;
            }
        }
        if (dynamicCards.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicCards.toArray(new DynamicObject[0]));
        }
    }

    @Override
    protected void restoreCard() {
        DynamicObject bill = this.bill;
        if (bill == null) {
            return;
        }
        DynamicObject clearBill = FaClearBillDaoFactory.getInstance().queryOneByDispatch(this.pk);
        if (clearBill != null) {
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("ispatch", "true");
            operate.setVariableValue("ishasright", String.valueOf(true));
            operate.setVariableValue("WF", "FALSE");
            OperationResult unresult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"fa_clearbill", (Object[])new Object[]{clearBill.getPkValue()}, (OperateOption)operate);
            FaCommonUtils.handleOperationResult(unresult);
            operate = OperateOption.create();
            operate.setVariableValue("deleteClearBillByUnAudit", "true");
            operate.setVariableValue("ishasright", String.valueOf(true));
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_clearbill", (Object[])new Object[]{clearBill.getPkValue()}, (OperateOption)operate);
            FaCommonUtils.handleOperationResult(result);
        }
        long srcbillId = bill.getLong("id");
        QFilter[] cardFilter = new QFilter[]{new QFilter("assetunit", "=", (Object)bill.getLong(Fa.dot((String[])new String[]{"inassetunit", "id"}))), new QFilter("srcbillentityname", "=", (Object)"fa_dispatch_in"), new QFilter("srcbillid", "=", (Object)srcbillId)};
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])cardFilter);
        Object[] realCardIds = (Long[])realCards.stream().map(v -> v.getLong("id")).toArray(Long[]::new);
        OperateOption deleteRealOp = OperateOption.create();
        deleteRealOp.setVariableValue("deleteByDispatch", "true");
        deleteRealOp.setVariableValue("ishasright", String.valueOf(true));
        OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_card_real", (Object[])realCardIds, (OperateOption)deleteRealOp);
        if (!deleteResult.isSuccess()) {
            List msg = deleteResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
            String errInfo = String.join((CharSequence)" ", msg);
            throw new KDBizException(errInfo);
        }
    }

    @Override
    protected void auditUpdateRealBizStatus() {
        ArrayList<FaBizCtrSource> fromSourceList = new ArrayList<FaBizCtrSource>(1);
        Long curSourceId = (Long)this.bill.getPkValue();
        String curSourceEntityName = "fa_dispatch";
        fromSourceList.add(new FaBizCtrSource(curSourceId, curSourceEntityName));
        FaBizCtrServiceUtils.updateOneBillBizCtrForBill(this.bill, "dispatchentry", "realcard", fromSourceList, 0L, "NOENTITYNAME");
        FaModiRealStatsUtils.update_oneBill_bizStatus(this.bill, "dispatchentry", "realcard", BizStatusEnum.READY, BizStatusEnum.DISPATCH);
    }

    @Override
    protected void unAuditUpdateRealBizStatus() {
        ArrayList<FaBizCtrSource> fromSourceList = new ArrayList<FaBizCtrSource>(1);
        fromSourceList.add(new FaBizCtrSource(0L, "NOENTITYNAME"));
        Long curSourceId = (Long)this.bill.getPkValue();
        String curSourceEntityName = "fa_dispatch";
        FaBizCtrServiceUtils.updateOneBillBizCtrForBill(this.bill, "dispatchentry", "realcard", fromSourceList, curSourceId, curSourceEntityName);
        FaModiRealStatsUtils.update_oneBill_bizStatus(this.bill, "dispatchentry", "realcard", BizStatusEnum.DISPATCH, BizStatusEnum.READY);
    }
}

