/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.pclock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.business.pclock.AbPcLockServiceUtils;
import kd.fi.fa.business.pclock.PcLockConfigUtils;
import kd.fi.fa.business.pclock.po.LockedBaseData;
import kd.fi.fa.business.pclock.po.PcLockConfigParameter;

public abstract class AbstractPcLockOperationServicePlugIn
extends AbstractBusyRecordServicePlugin {
    protected List<String> pcLockCofigBillNoList = new ArrayList<String>(2);
    protected Map<Object, Set<LockedBaseData>> oldLockedDataSetMap = new HashMap<Object, Set<LockedBaseData>>(2000);
    protected Map<Object, Set<LockedBaseData>> lockedDataSetMap = new HashMap<Object, Set<LockedBaseData>>(2000);
    protected Map<String, DynamicObject> billId2DbBillMap = null;
    @Deprecated
    protected Set<LockedBaseData> lockedDataSet;
    protected boolean isUpdateBaseData;

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey;
        super.beginOperationTransaction(e);
        this.setPcLockCofig();
        this.setUpdateLockedBaseBizStatus();
        if (this.pcLockCofigBillNoList.size() == 0) {
            return;
        }
        String entityName = this.billEntityType.getName();
        List<PcLockConfigParameter> configParameterList = PcLockConfigUtils.handleConfigBaseData(entityName, operationKey = e.getOperationKey(), this.pcLockCofigBillNoList);
        if (configParameterList == null || configParameterList.size() == 0) {
            return;
        }
        DynamicObject[] bills = e.getDataEntities();
        if (operationKey.equalsIgnoreCase("save") || operationKey.equalsIgnoreCase("submit")) {
            this.billId2DbBillMap = this.getInDbBillForSaveSubmit(entityName, bills);
        }
        this.setlockedEntityNameAndData(e.getDataEntities());
        for (DynamicObject bill : e.getDataEntities()) {
            for (PcLockConfigParameter configParameter : configParameterList) {
                DynamicObject oldBill;
                if ((operationKey.equalsIgnoreCase("save") || operationKey.equalsIgnoreCase("submit")) && this.billId2DbBillMap != null && this.billId2DbBillMap.size() != 0 && (oldBill = this.billId2DbBillMap.get(bill.getPkValue() + ".")) != null) {
                    AbPcLockServiceUtils.handleBillParameterToPclockService(oldBill, true, configParameter, this.oldLockedDataSetMap.get(bill.getPkValue()), this.isUpdateBaseData, this.billEntityType.getName());
                }
                AbPcLockServiceUtils.handleBillParameterToPclockService(bill, false, configParameter, this.lockedDataSetMap.get(bill.getPkValue()), this.isUpdateBaseData, this.billEntityType.getName());
            }
        }
    }

    protected abstract void setPcLockCofig();

    protected void setlockedEntityNameAndData(DynamicObject[] bills) {
    }

    protected void setUpdateLockedBaseBizStatus() {
        this.isUpdateBaseData = true;
    }

    private Map<String, DynamicObject> getInDbBillForSaveSubmit(String entityName, DynamicObject[] bills) {
        DynamicObject[] oldBills;
        if (bills == null || bills.length == 0) {
            return null;
        }
        HashMap<String, DynamicObject> billId2DbBillMap = new HashMap<String, DynamicObject>(bills.length, 1.0f);
        Object[] pkArray = Stream.of(bills).map(v -> v.getPkValue()).toArray(Object[]::new);
        for (DynamicObject oldBill : oldBills = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
            billId2DbBillMap.put(oldBill.getPkValue() + ".", oldBill);
        }
        return billId2DbBillMap;
    }
}

