/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.pclock;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.pclock.PcChildLockUtils;
import kd.fi.fa.business.pclock.inter.PcChildLock;
import kd.fi.fa.business.pclock.po.PcChildLockParameter;

public class PcChildLockImpl
implements PcChildLock {
    private PcChildLockParameter parameter;
    private static final Log logger = LogFactory.getLog(PcChildLockImpl.class);

    @Override
    public void init(PcChildLockParameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public void lock() {
        block15: {
            boolean isRequiresNew = this.parameter.isRequiresNew();
            if (isRequiresNew) {
                try (TXHandle h = TX.requiresNew((String)"PcChildLockImpl");){
                    try {
                        this.lockImplC();
                        h.commit();
                        break block15;
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
            this.lockImplC();
        }
    }

    @Override
    public void unlock() {
        boolean isRequiresNew = this.parameter.isRequiresNew();
        if (isRequiresNew) {
            try (TXHandle h = TX.requiresNew((String)"PcChildLockImplUnLock");){
                try {
                    this.unLockImplC();
                    h.commit();
                }
                catch (Throwable e) {
                    h.markRollback();
                    logger.error("PcChildLockImpl.unlock", e);
                }
            }
        } else {
            this.unLockImplC();
        }
    }

    private void lockImplC() {
        QFilter[] filters = new QFilter[]{new QFilter("lockeddatamasterid", "=", (Object)this.parameter.getLockedDataMasterId()), new QFilter("lockedentityname", "=", (Object)this.parameter.getLockedEntityName()), new QFilter("usepurpose", "=", (Object)this.parameter.getUsePurpose())};
        DynamicObject existedData = BusinessDataServiceHelper.loadSingle((String)"fa_pc_lock_n", (String)"id,detailentryentity.dtholdlockentityname,detailentryentity.dtholdlockdataid", (QFilter[])filters);
        if (existedData != null) {
            PcChildLockUtils.updatePcLock(this.parameter, existedData);
        } else {
            PcChildLockUtils.insertPLock(this.parameter);
        }
    }

    private void unLockImplC() {
        QFilter[] filters = new QFilter[]{new QFilter("lockeddatamasterid", "=", (Object)this.parameter.getLockedDataMasterId()), new QFilter("lockedentityname", "=", (Object)this.parameter.getLockedEntityName()), new QFilter("usepurpose", "=", (Object)this.parameter.getUsePurpose())};
        List existedDataIds = QueryServiceHelper.queryPrimaryKeys((String)"fa_pc_lock_n", (QFilter[])filters, null, (int)1);
        if (existedDataIds == null || existedDataIds.size() == 0) {
            MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)this.parameter.getLockedEntityName());
            String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38\uff0c\u603b\u9501\u7684[%1$s]\u6570\u636e[%2$s]\u53ef\u80fd\u88ab\u5f3a\u5236\u5220\u9664\u4e86\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"PcChildLockImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), billEntityDispName, this.parameter.getLockedDataNum()));
        }
        Object existedDataId = existedDataIds.get(0);
        DynamicObject pcLockDo = BusinessDataServiceHelper.loadSingle(existedDataId, (String)"fa_pc_lock_n");
        PcChildLockUtils.unlockValidate(pcLockDo, this.parameter);
        List<Object[]> deleteDetailIdList = PcChildLockUtils.getDeleteEntryIds(pcLockDo, this.parameter);
        PcChildLockUtils.unlock(pcLockDo, this.parameter, deleteDetailIdList);
    }
}

