/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.pclock;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.pclock.PcParentLockUtils;
import kd.fi.fa.business.pclock.inter.PcParentLock;
import kd.fi.fa.business.pclock.po.LockedBaseData;
import kd.fi.fa.business.pclock.po.PcParentLockParameter;

public class PcParentLockImpl
implements PcParentLock {
    private PcParentLockParameter parameter;
    private static final Log logger = LogFactory.getLog(PcParentLockImpl.class);

    @Override
    public void init(PcParentLockParameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public void lock() {
        block15: {
            boolean isRequiresNew = this.parameter.isRequiresNew();
            if (isRequiresNew) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        this.lockImplP();
                        h.commit();
                        break block15;
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
            this.lockImplP();
        }
    }

    @Override
    public void unlock() {
        boolean isRequiresNew = this.parameter.isRequiresNew();
        if (isRequiresNew) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    this.unLockImplP();
                    h.commit();
                }
                catch (Throwable e) {
                    h.markRollback();
                    logger.error("PcParentLockImpl.unlock", e);
                }
            }
        } else {
            this.unLockImplP();
        }
    }

    private void lockImplP() {
        Set<LockedBaseData> LockedDataSet = this.parameter.getLockedData();
        HashSet<Long> masterIds = new HashSet<Long>(LockedDataSet.size());
        for (LockedBaseData lockedData : LockedDataSet) {
            masterIds.add(lockedData.getLockedDataMasterId());
        }
        HashSet<Long> existMasterIdSet = new HashSet<Long>(masterIds.size());
        HashSet<Long> notExistMasterIdSet = new HashSet<Long>(masterIds.size());
        PcParentLockUtils.handleExistedPcDataToSet(this.parameter, masterIds, existMasterIdSet, notExistMasterIdSet);
        if (existMasterIdSet.size() > 0) {
            PcParentLockUtils.updatePLock(this.parameter, existMasterIdSet);
        }
        if (notExistMasterIdSet.size() > 0) {
            PcParentLockUtils.insertPLock(this.parameter, notExistMasterIdSet);
        }
        if (this.parameter.isUpdateBaseData() && !StringUtils.isEmpty((CharSequence)this.parameter.getToHoldLockBill().getLockedDataBizStatus())) {
            PcParentLockUtils.updateBaseDataBizstatus(this.parameter);
        }
    }

    private void unLockImplP() {
        this.lockImplP();
    }
}

