/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.pclock;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.pclock.enums.PcLockType;
import kd.fi.fa.business.pclock.po.LockedBaseData;
import kd.fi.fa.business.pclock.po.PcParentLockParameter;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.common.util.Fa;

public class PcParentLockUtils {
    private static String alterSelectFields = Fa.comma((String[])new String[]{"lockeddatanum", "holdlockentityname", "type", "sublocknum", Fa.dot((String[])new String[]{"detailentryentity", "dtholdlockentityname"})});

    protected static void handleExistedPcDataToSet(PcParentLockParameter parameter, Set<Long> masterIds, Set<Long> existMasterIdSet, Set<Long> notExistMasterIdSet) {
        SqlBuilder sbBusCtrt = new SqlBuilder();
        sbBusCtrt.append("select fid,flockedentityname,flockeddatamasterid,fusepurpose from t_fa_pc_lock_n where ", new Object[0]);
        sbBusCtrt.appendIn("flockeddatamasterid", masterIds.toArray());
        DataSet pcLockDS = DB.queryDataSet((String)"PcParentLockUtils_select_t_fa_pc_lock_n", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbBusCtrt);
        HashSet<Long> masterIdsInDB = new HashSet<Long>(masterIds.size());
        for (Row row : pcLockDS) {
            String lockedEntityName = row.getString("flockedentityname");
            String usePurpose = row.getString("fusepurpose");
            if (!lockedEntityName.equals(parameter.getLockedEntityName()) || !usePurpose.equals(parameter.getUsePurpose())) continue;
            masterIdsInDB.add(row.getLong("flockeddatamasterid"));
        }
        for (Long masterId : masterIds) {
            if (masterIdsInDB.contains(masterId)) {
                existMasterIdSet.add(masterId);
                continue;
            }
            notExistMasterIdSet.add(masterId);
        }
    }

    protected static void updatePLock(PcParentLockParameter parameter, Set<Long> existMasterIdSet) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_fa_pc_lock_n set ", new Object[0]);
        if (parameter.getToHoldLockBill().getHoldLockEntityName().equals("fa_noentityname")) {
            sb.append("fholdlockdataid = ?,", new Object[]{0});
            if (!StringUtils.isEmpty((CharSequence)parameter.getToHoldLockBill().getLockedDataBizStatus())) {
                sb.append("flockeddatastatus = ?,", new Object[]{parameter.getToHoldLockBill().getLockedDataBizStatus()});
            }
            sb.append("fholdlockdatano = ?,", new Object[]{Character.valueOf(' ')});
        } else {
            sb.append("fholdlockdataid = ?,", new Object[]{parameter.getToHoldLockBill().getHoldLockDataId()});
            if (!StringUtils.isEmpty((CharSequence)parameter.getToHoldLockBill().getLockedDataBizStatus())) {
                sb.append("flockeddatastatus = ?,", new Object[]{parameter.getToHoldLockBill().getLockedDataBizStatus()});
            }
            sb.append("fholdlockdatano = ?,", new Object[]{parameter.getToHoldLockBill().getHoldLockDataNum()});
        }
        sb.append("fmodifytime = ?,", new Object[]{new Date()}).append("fholdlockentityname = ?,", new Object[]{parameter.getToHoldLockBill().getHoldLockEntityName()}).append("ftype = ?", new Object[]{PcLockType.P.name()}).append(" where ", new Object[0]).appendIn("flockeddatamasterid", existMasterIdSet.toArray()).append(" and flockedentityname = ?", new Object[]{parameter.getLockedEntityName()}).append(" and fusepurpose = ?", new Object[]{parameter.getUsePurpose()}).append(" and fholdlockentityname = ?", new Object[]{parameter.getFromHoldLockEntityName()});
        if (!parameter.getFromHoldLockEntityName().equals("fa_noentityname")) {
            sb.append(" and fholdlockdataid = ?", new Object[]{parameter.getFromHoldLockDataId()});
        }
        if (!parameter.getFromHoldLockEntityName().equals("fa_noentityname") && parameter.getFromBizStatusList() != null && parameter.getFromBizStatusList().size() != 0) {
            sb.appendIn(" and flockeddatastatus", parameter.getFromBizStatusList().toArray());
        }
        sb.append(" and fsublocknum  = 0", new Object[0]);
        int updateRows = DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
        if (updateRows != existMasterIdSet.size()) {
            String alterNumber = PcParentLockUtils.getOtherHoldRealAlterString(parameter, existMasterIdSet);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u64cd\u4f5c\u5f02\u5e38,\u6b63\u5728\u505a\u5982\u4e0b\u4e1a\u52a1\uff1a%s\u3002", (String)"PcParentLockUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), alterNumber));
        }
    }

    protected static void insertPLock(PcParentLockParameter parameter, Set<Long> notExistMasterIdSet) {
        MainEntityType LockType = EntityMetadataCache.getDataEntityType((String)"fa_pc_lock_n");
        ArrayList<DynamicObject> notExistLockList = new ArrayList<DynamicObject>(notExistMasterIdSet.size());
        for (LockedBaseData lockedData : parameter.getLockedData()) {
            if (!notExistMasterIdSet.contains(lockedData.getLockedDataMasterId())) continue;
            DynamicObject lockDy = new DynamicObject((DynamicObjectType)LockType);
            lockDy.set("lockedentityname", (Object)parameter.getLockedEntityName());
            lockDy.set("lockeddatamasterid", (Object)lockedData.getLockedDataMasterId());
            lockDy.set("lockeddatanum", (Object)lockedData.getLockedDataNum());
            lockDy.set("usepurpose", (Object)parameter.getUsePurpose());
            lockDy.set("holdlockentityname", (Object)parameter.getToHoldLockBill().getHoldLockEntityName());
            lockDy.set("holdlockdataid", (Object)parameter.getToHoldLockBill().getHoldLockDataId());
            lockDy.set("holdlockdatanum", (Object)parameter.getToHoldLockBill().getHoldLockDataNum());
            lockDy.set("sublocknum", (Object)0);
            lockDy.set("type", (Object)PcLockType.P.name());
            lockDy.set("lockeddatastatus", (Object)parameter.getToHoldLockBill().getLockedDataBizStatus());
            lockDy.set("modifytime", (Object)new Date());
            notExistLockList.add(lockDy);
        }
        SaveServiceHelper.save((DynamicObject[])notExistLockList.toArray(new DynamicObject[notExistLockList.size()]));
    }

    protected static void updateBaseDataBizstatus(PcParentLockParameter parameter) {
        DynamicObject[] baseDataList;
        HashSet<Long> idSet = new HashSet<Long>(parameter.getLockedData().size(), 1.0f);
        for (LockedBaseData lockedData : parameter.getLockedData()) {
            if (lockedData.getLockedDataId() != null || lockedData.getLockedDataId() != 0L) {
                idSet.add(lockedData.getLockedDataId());
                continue;
            }
            idSet.add(lockedData.getLockedDataMasterId());
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", idSet)};
        if (StringUtils.isEmpty((CharSequence)parameter.getStatusCode())) {
            parameter.setStatusCode("bizstatus");
        }
        for (DynamicObject baseData : baseDataList = BusinessDataServiceHelper.load((String)parameter.getLockedEntityName(), (String)("id," + parameter.getStatusCode()), (QFilter[])filters)) {
            baseData.set(parameter.getStatusCode(), (Object)parameter.getToHoldLockBill().getLockedDataBizStatus());
        }
        SaveServiceHelper.save((DynamicObject[])baseDataList);
    }

    protected static String getOtherHoldRealAlterString(PcParentLockParameter parameter, Set<Long> existMasterIdSet) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select flockedentityname,flockeddatamasterid,flockeddatanum,fholdlockentityname,ftype from t_fa_pc_lock_n where ", new Object[0]).appendIn("flockeddatamasterid", existMasterIdSet.toArray()).append(" and flockedentityname = ?", new Object[]{parameter.getLockedEntityName()}).append(" and fusepurpose = ?", new Object[]{parameter.getUsePurpose()}).append(" and fholdlockentityname = ?", new Object[]{parameter.getToHoldLockBill().getHoldLockEntityName()}).append(" and fholdlockdataid = ?", new Object[]{parameter.getToHoldLockBill().getHoldLockDataId()});
        if (!StringUtils.isEmpty((CharSequence)parameter.getToHoldLockBill().getLockedDataBizStatus())) {
            sb.append(" and flockeddatastatus = ?", new Object[]{parameter.getToHoldLockBill().getLockedDataBizStatus()});
        }
        sb.append(" and ftype = ?", new Object[]{PcLockType.P.name()});
        DataSet dataSet = DB.queryDataSet((String)"PcParentLockUtils_fa_pc_lock", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
        Iterator it = dataSet.iterator();
        HashSet<Long> updateedExistSet = new HashSet<Long>(existMasterIdSet.size());
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long id = (Long)row.get("flockeddatamasterid");
            updateedExistSet.add(id);
            HashMap valueMap = new HashMap(2, 1.0f);
            valueMap.put("lockeddatanum", (String)row.get("flockeddatanum"));
            valueMap.put("holdlockentityname", (String)row.get("fholdlockentityname"));
        }
        if (existMasterIdSet.size() != updateedExistSet.size()) {
            existMasterIdSet.removeAll(updateedExistSet);
        }
        HashSet<Long> exceptionMasterIdSet = new HashSet<Long>(100);
        int i = 0;
        for (Long masterId : existMasterIdSet) {
            exceptionMasterIdSet.add(masterId);
            if (++i < 100) continue;
            break;
        }
        QFilter[] alterFilters = new QFilter[]{new QFilter("lockeddatamasterid", "in", (Object)exceptionMasterIdSet.toArray()), new QFilter("lockedentityname", "=", (Object)parameter.getLockedEntityName()), new QFilter("usepurpose", "=", (Object)parameter.getUsePurpose())};
        DynamicObjectCollection pcLockList = QueryServiceHelper.query((String)"fa_pc_lock_n", (String)alterSelectFields, (QFilter[])alterFilters);
        HashSet<String> alterSet = new HashSet<String>(100);
        for (DynamicObject pcLock : pcLockList) {
            StringBuilder sb2;
            String billEntityDispName;
            MainEntityType srcbillEntityType;
            String lockeddatanum = pcLock.getString("lockeddatanum");
            String type = pcLock.getString("type");
            MainEntityType lockedEntityType = EntityMetadataCache.getDataEntityType((String)parameter.getLockedEntityName());
            String lockedEntityDispName = lockedEntityType.getDisplayName().getLocaleValue();
            if (type.equals(PcLockType.P.name())) {
                String holdlockentityname = pcLock.getString("holdlockentityname");
                srcbillEntityType = EntityMetadataCache.getDataEntityType((String)holdlockentityname);
                billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
                sb2 = new StringBuilder();
                sb2.append("[").append(lockedEntityDispName).append(":").append(lockeddatanum).append("]").append(billEntityDispName);
                alterSet.add(sb2.toString());
                continue;
            }
            String dHoldLockEntityName = pcLock.getString(Fa.dot((String[])new String[]{"detailentryentity", "dtholdlockentityname"}));
            srcbillEntityType = EntityMetadataCache.getDataEntityType((String)dHoldLockEntityName);
            billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            sb2 = new StringBuilder();
            sb2.append("[").append(lockedEntityDispName).append(":").append(lockeddatanum).append("]").append(billEntityDispName);
            alterSet.add(sb2.toString());
        }
        return ((Object)alterSet).toString();
    }
}

