/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.periodclose;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.dao.IFaAssetBookDao;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.periodclose.PeriodCloseCenterLogProcessor;
import kd.fi.fa.business.utils.FunctionMutexHelper;

public class PeriodAutoCloseSingleHandler {
    private static final String ALGO = "kd.fi.fa.business.periodclose.PeriodAutoCloseSingleHandler";
    private IFaAssetBookDao bookDao = FaAssetBookDaoFactory.getInstance();
    private AbstractOperationServicePlugIn opPlugin;

    public PeriodAutoCloseSingleHandler(AbstractOperationServicePlugIn opPlugin) {
        this.opPlugin = opPlugin;
    }

    public void forIntelligence(DynamicObject bookObj) {
        this.monthCloseProcessCore(bookObj, null);
    }

    public Map<Class<?>, Object> forCenter(DynamicObject bookObj, String closeCacheKey) {
        return this.monthCloseProcessCore(bookObj, closeCacheKey);
    }

    private Map<Class<?>, Object> monthCloseProcessCore(DynamicObject bookObj, String closeCacheKey) {
        Long bookID = (Long)bookObj.getPkValue();
        HashMap map = new HashMap();
        try {
            if (!"C".equals(bookObj.get("status"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u672a\u542f\u7528\u3002", (String)"PeriodAutoCloseSingleHandler_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            FunctionMutexHelper.lockWithBook("fa_periodclosebill", bookObj, () -> {
                boolean success = this.writeInfoToCenter(bookObj, closeCacheKey);
                map.put(Boolean.class, success);
            });
        }
        catch (Exception e) {
            DynamicObject closecheck = this.createFailInfo(bookID, e.getMessage());
            if (closeCacheKey != null) {
                IAppCache cache = AppCache.get((String)"gl");
                cache.put("periodClose_" + closeCacheKey, (Object)DataEntitySerializer.serializerToString((Object)closecheck));
            }
            map.put(Boolean.class, false);
            map.put(Exception.class, e);
            return map;
        }
        return map;
    }

    DynamicObject createFailInfo(Object bookId, String mess) {
        if (mess != null && mess.length() > 100) {
            mess = mess.substring(0, 100);
        }
        Long org = this.bookDao.getOrgFromBook(bookId);
        Long periodid = this.bookDao.getPeriodFromBook(bookId);
        DynamicObject closecheck = BusinessDataServiceHelper.newDynamicObject((String)"bd_closecheckitem");
        closecheck.set("company", (Object)org);
        closecheck.set("period", (Object)periodid);
        closecheck.set("subsysformnum", (Object)"fa_assetbook");
        closecheck.set("accountbooks", bookId);
        DynamicObjectCollection entitys = closecheck.getDynamicObjectCollection("entryentity");
        DynamicObject entity = new DynamicObject(entitys.getDynamicObjectType());
        entity.set("checkitem", (Object)ResManager.loadKDString((String)"\u7ed3\u8d26\u5931\u8d25", (String)"PeriodAutoCloseSingleHandler_1", (String)"fi-fa-business", (Object[])new Object[0]));
        entity.set("checkstate", (Object)ResManager.loadKDString((String)"\u7ed3\u8d26\u5931\u8d25", (String)"PeriodAutoCloseSingleHandler_1", (String)"fi-fa-business", (Object[])new Object[0]));
        entity.set("menuid", (Object)"0");
        entity.set("formquery", null);
        entity.set("formnumber", null);
        entity.set("message", (Object)(mess == null ? ResManager.loadKDString((String)"\u7ed3\u8d26\u5185\u90e8\u9519\u8bef", (String)"PeriodAutoCloseSingleHandler_2", (String)"fi-fa-business", (Object[])new Object[0]) : mess));
        entitys.add((Object)entity);
        return closecheck;
    }

    private boolean writeInfoToCenter(DynamicObject bookObj, String closeCacheKey) {
        return new PeriodCloseCenterLogProcessor(this.opPlugin).createOrUpdateCloseLog(bookObj, closeCacheKey);
    }
}

