/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.periodclose;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.busyrecord.utils.BusyChgRecordUtils;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.periodclose.UnFinishedBizChecker;
import kd.fi.fa.business.utils.FaFutureChgFinRelUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class PeriodCloseCenterLogProcessor {
    public static final String ENTITY_NAME = "bd_closecheckitem";
    public static final MainEntityType ENTITY_TYPE = EntityMetadataCache.getDataEntityType((String)"bd_closecheckitem");
    private static final String ALGO = "kd.fi.fa.business.periodclose.PeriodCloseCenterLogProcessor";
    private static final String INIT_LEASE_CONTRACT_PUSH = "initLeaseContractPush";
    private final AbstractOperationServicePlugIn opPlugin;

    public PeriodCloseCenterLogProcessor(AbstractOperationServicePlugIn opPlugin) {
        this.opPlugin = opPlugin;
    }

    public boolean createOrUpdateCloseLog(DynamicObject bookObj, String closeCacheKey) {
        this.checkFinRealCardMasterId(bookObj);
        DynamicObject newObject = this.generateObject(bookObj);
        if (closeCacheKey != null) {
            IAppCache cache = AppCache.get((String)"gl");
            cache.put("periodClose_" + closeCacheKey, (Object)DataEntitySerializer.serializerToString((Object)newObject));
        }
        return !newObject.getDynamicObjectCollection("entryentity").stream().anyMatch(v -> v.getString("checkstate").equals("0"));
    }

    private void checkFinRealCardMasterId(DynamicObject bookObj) {
        DynamicObject org = bookObj.getDynamicObject("org");
        long orgId = (Long)org.getPkValue();
        boolean exist = QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("realcardmasterid", "=", (Object)0)});
        if (exist) {
            String msg = ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u7684[\u5361\u7247\u4e3b\u6570\u636eID]\u5b57\u6bb5\u672a\u6210\u529f\u5347\u7ea7\uff0c\u8bf7\u5148\u5347\u7ea7\u3002", (String)"PeriodCloseCenterLogProcessor_0", (String)"fi-fa-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    private DynamicObject generateObject(DynamicObject bookObj) {
        DynamicObject org = bookObj.getDynamicObject("org");
        DynamicObject currentPeriod = bookObj.getDynamicObject("curperiod");
        DynamicObject depreuse = bookObj.getDynamicObject("depreuse");
        long orgID = (Long)org.getPkValue();
        long bookID = (Long)bookObj.getPkValue();
        long depreuseID = (Long)depreuse.getPkValue();
        long currentPeriodID = (Long)currentPeriod.getPkValue();
        Date beginDate = currentPeriod.getDate("begindate");
        Date endDate = currentPeriod.getDate("enddate");
        boolean isMainBook = bookObj.getBoolean("ismainbook");
        DynamicObject centerLogObject = new DynamicObject((DynamicObjectType)ENTITY_TYPE);
        centerLogObject.set("company", (Object)orgID);
        centerLogObject.set("period", (Object)currentPeriodID);
        centerLogObject.set("subsysformnum", (Object)"fa_assetbook");
        centerLogObject.set("accountbooks", (Object)bookID);
        DynamicObjectCollection logEntityCollection = centerLogObject.getDynamicObjectCollection("entryentity");
        DynamicObjectType logEntityType = logEntityCollection.getDynamicObjectType();
        logEntityCollection.clear();
        UnFinishedBizChecker checker = this.getUnFinishedBizChecker(orgID, bookID, depreuseID, currentPeriodID, beginDate, endDate, isMainBook);
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247", (String)"PeriodCloseCenterLogProcessor_1", (String)"fi-fa-business", (Object[])new Object[0]), "fa_card_fin", checker::checkFCard, "KD9SZ32R7G=", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u53d8\u66f4\u5355", (String)"PeriodCloseCenterLogProcessor_2", (String)"fi-fa-business", (Object[])new Object[0]), "fa_change_dept", checker::checkChange, "/K31WHUXLW64", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u6e05\u7406\u5355", (String)"PeriodCloseCenterLogProcessor_3", (String)"fi-fa-business", (Object[])new Object[0]), "fa_clearbill", checker::checkClear, "/K2K1Y39VWO8", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u51cf\u503c\u5355", (String)"PeriodCloseCenterLogProcessor_4", (String)"fi-fa-business", (Object[])new Object[0]), "fa_asset_devalue", checker::checkDevalue, "KDA5CMOJ9KS", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u6298\u65e7\u8c03\u6574\u5355", (String)"PeriodCloseCenterLogProcessor_5", (String)"fi-fa-business", (Object[])new Object[0]), "fa_depreadjustbill", checker::checkDepreAdjust, "KDA5CMOJ9KS", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u62c6\u5206\u5355", (String)"PeriodCloseCenterLogProcessor_6", (String)"fi-fa-business", (Object[])new Object[0]), "fa_assetsplitbill", checker::checkSplitCard, "KDA5CMOJ9KS", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u7ef4\u62a4", (String)"PeriodCloseCenterLogProcessor_7", (String)"fi-fa-business", (Object[])new Object[0]), "fa_workload", checker::checkWorkLoad, "KDA5CMOJ9KS", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355", (String)"PeriodCloseCenterLogProcessor_8", (String)"fi-fa-business", (Object[])new Object[0]), "fa_lease_change_bill", checker::checkLeaseChangeBill, "1277572757147797504", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247", (String)"PeriodCloseCenterLogProcessor_9", (String)"fi-fa-business", (Object[])new Object[0]), "fa_card_real", checker::checkInitLeaseToRealCard, "KD9RDJMA2L8", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c\u521d\u59cb\u5316", (String)"PeriodCloseCenterLogProcessor_10", (String)"fi-fa-business", (Object[])new Object[0]), "fa_lease_contract_init", checker::checkInitLease, "1254326329571181568", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(INIT_LEASE_CONTRACT_PUSH, "fa_lease_contract_init", checker::checkInitLeaseContractPush, "1254326329571181568", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247", (String)"PeriodCloseCenterLogProcessor_11", (String)"fi-fa-business", (Object[])new Object[0]), "fa_asset_card", checker::checkAssetCard, "1+C0LKETPF=+", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u5408\u5e76\u5355", (String)"PeriodCloseCenterLogProcessor_12", (String)"fi-fa-business", (Object[])new Object[0]), "fa_mergebill", checker::checkMergeBill, "KDA5CMOJ9KS", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u6e05\u7406\u7533\u8bf7\u5355", (String)"PeriodCloseCenterLogProcessor_13", (String)"fi-fa-business", (Object[])new Object[0]), "fa_clearapplybill", checker::checkExitApplyNotGenClear, "KDA5CMOJ9KS", logEntityType));
        logEntityCollection.add((Object)this.getLogEntry(ResManager.loadKDString((String)"\u91cd\u542f\u5355", (String)"PeriodCloseCenterLogProcessor_25", (String)"fi-fa-business", (Object[])new Object[0]), "fa_restartrealbill", checker::checkRestartBill, "KDA5CMOJ9KS", logEntityType));
        String errMsg = null;
        if (!bookObj.getBoolean("curperiod.isadjustperiod")) {
            boolean exists = QueryServiceHelper.exists((String)"fa_depre_sum", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)bookObj.getLong(Fa.id((String)"org"))), new QFilter("depreuse", "=", (Object)bookObj.getLong(Fa.id((String)"depreuse"))), new QFilter("period", "=", (Object)currentPeriodID), new QFilter("deprestatus", "=", (Object)"3")});
            if (exists) {
                errMsg = ResManager.loadKDString((String)"\u8ba1\u63d0\u6298\u65e7\u672a\u6210\u529f\uff0c\u9700\u8981\u4fee\u6b63\u9519\u8bef\u5e76\u91cd\u65b0\u8ba1\u63d0\u6298\u65e7", (String)"PeriodCloseCenterLogProcessor_14", (String)"fi-fa-business", (Object[])new Object[0]);
            } else {
                Long periodtypeId = bookObj.getLong("periodtype.id");
                Long previousPeriodid = FaPeriodUtils.getPreviousPeriodId(currentPeriodID, periodtypeId);
                String sql = "SELECT fid id,fisneeddepre isneeddepre,fnumber number,foriginalval originalval,faccumdepre accumdepre, fdecval decval,fpreresidualval preresidualval,fbizperiodid bizperiodid FROM T_FA_CARD_FIN WHERE fbillstatus=? and forg = ? and fdepreuseid=? and fendperiodid > ? and (fbizperiodid in (?,0) or (fbizperiodid = ? and fisneeddepre='1')) and (fclearperiodid = 0 or fclearperiodid = ?)";
                HashSet<Long> set = new HashSet<Long>();
                HashSet toDepreNumberSet = new HashSet(100, 1.0f);
                try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{"C", orgID, depreuseID, currentPeriodID, previousPeriodid, currentPeriodID, currentPeriodID});){
                    for (Row row : ds) {
                        Long bizperiodid = row.getLong("bizperiodid");
                        if (bizperiodid.longValue() == previousPeriodid.longValue() || bizperiodid == 0L) {
                            boolean noValueToDepre;
                            BigDecimal originalval = row.getBigDecimal("originalval");
                            BigDecimal accumdepre = row.getBigDecimal("accumdepre");
                            BigDecimal decval = row.getBigDecimal("decval");
                            BigDecimal preresidualval = row.getBigDecimal("preresidualval");
                            BigDecimal leftValueToDepre = originalval.subtract(accumdepre).subtract(decval).subtract(preresidualval);
                            boolean bl = noValueToDepre = leftValueToDepre.compareTo(BigDecimal.ZERO) == 0;
                            if (noValueToDepre) continue;
                        }
                        set.add(row.getLong("id"));
                        if (bizperiodid != currentPeriodID || !row.getString("isneeddepre").equals("1") || toDepreNumberSet.size() >= 100) continue;
                        toDepreNumberSet.add(row.getString("number"));
                    }
                }
                if (toDepreNumberSet.size() > 0) {
                    String finIdStr = Fa.join((Collection)toDepreNumberSet, (String)",");
                    errMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u9700\u8981\u8ba1\u63d0\u6298\u65e7\u7684\u5361\u7247\u7f16\u7801\u201c%s\u201d\u3002", (String)"PeriodCloseCenterLogProcessor_15", (String)"fi-fa-business", (Object[])new Object[0]), finIdStr);
                    this.addOperationMessage(errMsg);
                } else {
                    DailyDepreImpl dailyDepreImpl;
                    Set<String> needRedepre;
                    String selectFields = Fa.dot((String[])new String[]{"entryentity", "realcard"});
                    QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgID), new QFilter("depreuse", "=", (Object)depreuseID), new QFilter("period", "=", (Object)currentPeriodID)};
                    DynamicObjectCollection depreAdjustBills = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)selectFields, (QFilter[])filters);
                    Set realIdSet = depreAdjustBills.stream().map(v -> v.get(selectFields)).collect(Collectors.toSet());
                    filters = new QFilter[]{new QFilter("org", "=", (Object)orgID), new QFilter("depreuse", "=", (Object)depreuseID), new QFilter("bizperiod", "<=", (Object)currentPeriodID), new QFilter("endperiod", ">", (Object)currentPeriodID), new QFilter("realcardmasterid", "in", realIdSet)};
                    DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])filters);
                    Set _finIds = finCards.stream().map(v -> v.get("id")).collect(Collectors.toSet());
                    set.removeAll(_finIds);
                    if (!set.isEmpty() && !(needRedepre = (dailyDepreImpl = new DailyDepreImpl(Boolean.FALSE, "fa_periodclose")).isNeedDeprePeriodClose(bookID, set)).isEmpty()) {
                        String finIdStr = Fa.join(needRedepre, (String)",");
                        if (finIdStr.length() > 2500) {
                            finIdStr = finIdStr.substring(0, 2500) + "...";
                        }
                        errMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u9700\u8981\u8ba1\u63d0\u6298\u65e7\u7684\u5361\u7247\u7f16\u7801\u5982\u4e0b\uff1a\u201c%s\u201d\u3002", (String)"PeriodCloseCenterLogProcessor_16", (String)"fi-fa-business", (Object[])new Object[0]), finIdStr);
                        this.addOperationMessage(errMsg);
                    }
                }
            }
        }
        boolean existsTempData = QueryServiceHelper.exists((String)"fa_depre_sum", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgID), new QFilter("depreuse", "=", (Object)depreuseID), new QFilter("period", "=", (Object)currentPeriodID), new QFilter("billstatus", "!=", (Object)"C")});
        if (errMsg != null || existsTempData) {
            DynamicObject entry = new DynamicObject(logEntityType);
            entry = new DynamicObject(logEntityType);
            entry.set("checkitem", (Object)ResManager.loadKDString((String)"\u9700\u63d0\u6298\u65e7", (String)"PeriodCloseCenterLogProcessor_17", (String)"fi-fa-business", (Object[])new Object[0]));
            entry.set("checkstate", (Object)"0");
            this.setMenu(entry, "/MLGOUA1CG6J");
            entry.set("message", (Object)errMsg);
            entry.set("formquery", null);
            entry.set("formnumber", null);
            logEntityCollection.add((Object)entry);
        }
        OperationResult operationResult = this.opPlugin.getOperationResult();
        ArrayList<String> errMsgLst = new ArrayList<String>();
        int i = 1;
        for (DynamicObject logEntry : logEntityCollection) {
            if (!"0".equals(logEntry.getString("checkstate"))) continue;
            errMsgLst.add(i++ + ". " + logEntry.getString("checkitem"));
        }
        if (!errMsgLst.isEmpty()) {
            operationResult.getAllErrorOrValidateInfo().clear();
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setMessage(Fa.join(errMsgLst, (String)"; "));
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setPkValue((Object)bookID);
            operationResult.addErrorInfo(operateErrorInfo);
        }
        FaFutureChgFinRelUtils.genCurPeriodFins4futurebus(bookID);
        BusyChgRecordUtils.deleteBusyChgRecord(bookObj);
        return centerLogObject;
    }

    private void addOperationMessage(String msg) {
        OperationResult operationResult = this.opPlugin.getOperationResult();
        operationResult.setMessage(msg);
    }

    private UnFinishedBizChecker getUnFinishedBizChecker(Object orgID, Object bookID, Object depreuseID, Object currentPeriodID, Date beginDate, Date endDate, boolean isMainBook) {
        return new UnFinishedBizChecker(orgID, bookID, depreuseID, currentPeriodID, beginDate, endDate, isMainBook);
    }

    private DynamicObject getLogEntry(String formname, String formnumber, Supplier<Tuple<Boolean, QFilter>> checkFn, String menu, DynamicObjectType logEntityType) {
        DynamicObject entry = new DynamicObject(logEntityType);
        entry.set("formnumber", (Object)formnumber);
        this.setMenu(entry, menu);
        Tuple<Boolean, QFilter> checkResult = checkFn.get();
        if (((Boolean)checkResult.item1).booleanValue()) {
            if (INIT_LEASE_CONTRACT_PUSH.equals(formname)) {
                entry.set("checkitem", (Object)ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c\u521d\u59cb\u5316\u672a\u4e0b\u63a8\u5b9e\u7269\u5361\u7247", (String)"PeriodCloseCenterLogProcessor_18", (String)"fi-fa-business", (Object[])new Object[0]));
            } else if ("fa_clearapplybill".equals(formnumber)) {
                entry.set("checkitem", (Object)String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f02\u5e38\u7684\u201c%s\u201d\uff0c\u8bf7\u5148\u53cd\u5ba1\u6838\u518d\u5220\u9664\u3002", (String)"PeriodCloseCenterLogProcessor_19", (String)"fi-fa-business", (Object[])new Object[0]), formname));
            } else {
                entry.set("checkitem", (Object)String.format(ResManager.loadKDString((String)"%s\u672a\u5ba1\u6838", (String)"PeriodCloseCenterLogProcessor_20", (String)"fi-fa-business", (Object[])new Object[0]), formname));
            }
            entry.set("checkstate", (Object)"0");
            entry.set("formquery", (Object)((QFilter)checkResult.item2).toSerializedString());
        } else {
            if (INIT_LEASE_CONTRACT_PUSH.equals(formname)) {
                entry.set("checkitem", (Object)ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c\u521d\u59cb\u5316\u5df2\u4e0b\u63a8\u5b9e\u7269\u5361\u7247", (String)"PeriodCloseCenterLogProcessor_21", (String)"fi-fa-business", (Object[])new Object[0]));
            } else if ("fa_clearapplybill".equals(formnumber)) {
                entry.set("checkitem", (Object)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u751f\u6210\u6e05\u7406\u5355\u6210\u529f\u3002", (String)"PeriodCloseCenterLogProcessor_22", (String)"fi-fa-business", (Object[])new Object[0]), formname));
            } else {
                entry.set("checkitem", (Object)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5ba1\u6838\u3002", (String)"PeriodCloseCenterLogProcessor_23", (String)"fi-fa-business", (Object[])new Object[0]), formname));
            }
            entry.set("checkstate", (Object)"1");
            entry.set("formquery", (Object)"");
            entry.set("message", (Object)ResManager.loadKDString((String)"\u68c0\u67e5\u901a\u8fc7\u3002", (String)"PeriodCloseCenterLogProcessor_24", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return entry;
    }

    private void setMenu(DynamicObject entry, String menu) {
        if (StringUtils.isNotEmpty((String)menu)) {
            AppMenuInfo appMenuInfo = AppMetadataCache.getAppMenuInfo((String)"fa", (String)menu);
            String icon = null;
            if (appMenuInfo != null) {
                icon = appMenuInfo.getShortcutIcon();
            }
            entry.set("menuid", (Object)(icon != null ? icon : "KDEHKIRNBLG"));
        } else {
            entry.set("menuid", (Object)"KDEHKIRNBLG");
        }
    }
}

