/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.periodclose;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.constants.PCSubStatusEnum;
import kd.fi.fa.business.dao.IFaAssetBookDao;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.utils.FaBizUtils;

public class PeriodUnCloseProcessor {
    protected Object bookId = null;
    protected Object currentPeriodId;
    private Object prevPeriodId = null;

    protected PeriodUnCloseProcessor(Long bookId) {
        this.bookId = bookId;
        this.init();
    }

    protected final void init() {
        DynamicObject assetBook = FaAssetBookDaoFactory.getInstance().queryOne(this.bookId);
        DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
        currentPeriod = FaBaseDaoFactory.getInstance("bd_period").queryOne(currentPeriod.getPkValue());
        this.currentPeriodId = currentPeriod.getPkValue();
        if (this.currentPeriodId.equals(assetBook.get("startperiod.id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u4ece\u672a\u7ed3\u8fc7\u8d26\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u8d26\u3002", (String)"PeriodUnCloseProcessor_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        DynamicObject prevPeriod = FaBizUtils.queryNeighborPeriod(this.currentPeriodId, 0);
        if (prevPeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u201c%s\u201d\u7684\u524d\u4e00\u4e2a\u671f\u95f4\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PeriodUnCloseProcessor_1", (String)"fi-fa-business", (Object[])new Object[0]), currentPeriod.get("number")));
        }
        this.prevPeriodId = prevPeriod.get("id");
    }

    protected void process() {
        IFaAssetBookDao bookDao = FaAssetBookDaoFactory.getInstance();
        try (TXHandle h = TX.required((String)"fi-fa-periodunclose");){
            try {
                bookDao.updateCurrentPeriod(this.bookId, this.prevPeriodId);
                bookDao.updatePCSubStatus(this.bookId, PCSubStatusEnum.INIT);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

