/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.service;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.constants.FaChangeItem;
import kd.fi.fa.business.service.api.AssetChangeBillGenService;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import org.apache.commons.collections.MapUtils;

public class AssetChangeBillGenServiceImpl
implements AssetChangeBillGenService {
    @Override
    public OperationResult generateChangeBill(Map<String, Object> params) {
        OperationResult option = new OperationResult();
        this.validateParam(params);
        DynamicObject bill = this.generateAssetChangeBill(params);
        this.doGenerate(bill);
        params.put("billno", bill.getString("billno"));
        params.put("id", bill.getPkValue());
        option.setSuccessPkIds(Collections.singletonList(bill.getPkValue()));
        return option;
    }

    @Override
    public void doGenerate(DynamicObject changeBill) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("IGNORE_API", "true");
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WF", "FALSE");
        try (TXHandle h = TX.required();){
            try {
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"fa_change_dept", (DynamicObject[])new DynamicObject[]{changeBill}, (OperateOption)option);
                this.handleOperationResult(submitResult);
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"fa_change_dept", (Object[])new Object[]{changeBill.getPkValue()}, (OperateOption)option);
                this.handleOperationResult(auditResult);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    @Override
    public void doGenerateWithSave(DynamicObject changeBill) {
        this.doGenerateWithSave(OperateOption.create(), changeBill);
    }

    @Override
    public void doGenerateWithSave(OperateOption option, DynamicObject changeBill) {
        if (!option.containsVariable("IGNORE_API")) {
            option.setVariableValue("IGNORE_API", "true");
        }
        if (!option.containsVariable("ishasright")) {
            option.setVariableValue("ishasright", String.valueOf(true));
        }
        try (TXHandle h = TX.required();){
            try {
                if (!option.containsVariable("IGNORE_SAVE") || !"true".equals(option.getVariableValue("IGNORE_SAVE"))) {
                    OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"fa_change_dept", (DynamicObject[])new DynamicObject[]{changeBill}, (OperateOption)option);
                    this.handleOperationResult(saveResult);
                }
                option.setVariableValue("WF", "FALSE");
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"fa_change_dept", (Object[])new Object[]{changeBill.getPkValue()}, (OperateOption)option);
                this.handleOperationResult(submitResult);
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"fa_change_dept", (Object[])new Object[]{changeBill.getPkValue()}, (OperateOption)option);
                this.handleOperationResult(auditResult);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void validateParam(Map<String, Object> params) {
        Map org = MapUtils.getMap(params, (Object)"org");
        if (org == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u4e2d%s\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"AssetChangeBillGenServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), "org"));
        }
        String orgNum = MapUtils.getString((Map)org, (Object)"number");
        if (StringUtils.isEmpty((String)orgNum)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u4e2d%s\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"AssetChangeBillGenServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), "org"));
        }
        String changeDate = MapUtils.getString(params, (Object)"changedate");
        if (StringUtils.isEmpty((String)changeDate)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u4e2d%s\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"AssetChangeBillGenServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), "changedate"));
        }
        Map changeType = MapUtils.getMap(params, (Object)"changetype");
        if (changeType == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u4e2d%s\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"AssetChangeBillGenServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), "changetype"));
        }
        String changeTypeNum = MapUtils.getString((Map)changeType, (Object)"number");
        if (StringUtils.isEmpty((String)changeTypeNum)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u4e2d%s\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"AssetChangeBillGenServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), "changetype"));
        }
    }

    private DynamicObject generateAssetChangeBill(Map<String, Object> params) {
        boolean isFuture;
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"fa_change_dept");
        bill.set("billstatus", (Object)"A");
        bill.set("creator", (Object)RequestContext.get().getCurrUserId());
        Map org = MapUtils.getMap(params, (Object)"org");
        String orgNum = MapUtils.getString((Map)org, (Object)"number");
        DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNum)});
        if (orgDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"AssetChangeBillGenServiceImpl_1", (String)"fi-fa-business", (Object[])new Object[0]), orgNum));
        }
        bill.set("org", (Object)orgDyn);
        Map changeType = MapUtils.getMap(params, (Object)"changetype");
        String changeTypeNum = MapUtils.getString((Map)changeType, (Object)"number");
        DynamicObject chgTypeDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_change_type", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)changeTypeNum)});
        if (chgTypeDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u53d8\u66f4\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"AssetChangeBillGenServiceImpl_2", (String)"fi-fa-business", (Object[])new Object[0]), changeTypeNum));
        }
        bill.set("changetype", (Object)chgTypeDyn);
        String applier = MapUtils.getString(params, (Object)"applier");
        if (StringUtils.isNotEmpty((String)applier)) {
            DynamicObject basUser = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)applier)});
            if (basUser == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"AssetChangeBillGenServiceImpl_3", (String)"fi-fa-business", (Object[])new Object[0]), applier));
            }
            bill.set("appliantid", (Object)basUser.getLong("id"));
        }
        String remark = MapUtils.getString(params, (Object)"remark");
        bill.set("remark", (Object)remark);
        bill.set("sourcetype", (Object)"5");
        Map orgBooks = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", orgDyn.getPkValue()), new QFilter("status", "=", (Object)"C")});
        Map<String, DynamicObject> orgDepBookMap = orgBooks.values().stream().collect(Collectors.toMap(b -> b.getString("depreuse.number"), b -> b));
        DynamicObject mainBook = orgBooks.values().stream().filter(book -> book.getBoolean("ismainbook")).findFirst().get();
        String changeDateStr = MapUtils.getString(params, (Object)"changedate");
        Date changeDate = null;
        try {
            changeDate = DateUtil.parseDate((String)changeDateStr, (String)"yyyy-MM-dd", (boolean)false);
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u7684\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"AssetChangeBillGenServiceImpl_4", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        DynamicObject curPeriodDyn = mainBook.getDynamicObject("curperiod");
        Date curPEndDate = curPeriodDyn.getDate("enddate");
        bill.set("changedate", (Object)changeDate);
        boolean bl = isFuture = DateUtil.compareShortDate((Date)changeDate, (Date)curPEndDate) > 0;
        if (isFuture) {
            long bookCurPeriodId = 0L;
            for (DynamicObject book2 : orgBooks.values()) {
                long periodId = book2.getLong(Fa.id((String)"curperiod"));
                if (bookCurPeriodId == 0L) {
                    bookCurPeriodId = periodId;
                }
                if (bookCurPeriodId == periodId) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e0d\u4e00\u81f4", (String)"AssetChangeBillGenServiceImpl_5", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
        DynamicObjectCollection fieldColl = bill.getDynamicObjectCollection("fieldentry");
        List fieldEntries = (List)params.get("fieldentry");
        this.fillChangeEntry(orgDyn.getLong("id"), chgTypeDyn, fieldColl, fieldEntries, orgDepBookMap, isFuture);
        DynamicObjectCollection realEntryColl = bill.getDynamicObjectCollection("realentry");
        HashMap realCard2FinCardMap = new HashMap();
        HashMap<Long, DynamicObject> card2FieldEntry = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> finCardMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject fieldEntry : fieldColl) {
            DynamicObject realCard = fieldEntry.getDynamicObject("realcard1");
            long cardId = realCard.getLong("id");
            card2FieldEntry.put(cardId, fieldEntry);
            HashSet<Long> finCardColl = (HashSet<Long>)realCard2FinCardMap.get(cardId);
            if (finCardColl == null) {
                finCardColl = new HashSet<Long>();
            }
            realCard2FinCardMap.put(cardId, finCardColl);
            DynamicObject finCard = fieldEntry.getDynamicObject("fincard1");
            if (finCard == null) continue;
            finCardMap.put(finCard.getLong("id"), finCard);
            finCardColl.add(finCard.getLong("id"));
        }
        for (Map.Entry cardEntry : realCard2FinCardMap.entrySet()) {
            DynamicObject realEntry = realEntryColl.addNew();
            DynamicObject fieldEntry = (DynamicObject)card2FieldEntry.get(cardEntry.getKey());
            realEntry.set("realcard", fieldEntry.get("realcard1"));
            DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
            Set finCardIds = (Set)cardEntry.getValue();
            for (Long finCardId : finCardIds) {
                DynamicObject finCard = (DynamicObject)finCardMap.get(finCardId);
                DynamicObject finEntry = finEntries.addNew();
                finEntry.set("depreuse", finCard.get("depreuse"));
                finEntry.set("currency", finCard.get("currency"));
                finEntry.set("fincard", (Object)finCard);
                finEntry.set("isadjustdepre", fieldEntry.get("isadjustdepre1"));
                finEntry.set("bizdate", fieldEntry.get("bizdate1"));
            }
        }
        return bill;
    }

    private void fillChangeEntry(long org, DynamicObject chgTypeDyn, DynamicObjectCollection fieldEntryBills, List<Map<String, Object>> fieldList, Map<String, DynamicObject> orgDepBookMap, boolean isFuture) {
        HashSet<String> cardNumberSet = new HashSet<String>(fieldList.size(), 1.0f);
        for (Map<String, Object> fieldRow : fieldList) {
            Map realcard = MapUtils.getMap(fieldRow, (Object)"realcard1");
            String cardNum = MapUtils.getString((Map)realcard, (Object)"number");
            cardNumberSet.add(cardNum);
        }
        QFilter[] filterRCard = new QFilter[]{new QFilter("org", "=", (Object)org), new QFilter("id", "=", (Object)"masterid", true), new QFilter("number", "in", cardNumberSet)};
        Map cardRealMap = BusinessDataServiceHelper.loadFromCache((String)"fa_card_real", (QFilter[])filterRCard);
        HashSet<Long> rCardIdSet = new HashSet<Long>(cardNumberSet.size());
        HashMap<String, DynamicObject> number_Cards = new HashMap<String, DynamicObject>(cardNumberSet.size());
        for (DynamicObject rCard : cardRealMap.values()) {
            String rCardNumber = (String)rCard.get("number");
            number_Cards.put(rCardNumber, rCard);
            rCardIdSet.add(rCard.getLong("id"));
        }
        DynamicObjectCollection chgItemEntry = chgTypeDyn.getDynamicObjectCollection("changetypeentry");
        Map<String, DynamicObject> chgItemMap = chgItemEntry.stream().map(item -> item.getDynamicObject("changeitem")).collect(Collectors.toMap(item -> item.getString("topic") + "." + item.getString("number"), item -> item));
        ArrayList fCards = new ArrayList(rCardIdSet.size() * orgDepBookMap.size());
        for (Map.Entry<String, DynamicObject> bookEntry : orgDepBookMap.entrySet()) {
            DynamicObject dynamicObject = bookEntry.getValue();
            Long assetBookId = dynamicObject.getLong("id");
            Map cards = BusinessDataServiceHelper.loadFromCache((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org), new QFilter("endperiod", "=", (Object)99999999999L), new QFilter("assetbook", "=", (Object)assetBookId), new QFilter("number", "in", number_Cards.keySet())});
            fCards.addAll(cards.values());
        }
        HashMap<String, DynamicObject> rId_duId2fcardMap = new HashMap<String, DynamicObject>(fCards.size());
        for (DynamicObject dynamicObject : fCards) {
            StringBuilder key = new StringBuilder(dynamicObject.getString("realcard.number"));
            key.append("_");
            key.append(dynamicObject.getString("depreuse.id"));
            rId_duId2fcardMap.put(key.toString(), dynamicObject);
        }
        for (Map map : fieldList) {
            String chgField;
            DynamicObject chgItem;
            DynamicObject entryBill = fieldEntryBills.addNew();
            Map realcard = MapUtils.getMap((Map)map, (Object)"realcard1");
            String cardNum = MapUtils.getString((Map)realcard, (Object)"number");
            DynamicObject realCardDyn = (DynamicObject)number_Cards.get(cardNum);
            if (realCardDyn == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5b9e\u7269\u5361\u7247\u4e0d\u5b58\u5728\u3002", (String)"AssetChangeBillGenServiceImpl_6", (String)"fi-fa-business", (Object[])new Object[0]), cardNum));
            }
            realcard.put("id", realCardDyn.getLong("id"));
            entryBill.set("realcard1", (Object)realCardDyn);
            entryBill.set("assetnumber", (Object)realCardDyn.getString("number"));
            Map depreuse = MapUtils.getMap((Map)map, (Object)"depreuse1");
            String depruseNum = MapUtils.getString((Map)depreuse, (Object)"number");
            DynamicObject depUseDyn = orgDepBookMap.get(depruseNum);
            if (depUseDyn == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%1$s]\u4e0d\u5b58\u5728\u6298\u65e7\u7528\u9014[%2$s]\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"AssetChangeBillGenServiceImpl_7", (String)"fi-fa-business", (Object[])new Object[0]), org, depruseNum));
            }
            depreuse.put("id", depUseDyn.getLong("depreuse.id"));
            entryBill.set("depreuse1", (Object)depUseDyn.getDynamicObject("depreuse"));
            String rid_duid_key = realCardDyn.getString("number") + "_" + depUseDyn.getLong("depreuse.id");
            DynamicObject finCardDyn = (DynamicObject)rId_duId2fcardMap.get(rid_duid_key);
            if (finCardDyn != null) {
                entryBill.set("fincard1", (Object)finCardDyn);
                entryBill.set("currency1", finCardDyn.get("currency"));
                entryBill.set("basecurrency1", finCardDyn.get("basecurrency"));
            }
            if ((chgItem = chgItemMap.get(chgField = MapUtils.getString((Map)map, (Object)"field"))) == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5b57\u6bb5[%s]\u4e0d\u5728\u53d8\u66f4\u7c7b\u578b\u8303\u56f4\u4e2d\u3002", (String)"AssetChangeBillGenServiceImpl_8", (String)"fi-fa-business", (Object[])new Object[0]), chgField));
            }
            entryBill.set("field", (Object)chgField);
            IDataEntityProperty prop = null;
            String chgTopic = chgItem.getString("topic");
            Object befValue = null;
            if ("fa_card_real".equals(chgTopic)) {
                befValue = realCardDyn.get(chgItem.getString("number"));
                prop = (IDataEntityProperty)realCardDyn.getDataEntityType().getProperties().get((Object)chgItem.getString("number"));
            } else if ("fa_card_fin".equals(chgTopic)) {
                if (isFuture) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u8d22\u52a1\u5361\u7247\u5b57\u6bb5\u3002", (String)"AssetChangeBillGenServiceImpl_9", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (finCardDyn == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247[%s]\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"AssetChangeBillGenServiceImpl_10", (String)"fi-fa-business", (Object[])new Object[0]), cardNum));
                }
                befValue = finCardDyn.get(chgItem.getString("number"));
                prop = (IDataEntityProperty)finCardDyn.getDataEntityType().getProperties().get((Object)chgItem.getString("number"));
            }
            if (befValue instanceof DynamicObject) {
                befValue = ((DynamicObject)befValue).getPkValue().toString();
            } else if (befValue instanceof Timestamp) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                befValue = sdf.format(befValue);
            }
            entryBill.set("beforevalue", befValue);
            Object aftValue = MapUtils.getObject((Map)map, (Object)"aftervalue");
            this.checkFieldFormat(prop, aftValue);
            if (prop instanceof BasedataProp) {
                if (Objects.isNull(aftValue)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5b57\u6bb5\u53d8\u66f4\u540e\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssetChangeBillGenServiceImpl_11", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                BasedataProp basedataProp = (BasedataProp)prop;
                String entityId = basedataProp.getBaseEntityId();
                String numberProp = basedataProp.getNumberProp();
                String nameProp = basedataProp.getDisplayProp();
                DynamicObject baseDataDyn = BusinessDataServiceHelper.loadSingleFromCache((String)entityId, (String)String.join((CharSequence)",", "id", numberProp, nameProp), (QFilter[])new QFilter[]{new QFilter(numberProp, "=", (Object)aftValue.toString())});
                if (baseDataDyn == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u503c\u4e0d\u6b63\u786e\uff1a\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"AssetChangeBillGenServiceImpl_12", (String)"fi-fa-business", (Object[])new Object[0]), aftValue));
                }
                entryBill.set("aftervalue", baseDataDyn.getPkValue());
            } else {
                entryBill.set("aftervalue", aftValue);
            }
            String reason = MapUtils.getString((Map)map, (Object)"reason");
            entryBill.set("reason", (Object)reason);
            Boolean isAdjust = MapUtils.getBoolean((Map)map, (Object)"isadjustdepre1");
            entryBill.set("isadjustdepre1", (Object)isAdjust);
            String bizDateStr = MapUtils.getString((Map)map, (Object)"bizdate1");
            Date bizDate = null;
            try {
                bizDate = DateUtil.parseDate((String)bizDateStr, (String)"yyyy-MM-dd", (boolean)false);
            }
            catch (ParseException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u7684\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"AssetChangeBillGenServiceImpl_13", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            entryBill.set("bizdate1", (Object)bizDate);
        }
        this.checkRepeatChangeField(fieldEntryBills);
        this.checkAdjustDepre(fieldEntryBills);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkFieldFormat(IDataEntityProperty propType, Object value) {
        if (value == null) {
            return;
        }
        try {
            if (propType instanceof QtyProp) {
                Double.parseDouble(value.toString());
                return;
            }
            if (propType instanceof DateProp) {
                DateProp dateProp = (DateProp)propType;
                DateFormat dateFormat = dateProp.getDateFormat();
                dateFormat.setLenient(false);
                dateFormat.parse(value.toString());
                return;
            }
            if (propType instanceof DateTimeProp) {
                DateTimeProp dateProp = (DateTimeProp)propType;
                DateFormat dateFormat = dateProp.getDateFormat();
                dateFormat.setLenient(false);
                dateFormat.parse(value.toString());
                return;
            }
            if (!(propType instanceof BasedataProp)) return;
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u503c(%s)\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\u662f\u5426\u548c\u5b57\u6bb5\u7c7b\u578b\u5339\u914d", (String)"AssetChangeBillGenServiceImpl_14", (String)"fi-fa-business", (Object[])new Object[0]), value));
        }
    }

    private void checkAdjustDepre(DynamicObjectCollection fieldEntry) {
        HashMap<String, Boolean> adjustDepreMap = new HashMap<String, Boolean>(fieldEntry.size());
        for (int i = 0; i < fieldEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)fieldEntry.get(i);
            String realCardNumber = row.getString("assetnumber");
            long depreUseId = row.getLong(Fa.id((String)"depreuse1"));
            String key = realCardNumber + "_" + depreUseId;
            String changeField = row.getString("field");
            boolean isAdjustDepre = row.getBoolean("isadjustdepre1");
            if (!adjustDepreMap.containsKey(key)) {
                adjustDepreMap.put(key, isAdjustDepre);
            } else if (isAdjustDepre != (Boolean)adjustDepreMap.get(key)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u76f8\u540c\u7684\u5361\u7247\uff0c\u201c\u672a\u6765\u9002\u7528\u201d\u7684\u503c\u5fc5\u987b\u76f8\u540c\u3002", (String)"AssetChangeBillGenServiceImpl_15", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if ("fa_card_real.usestatus".equals(changeField) && !isAdjustDepre) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u4f7f\u7528\u72b6\u6001\u65f6\uff0c\u53ea\u80fd\u505a\u672a\u6765\u9002\u7528\u7684\u53d8\u66f4", (String)"AssetChangeBillGenServiceImpl_16", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if ("fa_card_real.usestatus".equals(changeField) || FaChangeItem.ENABLE_MODIFY_IS_ADJUST_DEPRE.contains(changeField) || !isAdjustDepre) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u5b57\u6bb5\u4e0d\u80fd\u505a\u672a\u6765\u9002\u7528\u7684\u53d8\u66f4\uff0c\u8bf7\u4fee\u6539", (String)"AssetChangeBillGenServiceImpl_17", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private void checkRepeatChangeField(DynamicObjectCollection fieldEntry) {
        HashSet<String> changeField = new HashSet<String>(fieldEntry.size());
        for (DynamicObject row : fieldEntry) {
            String assetNumber = row.getString("assetnumber");
            String field = row.getString("field");
            long depreuse = row.getLong(Fa.id((String)"depreuse1"));
            boolean addRes = changeField.add(assetNumber + "_" + depreuse + "_" + field);
            if (addRes) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u3010%1$s\u3011\u6709\u91cd\u590d\u7684\u53d8\u66f4\u5b57\u6bb5\u3010%2$s\u3011\u3002", (String)"AssetChangeBillGenServiceImpl_18", (String)"fi-fa-business", (Object[])new Object[0]), assetNumber, field));
        }
    }

    private void handleOperationResult(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            List allError = operationResult.getAllErrorOrValidateInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            } else {
                errorInfo.append(operationResult.getMessage());
            }
            String msg = String.format("%s %s", ResManager.loadKDString((String)"\u751f\u6210\u8d44\u4ea7\u53d8\u66f4\u5355\u5931\u8d25:", (String)"AssetChangeBillGenServiceImpl_19", (String)"fi-fa-business", (Object[])new Object[0]), errorInfo.toString());
            throw new KDBizException(msg);
        }
    }
}

