/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class AssetPolicyUtil {
    private static final String ALGO = "kd.fi.fa.business.utils.AssetPolicyUtil";

    public static DynamicObject getByBookAndCat(Object bookPk, Object catPk) {
        Object depreSystemId = AssetPolicyUtil.getDepreSystemPK_ByBook(bookPk);
        return AssetPolicyUtil.getByDepreSystemAndCat(depreSystemId, catPk);
    }

    protected static Object getDepreSystemPK_ByBook(Object bookPk) {
        String selectFields = "depresystem";
        QFilter[] filters = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(bookPk))).toArray();
        String orderBys = null;
        Object depreSystemId = 0L;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"fa_assetbook", (String)selectFields, (QFilter[])filters, orderBys);){
            for (Row row : ds) {
                depreSystemId = row.get("depresystem");
            }
        }
        return depreSystemId;
    }

    protected static List<Object> getDepreSystemPK_ByBooks(List<Object> bookPk) {
        String selectFields = "depresystem";
        QFilter[] filters = new QFilter("id", "in", (Object)bookPk.toArray()).toArray();
        ArrayList<Object> depreSystemList = new ArrayList<Object>(2);
        Map assetBookMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)selectFields, (QFilter[])filters);
        for (DynamicObject assetBook : assetBookMap.values()) {
            long depreSystemId = assetBook.getLong(Fa.id((String)"depresystem"));
            depreSystemList.add(depreSystemId);
        }
        return depreSystemList;
    }

    private static String getCateLongNumber(Object catPK) {
        DynamicObject cate = QueryServiceHelper.queryOne((String)"fa_assetcategory", (String)"longnumber", (QFilter[])new QFilter("id", "=", catPK).toArray());
        return cate.getString("longnumber");
    }

    private static Map<Long, String> getCateLongNumber(Set<Long> catPks) {
        QFilter filter = new QFilter("id", "in", catPks);
        String selectFields = Fa.comma((String[])new String[]{"id", "longnumber"});
        Map assetCats = BusinessDataServiceHelper.loadFromCache((String)"fa_assetcategory", (String)selectFields, (QFilter[])filter.toArray());
        HashMap<Long, String> longNumberMap = new HashMap<Long, String>(assetCats.size(), 1.0f);
        for (DynamicObject assetCat : assetCats.values()) {
            long assetCatId = assetCat.getLong("id");
            String longNumber = assetCat.getString("longnumber");
            longNumberMap.put(assetCatId, longNumber);
        }
        return longNumberMap;
    }

    public static DynamicObject getByAssetPolicyInfoAndCateLongNumber(String catLongNumber, List<Tuple<String, DynamicObject>> assetPolicyInfo) {
        for (Tuple<String, DynamicObject> tuple : assetPolicyInfo) {
            if (catLongNumber.indexOf((String)tuple.item1) != 0) continue;
            return (DynamicObject)tuple.item2;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8d44\u4ea7\u7c7b\u522b\u201c%s\u201d\u627e\u4e0d\u5230\u6298\u65e7\u653f\u7b56\u3002", (String)"AssetPolicyUtil_0", (String)"fi-fa-business", (Object[])new Object[0]), catLongNumber));
    }

    public static DynamicObject getByDepreSystemAndCat(Object depreSystemId, Object catPk) {
        List<Tuple<String, DynamicObject>> assetPolicyMap = AssetPolicyUtil.getAssetPolicyInfoByDepreSystemId(depreSystemId);
        String cateLongNumber = AssetPolicyUtil.getCateLongNumber(catPk);
        for (Tuple<String, DynamicObject> tuple : assetPolicyMap) {
            if (cateLongNumber.indexOf((String)tuple.item1) != 0) continue;
            return (DynamicObject)tuple.item2;
        }
        DynamicObject depreSystem = QueryServiceHelper.queryOne((String)"fa_depresystem", (String)"name", (QFilter[])new QFilter("id", "=", depreSystemId).toArray());
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8d44\u4ea7\u7c7b\u522b\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u4e0b\u627e\u4e0d\u5230\u6298\u65e7\u653f\u7b56\u3002", (String)"AssetPolicyUtil_1", (String)"fi-fa-business", (Object[])new Object[0]), cateLongNumber, depreSystem.getString("name")));
    }

    public static Map<Long, Map<Long, DynamicObject>> getByDepreSystemAndCatBatch(Set<Long> depreSystemIdSet, Set<Long> assetCatIdSet) {
        HashMap<Long, Map<Long, DynamicObject>> depreSystemEntryMap = new HashMap<Long, Map<Long, DynamicObject>>(depreSystemIdSet.size(), 1.0f);
        Map depreSystemMap = BusinessDataServiceHelper.loadFromCache((Object[])depreSystemIdSet.toArray(), (String)"fa_depresystem");
        Map<Long, String> catLongNumber = AssetPolicyUtil.getCateLongNumber(assetCatIdSet);
        for (DynamicObject depreSystem : depreSystemMap.values()) {
            long depreSystemId = depreSystem.getLong("id");
            Map assetCatAndEntryMap = depreSystemEntryMap.computeIfAbsent(depreSystemId, v -> new HashMap(assetCatIdSet.size(), 1.0f));
            List<Tuple<String, DynamicObject>> assetPolicyList = AssetPolicyUtil.getAssetPolicyInfoByDepreSystems(depreSystem);
            for (Map.Entry<Long, String> entry : catLongNumber.entrySet()) {
                String longNumber = entry.getValue();
                boolean findPolicy = false;
                for (Tuple<String, DynamicObject> tuple : assetPolicyList) {
                    if (longNumber.indexOf((String)tuple.item1) != 0) continue;
                    Long assetCatId = entry.getKey();
                    assetCatAndEntryMap.put(assetCatId, tuple.item2);
                    findPolicy = true;
                    break;
                }
                if (findPolicy) continue;
                String depreSystemName = depreSystem.getString("name");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8d44\u4ea7\u7c7b\u522b\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u4e0b\u627e\u4e0d\u5230\u6298\u65e7\u653f\u7b56\u3002", (String)"AssetPolicyUtil_1", (String)"fi-fa-business", (Object[])new Object[0]), longNumber, depreSystemName));
            }
        }
        return depreSystemEntryMap;
    }

    public static List<Tuple<String, DynamicObject>> getAssetPolicyInfoByBookId(Object bookPk) {
        Object depreSystemId = AssetPolicyUtil.getDepreSystemPK_ByBook(bookPk);
        return AssetPolicyUtil.getAssetPolicyInfoByDepreSystemId(depreSystemId);
    }

    public static Map<Object, List<Tuple<String, DynamicObject>>> getAssetPolicyInfoByBookIds(List<Object> bookPks) {
        List<Object> depreSystemIds = AssetPolicyUtil.getDepreSystemPK_ByBooks(bookPks);
        return AssetPolicyUtil.getAssetPolicyInfoByDepreSystemIds(depreSystemIds.toArray());
    }

    public static List<Tuple<String, DynamicObject>> getAssetPolicyInfoByDepreSystemId(Object depreSystemId) {
        DynamicObject depreSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)depreSystemId, (String)"fa_depresystem");
        return AssetPolicyUtil.getAssetPolicyInfoByDepreSystems(depreSystem);
    }

    public static Map<Object, List<Tuple<String, DynamicObject>>> getAssetPolicyInfoByDepreSystemIds(Object[] depreSystemsIds) {
        Map depreSystemMap = BusinessDataServiceHelper.loadFromCache((Object[])depreSystemsIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_depresystem"));
        DynamicObject[] depreSystems = depreSystemMap.values().toArray(new DynamicObject[0]);
        return AssetPolicyUtil.getAssetPolicyInfoByDepreSystems(depreSystems);
    }

    public static Map<Object, List<Tuple<String, DynamicObject>>> getAssetPolicyInfoByDepreSystems(DynamicObject[] depreSystems) {
        HashMap<Object, List<Tuple<String, DynamicObject>>> ret = new HashMap<Object, List<Tuple<String, DynamicObject>>>(depreSystems.length);
        for (DynamicObject depreSystem : depreSystems) {
            ret.put(depreSystem.get("id"), AssetPolicyUtil.getAssetPolicyInfoByDepreSystems(depreSystem));
        }
        return ret;
    }

    public static List<Tuple<String, DynamicObject>> getAssetPolicyInfoByDepreSystems(DynamicObject depreSystem) {
        DynamicObjectCollection assetPolicies = depreSystem.getDynamicObjectCollection("assetpolicy_entry");
        ArrayList<Tuple<String, DynamicObject>> ret = new ArrayList<Tuple<String, DynamicObject>>();
        for (DynamicObject assetPolicie : assetPolicies) {
            ret.add((Tuple<String, DynamicObject>)new Tuple((Object)assetPolicie.getString("assetcat.longnumber"), (Object)assetPolicie));
        }
        ret.sort((v1, v2) -> ((String)v2.item1).length() - ((String)v1.item1).length());
        return ret;
    }
}

