/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;

public class AttachmentUtils {
    private static Log log = LogFactory.getLog(AttachmentUtils.class);
    public static final String DEFAULT_ATTACHMENT_PANEL = "attachmentpanel";

    public static void copyAttachments(String sourceEntity, String targetEntity, String targetAttachmentPanel, Map<Object, List<Object>> sourceId2TargetIdMap) {
        List sourceIdList = sourceId2TargetIdMap.keySet().stream().map(Object::toString).collect(Collectors.toList());
        Map sourceAttachments = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (QFilter[])new QFilter[]{new QFilter("fbilltype", "=", (Object)sourceEntity), new QFilter("finterid", "in", sourceIdList)});
        HashMap<String, ArrayList<Object>> sourceAttachmentMap = new HashMap<String, ArrayList<Object>>(sourceId2TargetIdMap.size());
        for (Map.Entry entry : sourceAttachments.entrySet()) {
            DynamicObject attachment = (DynamicObject)entry.getValue();
            String string = attachment.getString("finterid");
            ArrayList<Object> attachments = (ArrayList<Object>)sourceAttachmentMap.get(string);
            if (attachments == null) {
                attachments = new ArrayList<Object>(4);
                sourceAttachmentMap.put(string, attachments);
            }
            attachments.add(attachment);
        }
        ArrayList<DynamicObject> targetAttachments = new ArrayList<DynamicObject>(sourceAttachmentMap.size());
        Date curTime = new Date();
        for (Map.Entry entry : sourceId2TargetIdMap.entrySet()) {
            String sourceId = entry.getKey().toString();
            List curSourceAttachments = (List)sourceAttachmentMap.get(sourceId);
            List targetIds = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)curSourceAttachments)) continue;
            for (Object targetId : targetIds) {
                for (DynamicObject oneAttachment : curSourceAttachments) {
                    DynamicObject newAttachment = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)oneAttachment);
                    newAttachment.set("fnumber", (Object)AttachmentServiceHelper.generateUid());
                    newAttachment.set("fcreatemen", (Object)UserServiceHelper.getCurrentUserId());
                    newAttachment.set("fcreatetime", (Object)curTime);
                    newAttachment.set("finterid", (Object)targetId.toString());
                    newAttachment.set("fbilltype", (Object)targetEntity);
                    newAttachment.set("fattachmentpanel", (Object)targetAttachmentPanel);
                    targetAttachments.add(newAttachment);
                }
            }
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (CollectionUtils.isNotEmpty(targetAttachments)) {
                    SaveServiceHelper.save((DynamicObject[])targetAttachments.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                log.error("copyAttachments error is :", (Throwable)e);
                tx.markRollback();
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    public static List<Map<String, Object>> saveTempAndUpload(List<Map<String, Object>> attachmentData, String attachmentPanel, String formId, Object pkId) {
        String appId = "fa";
        if (CollectionUtils.isNotEmpty(attachmentData)) {
            ArrayList<Map<String, Object>> needUploadAttachments = new ArrayList<Map<String, Object>>(attachmentData.size());
            Set<String> relativeUids = AttachmentUtils.getRelativeAttachmentUids(attachmentData);
            for (Map<String, Object> attachment : attachmentData) {
                String uid = (String)attachment.get("uid");
                if (attachment.containsKey("relativeUrl") || relativeUids.contains(uid)) continue;
                needUploadAttachments.add(attachment);
            }
            if (CollectionUtils.isNotEmpty(needUploadAttachments)) {
                for (Map<String, Object> temp : needUploadAttachments) {
                    String tempUrl = (String)temp.get("url");
                    String fileName = (String)temp.get("name");
                    String fileId = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)appId, (String)formId, (Object)pkId, (String)fileName, (boolean)true);
                    temp.put("url", fileId);
                }
                AttachmentServiceHelper.upload((String)formId, (Object)pkId, (String)attachmentPanel, needUploadAttachments);
            }
        }
        return AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)attachmentPanel);
    }

    private static Set<String> getRelativeAttachmentUids(List<Map<String, Object>> attachmentData) {
        HashSet<String> uids = new HashSet<String>(attachmentData.size());
        for (Map<String, Object> attachment : attachmentData) {
            String uid = (String)attachment.get("uid");
            if (!attachment.containsKey("relativeUrl")) continue;
            uids.add(uid);
        }
        return uids;
    }

    public static List<Map<String, Object>> getTempDataFromSources(List<Map<String, Object>> attachmentData) {
        ArrayList<Map<String, Object>> tempAttachments = new ArrayList<Map<String, Object>>(attachmentData.size());
        if (CollectionUtils.isNotEmpty(attachmentData)) {
            for (Map<String, Object> attachment : attachmentData) {
                if (attachment.containsKey("relativeUrl")) continue;
                tempAttachments.add(attachment);
            }
        }
        return tempAttachments;
    }
}

