/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.fa.business.utils.FaFinCardUtil;

public class CheckFaFinCardDataUtil {
    public static Set<String> checkPreUsingAmountAndDepredAmount(Object depreMethod, Object workLoadUnit, Object preUsingAmount, Object depredAmount, Object number) {
        HashSet<String> errorMsgSet = new HashSet<String>(16);
        if (Objects.nonNull(depreMethod)) {
            if ("5".equals(((DynamicObject)depreMethod).getString("type"))) {
                int unitPrecision = 0;
                boolean mustInputWorkLoadUnit = FaFinCardUtil.isMustInputWorkLoadUnit();
                if (Objects.isNull(workLoadUnit) && mustInputWorkLoadUnit) {
                    if (Objects.nonNull(number)) {
                        errorMsgSet.add(String.format(ResManager.loadKDString((String)"%s \u5de5\u4f5c\u91cf\u6cd5\u5361\u7247\u9700\u586b\u5199\u5de5\u4f5c\u91cf\u5355\u4f4d\u3002", (String)"CheckFaFinCardDataUtil_0", (String)"fi-fa-business", (Object[])new Object[0]), number));
                    } else {
                        errorMsgSet.add(ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u6cd5\u5361\u7247\u9700\u586b\u5199\u5de5\u4f5c\u91cf\u5355\u4f4d\u3002", (String)"CheckFaFinCardDataUtil_1", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                }
                if (Objects.nonNull(workLoadUnit)) {
                    unitPrecision = ((DynamicObject)workLoadUnit).getInt("precision");
                }
                if (Objects.nonNull(preUsingAmount)) {
                    BigDecimal preUsingAmountBigDecimal = (BigDecimal)preUsingAmount;
                    if (preUsingAmountBigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                        if (Objects.nonNull(number)) {
                            errorMsgSet.add(String.format(ResManager.loadKDString((String)"%s \u5f55\u5165\u7684\u9884\u8ba1\u5bff\u547d\u5fc5\u987b\u5927\u4e8e\u96f6\u3002", (String)"CheckFaFinCardDataUtil_2", (String)"fi-fa-business", (Object[])new Object[0]), number));
                        } else {
                            errorMsgSet.add(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u9884\u8ba1\u5bff\u547d\u5fc5\u987b\u5927\u4e8e\u96f6\u3002", (String)"CheckFaFinCardDataUtil_3", (String)"fi-fa-business", (Object[])new Object[0]));
                        }
                    }
                    String preUsingAmountStr = preUsingAmountBigDecimal.stripTrailingZeros().toPlainString();
                    int preUsingAmountPrecision = 0;
                    if (preUsingAmountStr.split("\\.").length > 1) {
                        preUsingAmountPrecision = preUsingAmountStr.split("\\.")[1].length();
                    }
                    if (preUsingAmountPrecision > unitPrecision) {
                        if (Objects.nonNull(number)) {
                            errorMsgSet.add(String.format(ResManager.loadKDString((String)"%1$s \u9884\u8ba1\u5bff\u547d\u7cbe\u5ea6%2$s \u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5355\u4f4d\u7cbe\u5ea6%3$s\u3002", (String)"CheckFaFinCardDataUtil_4", (String)"fi-fa-business", (Object[])new Object[0]), number, preUsingAmountPrecision, unitPrecision));
                        } else {
                            errorMsgSet.add(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u5bff\u547d\u7cbe\u5ea6%1$s \u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5355\u4f4d\u7cbe\u5ea6%2$s\u3002", (String)"CheckFaFinCardDataUtil_5", (String)"fi-fa-business", (Object[])new Object[0]), preUsingAmountPrecision, unitPrecision));
                        }
                    }
                }
                if (Objects.nonNull(depredAmount)) {
                    BigDecimal depredAmountBigDecimal = (BigDecimal)depredAmount;
                    if (depredAmountBigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                        if (Objects.nonNull(number)) {
                            errorMsgSet.add(String.format(ResManager.loadKDString((String)"%s \u5df2\u6298\u65e7\u671f\u95f4\u6570\u5fc5\u987b\u5927\u4e8e\u96f6\u3002", (String)"CheckFaFinCardDataUtil_6", (String)"fi-fa-business", (Object[])new Object[0]), number));
                        } else {
                            errorMsgSet.add(ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u671f\u95f4\u6570\u5fc5\u987b\u5927\u4e8e\u96f6\u3002", (String)"CheckFaFinCardDataUtil_7", (String)"fi-fa-business", (Object[])new Object[0]));
                        }
                    }
                    String depredAmountStr = depredAmountBigDecimal.stripTrailingZeros().toPlainString();
                    int depredAmountPrecision = 0;
                    if (depredAmountStr.split("\\.").length > 1) {
                        depredAmountPrecision = depredAmountStr.split("\\.")[1].length();
                    }
                    if (depredAmountPrecision > unitPrecision) {
                        if (Objects.nonNull(number)) {
                            errorMsgSet.add(String.format(ResManager.loadKDString((String)"%1$s \u5df2\u6298\u65e7\u5bff\u547d\u7cbe\u5ea6%2$s\u5927\u4e8e\u5de5\u4f5c\u91cf\u5355\u4f4d\u7cbe\u5ea6%3$s\u3002", (String)"CheckFaFinCardDataUtil_8", (String)"fi-fa-business", (Object[])new Object[0]), number, depredAmountPrecision, unitPrecision));
                        } else {
                            errorMsgSet.add(String.format(ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u7cbe\u5ea6%1$s\u5927\u4e8e\u5de5\u4f5c\u91cf\u5355\u4f4d\u7cbe\u5ea6%2$s\u3002", (String)"CheckFaFinCardDataUtil_9", (String)"fi-fa-business", (Object[])new Object[0]), depredAmountPrecision, unitPrecision));
                        }
                    }
                }
            } else {
                if (Objects.nonNull(workLoadUnit)) {
                    if (Objects.nonNull(number)) {
                        errorMsgSet.add(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u4e3a%s\u7684\u5361\u7247\u6298\u65e7\u65b9\u6cd5\u4e3a\u975e\u5de5\u4f5c\u91cf\u6cd5\uff0c\u5de5\u4f5c\u91cf\u5355\u4f4d\u5e94\u8be5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CheckFaFinCardDataUtil_10", (String)"fi-fa-business", (Object[])new Object[0]), number));
                    } else {
                        errorMsgSet.add(ResManager.loadKDString((String)"\u975e\u5de5\u4f5c\u91cf\u6cd5\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5de5\u4f5c\u91cf\u5355\u4f4d\u3002", (String)"CheckFaFinCardDataUtil_11", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                }
                errorMsgSet.addAll(CheckFaFinCardDataUtil.checkPreUsingAmountAndDepredAmountPositiveInteger(preUsingAmount, depredAmount, number));
            }
        } else {
            errorMsgSet.addAll(CheckFaFinCardDataUtil.checkPreUsingAmountAndDepredAmountPositiveInteger(preUsingAmount, depredAmount, number));
        }
        return errorMsgSet;
    }

    private static Set<String> checkPreUsingAmountAndDepredAmountPositiveInteger(Object preUsingAmount, Object depredAmountObj, Object number) {
        HashSet<String> errorMsgSet = new HashSet<String>(16);
        if (Objects.nonNull(preUsingAmount) && CheckFaFinCardDataUtil.isNotPositiveInteger((BigDecimal)preUsingAmount)) {
            if (Objects.nonNull(number)) {
                errorMsgSet.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u9884\u8ba1\u5bff\u547d\u5e94\u4e3a\u6b63\u6574\u6570\u62160\u3002", (String)"CheckFaFinCardDataUtil_12", (String)"fi-fa-business", (Object[])new Object[0]), number));
            } else {
                errorMsgSet.add(ResManager.loadKDString((String)"\u9884\u8ba1\u5bff\u547d\u5e94\u4e3a\u6b63\u6574\u6570\u62160\u3002", (String)"CheckFaFinCardDataUtil_13", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
        if (Objects.nonNull(depredAmountObj) && CheckFaFinCardDataUtil.isNotPositiveInteger((BigDecimal)depredAmountObj)) {
            if (Objects.nonNull(number)) {
                errorMsgSet.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u6298\u65e7\u9700\u8981\u5f55\u5165\u6b63\u6574\u6570\u62160\u3002", (String)"CheckFaFinCardDataUtil_14", (String)"fi-fa-business", (Object[])new Object[0]), number));
            } else {
                errorMsgSet.add(ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u9700\u8981\u5f55\u5165\u6b63\u6574\u6570\u62160\u3002", (String)"CheckFaFinCardDataUtil_15", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
        return errorMsgSet;
    }

    public static boolean isNotPositiveInteger(BigDecimal bigDecimal) {
        return BigDecimal.ZERO.compareTo(bigDecimal) > 0 || bigDecimal.setScale(0, RoundingMode.UP).compareTo(bigDecimal) != 0;
    }
}

