/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.po.FaAssetBookDataUpgradeLogPo;
import kd.fi.fa.business.utils.FaBillParamUtils;

public class FaAssetBookDataUpgradeLogUtils {
    private static Log log = LogFactory.getLog(FaAssetBookDataUpgradeLogUtils.class);
    private static final String UPDATE_SQL = "update t_fa_upgraded_assetbook set ferrormsg = ?, ferrormsg_tag = ?, fstatus = ? where fid = ?";
    private static final int LIMIT_LENGTH = 50;

    public static boolean enableCurPeriodSplit(Long orgId) {
        return (Boolean)ThreadCache.get((Object)("curperiod.split." + orgId), () -> {
            String paramVal = FaBillParamUtils.getStringValue(orgId, null, null, "split.currentperiod.enable", false);
            if (StringUtils.isEmpty((String)paramVal)) {
                return false;
            }
            return Boolean.parseBoolean(paramVal);
        });
    }

    public static boolean enableCurPeriodSplitByOrgId(Collection<Long> orgIds) {
        Map<Long, Boolean> enableCurPeriodSplitMap = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit(orgIds);
        if (enableCurPeriodSplitMap.isEmpty()) {
            return Boolean.FALSE;
        }
        boolean enableCurPeriodSplit = Boolean.TRUE;
        Collection<Boolean> values = enableCurPeriodSplitMap.values();
        for (Boolean value : values) {
            if (value.booleanValue()) continue;
            enableCurPeriodSplit = Boolean.FALSE;
            break;
        }
        return enableCurPeriodSplit;
    }

    public static Map<Long, Boolean> enableCurPeriodSplit(Collection<Long> orgIds) {
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>(2);
        customFilters.add(new QFilter("org", "in", orgIds));
        DynamicObjectCollection billParams = FaBillParamUtils.query("split.currentperiod.enable", customFilters);
        HashMap<Long, Boolean> orgBillParamMap = new HashMap<Long, Boolean>(orgIds.size());
        if (billParams == null || billParams.isEmpty()) {
            return orgBillParamMap;
        }
        billParams.stream().forEach(t -> {
            Object org = t.get("org");
            Long orgId = null;
            orgId = org instanceof DynamicObject ? Long.valueOf(((DynamicObject)org).getLong("id")) : (Long)org;
            orgBillParamMap.put(orgId, Boolean.parseBoolean(t.getString("value")));
        });
        return orgBillParamMap;
    }

    public static boolean allOrgEnableCurPeriodSplit() {
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>();
        customFilters.add(new QFilter("value", "=", (Object)"false"));
        return !FaBillParamUtils.exists("split.currentperiod.enable", customFilters);
    }

    public static Long insertLog(FaAssetBookDataUpgradeLogPo insertPo, boolean isNewTran) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_upgraded_assetbook");
        DynamicObject logDyObj = new DynamicObject((DynamicObjectType)type);
        long logId = DB.genLongId((String)"t_fa_upgraded_assetbook");
        logDyObj.set("id", (Object)logId);
        logDyObj.set("org", (Object)insertPo.getOrgId());
        logDyObj.set("depreuse", (Object)insertPo.getDepreuseId());
        logDyObj.set("purpose", (Object)insertPo.getPurpose());
        logDyObj.set("opdate", (Object)insertPo.getOpDate());
        logDyObj.set("errormsg", null);
        logDyObj.set("status", (Object)insertPo.getStatus());
        if (isNewTran) {
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew((String)"FaAssetBookDataUpgradeLogUtils_insertLog");){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logDyObj});
                Long l = logId;
                return l;
            }
            catch (Exception e) {
                try {
                    log.error("FaAssetBookDataUpgradeLogUtils.insertLog\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                    h.markRollback();
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logDyObj});
            return logId;
        }
        catch (Exception e) {
            log.error("FaAssetBookDataUpgradeLogUtils.insertLog\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
    }

    public static void updateLog(Long logId, FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum statusEnum, String errorMsg) {
        if (StringUtils.isEmpty((String)errorMsg)) {
            errorMsg = " ";
        }
        String errorMsgShort = errorMsg;
        if (statusEnum == FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum.ERROR) {
            errorMsgShort = errorMsg.length() > 50 ? errorMsg.substring(0, 50) : errorMsg;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(UPDATE_SQL, new Object[]{errorMsgShort, errorMsg, statusEnum.name(), logId});
        try (TXHandle h = TX.requiresNew((String)"FaAssetBookDataUpgradeLogUtils_updateLog");){
            try {
                DB.update((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
            }
            catch (Exception e) {
                log.error("FaAssetBookDataUpgradeLogUtils.updateLog\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
    }

    public static void updateLog(String purpose, Collection<Long> orgIds, FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum statusEnum, String errorMsg) {
        if (StringUtils.isEmpty((String)errorMsg)) {
            errorMsg = " ";
        }
        String errorMsgShort = errorMsg;
        if (statusEnum == FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum.ERROR) {
            errorMsgShort = errorMsg.length() > 50 ? errorMsg.substring(0, 50) : errorMsg;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_fa_upgraded_assetbook set ferrormsg = ?, ferrormsg_tag = ?, fstatus = ? where fpurpose = ? and ", new Object[]{errorMsgShort, errorMsg, statusEnum.name(), purpose});
        sqlBuilder.appendIn("forgid", orgIds.toArray());
        try (TXHandle h = TX.requiresNew((String)"FaAssetBookDataUpgradeLogUtils_updateLog");){
            try {
                DB.update((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
            }
            catch (Exception e) {
                log.error("FaAssetBookDataUpgradeLogUtils.updateLog\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
    }

    public static DynamicObjectCollection queryByPurpose(String purpose, List<String> queryFields) {
        return QueryServiceHelper.query((String)"fa_upgraded_assetbook", (String)queryFields.stream().collect(Collectors.joining(",")), (QFilter[])new QFilter[]{new QFilter("purpose", "=", (Object)purpose)});
    }
}

