/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.utils.FaBizCtrSource;
import kd.fi.fa.business.utils.FaConstants;

public class FaBizCtrUtils {
    private static final String[] busCtrArr = new String[]{"id", "srcbillid", "srcbillentityname"};
    private static final String[] cardArr = new String[]{"number"};

    public static void batchUpdateBizCtrForBill(Set<Long> masterIds, List<FaBizCtrSource> fromSourceList, Long toSourceId, String toSourceEntityName) {
        if (masterIds == null || masterIds.size() == 0) {
            return;
        }
        SqlBuilder sbBusCtrt = new SqlBuilder();
        sbBusCtrt.append("select fid from t_fa_card_biz_ctr where ", new Object[0]);
        sbBusCtrt.appendIn("fid", masterIds.toArray());
        DataSet busCtrDS = DB.queryDataSet((String)"batchUpdateBizCtr_fa_card_biz_ctr", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbBusCtrt);
        HashSet<Long> busCtrSet = new HashSet<Long>(masterIds.size());
        for (Row row : busCtrDS) {
            busCtrSet.add(row.getLong("fid"));
        }
        HashSet<Long> existMasterIdSet = new HashSet<Long>(masterIds.size());
        HashSet<Long> notExistMasterIdSet = new HashSet<Long>(masterIds.size());
        for (Long masterId : masterIds) {
            if (busCtrSet.contains(masterId)) {
                existMasterIdSet.add(masterId);
                continue;
            }
            notExistMasterIdSet.add(masterId);
        }
        Date now = new Date();
        if (existMasterIdSet.size() > 0) {
            SqlBuilder sb = new SqlBuilder();
            sb.append("update t_fa_card_biz_ctr set ", new Object[0]).append("fsrcbillid = ?,", new Object[]{toSourceId}).append("fsrcbillentityname = ?,", new Object[]{toSourceEntityName}).append("fmodifytime = ?", new Object[]{now}).append(" where ", new Object[0]).appendIn("fid", existMasterIdSet.toArray());
            if (fromSourceList.size() == 1) {
                FaBizCtrSource fromSource = fromSourceList.get(0);
                sb.append("and fsrcbillid = ?", new Object[]{fromSource.getFromSourceId()});
                sb.append("and fsrcbillentityname = ?", new Object[]{fromSource.getFromSourceEntityName()});
            } else {
                sb.append("and (", new Object[0]);
                for (int i = 0; i < fromSourceList.size(); ++i) {
                    if (i != 0) {
                        sb.append(" or ", new Object[0]);
                    }
                    FaBizCtrSource fromSource = fromSourceList.get(i);
                    sb.append("(fsrcbillid = ?", new Object[]{fromSource.getFromSourceId()});
                    sb.append("and fsrcbillentityname = ?)", new Object[]{fromSource.getFromSourceEntityName()});
                }
                sb.append(")", new Object[0]);
            }
            int updateRows = DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
            if (updateRows != existMasterIdSet.size()) {
                String alterNumber = FaBizCtrUtils.getOtherHoldRealAlterStringForBiz(existMasterIdSet, toSourceId, toSourceEntityName);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u4ee5\u4e0b\u8d44\u4ea7\u7f16\u7801\u7684\u5361\u7247\u6b63\u5728\u505a\u5982\u4e0b\u6e05\u7406\u4e92\u65a5\u4e1a\u52a1\uff1a%s\u3002", (String)"FaBizCtrUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), alterNumber));
            }
        }
        if (notExistMasterIdSet.size() > 0) {
            MainEntityType cardBusCotrType = EntityMetadataCache.getDataEntityType((String)"fa_card_biz_ctr");
            ArrayList<DynamicObject> notExistBusCtrList = new ArrayList<DynamicObject>(notExistMasterIdSet.size());
            for (Long masterId : notExistMasterIdSet) {
                DynamicObject dy = new DynamicObject((DynamicObjectType)cardBusCotrType);
                dy.set("id", (Object)masterId);
                dy.set("srcbillid", (Object)toSourceId);
                dy.set("srcbillentityname", (Object)toSourceEntityName);
                dy.set("modifytime", (Object)now);
                notExistBusCtrList.add(dy);
            }
            SaveServiceHelper.save((DynamicObject[])notExistBusCtrList.toArray(new DynamicObject[notExistBusCtrList.size()]));
        }
    }

    private static String getOtherHoldRealAlterStringForBiz(Set<Long> existMasterIdSet, Long sourceId, String sourceEntityName) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fid as id from t_fa_card_biz_ctr where ", new Object[0]).appendIn("fid", existMasterIdSet.toArray()).append("and fsrcbillid = ?", new Object[]{sourceId}).append("and fsrcbillentityname  = ?", new Object[]{sourceEntityName});
        DataSet dataSet = DB.queryDataSet((String)"OtherHoldRealAlter_fa_card_biz_ctr", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
        Iterator it = dataSet.iterator();
        HashSet<Long> existSet = new HashSet<Long>(existMasterIdSet.size());
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long id = (Long)row.get("id");
            existSet.add(id);
        }
        if (existMasterIdSet.size() != existSet.size()) {
            existMasterIdSet.removeAll(existSet);
        }
        HashSet<Long> exceptionMasterIdSet = new HashSet<Long>(100);
        int i = 0;
        for (Long masterId : existMasterIdSet) {
            exceptionMasterIdSet.add(masterId);
            if (++i < 100) continue;
            break;
        }
        SqlBuilder sbCtr = new SqlBuilder();
        sbCtr.append("select fid as id,fsrcbillid as srcbillid,fsrcbillentityname as srcbillentityname from t_fa_card_biz_ctr where ", new Object[0]).appendIn("fid", exceptionMasterIdSet.toArray());
        DataSet dataSetCtr = DB.queryDataSet((String)"OtherHoldRealAlterSrc_fa_card_biz_ctr", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbCtr);
        SqlBuilder sbR = new SqlBuilder();
        sbR.append("select fmasterid as masterid,fnumber as number from t_fa_card_real where ", new Object[0]).appendIn("fmasterid", exceptionMasterIdSet.toArray()).append("and fisbak = '0'", new Object[0]);
        DataSet dataSetR = DB.queryDataSet((String)"OtherHoldRealAlterNumber_fa_card_biz_ctr", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbR);
        DataSet numSrcDs = dataSetCtr.join(dataSetR).on("id", "masterid").select(busCtrArr, cardArr).finish();
        Iterator itR = numSrcDs.iterator();
        HashSet<String> alterSet = new HashSet<String>(100);
        while (itR.hasNext()) {
            Row row = (Row)itR.next();
            String number = (String)row.get("number");
            String srcbillentityname = (String)row.get("srcbillentityname");
            String billEntityDispName = "";
            if (srcbillentityname.equals("NOENTITYNAME")) {
                billEntityDispName = ResManager.loadKDString((String)"\u65e0\u5355\u636e\uff0c\u521d\u59cb\u72b6\u6001\u3002", (String)"FaBizCtrUtils_1", (String)"fi-fa-business", (Object[])new Object[0]);
            } else {
                MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)srcbillentityname);
                billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            }
            alterSet.add("[" + number + "]" + billEntityDispName);
        }
        return ((Object)alterSet).toString();
    }
}

