/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.dao.impl.FaAssetBookDaoOrmImpl;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.DateUtil;

public class FaBizUtils {
    public static final Long YEAR_PERIOD_L = 10000L;
    private static final Log logger = LogFactory.getLog(FaBizUtils.class);
    static final String title = "titlepanelflex";
    static final String content = "contentpanelflex";
    static final String assetBookFields = "id,periodtype,curperiod,org,status,depreuse,name,curperiod.beginDate begindate,curperiod.enddate enddate,curperiod.periodnumber periodNumber,curperiod.periodyear periodyear";

    public static DynamicObject queryYoYPeriod(Object currentPeriodId, int dir) {
        DynamicObject currentPeriod = FaBaseDaoFactory.getInstance("bd_period").queryOne(currentPeriodId);
        int periodYear = currentPeriod.getInt("periodYear");
        int periodNumber = currentPeriod.getInt("periodNumber");
        Object periodTypePk = currentPeriod.getDynamicObject("periodType").getPkValue();
        int prevPeriodYear = dir > 0 ? periodYear + 1 : periodYear - 1;
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", periodTypePk), new QFilter("periodyear", "=", (Object)prevPeriodYear), new QFilter("periodnumber", "=", (Object)periodNumber)};
        DynamicObject[] periods = FaBaseDaoFactory.getInstance("bd_period").query(filters);
        if (periods != null && periods.length > 0) {
            return periods[0];
        }
        return null;
    }

    public static DynamicObject queryNeighborPeriod(Object curPeriodId, int dir) {
        String entityName = "bd_period";
        String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
        Object periodtypeid = currPeriod.get("periodtype_id");
        String oper = dir > 0 ? ">" : "<";
        String orderby = dir > 0 ? "id asc" : "id desc";
        QFilter filterDate = new QFilter("id", oper, curPeriodId);
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter isadjustperiod = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, isadjustperiod}, (String)orderby, (int)1);
        return coll != null && !coll.isEmpty() ? (DynamicObject)coll.get(0) : null;
    }

    public static DynamicObject queryNeighborPeriodByDo(DynamicObject curPeriod, int dir) {
        String entityName = "bd_period";
        String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
        Object periodtypeid = curPeriod.get("periodtype_id");
        String oper = dir > 0 ? ">" : "<";
        String orderby = dir > 0 ? "id asc" : "id desc";
        Long curPeriodId = curPeriod.getLong("id");
        QFilter filterDate = new QFilter("id", oper, (Object)curPeriodId);
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter isadjustperiod = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, isadjustperiod}, (String)orderby, (int)1);
        return coll != null && !coll.isEmpty() ? (DynamicObject)coll.get(0) : null;
    }

    public static Long[] getNextPeriodByDepre(long orgId, long depreUserId, int dir) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter depreFilter = new QFilter("depreuse", "=", (Object)depreUserId);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"fa_assetbook", (String)"curperiod", (QFilter[])new QFilter[]{orgFilter, depreFilter});
        Long curPeriodId = 0L;
        if (periods != null && periods.size() > 0) {
            curPeriodId = ((DynamicObject)periods.get(0)).getLong("curperiod");
        }
        if (curPeriodId == 0L) {
            return new Long[]{0L, 0L};
        }
        DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriod(curPeriodId, 1);
        if (nextPeriod == null) {
            return new Long[]{curPeriodId, 0L};
        }
        return new Long[]{curPeriodId, nextPeriod.getLong("id")};
    }

    public static long getPreviousYearSamePeriod(long curPeriodId) {
        long samePeriod = 0L;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            long num = curPeriodId % YEAR_PERIOD_L;
            samePeriod = (curPeriodId / YEAR_PERIOD_L - 1L) * YEAR_PERIOD_L + num;
            boolean exists = QueryServiceHelper.exists((String)"bd_period", (Object)samePeriod);
            if (!exists) {
                samePeriod = 0L;
            }
        }
        return samePeriod;
    }

    public static DynamicObject queryNeighborPeriod(Object periodtypeid, Date date, int dir) {
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("periodtype.id", "=", periodtypeid), new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date)});
        return FaBizUtils.queryNeighborPeriod(period.get("id"), dir);
    }

    public static String getPeriodDistanceByBook(Long bookPK, Long inputPeriodPK) {
        Long currentPeriodPK = (Long)new FaAssetBookDaoOrmImpl().queryCurrentPeriodByBook(bookPK).getPkValue();
        DynamicObject currentPeriod = FaBaseDaoFactory.getInstance("bd_period").queryOne(currentPeriodPK);
        DynamicObject endPeriod = null;
        if (FaBaseDaoFactory.getInstance("bd_period").isExist(inputPeriodPK)) {
            endPeriod = FaBaseDaoFactory.getInstance("bd_period").queryOne(inputPeriodPK);
        }
        if (endPeriod != null && currentPeriod.get("periodtype").toString().equals(endPeriod.get("periodtype").toString())) {
            int flag = FaPeriodUtils.compare2period(currentPeriodPK, inputPeriodPK);
            int count = 0;
            if (flag == 0) {
                return "0";
            }
            if (flag == 1) {
                while (currentPeriod.getLong("id") != endPeriod.getLong("id")) {
                    ++count;
                    if ((currentPeriod = FaBizUtils.queryNeighborPeriod(currentPeriod.getLong("id"), -1)) != null) continue;
                    return null;
                }
                return "-" + count;
            }
            if (flag == -1) {
                while (currentPeriod.getLong("id") != endPeriod.getLong("id")) {
                    ++count;
                    if ((currentPeriod = FaBizUtils.queryNeighborPeriod(currentPeriod.getLong("id"), 1)) != null) continue;
                    return null;
                }
                return "+" + count;
            }
        }
        return null;
    }

    public static DynamicObject queryRealCardByFinCard(Object finPK) {
        DynamicObject finCard = FaFinCardDaoFactory.getInstance().queryOne(finPK);
        return FaRealCardDaoFactory.getInstance().queryOne(finCard.getDynamicObject("realcard").getPkValue());
    }

    public static DynamicObject getAsstBookByOrg(Long orgId) {
        return (DynamicObject)ThreadCache.get((Object)("FaBizUtils.getAssetBookByOrg" + orgId), () -> FaBizUtils.getAsstBookByOrg(orgId, assetBookFields));
    }

    public static DynamicObject getAsstBookByOrg(Long orgId, String fields) {
        QFilter mainAssbookf = new QFilter("ismainbook", "=", (Object)true);
        QFilter orgf = new QFilter("org", "=", (Object)orgId);
        DynamicObject assBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)fields, (QFilter[])new QFilter[]{mainAssbookf, orgf});
        return assBook;
    }

    public static DynamicObjectCollection getAsstBookFieldsByOrg(Long orgId, String fields) {
        QFilter org = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection assBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)fields, (QFilter[])new QFilter[]{org});
        return assBooks;
    }

    public static DynamicObjectCollection getAsstBookFieldsByOrg(Set<Long> orgIds, String fields) {
        QFilter org = new QFilter("org", "in", orgIds);
        DynamicObjectCollection assBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)fields, (QFilter[])new QFilter[]{org});
        return assBooks;
    }

    public static List<DynamicObject> getAsstBooksByOrg(Long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        DynamicObjectCollection assBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)assetBookFields, (QFilter[])filters.toArray(new QFilter[0]));
        List<DynamicObject> result = assBooks.stream().collect(Collectors.toList());
        return result;
    }

    public static List<DynamicObject> getEnableAsstBooksByOrg(Long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("status", "=", (Object)Character.valueOf('C')));
        DynamicObjectCollection assBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)assetBookFields, (QFilter[])filters.toArray(new QFilter[0]));
        List<DynamicObject> result = assBooks.stream().collect(Collectors.toList());
        return result;
    }

    public static List<DynamicObject> getEnableAssetBooksByOrgs(List<Long> orgIds) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "in", orgIds));
        filters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        DynamicObjectCollection assBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)assetBookFields, (QFilter[])filters.toArray(new QFilter[0]));
        return new ArrayList<DynamicObject>((Collection<DynamicObject>)assBooks);
    }

    public static List<DynamicObject> getEnableAssetBooksByOrgsAndDepreuse(List<Long> orgIds, Long depreuseId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "in", orgIds));
        filters.add(new QFilter("depreuse", "=", (Object)depreuseId));
        filters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        DynamicObjectCollection assBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"startperiod,id,periodtype,curperiod,org,status,depreuse,name,curperiod.beginDate begindate,curperiod.enddate enddate,curperiod.periodnumber periodNumber,curperiod.periodyear periodyear", (QFilter[])filters.toArray(new QFilter[0]));
        return new ArrayList<DynamicObject>((Collection<DynamicObject>)assBooks);
    }

    public static DynamicObject getAsstBookByOrgAndDepreuse(Long orgId, Long depreuseId, String fields) {
        QFilter depreuseF = new QFilter("depreuse", "=", (Object)depreuseId);
        QFilter orgf = new QFilter("org", "=", (Object)orgId);
        DynamicObject assBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)fields, (QFilter[])new QFilter[]{depreuseF, orgf});
        return assBook;
    }

    public static DynamicObjectCollection getAllBookByOrg(Long orgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        return (DynamicObjectCollection)ThreadCache.get((Object)("FaBizUtils.getAllBookByOrg" + orgId), () -> QueryServiceHelper.query((String)"fa_assetbook", (String)"org,id,periodtype,curperiod,startperiod,curperiod.beginDate begindate,curperiod.enddate enddate,curperiod.periodnumber periodNumber,curperiod.number number,curperiod.periodyear periodyear,depreuse,ismainbook", (QFilter[])new QFilter[]{orgFilter}));
    }

    public static List<Long> getAllChildLeafOrg(Long orgId) {
        HashSet<Long> res = new HashSet<Long>();
        DynamicObjectCollection childOrgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org, isleaf, fullname", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)orgId), new QFilter("view.treetype", "=", (Object)"09"), new QFilter("view.isdefault", "=", (Object)"1")});
        for (DynamicObject org : childOrgs) {
            if (org.getBoolean("isleaf")) {
                res.add(org.getLong("org"));
                continue;
            }
            res.addAll(FaBizUtils.getAllChildLeafOrg(org.getLong("org")));
        }
        return new ArrayList<Long>(res);
    }

    public static void setDate(IFormView view, String buinessDate, DateEdit dateEndEdit, boolean futureBusiness, boolean ifUpdateDate) {
        IDataModel model = view.getModel();
        Date now = new Date();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            view.setEnable(Boolean.valueOf(false), new String[]{title});
            return;
        }
        Date maxBeginDate = null;
        Date minEndDate = null;
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg(org.getLong("id"));
        if (mainBook != null) {
            maxBeginDate = (Date)mainBook.get("begindate");
            minEndDate = mainBook.getDate("enddate");
            if (maxBeginDate == null) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"FaBizUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), org.getString("name")));
                view.setEnable(Boolean.valueOf(false), new String[]{title});
                return;
            }
            dateEndEdit.setMinDate(maxBeginDate);
            if (!futureBusiness) {
                dateEndEdit.setMaxDate(minEndDate);
            }
            if (ifUpdateDate) {
                if (now.before(maxBeginDate)) {
                    model.setValue(buinessDate, (Object)maxBeginDate);
                } else if (now.after(minEndDate)) {
                    model.setValue(buinessDate, (Object)DateUtil.stripTime((Date)minEndDate));
                } else {
                    model.setValue(buinessDate, (Object)DateUtil.stripTime((Date)now));
                }
            }
        } else {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"FaBizUtils_1", (String)"fi-fa-business", (Object[])new Object[0]), org.getString("name")));
            view.setEnable(Boolean.valueOf(false), new String[]{title});
            return;
        }
        view.setEnable(Boolean.valueOf(true), new String[]{title});
    }

    public static void setDate(IFormView view, String buinessDate, DateEdit dateEndEdit, boolean futureBusiness, boolean ifUpdateDate, int index) {
        IDataModel model = view.getModel();
        Date now = new Date();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            view.setEnable(Boolean.valueOf(false), new String[]{title});
            return;
        }
        Date maxBeginDate = null;
        Date minEndDate = null;
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg(org.getLong("id"));
        DynamicObjectCollection books = FaBizUtils.getAllBookByOrg(org.getLong("id"));
        if (mainBook != null) {
            maxBeginDate = (Date)mainBook.get("begindate");
            minEndDate = (Date)mainBook.get("enddate");
            if (maxBeginDate == null) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"FaBizUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), org.getString("name")));
                view.setEnable(Boolean.valueOf(false), new String[]{title});
                return;
            }
            dateEndEdit.setMinDate(maxBeginDate);
            boolean flag = true;
            if (futureBusiness) {
                flag = now.after(maxBeginDate);
            } else {
                dateEndEdit.setMaxDate(minEndDate);
                boolean bl = flag = now.after(maxBeginDate) && now.before(minEndDate);
            }
            if (ifUpdateDate) {
                if (now.before(maxBeginDate)) {
                    model.setValue(buinessDate, (Object)maxBeginDate, index);
                } else if (now.after(minEndDate)) {
                    model.setValue(buinessDate, (Object)minEndDate, index);
                } else {
                    model.setValue(buinessDate, (Object)now, index);
                }
            }
        } else {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"FaBizUtils_1", (String)"fi-fa-business", (Object[])new Object[0]), org.getString("name")));
            view.setEnable(Boolean.valueOf(false), new String[]{title});
            return;
        }
        view.setEnable(Boolean.valueOf(true), new String[]{title});
    }

    public static void setDateDifPeriod(IFormView view, String buinessDate, DateEdit dateEndEdit, boolean futureBusiness, boolean ifUpdateDate) {
        IDataModel model = view.getModel();
        Date now = new Date();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            view.setEnable(Boolean.valueOf(false), new String[]{title});
            return;
        }
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg(org.getLong("id"));
        if (mainBook != null) {
            Date begindate = (Date)mainBook.get("begindate");
            Date enddate = (Date)mainBook.get("enddate");
            if (begindate == null) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"FaBizUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), org.getString("name")));
                view.setEnable(Boolean.valueOf(false), new String[]{title});
                return;
            }
            dateEndEdit.setMinDate(begindate);
            boolean flag = true;
            if (futureBusiness) {
                flag = now.after(begindate);
            } else {
                dateEndEdit.setMaxDate(enddate);
                boolean bl = flag = now.after(begindate) && now.before(enddate);
            }
            if (ifUpdateDate) {
                if (flag) {
                    model.setValue(buinessDate, (Object)now);
                } else {
                    model.setValue(buinessDate, (Object)enddate);
                }
            }
        } else {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u8d44\u4ea7\u4e3b\u8d26\u7c3f\u3002", (String)"FaBizUtils_2", (String)"fi-fa-business", (Object[])new Object[0]), org.getString("name")));
            view.setEnable(Boolean.valueOf(false), new String[]{title});
            return;
        }
        view.setEnable(Boolean.valueOf(true), new String[]{title});
    }

    public static boolean isCurrentDate(Date bizDate, Long orgId) {
        List<DynamicObject> assetBooks = FaBizUtils.getAsstBooksByOrg(orgId);
        Boolean result = FaBizUtils.isCurrentDate(bizDate, assetBooks);
        return result;
    }

    public static boolean isCurrentDate(Date bizDate, List<DynamicObject> assetBooks) {
        for (DynamicObject book : assetBooks) {
            Date beginDate = book.getDate("begindate");
            Date endDate = book.getDate("enddate");
            if (bizDate.compareTo(beginDate) >= 0 && bizDate.getTime() <= endDate.getTime()) continue;
            return false;
        }
        return true;
    }

    public static DynamicObject checkAllBooksCurPeriod(Long orgId) {
        DynamicObjectCollection allBookByOrg = FaBizUtils.getAllBookByOrg(orgId);
        if (allBookByOrg.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u627e\u4e0d\u5230\u8d44\u4ea7\u8d26\u7c3f\uff0c\u8bf7\u68c0\u67e5\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaBizUtils_3", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        Set curPeriods = allBookByOrg.stream().map(v -> v.getLong("curperiod")).collect(Collectors.toSet());
        if (curPeriods.size() > 1) {
            return null;
        }
        return (DynamicObject)allBookByOrg.get(0);
    }

    public static List<DynamicObject> loadAssetBookByOrgOrder(Long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        Map bookMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)assetBookFields, (QFilter[])filters.toArray(new QFilter[0]), (String)"ismainbook desc");
        ArrayList<DynamicObject> assetBookList = new ArrayList<DynamicObject>(bookMap.size());
        for (Map.Entry entry : bookMap.entrySet()) {
            assetBookList.add((DynamicObject)entry.getValue());
        }
        return assetBookList;
    }

    public static String checkOrgBookCurPeriodEqual(Long orgId) {
        DynamicObjectCollection allBook = FaBizUtils.getAllBookByOrg(orgId);
        if (allBook == null || allBook.isEmpty()) {
            return ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u627e\u4e0d\u5230\u8d44\u4ea7\u8d26\u7c3f\uff0c\u8bf7\u68c0\u67e5\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaBizUtils_4", (String)"fi-fa-business", (Object[])new Object[0]);
        }
        if (allBook.size() == 1) {
            return null;
        }
        Set curPeriodIds = allBook.stream().map(v -> v.getLong("curperiod")).collect(Collectors.toSet());
        if (curPeriodIds.size() == 1) {
            return null;
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u591a\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e0d\u4e00\u81f4\u3002", (String)"FaBizUtils_5", (String)"fi-fa-business", (Object[])new Object[0]);
    }

    public static Boolean checkChangeStatus(Object befValue, Object aftValue) {
        Boolean result = true;
        if (befValue instanceof Integer || befValue instanceof Long) {
            Long bef = Long.parseLong(befValue.toString());
            Long aft = Long.parseLong(aftValue.toString());
            if (aft.equals(0L) || bef.equals(aft)) {
                result = false;
            }
        } else if (befValue instanceof BigDecimal && aftValue instanceof BigDecimal) {
            BigDecimal aft;
            BigDecimal bef = new BigDecimal(befValue.toString());
            if (bef.compareTo(aft = new BigDecimal(aftValue.toString())) == 0) {
                result = false;
            }
        } else {
            String aft;
            String bef = befValue.toString();
            String string = aft = aftValue != null ? aftValue.toString() : null;
            if (aft == null) {
                result = false;
            } else if (bef.equals(aft) || aft.isEmpty()) {
                result = false;
            }
        }
        return result;
    }

    public static Boolean checkChangeStatus(Object befValue, Object aftValue, boolean changeNo) {
        Boolean result = true;
        if (befValue instanceof Integer || befValue instanceof Long) {
            Long bef = Long.parseLong(befValue.toString());
            Long aft = Long.parseLong(aftValue.toString());
            if (changeNo) {
                if (bef.equals(aft)) {
                    result = false;
                }
            } else if (aft.equals(0L) || bef.equals(aft)) {
                result = false;
            }
        } else if (befValue instanceof BigDecimal && aftValue instanceof BigDecimal) {
            BigDecimal aft;
            BigDecimal bef = new BigDecimal(befValue.toString());
            if (bef.compareTo(aft = new BigDecimal(aftValue.toString())) == 0) {
                result = false;
            }
        } else {
            String aft;
            String bef = befValue.toString();
            String string = aft = aftValue != null ? aftValue.toString() : null;
            if (changeNo) {
                if (bef.equals(aft)) {
                    result = false;
                }
            } else if (aft == null) {
                result = false;
            } else if (bef.equals(aft) || aft.isEmpty()) {
                result = false;
            }
        }
        return result;
    }

    public static boolean isNewCustomer() {
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select top 1 fid from t_fa_card_real;", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)"kd.fi.fa.business.utils.FaBizUtils.isNewCustomer", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);
        return !dataSet.hasNext();
    }

    public static Set<Long> filterHasCurPeriodBizFinIds(Map<Long, Set<Long>> periodId2RealMasterIdsMap, String entityName) {
        HashSet<Long> resultRealMasterIds = new HashSet<Long>(16);
        if (periodId2RealMasterIdsMap == null || periodId2RealMasterIdsMap.isEmpty()) {
            return resultRealMasterIds;
        }
        for (Map.Entry<Long, Set<Long>> entry : periodId2RealMasterIdsMap.entrySet()) {
            Long periodId = entry.getKey();
            Set<Long> realMasterIds = entry.getValue();
            if (!CollectionUtils.isNotEmpty(realMasterIds)) continue;
            SqlBuilder sqlBuilder = new SqlBuilder();
            switch (entityName) {
                case "fa_mergebill": {
                    sqlBuilder.append("select a.finrealcardid realmasterid from t_fa_merge_in a inner join t_fa_mergebill b on a.fid = b.fid where ", new Object[0]);
                    sqlBuilder.appendIn(" a.finrealcardid ", (Object[])realMasterIds.toArray(new Long[0]));
                    sqlBuilder.append(" and b.fmergeperiodid = ?;", new Object[]{periodId});
                    break;
                }
                case "fa_clearbill": {
                    sqlBuilder.append("select a.frealcardid realmasterid from t_fa_clrbillentry_d a inner join t_fa_clrbill b on a.fid = b.fid where ", new Object[0]);
                    sqlBuilder.appendIn(" a.frealcardid ", (Object[])realMasterIds.toArray(new Long[0]));
                    sqlBuilder.append(" and b.fclearperiodid = ? and a.fisclearall != '1';", new Object[]{periodId});
                    break;
                }
                default: {
                    logger.error("filterHasCurPeriodBizFinIds -> \u6682\u4e0d\u652f\u6301\u7684entityName[{}]", (Object)entityName);
                }
            }
            DataSet dataSet = DB.queryDataSet((String)"kd.fi.fa.business.utils.FaBizUtils.filterHasCurPeriodBizFinIds", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
            Throwable throwable = null;
            try {
                for (Row row : dataSet) {
                    resultRealMasterIds.add(row.getLong("realmasterid"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return resultRealMasterIds;
    }

    public static String getOpResErrorMsg(OperationResult result) {
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return StringUtils.getEmpty();
        }
        List allError = result.getAllErrorOrValidateInfo();
        StringBuilder sbMsg = new StringBuilder();
        for (IOperateInfo info : allError) {
            sbMsg.append(info.getMessage());
        }
        return sbMsg.toString();
    }
}

