/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.common.util.Fa;

public class FaBusyChgRecordUtil {
    private static Log log = LogFactory.getLog(FaBusyChgRecordUtil.class);
    private static String INSERT_SQL = "INSERT INTO t_fa_billparam (fid, forgid, fdepreuseid, fassetbookid, fparam, fvalue, fdescription, fenable, fcreatedate) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String BIZCLOUD_ID = "83bfebc8000002ac";
    private static final String BIZAPP_ID = "83bfebc800001aac";
    private static final Long PARAMTYPE_ID = 1703113502363011072L;

    public static void upgradeStartBusyRecordPeriod(DynamicObjectCollection paramBooks) {
        DynamicObjectCollection books = paramBooks;
        if (books == null) {
            String selectBookFields = Fa.comma((String[])new String[]{"org", "id", "depreuse"});
            books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectBookFields, null);
        }
        if (books == null || books.size() == 0) {
            return;
        }
        int booksLength = books == null ? 8 : books.size();
        ArrayList book2MaxBizPeriodList = new ArrayList(booksLength);
        for (DynamicObject book : books) {
            Long orgId = book.getLong("org");
            Long depreUseId = book.getLong("depreuse");
            Long bookId = book.getLong("id");
            Long maxBizPeriodId = FaBusyChgRecordUtil.getMaxBizPeriodId(orgId, depreUseId);
            if (maxBizPeriodId == null || maxBizPeriodId == 0L) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4, 1.0f);
            hashMap.put("orgId", orgId);
            hashMap.put("depreUseId", depreUseId);
            hashMap.put("maxBizPeriodId", maxBizPeriodId);
            hashMap.put("bookId", bookId);
            book2MaxBizPeriodList.add(hashMap);
        }
        QFilter[] billParamFilters = new QFilter[]{new QFilter("param", "=", (Object)"START_BUSY_RECORD_PERIOD")};
        DynamicObjectCollection billParams = QueryServiceHelper.query((String)"fa_billparam", (String)"assetbook", (QFilter[])billParamFilters);
        HashSet<Long> existedBooks = new HashSet<Long>(8);
        for (DynamicObject dy : billParams) {
            existedBooks.add(dy.getLong("assetbook"));
        }
        ArrayList<DynamicObject> billParamList = new ArrayList<DynamicObject>(book2MaxBizPeriodList.size());
        MainEntityType billParamType = EntityMetadataCache.getDataEntityType((String)"fa_billparam");
        for (Map map : book2MaxBizPeriodList) {
            Long bookId = (Long)map.get("bookId");
            if (existedBooks.contains(bookId)) continue;
            DynamicObject billParamDy = new DynamicObject((DynamicObjectType)billParamType);
            billParamDy.set("bizcloud", (Object)BIZCLOUD_ID);
            billParamDy.set("bizapp", (Object)BIZAPP_ID);
            billParamDy.set("paramtype", (Object)PARAMTYPE_ID);
            billParamDy.set("org", map.get("orgId"));
            billParamDy.set("depreuse", map.get("depreUseId"));
            billParamDy.set("assetbook", (Object)bookId);
            billParamDy.set("param", (Object)"START_BUSY_RECORD_PERIOD");
            billParamDy.set("value", map.get("maxBizPeriodId"));
            billParamDy.set("description", (Object)ResManager.loadKDString((String)"\u542f\u7528\u5361\u7247\u53d8\u52a8\u8bb0\u5f55\u5f00\u59cb\u671f\u95f4", (String)"FaBusyChgRecordUtil_0", (String)"fi-fa-business", (Object[])new Object[0]));
            billParamDy.set("enable", (Object)Boolean.TRUE);
            billParamList.add(billParamDy);
        }
        if (billParamList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])billParamList.toArray(new DynamicObject[1]));
        }
    }

    public static void upgradeStartBusyRecordPeriodByDB() {
        Object row22;
        ArrayList book2MaxBizPeriodList = new ArrayList(16);
        SqlBuilder assetQuerySql = new SqlBuilder();
        assetQuerySql.append("select fid,forgid,fdepreuse from t_fa_assetbook;", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"FaBusyChgRecordUtil.upgradeStartBusyRecordPeriodByDB", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)assetQuerySql);){
            for (Object row22 : ds) {
                Long orgId = row22.getLong("forgid");
                Long depreUseId = row22.getLong("fdepreuse");
                Long bookId = row22.getLong("fid");
                Long l = FaBusyChgRecordUtil.getMaxBizPeriodId(orgId, depreUseId);
                if (l == null || l == 0L) continue;
                HashMap<String, Object> book2MaxBizPeriodMap = new HashMap<String, Object>(4, 1.0f);
                book2MaxBizPeriodMap.put("orgId", orgId);
                book2MaxBizPeriodMap.put("depreUseId", depreUseId);
                book2MaxBizPeriodMap.put("maxBizPeriodId", l);
                book2MaxBizPeriodMap.put("bookId", bookId);
                book2MaxBizPeriodList.add(book2MaxBizPeriodMap);
            }
        }
        if (CollectionUtils.isEmpty(book2MaxBizPeriodList)) {
            log.info("upgradeStartBusyRecordPeriodByDB : \u8d26\u7c3f\u6700\u5927\u671f\u95f4\u6570\u636e\u4e3a\u7a7a\uff01\u4e0d\u5904\u7406\u5361\u7247\u53d8\u52a8\u8bb0\u5f55\u6570\u636e\uff01");
            return;
        }
        HashSet<Long> existedBooks = new HashSet<Long>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fassetbookid from t_fa_billparam where fparam = 'START_BUSY_RECORD_PERIOD';", new Object[0]);
        DataSet ds = DB.queryDataSet((String)"FaBusyChgRecordUtil.upgradeStartBusyRecordPeriodByDB", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
        row22 = null;
        try {
            for (Row row3 : ds) {
                existedBooks.add(row3.getLong("fassetbookid"));
            }
        }
        catch (Throwable orgId) {
            row22 = orgId;
            throw orgId;
        }
        finally {
            if (ds != null) {
                if (row22 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable orgId) {
                        ((Throwable)row22).addSuppressed(orgId);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ArrayList<Object[]> billParamList = new ArrayList<Object[]>(book2MaxBizPeriodList.size());
        String desc = ResManager.loadKDString((String)"\u542f\u7528\u5361\u7247\u53d8\u52a8\u8bb0\u5f55\u5f00\u59cb\u671f\u95f4", (String)"FaBusyChgRecordUtil_0", (String)"fi-fa-business", (Object[])new Object[0]);
        long[] fids = DB.genLongIds((String)"t_fa_billparam", (int)book2MaxBizPeriodList.size());
        int i = 0;
        for (Map map : book2MaxBizPeriodList) {
            Long bookId = (Long)map.get("bookId");
            if (existedBooks.contains(bookId)) continue;
            Object[] param = new Object[]{fids[i], map.get("orgId"), map.get("depreUseId"), bookId, "START_BUSY_RECORD_PERIOD", map.get("maxBizPeriodId"), desc, "1", new Date()};
            billParamList.add(param);
            ++i;
        }
        if (billParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)INSERT_SQL, billParamList);
        }
    }

    private static Long getMaxBizPeriodId(Long orgId, Long depreUseId) {
        SqlBuilder queryMaxBizPeriodSql = new SqlBuilder();
        queryMaxBizPeriodSql.append("SELECT max(fbizperiodid) maxBizPeriodId from t_fa_card_fin  where", new Object[0]);
        queryMaxBizPeriodSql.append("forg = ? ", new Object[]{orgId});
        queryMaxBizPeriodSql.append("and fdepreuseid = ? ", new Object[]{depreUseId});
        queryMaxBizPeriodSql.append("and fendperiodid = 99999999999 ", new Object[0]);
        try (DataSet dsMaxBizPeriod = DB.queryDataSet((String)"FaBusyChgRecordUtil#getMaxBizPeriodId", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryMaxBizPeriodSql);){
            if (dsMaxBizPeriod.hasNext()) {
                Long maxBizPeriodId;
                Row rowMaxBizPeriod = dsMaxBizPeriod.next();
                Long l = maxBizPeriodId = rowMaxBizPeriod.getLong("maxBizPeriodId");
                return l;
            }
        }
        return null;
    }
}

