/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaCardVersion2Utils {
    public static void upgradeFaCardVersion2() {
        QFilter[] formMetaFilters = new QFilter[]{new QFilter("bizappid", "=", (Object)"83bfebc800001aac"), new QFilter("number", "=", (Object)"fa_future_chg_fin_rel")};
        boolean existFaFutureChgFinRel = QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])formMetaFilters);
        if (!existFaFutureChgFinRel) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("isgenfin", "=", (Object)Character.valueOf('0'))};
        DynamicObjectCollection futureChgFinRelData = QueryServiceHelper.query((String)"fa_future_chg_fin_rel", (String)"changebillid", (QFilter[])filters);
        if (futureChgFinRelData == null || futureChgFinRelData.size() == 0) {
            return;
        }
        Set changeBillIds = futureChgFinRelData.stream().map(v -> v.getLong("changebillid")).collect(Collectors.toSet());
        HashSet<Long> excludeChangeBillIds = new HashSet<Long>(changeBillIds.size());
        SqlBuilder excludeChangeBillSql = new SqlBuilder();
        excludeChangeBillSql.append("SELECT fsrcbillid from t_fa_card_version2 where ", new Object[0]);
        excludeChangeBillSql.appendIn("fsrcbillid", changeBillIds.toArray());
        try (DataSet excludeChangeBillDs = DB.queryDataSet((String)"FaCardVersion2UpgradeService_excludeChangeBillSql", (DBRoute)new DBRoute("fa"), (SqlBuilder)excludeChangeBillSql);){
            for (Row excludeChg : excludeChangeBillDs) {
                excludeChangeBillIds.add(excludeChg.getLong("fsrcbillid"));
            }
        }
        changeBillIds.removeAll(excludeChangeBillIds);
        if (changeBillIds.size() == 0) {
            return;
        }
        QFilter[] changeBillFilters = new QFilter[]{new QFilter("id", "in", changeBillIds), new QFilter("billstatus", "=", (Object)BillStatus.C.name())};
        String selectChangeFields = Fa.comma((String[])new String[]{"id", "org", "changedate", "auditdate", Fa.dot((String[])new String[]{"realentry", "realcard"}), Fa.dot((String[])new String[]{"realentry", "aftrealcard"})});
        DynamicObjectCollection changeBillData = QueryServiceHelper.query((String)"fa_change_dept", (String)selectChangeFields, (QFilter[])changeBillFilters);
        if (changeBillData == null || changeBillData.size() == 0) {
            return;
        }
        HashSet<Long> befRealIds = new HashSet<Long>(changeBillData.size());
        for (DynamicObject changeBill : changeBillData) {
            befRealIds.add(changeBill.getLong(Fa.dot((String[])new String[]{"realentry", "realcard"})));
        }
        if (befRealIds.size() == 0) {
            return;
        }
        HashMap<Long, Long> realId2MasterIdMap = new HashMap<Long, Long>(befRealIds.size(), 1.0f);
        SqlBuilder queryMasterIdSql = new SqlBuilder();
        queryMasterIdSql.append("SELECT fid,fmasterid from t_fa_card_real where ", new Object[0]);
        queryMasterIdSql.appendIn("FID", befRealIds.toArray());
        try (DataSet dsMasterIds = DB.queryDataSet((String)"FaCardVersion2UpgradeService_queryMasterIdSql", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryMasterIdSql);){
            for (Row dsMasterId : dsMasterIds) {
                Long realId = dsMasterId.getLong("fid");
                Long masterid = dsMasterId.getLong("fmasterid");
                realId2MasterIdMap.put(realId, masterid);
            }
        }
        ArrayList<DynamicObject> faCardVerson2List = new ArrayList<DynamicObject>(changeBillData.size());
        MainEntityType cardVersion2BillType = EntityMetadataCache.getDataEntityType((String)"fa_card_version2");
        for (DynamicObject changeBill : changeBillData) {
            Long masterId;
            DynamicObject cardVersion2Dy = new DynamicObject((DynamicObjectType)cardVersion2BillType);
            cardVersion2Dy.set("org", (Object)changeBill.getLong("org"));
            Long befRealId = changeBill.getLong(Fa.dot((String[])new String[]{"realentry", "realcard"}));
            if (befRealId == null || befRealId == 0L || (masterId = (Long)realId2MasterIdMap.get(befRealId)) == null || masterId == 0L) continue;
            cardVersion2Dy.set("cardmasterid", (Object)masterId);
            cardVersion2Dy.set("accountdate", (Object)changeBill.getDate("changedate"));
            cardVersion2Dy.set("versiontime", (Object)changeBill.getDate("auditdate"));
            cardVersion2Dy.set("befrealcard", (Object)befRealId);
            Long aftRealId = changeBill.getLong(Fa.dot((String[])new String[]{"realentry", "aftrealcard"}));
            if (aftRealId == null || aftRealId == 0L) continue;
            cardVersion2Dy.set("aftrealcard", (Object)aftRealId);
            cardVersion2Dy.set("srcbillid", (Object)changeBill.getLong("id"));
            cardVersion2Dy.set("srcbillentityname", (Object)"fa_change_dept");
            faCardVerson2List.add(cardVersion2Dy);
        }
        if (faCardVerson2List.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])faCardVerson2List.toArray(new DynamicObject[1]));
        }
    }
}

