/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaCardVersionUtils {
    private static final String selectCardVersionFields = Fa.comma((String[])new String[]{"org", "cardmasterid", "accountdate", "versiontime", "befrealcard", "aftrealcard"});

    public static Map<Long, List<DynamicObject>> getCardVerisons2(Set<Long> masterIdSet) {
        HashMap<Long, List<DynamicObject>> masterId2DyMap = new HashMap<Long, List<DynamicObject>>(masterIdSet.size());
        if (masterIdSet.size() > 0) {
            QFilter[] filters = new QFilter[]{new QFilter("cardmasterid", "in", masterIdSet)};
            DynamicObjectCollection cardVersions2 = QueryServiceHelper.query((String)"fa_card_version2", (String)selectCardVersionFields, (QFilter[])filters, (String)"cardmasterid,versiontime desc");
            for (DynamicObject cardVersion2 : cardVersions2) {
                Long cardMasterId = cardVersion2.getLong("cardmasterid");
                ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)masterId2DyMap.get(cardMasterId);
                if (list == null || list.size() == 0) {
                    list = new ArrayList<DynamicObject>(16);
                    masterId2DyMap.put(cardMasterId, list);
                }
                list.add(cardVersion2);
            }
        }
        return masterId2DyMap;
    }

    public static DynamicObject getTargetCardVersion2(Long orgId, Long masterId, DynamicObject curPeriod, Map<Long, List<DynamicObject>> masterId2DyMap) {
        List<DynamicObject> cardVersionList = masterId2DyMap.get(masterId);
        if (cardVersionList != null && cardVersionList.size() > 0) {
            Date endDate = curPeriod.getDate("enddate");
            for (DynamicObject cardVersion : cardVersionList) {
                Date accountdate;
                Long orgIdTemp = cardVersion.getLong("org");
                if (orgId.longValue() != orgIdTemp.longValue() || (accountdate = cardVersion.getDate("accountdate")).after(endDate)) continue;
                return cardVersion;
            }
        }
        return null;
    }
}

