/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.change.ChangeTypeItem;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.enums.FutureChangeTypeEnum;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.exception.FaException;
import kd.fi.fa.common.util.Fa;

public class FaChangeBillUtil {
    private static final Log logger = LogFactory.getLog(FaChangeBillUtil.class);
    public static final DynamicObjectType REAL_TYPE = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
    public static final DynamicObjectType FIN_TYPE = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
    private static final String[] CAN_IS_ADJUSTDEPRE = new String[]{"preusingamount", "depremethod", "originalval", "preresidualval", "realaccountdate", "usestatus"};
    private static final Set<String> futureChangType = new HashSet<String>(3, 1.0f);

    public static Object parseValue(String field, String raw) {
        String[] split = field.split("\\.");
        String cardType = split[0];
        String propName = split[1];
        DynamicObjectType type = "fa_card_real".equalsIgnoreCase(cardType) ? REAL_TYPE : FIN_TYPE;
        return FaChangeBillUtil.parseValue(type, propName, raw);
    }

    public static Object parseValue(DynamicObjectType type, String propName, String raw) {
        DynamicProperty property = type.getProperty(propName);
        Class propertyType = property.getPropertyType();
        if (propertyType == Integer.class) {
            if (StringUtils.isEmpty((String)raw)) {
                return 0;
            }
            return Integer.valueOf(raw);
        }
        if (propertyType == Long.class || propertyType == DynamicObject.class) {
            if (StringUtils.isEmpty((String)raw)) {
                return propertyType == Long.class ? Long.valueOf(0L) : null;
            }
            return Long.valueOf(raw);
        }
        if (propertyType == BigDecimal.class) {
            if (StringUtils.isEmpty((String)raw)) {
                return null;
            }
            return new BigDecimal(raw);
        }
        if (propertyType == Date.class) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (StringUtils.isEmpty((String)raw)) {
                return null;
            }
            try {
                return sdf.parse(raw);
            }
            catch (ParseException e) {
                logger.error((Throwable)e);
                throw new FaException((Throwable)e);
            }
        }
        return raw;
    }

    public static Object getValueFromDy(DynamicObject dy, String propertyName) {
        Object valueStr = "";
        if (dy != null) {
            DataEntityPropertyCollection propertys = dy.getDataEntityType().getProperties();
            for (IDataEntityProperty property : propertys) {
                String name = property.getName();
                if (!name.equals(propertyName)) continue;
                if (property instanceof BasedataProp || property instanceof OrgProp || property instanceof UserProp || property instanceof AssistantProp) {
                    if (dy.getDynamicObject(name) != null) {
                        if (property instanceof BasedataProp) {
                            BasedataProp prop = (BasedataProp)property;
                            if ("fa_depremethod".equalsIgnoreCase(prop.getBaseEntityId())) {
                                valueStr = Long.parseLong(dy.getDynamicObject(name).getString("type"));
                                break;
                            }
                            valueStr = Long.parseLong(dy.getDynamicObject(name).getPkValue().toString());
                            break;
                        }
                        valueStr = Long.parseLong(dy.getDynamicObject(name).getPkValue().toString());
                        break;
                    }
                    valueStr = 0L;
                    break;
                }
                if (property instanceof BooleanProp) {
                    Boolean curValue = dy.getBoolean(name);
                    valueStr = curValue != false ? "1" : "0";
                    break;
                }
                if (property instanceof LongProp) {
                    valueStr = dy.getLong(propertyName);
                    break;
                }
                if (property instanceof IntegerProp) {
                    valueStr = dy.getInt(propertyName);
                    break;
                }
                if (property instanceof AmountProp || property instanceof DecimalProp) {
                    valueStr = dy.getBigDecimal(propertyName);
                    break;
                }
                if (property instanceof DateProp) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = dy.getDate(propertyName);
                    if (date == null) {
                        valueStr = "";
                        break;
                    }
                    valueStr = sdf.format(date);
                    break;
                }
                valueStr = dy.getString(propertyName);
                break;
            }
        }
        return valueStr;
    }

    public static Set<Object> getAllTypeIsWorkLoad() {
        QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)"5")};
        Map workLoadData = BusinessDataServiceHelper.loadFromCache((String)"fa_depremethod", (String)"id", (QFilter[])qFilters);
        return workLoadData.keySet();
    }

    public static Set<Object> getAllTypeIsDayDepre() {
        QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)"51")};
        Map dayDepreMethods = BusinessDataServiceHelper.loadFromCache((String)"fa_depremethod", (String)"id", (QFilter[])qFilters);
        return dayDepreMethods.keySet();
    }

    public static boolean canAdjustDepre(String changeItem) {
        boolean result = false;
        for (String canadjust : CAN_IS_ADJUSTDEPRE) {
            if (changeItem.indexOf(canadjust) <= -1) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean getIsAccdate(long masterid) {
        String sql = "select A.fid from t_fa_changefieldentry A left join T_FA_CHANGEBILL B on A.fid = B.fid left join T_FA_CARD_REAL C on A.frealcardid = C.fid  where B.fbillstatus = 'C' and A.ffield = 'fa_card_real.realaccountdate' and C.fmasterid = ?";
        DataSet dataSet = DB.queryDataSet((String)"kd.fi.fa.formplugin.FaChangeBillChangeTypeEditPlugin", (DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{masterid});
        return dataSet.hasNext();
    }

    public static List<Long> getAccdatedList(List<Long> sourceCardIdList) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(sourceCardIdList)) {
            return resultList;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select C.fmasterid from t_fa_changefieldentry A ", new Object[0]);
        sqlBuilder.append("left join T_FA_CHANGEBILL B on A.fid = B.fid ", new Object[0]);
        sqlBuilder.append("left join T_FA_CARD_REAL C on A.frealcardid = C.fid ", new Object[0]);
        sqlBuilder.append(" where B.fbillstatus = 'C' and A.ffield = 'fa_card_real.realaccountdate' and ", new Object[0]);
        sqlBuilder.appendIn("C.fmasterid", sourceCardIdList.toArray());
        try {
            DataSet dataSet = DB.queryDataSet((String)"kd.fi.fa.formplugin.FaChangeBillChangeTypeEditPlugin", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
            while (dataSet.hasNext()) {
                resultList.add(dataSet.next().getLong("fmasterid"));
            }
        }
        catch (Exception e) {
            logger.error("sql error is : ", (Throwable)e);
        }
        return resultList;
    }

    public static Map<Long, List<Long>> getDynamicMapList(List<Long> sourceCardIdList) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>();
        QFilter qMasterId = new QFilter("realcard", "in", sourceCardIdList);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fa_card_dynamic", (String)"realcard".concat(",").concat("depreuse"), (QFilter[])new QFilter[]{qMasterId});
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return resultMap;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long cardId = dynamicObject.getLong("realcard");
            Long depreuseId = dynamicObject.getLong("depreuse");
            List valueList = resultMap.containsKey(cardId) ? (List)resultMap.get(cardId) : new LinkedList();
            valueList.add(depreuseId);
            resultMap.put(cardId, valueList);
        }
        return resultMap;
    }

    public static BusyTypeDetailEnum getChangeTypeDetail4F7(DynamicObject changetype, Map<Long, String> changeItemID2TopMap) {
        if (changetype == null) {
            return BusyTypeDetailEnum.REAL_FIN_CHG;
        }
        DynamicObjectCollection changeTypeEntry = changetype.getDynamicObjectCollection("changetypeentry");
        HashSet<String> topicSet = new HashSet<String>(8);
        for (DynamicObject changeItemEntry : changeTypeEntry) {
            DynamicObject changeItem = changeItemEntry.getDynamicObject("changeitem");
            String topic = changeItemID2TopMap.get(changeItem.getLong("id"));
            topicSet.add(topic);
        }
        if (topicSet.contains("fa_card_real") && topicSet.size() == 1) {
            return BusyTypeDetailEnum.REAL_CHG;
        }
        if (topicSet.contains("fa_card_fin") && topicSet.size() == 1) {
            return BusyTypeDetailEnum.FIN_CHG;
        }
        return BusyTypeDetailEnum.REAL_FIN_CHG;
    }

    public static BusyTypeDetailEnum getChangeTypeDetail(DynamicObjectCollection fieldList) {
        if (fieldList == null) {
            return BusyTypeDetailEnum.REAL_FIN_CHG;
        }
        boolean isReal = false;
        boolean isFin = false;
        for (DynamicObject fieldDy : fieldList) {
            String field = fieldDy.getString("field");
            if (!isReal && field.startsWith("fa_card_real.")) {
                isReal = true;
            }
            if (!isFin && field.startsWith("fa_card_fin.")) {
                isFin = true;
            }
            if (!isReal || !isFin) continue;
            return BusyTypeDetailEnum.REAL_FIN_CHG;
        }
        if (isReal) {
            return BusyTypeDetailEnum.REAL_CHG;
        }
        if (isFin) {
            return BusyTypeDetailEnum.FIN_CHG;
        }
        return BusyTypeDetailEnum.REAL_FIN_CHG;
    }

    public static boolean checkChangeItemIn(DynamicObjectCollection fieldList, Set<String> changeItemSet) {
        if (fieldList == null || changeItemSet == null) {
            return false;
        }
        for (DynamicObject fieldDy : fieldList) {
            String field = fieldDy.getString("field");
            String[] fieldArr = field.trim().split("\\.");
            if (!fieldArr[0].equals("fa_card_real") || !changeItemSet.contains(fieldArr[1])) continue;
            return true;
        }
        return false;
    }

    public static Map<Long, String> getChangeItemMap() {
        HashMap<Long, String> changeItemID2TopMap = new HashMap(50);
        DynamicObjectCollection changeItemLit = QueryServiceHelper.query((String)"fa_change_item", (String)"id,topic", null);
        changeItemID2TopMap = changeItemLit.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getString("topic")));
        return changeItemID2TopMap;
    }

    public static Set<String> getGenVoucherChangeBillNo(Long orgId, Date curPeriodEndDate, Set<Long> realIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("changedate", ">", (Object)curPeriodEndDate), new QFilter("chtypedetail", "=", (Object)BusyTypeDetailEnum.REAL_CHG.getValue()), new QFilter(Fa.dot((String[])new String[]{"fieldentry", "realcard1"}), "in", realIds)};
        DynamicObjectCollection changeBills = QueryServiceHelper.query((String)"fa_change_dept", (String)Fa.comma((String[])new String[]{"id", "billno"}), (QFilter[])filters);
        if (changeBills == null || changeBills.size() == 0) {
            return null;
        }
        HashMap<String, String> id2BillNoMap = new HashMap<String, String>(changeBills.size(), 1.0f);
        ArrayList<String> ids = new ArrayList<String>(changeBills.size());
        for (DynamicObject changeBill : changeBills) {
            if (id2BillNoMap.get(changeBill.getString("id")) != null) continue;
            id2BillNoMap.put(changeBill.getString("id"), changeBill.getString("billno"));
            ids.add(changeBill.getString("id"));
        }
        Set<Long> existedSet = FaDepreUtil.getIds4HaveVouncher(ids, "fa_change_dept");
        if (existedSet == null || existedSet.size() == 0) {
            return null;
        }
        HashSet<String> existedBillNoSet = new HashSet<String>(existedSet.size());
        for (Long id : existedSet) {
            existedBillNoSet.add((String)id2BillNoMap.get(id.toString()));
        }
        return existedBillNoSet;
    }

    private static Set<String> getNumber4haveFutureRealChangeBill(Long orgId, Date curPeriodEndDate, Map<Long, String> realId2numberMap) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("changedate", ">", (Object)curPeriodEndDate), new QFilter("chtypedetail", "=", (Object)BusyTypeDetailEnum.REAL_CHG.getValue()), new QFilter(Fa.dot((String[])new String[]{"fieldentry", "realcard1"}), "in", realId2numberMap.keySet())};
        DynamicObjectCollection changeBills = QueryServiceHelper.query((String)"fa_change_dept", (String)Fa.comma((String[])new String[]{"id", Fa.dot((String[])new String[]{"fieldentry", "realcard1"})}), (QFilter[])filters);
        if (changeBills == null || changeBills.size() == 0) {
            return null;
        }
        HashSet<String> realNumbers = new HashSet<String>(changeBills.size());
        for (DynamicObject changeBill : changeBills) {
            Long realId = changeBill.getLong(Fa.dot((String[])new String[]{"fieldentry", "realcard1"}));
            realNumbers.add(realId2numberMap.get(realId));
        }
        return realNumbers;
    }

    public static Set<String> checkhaveFutureRealChangeBill(Long orgId, Date curPeriodEndDate, Map<Long, String> realId2numberMap) {
        Set<String> billNumbers;
        String futureChangeSystemParameter = SystemParamHelper.getStringParam("futurechangesystemparameter", orgId, "1");
        boolean isNeedFuture = false;
        if (futureChangeSystemParameter.equals(FutureChangeTypeEnum.ONE.getValue())) {
            String billParamV = FaBillParamUtils.queryOne(null, null, null, "FUTURE_CHANG_TYPE", FutureChangeTypeEnum.ONE.getValue());
            if (!futureChangType.contains(billParamV)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u53c2\u6570\u4e3a1\u30012\u30013\u4ee5\u5916\u7684\u503c", (String)"FaChangeBillUtil_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (!billParamV.equals(FutureChangeTypeEnum.THREE.getValue()) || FaBillParamUtils.queryOne(orgId, 0L, "", "FUTURE_CHANG_ORGIDS") == null) {
                isNeedFuture = true;
            }
        } else if (!futureChangeSystemParameter.equals(FutureChangeTypeEnum.THREE.getValue())) {
            isNeedFuture = true;
        }
        if (isNeedFuture && (billNumbers = FaChangeBillUtil.getNumber4haveFutureRealChangeBill(orgId, curPeriodEndDate, realId2numberMap)) != null && billNumbers.size() > 0) {
            return billNumbers;
        }
        return null;
    }

    public static Map<String, DynamicObject> getFinCardByRealAndBook(Collection<Long> realCardIds, Map<Object, DynamicObject> realCardsMap, Collection<DynamicObject> allAssetBooks, Set<String> fieldSet) {
        List<DynamicObject> finCardLst = FaUtils.queryFinCardList4BookCurPeriod(realCardIds, fieldSet, allAssetBooks);
        HashMap<String, DynamicObject> finCardMap = new HashMap<String, DynamicObject>(finCardLst.size());
        FaChangeBillUtil.genRealDep2FinMap(finCardLst.toArray(new DynamicObject[0]), finCardMap);
        Set<String> finCardMapKeys = finCardMap.keySet();
        for (DynamicObject book : allAssetBooks) {
            Map<String, Long> number2RealIdMap = FaChangeBillUtil.getNumber2RealMap(realCardIds, realCardsMap, finCardMapKeys, book);
            if (number2RealIdMap.size() == 0) continue;
            HashSet<String> fieldSet2 = new HashSet<String>(FaUtils.getFinCommonQueryField());
            if (fieldSet != null) {
                fieldSet2.addAll(fieldSet);
            }
            String selector = String.join((CharSequence)",", fieldSet2);
            SqlBuilder queryNewFinIdSql = new SqlBuilder();
            queryNewFinIdSql.append("SELECT fid ", new Object[0]);
            queryNewFinIdSql.append("FROM t_fa_card_fin WHERE ", new Object[0]);
            queryNewFinIdSql.appendIn("fnumber", number2RealIdMap.keySet().toArray());
            queryNewFinIdSql.append("and fdepreuseid = ?", new Object[]{book.getLong(Fa.id((String)"depreuse"))});
            queryNewFinIdSql.append("and forg = ?", new Object[]{book.getLong(Fa.id((String)"org"))});
            queryNewFinIdSql.append("and fendperiodid = ?", new Object[]{99999999999L});
            ArrayList<Long> newFinIds = new ArrayList<Long>(number2RealIdMap.size());
            try (DataSet dsFins = DB.queryDataSet((String)"getFinCardByRealAndBook", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryNewFinIdSql);){
                for (Row fin : dsFins) {
                    Long finId = fin.getLong("fid");
                    newFinIds.add(finId);
                }
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", newFinIds)};
            DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters, null);
            FaChangeBillUtil.genRealDep2FinMap(finCards, finCardMap);
        }
        return finCardMap;
    }

    private static void genRealDep2FinMap(DynamicObject[] finCardLst, Map<String, DynamicObject> finCardMap) {
        for (DynamicObject finCard : finCardLst) {
            Long realCardMasterId = finCard.getLong("realcardmasterid");
            Long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
            String keyStr = String.format("%s_%s", realCardMasterId, depreUseId);
            finCardMap.put(keyStr, finCard);
        }
    }

    private static Map<String, Long> getNumber2RealMap(Collection<Long> realCardIds, Map<Object, DynamicObject> realCardsMap, Set<String> finCardMapKeys, DynamicObject book) {
        HashMap<String, Long> number2RealIdMap = new HashMap<String, Long>(realCardIds.size());
        for (Long realCardId : realCardIds) {
            DynamicObject realDy = realCardsMap.get(realCardId);
            if (finCardMapKeys.contains(realDy.getString("number") + "_" + book.getLong(Fa.id((String)"depreuse")))) continue;
            number2RealIdMap.put(realDy.getString("number"), realCardId);
        }
        return number2RealIdMap;
    }

    public static Map<String, List<ChangeTypeItem>> getAllChangeTypeItems(Collection<DynamicObject> changeItems) {
        ArrayList<ChangeTypeItem> mainChangeItems = new ArrayList<ChangeTypeItem>(changeItems.size());
        ArrayList<ChangeTypeItem> otherChangeItems = new ArrayList<ChangeTypeItem>(changeItems.size());
        String mainPrefix = "m";
        String otherPrefix = "o";
        String prefixKeyBefore = "bef";
        String prefixKeyAfter = "aft";
        for (DynamicObject changeItem : changeItems) {
            String number = changeItem.getString("number");
            ArrayList<String> mainFields = new ArrayList<String>(2);
            String before = String.format("%s_%s_%s", mainPrefix, prefixKeyBefore, number);
            String after = String.format("%s_%s_%s", mainPrefix, prefixKeyAfter, number);
            mainFields.add(before);
            mainFields.add(after);
            ArrayList<String> otherFields = new ArrayList<String>(2);
            before = String.format("%s_%s_%s", otherPrefix, prefixKeyBefore, number);
            after = String.format("%s_%s_%s", otherPrefix, prefixKeyAfter, number);
            otherFields.add(before);
            otherFields.add(after);
            ChangeTypeItem mainItem = FaChangeBillUtil.convert2ChangeTypeItem(changeItem, mainFields);
            ChangeTypeItem otherItem = FaChangeBillUtil.convert2ChangeTypeItem(changeItem, otherFields);
            mainChangeItems.add(mainItem);
            otherChangeItems.add(otherItem);
        }
        HashMap<String, List<ChangeTypeItem>> changeEntry2ChangeItems = new HashMap<String, List<ChangeTypeItem>>(2);
        changeEntry2ChangeItems.put("main_changebillentry", mainChangeItems);
        changeEntry2ChangeItems.put("other_changebillentry", otherChangeItems);
        return changeEntry2ChangeItems;
    }

    private static ChangeTypeItem convert2ChangeTypeItem(DynamicObject baseItemDy, List<String> mainFields) {
        ChangeTypeItem changeItem = new ChangeTypeItem();
        changeItem.setItemKey(baseItemDy.getString("number"));
        changeItem.setItemName(baseItemDy.getString("name"));
        changeItem.setMapFields(mainFields);
        changeItem.setFormMeta(baseItemDy.getString("topic"));
        return changeItem;
    }

    public static List<String> hasMustField() {
        MainEntityType realCardType = MetadataServiceHelper.getDataEntityType((String)"fa_card_real");
        MainEntityType finCardType = MetadataServiceHelper.getDataEntityType((String)"fa_card_fin");
        ArrayList realCardProps = new ArrayList(realCardType.getAllFields().values());
        ArrayList finCardProps = new ArrayList(finCardType.getAllFields().values());
        realCardProps.addAll(finCardProps);
        ArrayList<String> mustInputCardFields = new ArrayList<String>(realCardProps.size());
        for (IDataEntityProperty cardProp : realCardProps) {
            String field = cardProp.getName();
            if (cardProp instanceof FieldProp) {
                if (((FieldProp)cardProp).isMustInput()) {
                    mustInputCardFields.add(field);
                }
            } else if (cardProp instanceof BasedataProp) {
                if (((BasedataProp)cardProp).isMustInput()) {
                    mustInputCardFields.add(field);
                }
            } else if (cardProp instanceof MulBasedataProp && ((MulBasedataProp)cardProp).isMustInput()) {
                mustInputCardFields.add(field);
            }
            if (!"originalval".equals(field) && !"preresidualval".equals(field)) continue;
            mustInputCardFields.add(field);
        }
        return mustInputCardFields;
    }

    public static Boolean checkEmptyField(Object fieldValue) {
        boolean isEmpty = false;
        if (fieldValue instanceof OrmLocaleValue) {
            String langName = RequestContext.get().getLang().name();
            if (((OrmLocaleValue)fieldValue).containsKey((Object)langName) && StringUtils.isEmpty((String)((OrmLocaleValue)fieldValue).get((Object)langName))) {
                isEmpty = true;
            }
        } else {
            isEmpty = ObjectUtils.isEmpty((Object)fieldValue);
        }
        return isEmpty;
    }

    public static void setEntryCellStyleChange(boolean changeNo, boolean open, IDataModel model, EntryGrid entryGrid, String changeItemStr, String entryName, String prefix, List<DynamicObject> entryEntity, String property) {
        DynamicObjectCollection changeItemTypes = (DynamicObjectCollection)model.getValue(changeItemStr);
        if (entryEntity == null) {
            entryEntity = new ArrayList<DynamicObject>((Collection<DynamicObject>)model.getEntryEntity(entryName));
        }
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(entryEntity.size());
        for (DynamicObject dy : entryEntity) {
            int index = dy.getInt("seq") - 1;
            for (DynamicObject changeItemType : changeItemTypes) {
                CellStyle aftCellStyle;
                Object afterValue;
                DynamicObject changeItem = changeItemType.getDynamicObject("fbasedataid");
                if (changeItem == null) continue;
                String number = changeItem.getString("number");
                String fieldKey = "";
                if (changeItem.containsProperty("changeapplykey")) {
                    fieldKey = changeItem.getString("changeapplykey");
                }
                String befProperty = prefix + "bef_" + number;
                String aftProperty = prefix + "aft_" + number;
                if (fieldKey != null && !fieldKey.isEmpty() && !fieldKey.equals(" ")) {
                    befProperty = prefix + "bef_" + fieldKey;
                    aftProperty = prefix + "aft_" + fieldKey;
                }
                if (property != null && !aftProperty.equals(property)) continue;
                Object beforeValue = FaUtils.getValueFromDy(dy, befProperty);
                Boolean changeStatus = FaBizUtils.checkChangeStatus(beforeValue, afterValue = FaUtils.getValueFromDy(dy, aftProperty), changeNo);
                if (changeStatus.booleanValue()) {
                    aftCellStyle = new CellStyle();
                    aftCellStyle.setFieldKey(aftProperty);
                    aftCellStyle.setRow(index);
                    aftCellStyle.setBackColor("#DEE5F7");
                    cellStyles.add(aftCellStyle);
                    continue;
                }
                if (open) continue;
                aftCellStyle = new CellStyle();
                aftCellStyle.setFieldKey(aftProperty);
                aftCellStyle.setRow(index);
                aftCellStyle.setBackColor("#ffffff");
                cellStyles.add(aftCellStyle);
            }
        }
        if (!cellStyles.isEmpty()) {
            entryGrid.setCellStyle(cellStyles);
        }
    }

    public static void setEntryCellStyleChange(boolean changeNo, boolean open, IDataModel model, EntryGrid entryGrid, String changeItemStr, String entryName, String prefix) {
        DynamicObjectCollection changeItemTypes = (DynamicObjectCollection)model.getValue(changeItemStr);
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryName);
        int index = 0;
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(entryEntity.size());
        for (DynamicObject dy : entryEntity) {
            for (DynamicObject changeItemType : changeItemTypes) {
                CellStyle aftCellStyle;
                Object afterValue;
                Object beforeValue;
                Boolean changeStatus;
                DynamicObject changeItem = changeItemType.getDynamicObject("fbasedataid");
                if (changeItem == null) continue;
                String number = changeItem.getString("number");
                String fieldKey = "";
                if (changeItem.containsProperty("changeapplykey")) {
                    fieldKey = changeItem.getString("changeapplykey");
                }
                String befProperty = prefix + "bef_" + number;
                String aftProperty = prefix + "aft_" + number;
                if (fieldKey != null && !fieldKey.isEmpty() && !fieldKey.equals(" ")) {
                    befProperty = prefix + "bef_" + fieldKey;
                    aftProperty = prefix + "aft_" + fieldKey;
                }
                if ((changeStatus = FaBizUtils.checkChangeStatus(beforeValue = FaUtils.getValueFromDy(dy, befProperty), afterValue = FaUtils.getValueFromDy(dy, aftProperty), changeNo)).booleanValue()) {
                    aftCellStyle = new CellStyle();
                    aftCellStyle.setFieldKey(aftProperty);
                    aftCellStyle.setRow(index);
                    aftCellStyle.setBackColor("#DEE5F7");
                    cellStyles.add(aftCellStyle);
                    continue;
                }
                if (open) continue;
                aftCellStyle = new CellStyle();
                aftCellStyle.setFieldKey(aftProperty);
                aftCellStyle.setRow(index);
                aftCellStyle.setBackColor("#ffffff");
                cellStyles.add(aftCellStyle);
            }
            ++index;
        }
        if (!cellStyles.isEmpty()) {
            entryGrid.setCellStyle(cellStyles);
        }
    }

    public static boolean checkChangeStatus(DynamicObject dy, boolean changeNo) {
        Object befValue = dy.getString("beforevalue");
        Object aftValue = dy.getString("aftervalue");
        String mateFiledStr = dy.getString("field");
        String[] mateArr = mateFiledStr.split("\\.");
        String propertyName = mateArr[1];
        MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)mateArr[0]);
        DynamicProperty property = dyType.getProperty(propertyName);
        if (property instanceof BasedataProp || property instanceof OrgProp || property instanceof UserProp || property instanceof LongProp || property instanceof IntegerProp) {
            befValue = dy.getLong("beforevalue");
            aftValue = dy.getLong("aftervalue");
        } else if (property instanceof BooleanProp) {
            befValue = dy.getString("beforevalue");
            aftValue = dy.getString("aftervalue");
        } else if (property instanceof AmountProp || property instanceof DecimalProp) {
            befValue = dy.getBigDecimal("beforevalue");
            aftValue = StringUtils.isEmpty((String)dy.getString("aftervalue")) ? null : dy.getBigDecimal("aftervalue");
        }
        return FaBizUtils.checkChangeStatus(befValue, aftValue, changeNo);
    }

    static {
        futureChangType.add(FutureChangeTypeEnum.ONE.getValue());
        futureChangType.add(FutureChangeTypeEnum.TWO.getValue());
        futureChangType.add(FutureChangeTypeEnum.THREE.getValue());
    }
}

