/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FaCheckBaseDataRef {
    private static Log logger = LogFactory.getLog(FaCheckBaseDataRef.class);

    public static Map<String, String> checkRef(String baseDataNumber, OperateOption option, Map<Object, String> idToNumber) throws Exception {
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"checkRef");){
            BasedataEntityType mainType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseDataNumber);
            BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
            FaCheckBaseDataRef.addIgnoreRefEntityIds(checker, option);
            Map checkResult = checker.checkRef(mainType, idToNumber.keySet().toArray());
            HashMap<String, String> msgMap = new HashMap<String, String>(checkResult.size());
            for (Map.Entry entry : checkResult.entrySet()) {
                if (!idToNumber.containsKey(entry.getKey())) continue;
                BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
                if (!((BaseDataCheckRefrenceResult)entry.getValue()).isRefence()) continue;
                String msg = FaCheckBaseDataRef.buildRefMessage(refrenceResult);
                msgMap.put(idToNumber.get(entry.getKey()), msg);
            }
            HashMap<String, String> hashMap = msgMap;
            return hashMap;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                logger.info("FaCheckBaseDataRef.checkRef:" + e.getMessage());
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void addIgnoreRefEntityIds(BaseDataCheckRefrence checker, OperateOption option) {
        String[] entityIds;
        RefObject opValue = new RefObject();
        if (option.tryGetVariableValue("ignorerefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getIgnoreRefEntityIds().add(entityId);
            }
        }
        if (option.tryGetVariableValue("checkrefentityids", opValue = new RefObject()) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getCheckRefEntityIds().add(entityId);
            }
        }
    }

    private static String buildRefMessage(BaseDataCheckRefrenceResult refrenceResult) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
        String billName = refMainType.getDisplayName().toString();
        String tableName = refrenceResult.getRefenceKey().getRefTable();
        String fieldName = refrenceResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (FaCheckBaseDataRef.equalsFieldname(property, tableName, fieldName)) {
                fieldName = property.getDisplayName().toString();
                break;
            }
            if (!FaCheckBaseDataRef.equalsMulBasedataFieldname(property, tableName, fieldName)) continue;
            fieldName = property.getDisplayName().toString();
            break;
        }
        return String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"FaCheckBaseDataRef_0", (String)"fi-fa-business", (Object[])new Object[0]), billName, fieldName);
    }

    private static boolean equalsFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof IFieldHandle) || property.getParent() == null || property.getParent().getAlias() == null) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)fieldName)) {
            return false;
        }
        String propTableName = property.getParent().getAlias();
        if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
            propTableName = propTableName + "_" + property.getTableGroup();
        }
        return StringUtils.equalsIgnoreCase((CharSequence)propTableName, (CharSequence)tableName);
    }

    private static boolean equalsMulBasedataFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof MulBasedataProp)) {
            return false;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
        if (mulBasedataProp.getItemType() == null || mulBasedataProp.getItemType().getAlias() == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"fbasedataid") && StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)mulBasedataProp.getItemType().getAlias());
    }
}

