/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class FaDataSetUtils {
    public static final String TAB = "\t";

    public static void printDataSet(Map container, String desc, DataSet dataSet) {
        List<Map<String, String>> details = FaDataSetUtils.dataSetToList(dataSet);
        container.put(desc, details);
    }

    public static List<Map<String, String>> dataSetToList(DataSet dataSet) {
        DataSet dataSetCopy = dataSet.copy();
        return FaDataSetUtils._dataSetToList(dataSetCopy);
    }

    private static List<Map<String, String>> _dataSetToList(DataSet dataSetCopy) {
        RowMeta rowType = dataSetCopy.getRowMeta();
        ArrayList<Map<String, String>> details = new ArrayList<Map<String, String>>();
        for (Row row : dataSetCopy) {
            TreeMap<String, String> m = new TreeMap<String, String>();
            for (Field field : rowType.getFields()) {
                Object value = row.get(field.getAlias());
                m.put(FaDataSetUtils.descField(field), value != null ? value.toString() : "null");
            }
            details.add(m);
        }
        return details;
    }

    public static String descField(Field field) {
        String name = field.getAlias();
        if (name == null) {
            name = field.getName();
        }
        return name;
    }

    public static Set<String> getFieldsByDataSet(DataSet dataSet) {
        Field[] fields;
        LinkedHashSet<String> selFields = new LinkedHashSet<String>(12);
        if (dataSet == null) {
            return selFields;
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        for (Field field : fields = rowMeta.getFields()) {
            selFields.add(field.getAlias().toLowerCase());
        }
        return selFields;
    }
}

