/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreSegment;
import kd.fi.fa.business.utils.ChangeBillUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;

public class FaDepreUtil {
    public static final String ALGOKEY = "kd.fi.fa.business.utils.FaDepreUtil";
    public static final String SHORTCUT_DEPRE_LOG = "shift+m";
    public static final String SHORTCUT_DEPRE_PARAM = "shift+p";
    public static final String SHORTCUT_DEPRE_PARAM_EVENT_ARGS = "[16,80]";
    public static final String SHORTCUT_DEPRE_LOG_EVENT_ARGS = "[16,77]";
    public static final String changDeptFields = "changeDate, auditdate, billno,";
    public static final String selectFields = "changeDate, billno,fieldentry.realcard1 realCard,fieldentry.field field,fieldentry.realcard1.realaccountdate realaccountdate,fieldentry.bizdate1 bizDate,fieldentry.isadjustdepre1 isadjustdepre";

    public static Set<String> getDimField() {
        HashSet<String> fieldList = new HashSet<String>();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        EntityType depreSplitSum = (EntityType)EntityMetadataCache.getDataEntityType((String)"fa_depre_sum").getAllEntities().get("depresplitsum");
        if (depreSplitSum != null) {
            Map tt = depreSplitSum.getFields();
            for (Map.Entry entryI : tt.entrySet()) {
                if ("totalsplitdept".equals(entryI.getKey()) || "totalsplitamount".equals(entryI.getKey()) || met.getProperty((String)entryI.getKey()) == null) continue;
                fieldList.add((String)entryI.getKey());
            }
        }
        return fieldList;
    }

    public static Map<String, String> getDimFieldMap() {
        HashMap<String, String> fieldListMap = new HashMap<String, String>();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        EntityType depreSplitSum = (EntityType)EntityMetadataCache.getDataEntityType((String)"fa_depre_sum").getAllEntities().get("depresplitsum");
        if (depreSplitSum != null) {
            Map tt = depreSplitSum.getFields();
            for (Map.Entry entry : tt.entrySet()) {
                String key = (String)entry.getKey();
                if ("totalsplitdept".equals(key) || "totalsplitamount".equals(key) || met.getProperty(key) == null) continue;
                Object prop = entry.getValue();
                if (prop instanceof BasedataProp) {
                    fieldListMap.put(key, key + "_id");
                    continue;
                }
                fieldListMap.put(key, key);
            }
        }
        return fieldListMap;
    }

    public static boolean hasVoucher(Long orgId, Long depreuseId, Long periodId, boolean include) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        filterList.add(new QFilter("org", "=", (Object)orgId));
        if (depreuseId != null) {
            filterList.add(new QFilter("depreuse", "=", (Object)depreuseId));
        }
        filterList.add(new QFilter("period", include ? ">=" : ">", (Object)periodId));
        List fids = QueryServiceHelper.queryPrimaryKeys((String)"fa_depre_sum", (String)"fa_depre_sum", (QFilter[])filterList.toArray(new QFilter[1]), null, (int)-1);
        return FaDepreUtil.hashVouncherV2(fids, "fa_depre_sum");
    }

    @Deprecated
    public static boolean hashVouncher(Set<Object> fids) {
        return FaDepreUtil.hashVouncher(fids.stream().map(v -> v.toString()).collect(Collectors.toList()));
    }

    @Deprecated
    public static boolean hashVouncher(List<String> fids) {
        if (CollectionUtils.isEmpty(fids)) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" select ai.FSOURCEBILLID as id ");
        sb.append(" from t_ai_daptracker ai ");
        sb.append(" where ai.FSOURCEBILLID in (");
        for (String fid : fids) {
            sb.append(fid);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        int rows = 0;
        try (DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)"fa"), (String)sb.toString(), null);){
            rows = ds.count("id", false);
        }
        return rows > 0;
    }

    public static Set<Long> getVoucherIds(Long orgId, Long depreuseId, Long periodId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        filterList.add(new QFilter("org", "=", (Object)orgId));
        filterList.add(new QFilter("depreuse", "=", (Object)depreuseId));
        if (periodId != null) {
            filterList.add(new QFilter("period", "=", (Object)periodId));
        }
        List fids = QueryServiceHelper.queryPrimaryKeys((String)"fa_depre_sum", (String)"fa_depre_sum", (QFilter[])filterList.toArray(new QFilter[1]), null, (int)-1);
        return FaDepreUtil.getIds4HaveVouncher(fids.stream().map(v -> v.toString()).collect(Collectors.toList()), "fa_depre_sum");
    }

    public static Set<Long> getIds4HaveVouncher(List<String> fids, String billType) {
        HashSet<Long> existedVouncherIds = new HashSet<Long>(fids.size());
        if (CollectionUtils.isEmpty(fids)) {
            return existedVouncherIds;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" select ai.FSOURCEBILLID as id ");
        sb.append(" from t_ai_daptracker ai ");
        sb.append(" where ai.FSOURCEBILLID in (");
        for (String fid : fids) {
            sb.append(fid);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        sb.append(" and ai.fbilltype = ?");
        Object[] params = new Object[]{billType};
        try (DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)"fa"), (String)sb.toString(), (Object[])params);){
            for (Row row : ds) {
                Long sourceBillId = row.getLong("id");
                existedVouncherIds.add(sourceBillId);
            }
        }
        return existedVouncherIds;
    }

    public static boolean hashVouncherV2(List<Object> fids, String entityName) {
        if (CollectionUtils.isEmpty(fids)) {
            return false;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select top 1,0 ai.FSOURCEBILLID as id ", new Object[0]);
        sqlBuilder.append(" from t_ai_daptracker ai ", new Object[0]);
        sqlBuilder.append(" where ai.FBILLTYPE = ? and ", new Object[]{entityName});
        sqlBuilder.appendIn(" ai.FSOURCEBILLID", fids);
        try (DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                Long id = row.getLong("id");
                if (id == null) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static Set<Long> hasVoucher(List<Object> fids, String entityName) {
        HashSet<Long> hasVoucherBillIds = new HashSet<Long>(fids.size());
        if (CollectionUtils.isEmpty(fids)) {
            return hasVoucherBillIds;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select ai.FSOURCEBILLID as id ", new Object[0]);
        sqlBuilder.append(" from t_ai_daptracker ai ", new Object[0]);
        sqlBuilder.append(" where ai.FBILLTYPE = ? ", new Object[]{entityName});
        sqlBuilder.appendIn(" and ai.FSOURCEBILLID ", fids);
        try (DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                hasVoucherBillIds.add(row.getLong("id"));
            }
        }
        return hasVoucherBillIds;
    }

    @Deprecated
    public static Map<String, Object> hashVounchers(List<String> fids) {
        HashMap<String, Object> idAndVouncherMap = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(fids)) {
            return idAndVouncherMap;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" select ai.FSOURCEBILLID as id,gl.FNUMBER as vounchernumber");
        sb.append(" from t_ai_daptracker ai LEFT JOIN t_gl_voucher gl");
        sb.append(" on ai.FVOUCHERID = gl.FID");
        sb.append(" where ai.FSOURCEBILLID in (");
        for (String fid : fids) {
            sb.append(fid);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)"fa"), (String)sb.toString(), null);
        if (ds == null) {
            return idAndVouncherMap;
        }
        for (Row row : ds) {
            idAndVouncherMap.put(row.getString("id"), row.getString("vounchernumber"));
        }
        return idAndVouncherMap;
    }

    public static Map<String, Object> hashVounchersV2(List<Object> fids, String entityName) {
        HashMap<String, Object> idAndVouncherMap = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(fids)) {
            return idAndVouncherMap;
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select ai.FSOURCEBILLID as id,gl.FNUMBER as vounchernumber", new Object[0]);
        sb.append(" from t_ai_daptracker ai LEFT JOIN t_gl_voucher gl", new Object[0]);
        sb.append(" on ai.FVOUCHERID = gl.FID", new Object[0]);
        sb.append(" where ai.FBILLTYPE = ?", new Object[]{entityName});
        sb.appendIn(" and ai.FSOURCEBILLID ", fids);
        DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sb);
        if (ds == null) {
            return idAndVouncherMap;
        }
        for (Row row : ds) {
            idAndVouncherMap.put(row.getString("id"), row.getString("vounchernumber"));
        }
        return idAndVouncherMap;
    }

    public static String getWorkLoadKey(DynamicObject workload) {
        String realcardNumber = workload.getString("realcard.number");
        Long periodId = workload.getLong("period.id");
        StringBuilder keySb = new StringBuilder();
        keySb = keySb.append(realcardNumber).append("_").append(periodId);
        return keySb.toString();
    }

    public static String getFinCardWorkLoadKey(DepreAlgoInter depreCard, DepreSegment seg) {
        String number = depreCard.getFinCard().getString("number");
        String periodId = seg.getPeriodId().toString();
        StringBuilder keySb = new StringBuilder();
        keySb = keySb.append(number).append("_").append(periodId);
        return keySb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> getTraceChangeDeptInfo(DynamicObject book) {
        void var15_24;
        QFilter[] depreMethodfilters = new QFilter[]{new QFilter("type", "=", (Object)"5")};
        DynamicObjectCollection depreMethodList = QueryServiceHelper.query((String)"fa_depremethod", (String)"id", (QFilter[])depreMethodfilters);
        Long[] depreMethodListIds = new Long[depreMethodList.size()];
        for (int i = 0; i < depreMethodList.size(); ++i) {
            depreMethodListIds[i] = ((DynamicObject)depreMethodList.get(i)).getLong("id");
        }
        DynamicObject currentPeriod = book.getDynamicObject("curperiod");
        Date curBeginDate = currentPeriod.getDate("beginDate");
        Date curEndDate = currentPeriod.getDate("endDate");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)book.getLong("org.id")), new QFilter("fieldentry.depreuse1", "=", (Object)book.getLong("depreuse.id")), new QFilter("fieldentry.field", "in", (Object)ChangeBillUtils.getCanIsAdjustdepreArr()), new QFilter("fieldentry.fincard1.depremethod.id", "in", (Object)depreMethodListIds), new QFilter("billstatus", "=", (Object)BillStatus.C.name())};
        DynamicObjectCollection billObjs = QueryServiceHelper.query((String)"fa_change_dept", (String)selectFields, (QFilter[])filters);
        Map<Boolean, List<DynamicObject>> isAdjustDepreMap = billObjs.stream().collect(Collectors.partitioningBy(v -> v.getBoolean("isadjustdepre")));
        List<DynamicObject> noTraceChangDept = isAdjustDepreMap.get(true);
        List<DynamicObject> traceChangDept = isAdjustDepreMap.get(false);
        HashSet<Long> realCardIdSet = new HashSet<Long>(billObjs.size() / 2);
        Date minNoTraceAjustDate = null;
        for (DynamicObject dynamicObject : noTraceChangDept) {
            Date bizDate = dynamicObject.getDate("bizdate");
            if (bizDate.compareTo(curBeginDate) >= 0) continue;
            if (minNoTraceAjustDate == null) {
                minNoTraceAjustDate = bizDate;
            } else if (bizDate.compareTo(minNoTraceAjustDate) < 0) {
                minNoTraceAjustDate = bizDate;
            }
            Long realCardId = dynamicObject.getLong("realcard");
            realCardIdSet.add(realCardId);
        }
        Date mintraceAjustDate = null;
        for (DynamicObject changDept : traceChangDept) {
            Date realaccountdate = changDept.getDate("realaccountdate");
            if (realaccountdate.compareTo(curBeginDate) >= 0) continue;
            if (mintraceAjustDate == null) {
                mintraceAjustDate = realaccountdate;
            } else if (realaccountdate.compareTo(mintraceAjustDate) < 0) {
                mintraceAjustDate = realaccountdate;
            }
            Long realCardId = changDept.getLong("realcard");
            realCardIdSet.add(realCardId);
        }
        Object var15_18 = null;
        if (minNoTraceAjustDate == null && mintraceAjustDate == null) {
            Object var15_19 = null;
        } else if (minNoTraceAjustDate == null && mintraceAjustDate != null) {
            Date date = mintraceAjustDate;
        } else if (minNoTraceAjustDate != null && mintraceAjustDate == null) {
            Date date = minNoTraceAjustDate;
        } else if (minNoTraceAjustDate != null && mintraceAjustDate != null) {
            if (minNoTraceAjustDate.compareTo(mintraceAjustDate) < 0) {
                Date date = minNoTraceAjustDate;
            } else {
                Date date = mintraceAjustDate;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("minAjustDate", var15_24);
        map.put("realCardIdSet", realCardIdSet);
        return map;
    }

    public static Map<String, Map<String, Object>> depreHisCardHandle(Long orgId, Long depreUseId, Long preDictPeriodId, Set<String> numberSet) {
        HashMap<String, Map<String, Object>> keyValueMap = new HashMap<String, Map<String, Object>>(10000);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT fid id,fnumber number2,foriginalval originalval,fmonthdepre monthdepre,faddupyeardepre addupyeardepre, fpreusingamount preusingamount, fdepredamount depredamount, fpreresidualval preresidualval,faccumdepre accumdepre,fnetworth networth,fdecval decval,fnetamount netamount,faddidepreamount addidepreamount FROM T_FA_CARD_FIN WHERE fbillstatus=? and forg = ? and fdepreuseid=? and fbizperiodid = ? and fisneeddepre='0' and foriginaldata = '0'", new Object[]{"C", orgId, depreUseId, preDictPeriodId});
        if (!CollectionUtils.isEmpty(numberSet)) {
            sqlBuilder.appendIn(" and fnumber", numberSet.toArray());
        }
        try (DataSet ds = DB.queryDataSet((String)"FaDepreUtil.getDepreHisCardList", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                String number = row.getString("number2");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("number", number);
                map.put("originalval", row.getBigDecimal("originalval"));
                map.put("monthdepre", row.getBigDecimal("monthdepre"));
                map.put("accumdepre", row.getBigDecimal("accumdepre"));
                map.put("networth", row.getBigDecimal("networth"));
                map.put("decval", row.getBigDecimal("decval"));
                map.put("netamount", row.getBigDecimal("netamount"));
                map.put("addupyeardepre", row.getBigDecimal("addupyeardepre"));
                map.put("preusingamount", row.getBigDecimal("preusingamount"));
                map.put("depredamount", row.getBigDecimal("depredamount"));
                map.put("preresidualval", row.getBigDecimal("preresidualval"));
                map.put("addidepreamount", row.getBigDecimal("addidepreamount"));
                keyValueMap.put(number, map);
            }
        }
        return keyValueMap;
    }

    public static Set<Long> queryForDeprePredictFinId(Long orgId, Long depreUseId, Long preDictPeriodId, Set<String> numberSet) {
        HashSet<Long> cardIds = new HashSet<Long>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT fid id,fnumber number2 FROM T_FA_CARD_FIN WHERE fbillstatus=? and forg = ? and fdepreuseid=? and fendperiodid > ? and (fbizperiodid < ? or (fbizperiodid = ? and fisneeddepre='1')) and (fclearperiodid = 0 or fclearperiodid = ?)", new Object[]{"C", orgId, depreUseId, preDictPeriodId, preDictPeriodId, preDictPeriodId, preDictPeriodId});
        if (!CollectionUtils.isEmpty(numberSet)) {
            sqlBuilder.appendIn(" and fnumber", numberSet.toArray());
        }
        try (DataSet ds = DB.queryDataSet((String)"FaDepreUtil.queryForDeprePredictFinId", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                cardIds.add(row.getLong("id"));
            }
        }
        String selectFields = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"entryentity", "realcard"}), "auditdate"});
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("period", "=", (Object)preDictPeriodId)};
        DynamicObjectCollection depreAdjustBills = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)selectFields, (QFilter[])filters);
        Set realIdSet = depreAdjustBills.stream().map(v -> v.get(Fa.dot((String[])new String[]{"entryentity", "realcard"}))).collect(Collectors.toSet());
        filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("bizperiod", "<=", (Object)preDictPeriodId), new QFilter("endperiod", ">", (Object)preDictPeriodId), new QFilter("realcardmasterid", "in", realIdSet)};
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])filters);
        Set _finIds = finCards.stream().map(v -> v.get("id")).collect(Collectors.toSet());
        cardIds.removeAll(_finIds);
        return cardIds;
    }

    public static Map<String, Long> queryUnNeedDepreFinMap4IgnoreUseStatus(Long orgId, Long depreUseId, Long preDictPeriodId, Set<String> numberSet) {
        Object row2;
        HashMap<String, Long> results = new HashMap<String, Long>(16);
        HashSet<Long> usestatusIds4NotDepre = new HashSet<Long>();
        SqlBuilder usestatusSql = new SqlBuilder();
        usestatusSql.append("select fid from T_FA_USESTATUS where FISDEPRE = '0';", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"queryFinMap4IgnoreUseStatus_usestatusSql", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)usestatusSql);){
            for (Object row2 : dataSet) {
                usestatusIds4NotDepre.add(row2.getLong("fid"));
            }
        }
        if (CollectionUtils.isEmpty(usestatusIds4NotDepre)) {
            return results;
        }
        HashSet<Long> realCardIds = new HashSet<Long>();
        SqlBuilder realSql = new SqlBuilder();
        realSql.append("select fid from t_fa_card_real where forgid = ? and ", new Object[]{orgId});
        realSql.appendIn(" fusestatusid ", (Object[])usestatusIds4NotDepre.toArray(new Long[0]));
        if (!CollectionUtils.isEmpty(numberSet)) {
            realSql.appendIn(" and fnumber", (Object[])numberSet.toArray(new String[0]));
        }
        DataSet dataSet = DB.queryDataSet((String)"queryFinMap4IgnoreUseStatus_realSql", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)realSql);
        row2 = null;
        try {
            for (Row row3 : dataSet) {
                realCardIds.add(row3.getLong("fid"));
            }
        }
        catch (Throwable throwable) {
            row2 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (row2 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row2).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (CollectionUtils.isEmpty(realCardIds)) {
            return results;
        }
        SqlBuilder finSql = new SqlBuilder();
        finSql.append("select fid,fnumber from t_fa_card_fin where fbillstatus='C' and fdepreuseid = ? and fbizperiodid <= ? and fendperiodid > ? and (fclearperiodid = 0 or fclearperiodid = ?)", new Object[]{depreUseId, preDictPeriodId, preDictPeriodId, preDictPeriodId});
        finSql.appendIn(" and frealcardid ", (Object[])realCardIds.toArray(new Long[0]));
        DataSet dataSet2 = DB.queryDataSet((String)"queryFinMap4IgnoreUseStatus_finSql", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)finSql);
        Object object = null;
        try {
            for (Row row4 : dataSet2) {
                String cardNum = row4.getString("fnumber");
                Long finId = row4.getLong("fid");
                results.put(cardNum, finId);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet2 != null) {
                if (object != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        return results;
    }

    public static void updateLessQualsCurPeriodYearDepre(Long orgId, Long depreUseId, Long startPeriodId, Long curPeriodId, Set<String> numbers, List<Object> lessQualsCurPeriodidsInThisYear) {
        if (numbers.size() == 0) {
            return;
        }
        SqlBuilder queryFinSql = new SqlBuilder();
        queryFinSql.append("SELECT fid,fnumber,fperiodid,fbizperiodid,fmonthdepre", new Object[0]);
        queryFinSql.append("FROM t_fa_card_fin WHERE ", new Object[0]);
        queryFinSql.appendIn("fnumber", numbers.toArray());
        queryFinSql.appendIn("and fbizperiodid", lessQualsCurPeriodidsInThisYear.toArray());
        queryFinSql.append("and forg = ? ", new Object[]{orgId});
        queryFinSql.append("and fdepreuseid = ? ", new Object[]{depreUseId});
        HashMap<String, Object[]> number2Vales = new HashMap<String, Object[]>(numbers.size(), 1.0f);
        HashSet<String> notNewInThisYearNumbers = new HashSet<String>(numbers.size(), 1.0f);
        DataSet fins = DB.queryDataSet((String)"selectLessQualsFins_depreFinCards", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryFinSql);
        Object object = null;
        try {
            for (Row fin : fins) {
                String number = fin.getString("fnumber");
                Long bizperiodid = fin.getLong("fbizperiodid");
                Long periodidId = fin.getLong("fperiodid");
                if (bizperiodid.longValue() == curPeriodId.longValue()) {
                    if (periodidId != 0L && lessQualsCurPeriodidsInThisYear.contains(periodidId) || periodidId == 0L && lessQualsCurPeriodidsInThisYear.contains(startPeriodId)) continue;
                    Object[] arr = new Object[]{fin.getBigDecimal("fmonthdepre"), fin.getLong("fid")};
                    number2Vales.put(number, arr);
                    continue;
                }
                notNewInThisYearNumbers.add(number);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fins != null) {
                if (object != null) {
                    try {
                        fins.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fins.close();
                }
            }
        }
        ArrayList vales2Updated = new ArrayList(numbers.size());
        for (Map.Entry entry : number2Vales.entrySet()) {
            if (notNewInThisYearNumbers.contains(entry.getKey())) continue;
            vales2Updated.add(entry.getValue());
        }
        if (vales2Updated.size() > 0) {
            String sql = "UPDATE T_FA_CARD_FIN SET FADDUPYEARDEPRE=? WHERE FID=?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, vales2Updated);
        }
    }

    public static void updateRefRCard4CurPeriodSplitDetail(long periodId, Map<Object, Object> realCardIdMap) {
        if (realCardIdMap == null || realCardIdMap.size() == 0) {
            return;
        }
        SqlBuilder queryRealSql = new SqlBuilder();
        queryRealSql.append("SELECT fid,forgid ", new Object[0]);
        queryRealSql.append("FROM t_fa_card_real WHERE ", new Object[0]);
        queryRealSql.appendIn("fid", realCardIdMap.keySet().toArray());
        HashMap<Long, Boolean> orgId2EnableTotalSumVoucher = new HashMap<Long, Boolean>(16);
        HashSet<Long> notEnableTotalSumVoucherOrgSet = new HashSet<Long>(3);
        try (DataSet dsReal = DB.queryDataSet((String)"updateRefRCard4CurPeriodSplitDetail_fa_card_real", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryRealSql);){
            for (Row rowReal : dsReal) {
                Long orgId = rowReal.getLong("forgid");
                Boolean enableTotalSumVoucher = null;
                if (orgId2EnableTotalSumVoucher.get(orgId) == null) {
                    enableTotalSumVoucher = SystemParamHelper.getBooleanParam("isuse_depredetail", orgId, false);
                    orgId2EnableTotalSumVoucher.put(orgId, enableTotalSumVoucher);
                } else {
                    enableTotalSumVoucher = (Boolean)orgId2EnableTotalSumVoucher.get(orgId);
                }
                if (enableTotalSumVoucher.booleanValue()) continue;
                notEnableTotalSumVoucherOrgSet.add(orgId);
            }
        }
        FaDepreUtil.updateRefRCard4CurPeriodSplitDetail(notEnableTotalSumVoucherOrgSet, periodId, realCardIdMap);
    }

    public static void updateRefRCard4CurPeriodSplitDetail(Set<Long> notEnableTotalSumVoucherOrgSet, long periodId, Map<Object, Object> realCardIdMap) {
        if (notEnableTotalSumVoucherOrgSet.size() == 0) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", notEnableTotalSumVoucherOrgSet), new QFilter("period", "=", (Object)periodId)};
        List sumIds = QueryServiceHelper.queryPrimaryKeys((String)"fa_depre_sum", (QFilter[])filters, (String)"createtime desc", (int)10000);
        if (sumIds.size() == 0) {
            return;
        }
        Set<Long> hasVerSet = FaDepreUtil.hasVoucher(sumIds, "fa_depre_sum");
        HashMap<Long, Integer> sumId2OrderMap = new HashMap<Long, Integer>(8);
        int sumIndex = 1;
        for (Object sumId : sumIds) {
            sumId2OrderMap.put((Long)sumId, sumIndex);
            ++sumIndex;
        }
        SqlBuilder queryDetailSql = new SqlBuilder();
        queryDetailSql.append("SELECT FREALCARDID,fdetailsid,fid,freversesplitdetailid", new Object[0]);
        queryDetailSql.append("FROM t_fa_depredetailentry WHERE ", new Object[0]);
        queryDetailSql.appendIn("FREALCARDID", realCardIdMap.keySet().toArray());
        queryDetailSql.appendIn("and fid", sumId2OrderMap.keySet().toArray());
        queryDetailSql.append(" order by fid asc", new Object[0]);
        HashMap realId2HisDetailsIdMap = new HashMap(realCardIdMap.size() * 2, 1.0f);
        HashMap<Long, Long[]> realId2NewSumIdMap = new HashMap<Long, Long[]>(realCardIdMap.size(), 1.0f);
        DataSet dsDetail = DB.queryDataSet((String)"updateRefRCard4CurPeriodSplitDetail_fa_depredetailentry2detail", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryDetailSql);
        Object object = null;
        try {
            for (Row rowDetail : dsDetail) {
                Long realId = rowDetail.getLong("FREALCARDID");
                Long detailsIdCur = rowDetail.getLong("fdetailsid");
                Long sumIdCur = rowDetail.getLong("fid");
                Long reversesplitdetailidCur = rowDetail.getLong("freversesplitdetailid");
                HashSet<Long> addedDetailIdSet = new HashSet<Long>(2, 1.0f);
                if (reversesplitdetailidCur != 0L) {
                    addedDetailIdSet.add(detailsIdCur);
                    HashSet<Long> hisDetailsList = (HashSet<Long>)realId2HisDetailsIdMap.get(realId);
                    if (hisDetailsList == null) {
                        hisDetailsList = new HashSet<Long>();
                        hisDetailsList.addAll(addedDetailIdSet);
                        realId2HisDetailsIdMap.put(realId, hisDetailsList);
                        continue;
                    }
                    hisDetailsList.addAll(addedDetailIdSet);
                    continue;
                }
                Long[] newSumIdArr = (Long[])realId2NewSumIdMap.get(realId);
                if (newSumIdArr == null) {
                    newSumIdArr = new Long[]{detailsIdCur, sumIdCur};
                    realId2NewSumIdMap.put(realId, newSumIdArr);
                    if (hasVerSet.contains(sumIdCur)) {
                        addedDetailIdSet.add(detailsIdCur);
                    }
                } else {
                    Long newSumId = newSumIdArr[1];
                    Long newDetailId = newSumIdArr[0];
                    int sumIndexNew = (Integer)sumId2OrderMap.get(newSumId);
                    int sumIndexCur = (Integer)sumId2OrderMap.get(sumIdCur);
                    if (newSumId.longValue() == sumIdCur.longValue() && newDetailId.longValue() == detailsIdCur.longValue()) continue;
                    if (sumIndexCur < sumIndexNew) {
                        Long[] newSumIdArrTemp = new Long[]{detailsIdCur, sumIdCur};
                        realId2NewSumIdMap.put(realId, newSumIdArrTemp);
                        if (hasVerSet.contains(sumIdCur)) {
                            addedDetailIdSet.add(detailsIdCur);
                        }
                        addedDetailIdSet.add(newDetailId);
                    } else {
                        addedDetailIdSet.add(detailsIdCur);
                    }
                }
                if (addedDetailIdSet.size() <= 0) continue;
                HashSet<Long> hisDetailsList = (HashSet<Long>)realId2HisDetailsIdMap.get(realId);
                if (hisDetailsList == null) {
                    hisDetailsList = new HashSet<Long>();
                    hisDetailsList.addAll(addedDetailIdSet);
                    realId2HisDetailsIdMap.put(realId, hisDetailsList);
                    continue;
                }
                hisDetailsList.addAll(addedDetailIdSet);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dsDetail != null) {
                if (object != null) {
                    try {
                        dsDetail.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dsDetail.close();
                }
            }
        }
        ArrayList params = new ArrayList();
        for (Map.Entry entry : realId2HisDetailsIdMap.entrySet()) {
            Set detailsIds;
            Object bakId = realCardIdMap.get(entry.getKey());
            if (bakId == null || (detailsIds = (Set)entry.getValue()) == null || detailsIds.size() == 0) continue;
            detailsIds.stream().forEach(f -> params.add(new Object[]{bakId, entry.getKey(), f}));
        }
        if (params != null && params.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depresplitdetail set FREALCARDID =?  where FREALCARDID = ? and fdetailsid = ?", params);
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depredetailentry set frealcardid =?  where FREALCARDID = ?  and fdetailsid = ?", params);
        }
    }
}

