/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.fa.business.utils.FaUtils;

public class FaInitAssetFinEntryDataUpService {
    private static final Log logger = LogFactory.getLog(FaInitAssetFinEntryDataUpService.class);
    private static final DBRoute DB_FA = DBRoute.of((String)"fa");
    private static final int BATCH_NUM = 10000;
    private static final String LOCK_KEY = "fi/fa/FaInitAssetFinEntryDataUpService";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeUpgradeService() {
        try (DLock dLock = DLock.create((String)LOCK_KEY).fastMode();){
            boolean tryLock = dLock.tryLock();
            if (!tryLock) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5728\u5347\u7ea7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u3002", (String)"FaInitAssetFinEntryDataUpService_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            String string = this.execute();
            return string;
        }
        catch (Exception e) {
            logger.error("\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u6570\u636e\u5347\u7ea7\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
    }

    private String execute() {
        String queryFinHasUpSql = "select count(1) as count from t_fa_masterid_upgrade_log where fbilltype = 'fa_card_fin' and fbizstatus = 'SUCCESS'";
        int successCount = (Integer)DB.query((DBRoute)DB_FA, (String)queryFinHasUpSql, rs -> {
            if (rs.next()) {
                return rs.getInt("count");
            }
            return 0;
        });
        if (successCount == 0) {
            logger.error("\u8bf7\u5148\u5347\u7ea7\u8d22\u52a1\u5361\u7247frealcardmasterid\u5b57\u6bb5\u540e\u518d\u8bd5\u3002");
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5347\u7ea7\u8d22\u52a1\u5361\u7247frealcardmasterid\u5b57\u6bb5\u540e\u518d\u8bd5\u3002", (String)"FaInitAssetFinEntryDataUpService_1", (String)"fi-fa-business", (Object[])new Object[0]);
        }
        long startTime = System.currentTimeMillis();
        this.updateAssetFinEntryData();
        logger.info("\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u539f\u59cb\u8d22\u52a1\u5361\u7247\u5347\u7ea7\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        this.insertAssetFinEntryData();
        logger.info("\u5347\u7ea7\u5168\u90e8\u5b8c\u6210\uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        return null;
    }

    private void insertAssetFinEntryData() {
        SqlBuilder queryInitRealOriginalSql = new SqlBuilder();
        queryInitRealOriginalSql.append("select a.fid, a.fmasterid from t_fa_card_real a left join t_fa_asset_finentry b", new Object[0]);
        queryInitRealOriginalSql.append(" on a.fid = b.fid and b.fid is null", new Object[0]);
        queryInitRealOriginalSql.append(" where fisbak = '1' and foriginaldata = '1' and fisinitialcard = '1'", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)(this.getClass().getName() + "queryInitRealOriginalData"), (DBRoute)DB_FA, (SqlBuilder)queryInitRealOriginalSql);
        HashMap<Object, Object> masterId2Id = new HashMap<Object, Object>(FaUtils.getInitialCapacity43(10000));
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            masterId2Id.put(next.get("fmasterid"), next.get("fid"));
        }
        if (!masterId2Id.isEmpty()) {
            this.genAssetFinEntryByRealMap(masterId2Id);
        }
    }

    public void genAssetFinEntryByRealMap(Map<Object, Object> masterId2Id) {
        SqlBuilder queryAssetFinEntrySql = new SqlBuilder();
        queryAssetFinEntrySql.append("select fid, fseq, ffincardid, foriginalfincardid from t_fa_asset_finentry", new Object[0]);
        queryAssetFinEntrySql.appendIn(" where fid", new ArrayList<Object>(masterId2Id.keySet()));
        DataSet entryDataSet = DB.queryDataSet((String)(this.getClass().getName() + "queryAssetFinEntryData"), (DBRoute)DB_FA, (SqlBuilder)queryAssetFinEntrySql);
        int insertCount = entryDataSet.copy().count("fid", false);
        long[] assetFinEntryIds = DBServiceHelper.genLongIds((String)"t_fa_asset_finentry", (int)insertCount);
        int idIndex = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(FaUtils.getInitialCapacity43(10000));
        while (entryDataSet.hasNext()) {
            if (insertParams.size() == 10000) {
                this.insertAssetFinEntry(insertParams);
                insertParams.clear();
            }
            Row next = entryDataSet.next();
            Object masterId = next.get("fid");
            Object seq = next.get("fseq");
            Object finCard = next.get("ffincardid");
            Object originalFinCardId = next.get("foriginalfincardid");
            Object id = masterId2Id.get(masterId);
            long entryId = assetFinEntryIds[idIndex++];
            insertParams.add(new Object[]{id, entryId, seq, finCard, originalFinCardId});
        }
        this.insertAssetFinEntry(insertParams);
    }

    private void updateAssetFinEntryData() {
        String queryInitFinOriginal2NewDataSql = "select a.fid foriginalfincardid, a.frealcardmasterid, b.fid ffincardid from (select fid, frealcardmasterid, fdepreuseid from t_fa_card_fin where fperiodid = 0 and fbizperiodid = 0 and fendperiodid != 99999999999) a left join (select fid, frealcardmasterid, fdepreuseid from t_fa_card_fin where fperiodid = 0 and fbizperiodid != 0 and fendperiodid = 99999999999) b on a.frealcardmasterid = b.frealcardmasterid and a.fdepreuseid = b.fdepreuseid where b.fid is not null";
        DataSet dataSet = DB.queryDataSet((String)(this.getClass().getName() + "queryInitFInData"), (DBRoute)DB_FA, (String)queryInitFinOriginal2NewDataSql);
        ArrayList<Object[]> params = new ArrayList<Object[]>(FaUtils.getInitialCapacity43(10000));
        for (Row row : dataSet) {
            if (params.size() == 10000) {
                this.updateAssetFinEntry(params);
                params.clear();
            }
            params.add(new Object[]{row.get("foriginalfincardid"), row.get("ffincardid")});
        }
        this.updateAssetFinEntry(params);
    }

    private void updateAssetFinEntry(List<Object[]> params) {
        if (params != null && !params.isEmpty()) {
            String updateSql = "update t_fa_asset_finentry set foriginalfincardid = ? where ffincardid = ?";
            DB.executeBatch((DBRoute)DB_FA, (String)updateSql, params);
        }
    }

    private void insertAssetFinEntry(List<Object[]> params) {
        if (params != null && !params.isEmpty()) {
            String updateSql = "insert into t_fa_asset_finentry(fid, fentryid, fseq, ffincardid, foriginalfincardid) values (?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)DB_FA, (String)updateSql, params);
        }
    }
}

