/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FaMutexRequireUtil {
    private static final Log logger = LogFactory.getLog(FaMutexRequireUtil.class);
    private static final String MUTEX_DATA_OBJ_ID = "dataObjId";
    private static final String MUTEX_GROUP_ID = "groupId";
    private static final String MUTEX_ENTITY_KEY = "entityKey";
    private static final String MUTEX_OPERATION_KEY = "operationKey";
    private static final String MUTEX_IS_STRICT = "isStrict";

    public static Set<Long> requireMutexBatch(String entityKey, Collection<Long> billIds, String groupId, String operationKey) {
        HashSet<Long> lockIds = new HashSet<Long>();
        if (billIds.isEmpty()) {
            return lockIds;
        }
        ArrayList mutexRequireList = new ArrayList(billIds.size());
        for (Long l : billIds) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
            requireParam.put(MUTEX_DATA_OBJ_ID, l.toString());
            requireParam.put(MUTEX_GROUP_ID, groupId);
            requireParam.put(MUTEX_ENTITY_KEY, entityKey);
            requireParam.put(MUTEX_OPERATION_KEY, operationKey);
            requireParam.put(MUTEX_IS_STRICT, true);
            mutexRequireList.add(requireParam);
        }
        try {
            Throwable throwable = null;
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                long now = System.currentTimeMillis();
                HashMap<Long, String> userName = new HashMap<Long, String>(2);
                ArrayList<Long> failIds = new ArrayList<Long>(8);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String string = (String)mutexItem.getKey();
                    Boolean ret = (Boolean)mutexItem.getValue();
                    Long id = Long.valueOf(string);
                    if (Boolean.TRUE.equals(ret)) {
                        lockIds.add(id);
                        continue;
                    }
                    failIds.add(id);
                }
                HashSet<Long> toReleaseSet = new HashSet<Long>(8);
                for (Long l : failIds) {
                    Map lockInfo = dataMutex.getLockInfo(l.toString(), groupId, entityKey);
                    StringBuilder sb = new StringBuilder();
                    if (lockInfo != null) {
                        Long userId = Long.valueOf((String)lockInfo.get("userid"));
                        String timeStr = (String)lockInfo.get("lockedTime");
                        long timeL = 0L;
                        if (timeStr != null && now - (timeL = Long.parseLong(timeStr)) > 3600000L) {
                            logger.info("\u5355\u636e\u7f51\u7edc\u9501\u5b9a\u8d85\u8fc71\u5c0f\u65f6\uff0c\u81ea\u52a8\u89e3\u9501\uff0c" + entityKey + "\u5355\u636eID\uff1a" + l);
                            toReleaseSet.add(l);
                            continue;
                        }
                        sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237", (String)"FaMutexRequireUtil_0", (String)"fi-fa-business", (Object[])new Object[0]));
                        String uName = userName.computeIfAbsent(userId, uid -> {
                            DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)uid, (String)"bos_user");
                            if (userObj != null) {
                                return userObj.getString("name");
                            }
                            return "";
                        });
                        sb.append(uName);
                        if (timeL != 0L) {
                            sb.append(ResManager.loadKDString((String)"\u5728", (String)"FaMutexRequireUtil_1", (String)"fi-fa-business", (Object[])new Object[0])).append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timeL)));
                        }
                        sb.append(ResManager.loadKDString((String)"\u9501\u5b9a", (String)"FaMutexRequireUtil_2", (String)"fi-fa-business", (Object[])new Object[0]));
                    } else {
                        sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237\u9501\u5b9a\u3002", (String)"FaMutexRequireUtil_3", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                    logger.info("\u7533\u8bf7\u9501\u5931\u8d25\u5206\u6790\u7ed3\u679c\uff1a{} : {}", (Object)l, (Object)sb.toString());
                }
                if (!toReleaseSet.isEmpty()) {
                    FaMutexRequireUtil.batchRelease(entityKey, toReleaseSet, groupId, operationKey);
                    mutexRequireList = new ArrayList(toReleaseSet.size());
                    for (Long l : toReleaseSet) {
                        HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
                        requireParam.put(MUTEX_DATA_OBJ_ID, l.toString());
                        requireParam.put(MUTEX_GROUP_ID, groupId);
                        requireParam.put(MUTEX_ENTITY_KEY, entityKey);
                        requireParam.put(MUTEX_OPERATION_KEY, operationKey);
                        requireParam.put(MUTEX_IS_STRICT, true);
                        mutexRequireList.add(requireParam);
                    }
                    mutexResult = dataMutex.batchrequire(mutexRequireList);
                    for (Map.Entry entry : mutexResult.entrySet()) {
                        String objId = (String)entry.getKey();
                        Boolean ret = (Boolean)entry.getValue();
                        Long id = Long.valueOf(objId);
                        if (Boolean.TRUE.equals(ret)) {
                            lockIds.add(id);
                            continue;
                        }
                        Map lockInfo = dataMutex.getLockInfo(objId, groupId, entityKey);
                        StringBuilder sb = new StringBuilder();
                        if (lockInfo != null) {
                            Long userId = Long.valueOf((String)lockInfo.get("userid"));
                            String timeStr = (String)lockInfo.get("lockedTime");
                            long timeL = 0L;
                            if (timeStr != null) {
                                timeL = Long.parseLong(timeStr);
                            }
                            sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237", (String)"FaMutexRequireUtil_0", (String)"fi-fa-business", (Object[])new Object[0]));
                            String uName = userName.computeIfAbsent(userId, uid -> {
                                DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)uid, (String)"bos_user");
                                if (userObj != null) {
                                    return userObj.getString("name");
                                }
                                return "";
                            });
                            sb.append(uName);
                            if (timeL != 0L) {
                                sb.append(ResManager.loadKDString((String)"\u5728", (String)"FaMutexRequireUtil_1", (String)"fi-fa-business", (Object[])new Object[0])).append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timeL)));
                            }
                            sb.append(ResManager.loadKDString((String)"\u9501\u5b9a", (String)"FaMutexRequireUtil_2", (String)"fi-fa-business", (Object[])new Object[0]));
                        } else {
                            sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237\u9501\u5b9a\u3002", (String)"FaMutexRequireUtil_3", (String)"fi-fa-business", (Object[])new Object[0]));
                        }
                        logger.info("\u7533\u8bf7\u9501\u8d85\u65f6\u91ca\u653e\u540e\u518d\u6b21\u7533\u8bf7\u5931\u8d25\u5206\u6790\u7ed3\u679c\uff1a{} : {}", (Object)objId, (Object)sb.toString());
                    }
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            FaMutexRequireUtil.batchRelease(entityKey, lockIds, groupId, operationKey);
            ErrorCode errorCode = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"FaMutexRequireUtil_4", (String)"fi-fa-business", (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, errorCode, new Object[0]);
        }
        return lockIds;
    }

    public static void batchRelease(String entityNumber, Collection<Long> lockIds, String groupId, String operationKey) {
        if (!lockIds.isEmpty()) {
            ArrayList mutexRequireList = new ArrayList(lockIds.size());
            for (Long lockID : lockIds) {
                HashMap<String, String> requireParam = new HashMap<String, String>(8);
                requireParam.put(MUTEX_DATA_OBJ_ID, lockID.toString());
                requireParam.put(MUTEX_GROUP_ID, groupId);
                requireParam.put(MUTEX_ENTITY_KEY, entityNumber);
                requireParam.put(MUTEX_OPERATION_KEY, operationKey);
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (releaseRet) continue;
                    logger.info("\u91ca\u653e\u6570\u636e\u5bf9\u8c61[" + objId + "]\u4e92\u65a5\u9501\u5931\u8d25.");
                }
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519%s\u3002", (String)"FaMutexRequireUtil_5", (String)"fi-fa-business", (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
        }
    }

    public static boolean requireMutex(String entityKey, Object billId, String groupId, String operationKey) {
        boolean require = false;
        String dataObjId = billId.toString();
        try (DataMutex dataMutex = DataMutex.create();){
            MutexLockInfo mutexInfo = new MutexLockInfo();
            mutexInfo.setDataObjId(dataObjId);
            mutexInfo.setGroupId(groupId);
            mutexInfo.setEntityNumber(entityKey);
            mutexInfo.setOperationKey(operationKey);
            mutexInfo.setStrict(true);
            require = dataMutex.require(mutexInfo);
        }
        catch (Throwable t) {
            FaMutexRequireUtil.releaseMutex(dataObjId, entityKey, operationKey);
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"FaMutexRequireUtil_4", (String)"fi-fa-business", (Object[])new Object[0]), t.getMessage()));
            throw new KDException(t, ec, new Object[0]);
        }
        return require;
    }

    public static void releaseMutex(Object dataObjId, String entityKey, String operationKey) {
        try (DataMutex dataMutex = DataMutex.create();){
            dataMutex.release(String.valueOf(dataObjId), entityKey, operationKey);
        }
        catch (Throwable t) {
            throw new KDException(t, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519%s\u3002", (String)"FaMutexRequireUtil_5", (String)"fi-fa-business", (Object[])new Object[0]), t.getMessage())), new Object[0]);
        }
    }
}

