/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;

public class FaOperationLogUtils {
    private static final Log log = LogFactory.getLog(FaOperationLogUtils.class);
    private static int SHORT_CONTENT_LENGTH = 100;

    public static Long insertOperationLog(FaOperationLogInsertPo insertPo) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_operation_log");
        DynamicObject logObj = new DynamicObject((DynamicObjectType)type);
        ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(1);
        logObj.set("username", (Object)ContextUtil.getUsername());
        logObj.set("orgname", (Object)insertPo.getOrgName());
        logObj.set("depreusename", (Object)insertPo.getDepreUseName());
        logObj.set("period", (Object)insertPo.getPeriod());
        logObj.set("assetbookname", (Object)insertPo.getAssetBookName());
        logObj.set("status", (Object)FaOperationStatusEnum.DOING.name());
        logObj.set("depredcount", (Object)insertPo.getDepredCount());
        logObj.set("fromentityname", (Object)insertPo.getFromEntityname());
        logObj.set("params_tag", (Object)insertPo.getParams());
        int paramsSplitLength = insertPo.getParams().length();
        if (paramsSplitLength > SHORT_CONTENT_LENGTH) {
            paramsSplitLength = SHORT_CONTENT_LENGTH;
        }
        logObj.set("params", (Object)insertPo.getParams().substring(0, paramsSplitLength));
        logObj.set("optype", (Object)insertPo.getOpType().name());
        logObj.set("opdate", (Object)new Date());
        logList.add(logObj);
        LogORM logORM = LogORM.create();
        long[] resultArray = new long[]{};
        try {
            resultArray = logORM.insert(logList);
        }
        catch (Throwable e) {
            log.error("\u63d2\u5165\u65e5\u5fd7\u5f02\u5e38", e);
        }
        return ArrayUtils.isEmpty((long[])resultArray) ? null : Long.valueOf(resultArray[0]);
    }

    public static Long insertOperationLog(FaOperationLogInsertPo insertPo, FaOperationStatusEnum statusEnum, String result) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_operation_log");
        DynamicObject logObj = new DynamicObject((DynamicObjectType)type);
        ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(1);
        logObj.set("username", (Object)ContextUtil.getUsername());
        logObj.set("orgname", (Object)insertPo.getOrgName());
        logObj.set("depreusename", (Object)insertPo.getDepreUseName());
        logObj.set("period", (Object)insertPo.getPeriod());
        logObj.set("assetbookname", (Object)insertPo.getAssetBookName());
        logObj.set("status", (Object)statusEnum.name());
        logObj.set("depredcount", (Object)insertPo.getDepredCount());
        logObj.set("fromentityname", (Object)insertPo.getFromEntityname());
        logObj.set("params_tag", (Object)insertPo.getParams());
        if (StringUtils.isNotEmpty((String)insertPo.getParams())) {
            int paramsSplitLength = insertPo.getParams().length();
            if (paramsSplitLength > SHORT_CONTENT_LENGTH) {
                paramsSplitLength = SHORT_CONTENT_LENGTH;
            }
            logObj.set("params", (Object)insertPo.getParams().substring(0, paramsSplitLength));
        }
        logObj.set("result_tag", (Object)result);
        if (StringUtils.isNotEmpty((String)result)) {
            int resultSplitLength = result.length();
            if (resultSplitLength > SHORT_CONTENT_LENGTH) {
                resultSplitLength = SHORT_CONTENT_LENGTH;
            }
            logObj.set("result", (Object)result.substring(0, resultSplitLength));
        }
        logObj.set("optype", (Object)insertPo.getOpType().name());
        logObj.set("opdate", (Object)new Date());
        logObj.set("finishtime", (Object)new Date());
        logList.add(logObj);
        LogORM logORM = LogORM.create();
        long[] resultArray = new long[]{};
        try {
            resultArray = logORM.insert(logList);
        }
        catch (Throwable e) {
            log.error("\u63d2\u5165\u65e5\u5fd7\u5f02\u5e38", e);
        }
        return ArrayUtils.isEmpty((long[])resultArray) ? null : Long.valueOf(resultArray[0]);
    }

    public static void updateOperationLog(Long logId, FaOperationStatusEnum statusEnum, String result) {
        if (logId == null || logId == 0L) {
            return;
        }
        LogORM logORM = LogORM.create();
        DynamicObjectCollection logList = logORM.query("fa_operation_log", Fa.comma((String[])new String[]{"id", "status", "result", "result_tag", "finishtime"}), new QFilter[]{new QFilter("id", "=", (Object)logId)}, 1, 0);
        for (DynamicObject log : logList) {
            log.set("status", (Object)statusEnum.name());
            log.set("finishtime", (Object)new Date());
            if (result == null) continue;
            int resultSplitLength = result.length();
            if (resultSplitLength > SHORT_CONTENT_LENGTH) {
                resultSplitLength = SHORT_CONTENT_LENGTH;
            }
            log.set("result", (Object)result.substring(0, resultSplitLength));
            log.set("result_tag", (Object)result);
        }
        try {
            logORM.update((List)logList);
        }
        catch (Throwable e) {
            log.error("\u66f4\u65b0\u65e5\u5fd7\u5f02\u5e38", e);
        }
    }
}

