/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fa.common.util.ContextUtil;

public class FaPermissionUtils {
    private static final Log logger = LogFactory.getLog(FaPermissionUtils.class);
    public static final String AUDITID = "47162f66000000ac";
    public static final String NEWID = "47156aff000000ac";
    public static final String VIEWID = "47150e89000000ac";

    public static List<Long> getPermissionOrgIdsV2(String pageId, String entityNum, String funcID) {
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)entityNum, (String)funcID);
        List allPermissionOrgs = null;
        allPermissionOrgs = allPermOrgs.hasAllOrgPerm() ? PermissionServiceHelper.getAllPermissionOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)entityNum, (String)funcID) : allPermOrgs.getHasPermOrgs();
        return allPermissionOrgs;
    }

    @Deprecated
    public static List<Long> getPermissionOrgIds(String entityNum, String funcID) {
        return PermissionServiceHelper.getAllPermissionOrgs((Long)ContextUtil.getUserId(), (String)"fa", (String)entityNum, (String)funcID);
    }

    @Deprecated
    public static List<Long> getPermissionLeafOrgIds(String entityNum, String funcID, String orgViewType) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)orgViewType, (String)"fa", (String)entityNum, (String)funcID);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(true, Collections.emptyList(), orgViewType);
        }
        return FaPermissionUtils.getLeafOrgs(false, allPermOrgs.getHasPermOrgs(), orgViewType);
    }

    public static List<Long> getPermissionLeafOrgIdsV2(String pageId, String entityNum, String funcID, String orgViewType) {
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)orgViewType, (String)appId, (String)entityNum, (String)funcID);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(true, Collections.emptyList(), orgViewType);
        }
        return FaPermissionUtils.getLeafOrgs(false, allPermOrgs.getHasPermOrgs(), orgViewType);
    }

    @Deprecated
    public static List<Long> getLeafOrgs(List<Long> orgIds, String orgViewType) {
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)orgViewType);
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)true);
        QFilter idFilter = new QFilter("org", "in", orgIds);
        QFilter leafFilter = new QFilter("isbizunit", "=", (Object)true);
        QFilter[] filters = new QFilter[]{treeTypeFilter, defaultViewFilter, idFilter, leafFilter};
        logger.info("\u5f00\u59cb\u67e5\u8be2\u53f6\u5b50\u7ec4\u7ec7");
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id", (QFilter[])filters);
        logger.info("\u7ed3\u675f\u67e5\u8be2\u53f6\u5b50\u7ec4\u7ec7");
        ArrayList<Long> leafOrgs = new ArrayList<Long>();
        for (DynamicObject s : orgs) {
            leafOrgs.add(s.getLong("org.id"));
        }
        leafOrgs.sort((v1, v2) -> v1.compareTo((Long)v2));
        logger.info(String.format("\u8ddf\u8e2a\u8fd4\u56de\u7684\u53f6\u5b50\u7ec4\u7ec7\u5927\u5c0f\u4e3a: %s", leafOrgs.size()));
        return leafOrgs;
    }

    public static List<Long> getLeafOrgs(boolean hasAllPerm, List<Long> orgIds, String orgViewType) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(4);
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)orgViewType);
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)true);
        QFilter leafFilter = new QFilter("isbizunit", "=", (Object)true);
        filterList.add(treeTypeFilter);
        filterList.add(defaultViewFilter);
        filterList.add(leafFilter);
        if (!hasAllPerm) {
            QFilter idFilter = new QFilter("org", "in", orgIds);
            filterList.add(idFilter);
        }
        logger.info("\u5f00\u59cb\u67e5\u8be2\u53f6\u5b50\u7ec4\u7ec7");
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id", (QFilter[])filterList.toArray(new QFilter[0]));
        logger.info("\u7ed3\u675f\u67e5\u8be2\u53f6\u5b50\u7ec4\u7ec7");
        ArrayList<Long> leafOrgs = new ArrayList<Long>();
        for (DynamicObject s : orgs) {
            leafOrgs.add(s.getLong("org.id"));
        }
        leafOrgs.sort((v1, v2) -> v1.compareTo((Long)v2));
        logger.info(String.format("\u8ddf\u8e2a\u8fd4\u56de\u7684\u53f6\u5b50\u7ec4\u7ec7\u5927\u5c0f\u4e3a: %s", leafOrgs.size()));
        return leafOrgs;
    }

    public static boolean checkOrgIsLeaf(Long orgId, String orgViewType) {
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)orgViewType);
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)true);
        QFilter idFilter = new QFilter("org", "=", (Object)orgId);
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)true);
        QFilter[] filters = new QFilter[]{treeTypeFilter, defaultViewFilter, idFilter, leafFilter};
        return QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])filters);
    }

    @Deprecated
    public static List<Long> getNewPermissionLeafAssetOrg(String entityNum) {
        return FaPermissionUtils.getPermissionLeafOrgIds(entityNum, NEWID, "09");
    }

    public static List<Long> getNewPermissionLeafAssetOrgV2(String pageId, String entityNum) {
        return FaPermissionUtils.getPermissionLeafOrgIdsV2(pageId, entityNum, NEWID, "09");
    }

    @Deprecated
    private static List<Long> getLeafAssetOrgs(List<Long> orgIds) {
        return FaPermissionUtils.getLeafOrgs(orgIds, "10");
    }

    @Deprecated
    private static List<Long> getLeafAssetAssetUnits(List<Long> orgIds) {
        return FaPermissionUtils.getLeafOrgs(orgIds, "09");
    }

    public static List<ComboItem> getLeafAssetUnitCombos(List<Long> allPermissionOrgs) {
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"09");
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)true);
        QFilter idFilter = new QFilter("org", "in", allPermissionOrgs);
        QFilter leafFilter = new QFilter("isbizunit", "=", (Object)true);
        QFilter[] filters = new QFilter[]{treeTypeFilter, defaultViewFilter, idFilter, leafFilter};
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id,org.name", (QFilter[])filters);
        ArrayList<ComboItem> leafOrgs = new ArrayList<ComboItem>();
        for (DynamicObject s : orgs) {
            ComboItem c = new ComboItem();
            c.setValue(Long.valueOf(s.getLong("org.id")).toString());
            c.setCaption(new LocaleString(s.getString("org.name")));
            leafOrgs.add(c);
        }
        return leafOrgs;
    }

    public static List<ComboItem> getLeafOrgCombos(List<Long> allPermissionOrgs) {
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)true);
        QFilter idFilter = new QFilter("org", "in", allPermissionOrgs);
        QFilter leafFilter = new QFilter("isbizunit", "=", (Object)true);
        QFilter[] filters = new QFilter[]{treeTypeFilter, defaultViewFilter, idFilter, leafFilter};
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id,org.name", (QFilter[])filters);
        LinkedHashMap<String, String> orgIdAndNameMap = new LinkedHashMap<String, String>();
        for (DynamicObject s : orgs) {
            orgIdAndNameMap.put(Long.valueOf(s.getLong("org.id")).toString(), s.getString("org.name"));
        }
        Set entrySet = orgIdAndNameMap.entrySet();
        ArrayList<ComboItem> leafOrgs = new ArrayList<ComboItem>(entrySet.size());
        for (Map.Entry m : entrySet) {
            ComboItem c = new ComboItem();
            c.setValue((String)m.getKey());
            c.setCaption(new LocaleString((String)m.getValue()));
            leafOrgs.add(c);
        }
        return leafOrgs;
    }

    public static List<ComboItem> getDepreuses(List<Long> depreusesIds) {
        QFilter idFilter = new QFilter("id", "in", depreusesIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection depreuses = QueryServiceHelper.query((String)"fa_depreuse", (String)"id,name", (QFilter[])filters);
        LinkedHashMap<String, String> orgIdAndNameMap = new LinkedHashMap<String, String>();
        for (DynamicObject s : depreuses) {
            orgIdAndNameMap.put(Long.valueOf(s.getLong("id")).toString(), s.getString("name"));
        }
        Set entrySet = orgIdAndNameMap.entrySet();
        ArrayList<ComboItem> leafDepreuses = new ArrayList<ComboItem>(entrySet.size());
        for (Map.Entry m : entrySet) {
            ComboItem c = new ComboItem();
            c.setCaption(new LocaleString((String)m.getValue()));
            c.setValue((String)m.getKey());
            leafDepreuses.add(c);
        }
        return leafDepreuses;
    }

    @Deprecated
    public static List<Long> getViewPermissionLeafOrg(String entityNum) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)"fa", (String)entityNum, (String)VIEWID);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(true, Collections.emptyList(), "10");
        }
        return FaPermissionUtils.getLeafOrgs(false, allPermOrgs.getHasPermOrgs(), "10");
    }

    public static List<Long> getViewPermissionLeafOrgV2(String pageId, String entityNum) {
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)appId, (String)entityNum, (String)VIEWID);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(true, Collections.emptyList(), "10");
        }
        return FaPermissionUtils.getLeafOrgs(false, allPermOrgs.getHasPermOrgs(), "10");
    }

    @Deprecated
    public static List<Long> getViewPermissionLeafAssetUnit(String entityNum) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"09", (String)"fa", (String)entityNum, (String)VIEWID);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(true, Collections.emptyList(), "09");
        }
        return FaPermissionUtils.getLeafOrgs(false, allPermOrgs.getHasPermOrgs(), "09");
    }

    public static List<Long> getViewPermissionLeafAssetUnitV2(String pageId, String entityNum) {
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"09", (String)appId, (String)entityNum, (String)VIEWID);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(true, Collections.emptyList(), "09");
        }
        return FaPermissionUtils.getLeafOrgs(false, allPermOrgs.getHasPermOrgs(), "09");
    }

    @Deprecated
    public static List<Long> getAllEnableBookAndPermissionOrgs(String entityId) {
        return FaPermissionUtils.getAllEnableBookAndPermissionOrgs(entityId, VIEWID);
    }

    public static List<Long> getAllEnableBookAndPermissionOrgsV2(String pageId, String entityId) {
        return FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2(pageId, entityId, VIEWID);
    }

    @Deprecated
    public static List<Long> getAllBookAndPermissionOrgs(String entityId) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)"fa", (String)entityId, (String)VIEWID);
        List<Long> bookOrgIds = FaPermissionUtils.getAllBookOrgs();
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(false, bookOrgIds, "10");
        }
        List permOrgs = allPermOrgs.getHasPermOrgs();
        permOrgs.retainAll(bookOrgIds);
        return FaPermissionUtils.getLeafOrgs(false, permOrgs, "10");
    }

    public static List<Long> getAllBookAndPermissionOrgsV2(String pageId, String entityId) {
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)appId, (String)entityId, (String)VIEWID);
        List<Long> bookOrgIds = FaPermissionUtils.getAllBookOrgs();
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(false, bookOrgIds, "10");
        }
        List permOrgs = allPermOrgs.getHasPermOrgs();
        permOrgs.retainAll(bookOrgIds);
        return FaPermissionUtils.getLeafOrgs(false, permOrgs, "10");
    }

    @Deprecated
    public static List<Long> getAllPermissionAsseUnits(String entityId) {
        return FaPermissionUtils.getAllPermissionAssetUnits(entityId, VIEWID);
    }

    public static List<Long> getAllPermissionAsseUnitsV2(String pageId, String entityId) {
        return FaPermissionUtils.getAllPermissionAssetUnitsV2(pageId, entityId, VIEWID);
    }

    @Deprecated
    public static List<Long> getAllEnableBookAndPermissionOrgs(String entityId, String permId) {
        return FaPermissionUtils.getAllBookAndPermissionOrgs(entityId, permId, true, false);
    }

    public static List<Long> getAllEnableBookAndPermissionOrgsV2(String pageId, String entityId, String permId) {
        return FaPermissionUtils.getAllBookAndPermissionOrgsV2(pageId, entityId, permId, true, false);
    }

    @Deprecated
    public static List<Long> getAllBookAndPermissionOrgs(String entityId, String permId, boolean enable, boolean isMain) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)"fa", (String)entityId, (String)permId);
        List<Long> bookOrgIds = FaPermissionUtils.getAllBookOrgs(enable, isMain);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(false, bookOrgIds, "10");
        }
        List permOrgs = allPermOrgs.getHasPermOrgs();
        permOrgs.retainAll(bookOrgIds);
        return FaPermissionUtils.getLeafOrgs(false, permOrgs, "10");
    }

    public static List<Long> getAllBookAndPermissionOrgsV2(String pageId, String entityId, String permId, boolean enable, boolean isMain) {
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)appId, (String)entityId, (String)permId);
        List<Long> bookOrgIds = FaPermissionUtils.getAllBookOrgs(enable, isMain);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(false, bookOrgIds, "10");
        }
        List permOrgs = allPermOrgs.getHasPermOrgs();
        permOrgs.retainAll(bookOrgIds);
        return FaPermissionUtils.getLeafOrgs(false, permOrgs, "10");
    }

    @Deprecated
    public static List<Long> getAllPermissionAssetUnits(String entityId, String permId) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"09", (String)"fa", (String)entityId, (String)permId);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(true, Collections.emptyList(), "09");
        }
        return FaPermissionUtils.getLeafOrgs(false, allPermOrgs.getHasPermOrgs(), "09");
    }

    public static List<Long> getAllPermissionAssetUnitsV2(String pageId, String entityId, String permId) {
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"09", (String)appId, (String)entityId, (String)permId);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(true, Collections.emptyList(), "09");
        }
        return FaPermissionUtils.getLeafOrgs(false, allPermOrgs.getHasPermOrgs(), "09");
    }

    public static List<Long> getAllPermissionAssetunits(String entityId, String permId) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"09", (String)"fa", (String)entityId, (String)permId);
        if (allPermOrgs.hasAllOrgPerm()) {
            return FaPermissionUtils.getLeafOrgs(true, Collections.emptyList(), "09");
        }
        return FaPermissionUtils.getLeafOrgs(false, allPermOrgs.getHasPermOrgs(), "09");
    }

    @Deprecated
    public static List<ComboItem> getAllEnableBookAndPermissionOrgsCombos(String entityId) {
        List<Long> permissionOrgIds = FaPermissionUtils.getViewPermissionLeafOrg(entityId);
        HashSet<Long> resultOrgs = new HashSet<Long>(permissionOrgIds);
        HashSet<Long> bookOrgIds = new HashSet<Long>(FaPermissionUtils.getAllBookOrgs(true, false));
        resultOrgs.retainAll(bookOrgIds);
        permissionOrgIds = new ArrayList<Long>(resultOrgs);
        return FaPermissionUtils.getLeafOrgCombos(permissionOrgIds);
    }

    public static List<ComboItem> getAllEnableBookAndPermissionOrgsCombosV2(String pageId, String entityId) {
        List<Long> permissionOrgIds = FaPermissionUtils.getViewPermissionLeafOrgV2(pageId, entityId);
        HashSet<Long> resultOrgs = new HashSet<Long>(permissionOrgIds);
        HashSet<Long> bookOrgIds = new HashSet<Long>(FaPermissionUtils.getAllBookOrgs(true, false));
        resultOrgs.retainAll(bookOrgIds);
        permissionOrgIds = new ArrayList<Long>(resultOrgs);
        return FaPermissionUtils.getLeafOrgCombos(permissionOrgIds);
    }

    @Deprecated
    public static List<ComboItem> getAllBookAndPermissionOrgsCombos(String entityId) {
        List<Long> permissionOrgIds = FaPermissionUtils.getViewPermissionLeafOrg(entityId);
        HashSet<Long> resultOrgs = new HashSet<Long>(permissionOrgIds);
        HashSet<Long> bookOrgIds = new HashSet<Long>(FaPermissionUtils.getAllBookOrgs());
        logger.debug("getAllBookAndPermissionOrgsCombos size = {} step1", (Object)permissionOrgIds.size());
        resultOrgs.retainAll(bookOrgIds);
        logger.debug("getAllBookAndPermissionOrgsCombos size = {} step2", (Object)bookOrgIds.size());
        permissionOrgIds = new ArrayList<Long>(resultOrgs);
        return FaPermissionUtils.getLeafOrgCombos(permissionOrgIds);
    }

    public static List<ComboItem> getAllBookAndPermissionOrgsCombosV2(String pageId, String entityId) {
        List<Long> permissionOrgIds = FaPermissionUtils.getViewPermissionLeafOrgV2(pageId, entityId);
        HashSet<Long> resultOrgs = new HashSet<Long>(permissionOrgIds);
        HashSet<Long> bookOrgIds = new HashSet<Long>(FaPermissionUtils.getAllBookOrgs());
        logger.info("getAllBookAndPermissionOrgsCombos size = {} step1", (Object)permissionOrgIds.size());
        resultOrgs.retainAll(bookOrgIds);
        logger.info("getAllBookAndPermissionOrgsCombos size = {} step2", (Object)bookOrgIds.size());
        permissionOrgIds = new ArrayList<Long>(resultOrgs);
        return FaPermissionUtils.getLeafOrgCombos(permissionOrgIds);
    }

    @Deprecated
    public static List<ComboItem> getAllPermissionAssetUnitCombos(String entityId) {
        List<Long> permissionOrgIds = FaPermissionUtils.getViewPermissionLeafAssetUnit(entityId);
        return FaPermissionUtils.getLeafAssetUnitCombos(permissionOrgIds);
    }

    public static List<ComboItem> getAllPermissionAssetUnitCombosV2(String pageId, String entityId) {
        List<Long> permissionOrgIds = FaPermissionUtils.getViewPermissionLeafAssetUnitV2(pageId, entityId);
        return FaPermissionUtils.getLeafAssetUnitCombos(permissionOrgIds);
    }

    @Deprecated
    public static List<ComboItem> getAllPermissionOrgsCombos(String entityId) {
        List<Long> permissionOrgIds = FaPermissionUtils.getViewPermissionLeafOrg(entityId);
        return FaPermissionUtils.getLeafOrgCombos(permissionOrgIds);
    }

    public static List<ComboItem> getAllPermissionOrgsCombosV2(String pageId, String entityId) {
        List<Long> permissionOrgIds = FaPermissionUtils.getViewPermissionLeafOrgV2(pageId, entityId);
        return FaPermissionUtils.getLeafOrgCombos(permissionOrgIds);
    }

    public static List<Long> getAllBookOrgs(boolean enable, boolean isMain) {
        QFilter peroidQF = new QFilter("startperiod", "!=", (Object)0L);
        if (isMain) {
            peroidQF = peroidQF.and(new QFilter("ismainbook", "=", (Object)true));
        }
        peroidQF = enable ? peroidQF.and(new QFilter("status", "=", (Object)"C")) : peroidQF.and(new QFilter("status", "!=", (Object)"C"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"fa_assetbook", (String)"org", (QFilter[])peroidQF.toArray());
        ArrayList<Long> list = new ArrayList<Long>();
        for (DynamicObject db : coll) {
            list.add(db.getLong("org"));
        }
        return list;
    }

    public static List<Long> getAllBookOrgs() {
        QFilter peroidQF = new QFilter("startperiod", "!=", (Object)0L);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"fa_assetbook", (String)"org", (QFilter[])peroidQF.toArray());
        ArrayList<Long> list = new ArrayList<Long>();
        for (DynamicObject db : coll) {
            list.add(db.getLong("org"));
        }
        return list;
    }

    public static Long getDefaultAcctOrg(List<Long> orgPkList) {
        Long curLoginOrg = RequestContext.get().getOrgId();
        if (orgPkList.contains(curLoginOrg)) {
            return curLoginOrg;
        }
        if (!orgPkList.isEmpty()) {
            return orgPkList.get(0);
        }
        return null;
    }
}

