/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.fa.business.dao.IFaBillDao;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;

public class FaUserUtils {
    public static DynamicObject getAdminOrgByUser(DynamicObject user) {
        DynamicObject org = null;
        if (user == null) {
            return null;
        }
        DynamicObjectCollection orgEntrys = user.getDynamicObjectCollection("entryentity");
        for (DynamicObject orgEntry : orgEntrys) {
            if (orgEntry.getBoolean("ispartjob")) continue;
            org = orgEntry.getDynamicObject("dpt");
            break;
        }
        return org;
    }

    public static DynamicObject getUserById(String userId) {
        DynamicObject user = FaBaseDaoFactory.getInstance("bos_user").queryOne(userId);
        return user;
    }

    public static DynamicObject getCompanyByUser(DynamicObject user) {
        return FaUserUtils.getCompany(user);
    }

    private static DynamicObject getCompany(DynamicObject user) {
        IFaBillDao bdOrgDao = FaBillDaoFactory.getInstance("bos_org");
        DynamicObject adminOrg = FaUserUtils.getAdminOrgByUser(user);
        if (adminOrg == null) {
            return null;
        }
        DynamicObject adminOrgDyn = FaBillDaoFactory.getInstance("bos_org_structure").queryOne(new QFilter("org", "=", adminOrg.getPkValue()));
        if (adminOrgDyn == null) {
            return null;
        }
        String longNumber = adminOrgDyn.getString("longnumber");
        String[] numbers = longNumber.split("!");
        if (numbers.length == 0) {
            return null;
        }
        DynamicObject org = null;
        for (int i = numbers.length - 1; i >= 0; --i) {
            org = bdOrgDao.queryOne(new QFilter("number", "=", (Object)numbers[i]));
            if (org.getInt("orgpattern_id") != 1) continue;
            return org;
        }
        return org;
    }

    public static DynamicObject getAssetOrgByUser(DynamicObject user) {
        DynamicObject adminOrg = FaUserUtils.getAdminOrgByUser(user);
        if (adminOrg == null) {
            return null;
        }
        DynamicObject bizOrg = FaUserUtils.getBizOrg((Long)adminOrg.getPkValue(), "09");
        return bizOrg;
    }

    public static DynamicObject getAssetOrgByUserPkId(Object pkId) {
        DynamicObject user = FaBillDaoFactory.getInstance("bos_user").queryOne(pkId);
        return FaUserUtils.getAssetOrgByUser(user);
    }

    private static DynamicObject getBizOrg(Long childOrgId, String orgViewType) {
        OrgServiceHelper orgServiceHelper = new OrgServiceHelper();
        DynamicObject bizOrg = orgServiceHelper.getBizOrg(childOrgId, orgViewType);
        if (bizOrg != null) {
            return bizOrg;
        }
        List ids = OrgServiceHelper.getSuperiorOrgs((long)childOrgId);
        if (ids == null || ids.size() == 0) {
            return null;
        }
        Long parentOrgId = (Long)ids.get(0);
        if (parentOrgId == null || parentOrgId == 0L) {
            return null;
        }
        return FaUserUtils.getBizOrg(parentOrgId, orgViewType);
    }

    public static Map<Object, DynamicObject> getAdminOrgByUseIds(Collection<Object> useIds) {
        if (useIds == null || useIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, DynamicObject> useId2AdminOrg = new HashMap<Object, DynamicObject>(useIds.size());
        Map useId2Dy = BusinessDataServiceHelper.loadFromCache((Object[])useIds.toArray(), (String)"bos_user");
        for (DynamicObject value : useId2Dy.values()) {
            if (useId2AdminOrg.containsKey(value.getPkValue())) continue;
            useId2AdminOrg.put(value.getPkValue(), FaUserUtils.getAdminOrgByUser(value));
        }
        return useId2AdminOrg;
    }

    public static Object getAdminOrgByUse(Object usePk) {
        if (usePk == null) {
            return 0L;
        }
        DynamicObject adminOrg = FaUserUtils.getAdminOrgByUser(BusinessDataServiceHelper.loadSingleFromCache((Object)usePk, (String)"bos_user"));
        if (adminOrg != null) {
            return adminOrg.getPkValue();
        }
        return 0L;
    }
}

