/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.enums.assetpolicy.DevaluePolicy;
import kd.fi.fa.business.model.CompFieldsValuesPo;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.CompFieldsValuesUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaCurrencyUtil;
import kd.fi.fa.common.util.Tuple;

public class AssetDeValueValidator {
    private static final Log logger = LogFactory.getLog(AssetDeValueValidator.class);

    public static List<String> validateForSave(DynamicObject bill, Boolean enableSumMutilVoucher) {
        List<String> errorInfo = AssetDeValueValidator.validateMustInput(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("changebillentry");
        int entrySize = entry.size();
        if (entrySize == 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssetDeValueValidator_0", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        errorInfo = AssetDeValueValidator.validateRealCardNumberRepeat(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo = AssetDeValueValidator.validateChangeBusiness(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo = AssetDeValueValidator.validateAssetUniqueness(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo = AssetDeValueValidator.validateClearBusinessAndDevalueBizDate(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        String fuGenVouErrorInfo = AssetDeValueValidator.validateFutureRealChange(bill);
        if (fuGenVouErrorInfo != null) {
            errorInfo.add(fuGenVouErrorInfo);
        }
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        return Collections.emptyList();
    }

    private static List<String> validateRealCardNumberRepeat(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>();
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("changebillentry");
        HashSet<String> realCardNumbers = new HashSet<String>(entry.size());
        int rowIndex = 0;
        for (DynamicObject row : entry) {
            DynamicObject realCard = row.getDynamicObject("realcard");
            String realCardNumber = realCard.getString("number");
            boolean addRes = realCardNumbers.add(realCardNumber);
            if (!addRes) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u8d44\u4ea7\u7f16\u7801\u91cd\u590d\u3002", (String)"AssetDeValueValidator_1", (String)"fi-fa-business", (Object[])new Object[0]), rowIndex + 1));
            }
            ++rowIndex;
        }
        return errorInfo;
    }

    private static List<String> validateClearBusinessAndDevalueBizDate(DynamicObject bill) {
        DynamicObjectCollection depreAdjustClearRealCardIds;
        Set hasAdjustClearCardIds;
        String cardNumber;
        ArrayList<String> errorInfo = new ArrayList<String>();
        Object orgId = bill.getDynamicObject("org").getPkValue();
        Object depreUseId = bill.getDynamicObject("depreuse").getPkValue();
        DynamicObject devaluePeriod = bill.getDynamicObject("devalueperiod");
        Object devaluePeriodId = devaluePeriod.getPkValue();
        DynamicObjectCollection devalueEntry = bill.getDynamicObjectCollection("changebillentry");
        Set realCardIds = devalueEntry.stream().map(v -> v.getLong(Fa.id((String)"realcard"))).collect(Collectors.toSet());
        DynamicObjectCollection depreAdjustCardIds = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)Fa.dot((String[])new String[]{"entryentity", "realcard"}), (QFilter[])new QFilter[]{new QFilter("org", "=", orgId), new QFilter("depreuse", "=", depreUseId), new QFilter("period", "=", devaluePeriodId), new QFilter(Fa.dot((String[])new String[]{"entryentity", "realcard"}), "in", realCardIds)});
        Set hasDepreAdjustIds = depreAdjustCardIds.stream().map(v -> v.getLong(Fa.dot((String[])new String[]{"entryentity", "realcard"}))).collect(Collectors.toSet());
        if (!hasDepreAdjustIds.isEmpty()) {
            Date endDate = devaluePeriod.getDate("enddate");
            StringBuilder sb = new StringBuilder();
            for (Object entry : devalueEntry) {
                Date bizDate;
                long cardId = entry.getLong(Fa.id((String)"realcard"));
                if (!hasDepreAdjustIds.contains(cardId) || (bizDate = entry.getDate("bizdate")).compareTo(endDate) > 0) continue;
                cardNumber = entry.getDynamicObject("realcard").getString("number");
                sb.append("\u3001").append(cardNumber);
            }
            String cardNumbers = sb.toString();
            if (!cardNumbers.isEmpty()) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u3010%s\u3011\u5f53\u671f\u5b58\u5728\u6298\u65e7\u8c03\u6574\u5355\uff0c\u53ea\u80fd\u505a\u5f71\u54cd\u4e0b\u671f\u7684\u51cf\u503c\u5355\u3002", (String)"AssetDeValueValidator_2", (String)"fi-fa-business", (Object[])new Object[0]), cardNumbers.substring(1)));
            }
        }
        if (!(hasAdjustClearCardIds = (depreAdjustClearRealCardIds = QueryServiceHelper.query((String)"fa_clearbill", (String)Fa.dot((String[])new String[]{"detail_entry", "realcardmasterid"}), (QFilter[])new QFilter[]{new QFilter("org", "=", orgId), new QFilter("clearperiod", "=", devaluePeriodId), new QFilter(Fa.dot((String[])new String[]{"detail_entry", "depreuse"}), "=", depreUseId), new QFilter(Fa.dot((String[])new String[]{"detail_entry", "realcardmasterid"}), "in", realCardIds), new QFilter(Fa.dot((String[])new String[]{"detail_entry", "isadjustdepre"}), "=", (Object)true)})).stream().map(v -> v.getLong(Fa.dot((String[])new String[]{"detail_entry", "realcardmasterid"}))).collect(Collectors.toSet())).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject entry : devalueEntry) {
                long cardId = entry.getLong(Fa.id((String)"realcard"));
                if (!hasAdjustClearCardIds.contains(cardId)) continue;
                cardNumber = entry.getDynamicObject("realcard").getString("number");
                sb.append("\u3001").append(cardNumber);
            }
            String cardNumbers = sb.toString();
            if (!cardNumbers.isEmpty()) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u3010%s\u3011\u5f53\u671f\u5b58\u5728\u6298\u65e7\u8c03\u6574\u540e\u7684\u6e05\u7406\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u505a\u51cf\u503c\u3002", (String)"AssetDeValueValidator_3", (String)"fi-fa-business", (Object[])new Object[0]), cardNumbers.substring(1)));
            }
        }
        return errorInfo;
    }

    private static List<String> validateChangeBusiness(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>();
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("changebillentry");
        HashSet<String> cardNumberSet = new HashSet<String>(entry.size());
        for (DynamicObject cardEntry : entry) {
            DynamicObject realCard = cardEntry.getDynamicObject("realcard");
            String number = realCard.getString("number");
            cardNumberSet.add(number);
        }
        DynamicObject bizPeriod = bill.getDynamicObject("devalueperiod");
        Date beginDate = bizPeriod.getDate("begindate");
        Date endDate = bizPeriod.getDate("enddate");
        DynamicObjectCollection changeBillCards = QueryServiceHelper.query((String)"fa_change_dept", (String)"billno, realentry.realcard.number cardnumber", (QFilter[])new QFilter[]{new QFilter("realentry.finentry.isadjustdepre", "=", (Object)false), new QFilter("realentry.realcard.number", "in", cardNumberSet), new QFilter("realentry.finentry.depreuse.id", "=", (Object)bill.getLong("depreuse_id")), new QFilter("changedate", ">=", (Object)beginDate), new QFilter("changedate", "<=", (Object)endDate)});
        for (DynamicObject changeCard : changeBillCards) {
            String cardNumber = changeCard.getString("cardnumber");
            if (!cardNumberSet.contains(cardNumber)) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u5f53\u671f\u5b58\u5728\u8ffd\u6eaf\u8c03\u6574\u53d8\u66f4\u4e1a\u52a1\uff0c\u4e0d\u80fd\u8fdb\u884c\u51cf\u503c\u4e1a\u52a1\u3002", (String)"AssetDeValueValidator_4", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber));
        }
        return errorInfo;
    }

    public static List<String> validateForSubmit(DynamicObject bill, Boolean enableSumMutilVoucher) {
        boolean include;
        List<String> errorInfo = AssetDeValueValidator.validateForSave(bill, enableSumMutilVoucher);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo = AssetDeValueValidator.validateEntry(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo = AssetDeValueValidator.validateAssetUniqueness(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        String msg = null;
        if (enableSumMutilVoucher.booleanValue()) {
            include = false;
            msg = ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AssetDeValueValidator_5", (String)"fi-fa-business", (Object[])new Object[0]);
        } else {
            include = true;
            msg = ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AssetDeValueValidator_6", (String)"fi-fa-business", (Object[])new Object[0]);
        }
        if (FaDepreUtil.hasVoucher(bill.getDynamicObject("org").getLong("id"), bill.getDynamicObject("depreuse").getLong("id"), bill.getDynamicObject("devalueperiod").getLong("id"), include)) {
            errorInfo.add(msg);
        }
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        return Collections.emptyList();
    }

    public static List<String> validateForAudit(DynamicObject bill, Boolean enableSumMutilVoucher) {
        String fuGenVouErrorInfo;
        boolean include;
        List<String> errorInfo = AssetDeValueValidator.compareFieldValuesForAudit(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        String msg = null;
        if (enableSumMutilVoucher.booleanValue()) {
            include = false;
            msg = ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AssetDeValueValidator_5", (String)"fi-fa-business", (Object[])new Object[0]);
        } else {
            include = true;
            msg = ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AssetDeValueValidator_6", (String)"fi-fa-business", (Object[])new Object[0]);
        }
        if (FaDepreUtil.hasVoucher(bill.getDynamicObject("org").getLong("id"), bill.getDynamicObject("depreuse").getLong("id"), bill.getDynamicObject("devalueperiod").getLong("id"), include)) {
            errorInfo.add(msg);
        }
        if ((fuGenVouErrorInfo = AssetDeValueValidator.validateFutureRealChange(bill)) != null) {
            errorInfo.add(fuGenVouErrorInfo);
        }
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        return Collections.emptyList();
    }

    public static List<String> validateForUnAudit(DynamicObject bill, Boolean enableSumMutilVoucher) {
        String fuGenVouErrorInfo;
        boolean include;
        List realCards = bill.getDynamicObjectCollection("changebillentry").stream().map(v -> v.getDynamicObject("realcard")).collect(Collectors.toList());
        Set<Object> realCardIds = realCards.stream().map(v -> v.get("id")).collect(Collectors.toSet());
        Long orgId = bill.getLong("org.id");
        Optional<String> checkResult = new FutureBizChecker(bill.getPkValue(), (Object)orgId, realCardIds, bill.getDate("auditdate"), BusyTypeDetailEnum.FIN_CHG, (Long)bill.getLong("depreuse.id")).checkWhenun();
        if (checkResult.isPresent()) {
            ArrayList<String> resultList = new ArrayList<String>(1);
            String result = String.format(ResManager.loadKDString((String)"\u51cf\u503c\u5355\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s\u3002", (String)"AssetDeValueValidator_7", (String)"fi-fa-business", (Object[])new Object[0]), checkResult.get());
            resultList.add(result);
            return resultList;
        }
        List<String> errorInfo = AssetDeValueValidator.validatePeriodConsistency(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo = AssetDeValueValidator.validateCardBizFinish(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo = AssetDeValueValidator.compareFieldValuesForUnAudit(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        String msg = null;
        if (enableSumMutilVoucher.booleanValue()) {
            include = false;
            msg = ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AssetDeValueValidator_5", (String)"fi-fa-business", (Object[])new Object[0]);
        } else {
            include = true;
            msg = ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AssetDeValueValidator_6", (String)"fi-fa-business", (Object[])new Object[0]);
        }
        if (FaDepreUtil.hasVoucher(bill.getDynamicObject("org").getLong("id"), bill.getDynamicObject("depreuse").getLong("id"), bill.getDynamicObject("devalueperiod").getLong("id"), include)) {
            errorInfo.add(msg);
        }
        if ((fuGenVouErrorInfo = AssetDeValueValidator.validateFutureRealChange(bill)) != null) {
            errorInfo.add(fuGenVouErrorInfo);
        }
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        return Collections.emptyList();
    }

    public static List<String> validateForImport(DynamicObject bill, Boolean enableSumMutilVoucher) {
        List<String> errorInfo = AssetDeValueValidator.validateForSubmit(bill, enableSumMutilVoucher);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        return Collections.emptyList();
    }

    private static List<String> validateMustInput(DynamicObject bill) {
        DynamicObject deValuePeriod;
        DynamicObject depreUse;
        ArrayList<String> errorInfo = new ArrayList<String>();
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssetDeValueValidator_8", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((depreUse = bill.getDynamicObject("depreuse")) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssetDeValueValidator_9", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((deValuePeriod = bill.getDynamicObject("devalueperiod")) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u83b7\u53d6\u51cf\u503c\u671f\u95f4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8d44\u4ea7\u8d26\u7c3f\u662f\u5426\u542f\u7528\u3001\u662f\u5426\u7ef4\u62a4\u5f53\u524d\u671f\u95f4\u3002", (String)"AssetDeValueValidator_10", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("changebillentry");
        for (int i = 0; i < entry.size(); ++i) {
            int seq = i + 1;
            DynamicObject row = (DynamicObject)entry.get(i);
            DynamicObject realCard = row.getDynamicObject("realcard");
            if (realCard != null) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u8d44\u4ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssetDeValueValidator_11", (String)"fi-fa-business", (Object[])new Object[0]), seq));
        }
        return errorInfo;
    }

    private static List<String> validateAssetUniqueness(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>();
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject depreUse = bill.getDynamicObject("depreuse");
        DynamicObject deValuePeriod = bill.getDynamicObject("devalueperiod");
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("changebillentry");
        List realCards = entry.stream().map(v -> v.getDynamicObject("realcard")).collect(Collectors.toList());
        List realCardIds = realCards.stream().map(v -> v.getLong("id")).distinct().collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", depreUse.getPkValue()), new QFilter("devalueperiod", "=", deValuePeriod.getPkValue()), new QFilter("id", "!=", bill.getPkValue()), new QFilter(Fa.dot((String[])new String[]{"changebillentry", "realcard"}), "in", realCardIds)};
        DynamicObjectCollection deValueCard = QueryServiceHelper.query((String)"fa_asset_devalue", (String)"changebillentry.realcard", (QFilter[])filters);
        List exists = deValueCard.stream().map(v -> v.getLong("changebillentry.realcard")).distinct().collect(Collectors.toList());
        if (!exists.isEmpty()) {
            int seq = 1;
            for (Long realCardId : realCardIds) {
                if (exists.contains(realCardId)) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\u5df2\u5b58\u5728\u540c\u4e00\u671f\u95f4\u5176\u4ed6\u51cf\u503c\u5355\u3002", (String)"AssetDeValueValidator_12", (String)"fi-fa-business", (Object[])new Object[0]), seq));
                }
                ++seq;
            }
        }
        return errorInfo;
    }

    private static List<String> validateEntry(DynamicObject bill) {
        boolean hasInfluenceNext;
        ArrayList<String> errorInfo = new ArrayList<String>(5);
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("changebillentry");
        Tuple<String, Set<Object>> checkFutureResult = AssetDeValueValidator.checkFutureBiz(bill);
        Set hasFutureBizCardIds = Collections.EMPTY_SET;
        if (checkFutureResult != null) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff1a%s", (String)"AssetDeValueValidator_13", (String)"fi-fa-business", (Object[])new Object[0]), checkFutureResult.item1));
            hasFutureBizCardIds = (Set)checkFutureResult.item2;
        }
        DynamicObject assetBook = AssetDeValueValidator.queryAssetBook(bill);
        DynamicObject devaluePeriod = bill.getDynamicObject("devalueperiod");
        Set<String> needPredictCards = entry.stream().filter(row -> row.getDate("bizdate").compareTo(devaluePeriod.getDate("enddate")) > 0).map(row -> row.getDynamicObject("realcard").getString("number")).collect(Collectors.toSet());
        for (int i = 0; i < entry.size(); ++i) {
            int seq = i + 1;
            DynamicObject row2 = (DynamicObject)entry.get(i);
            DynamicObject realCard = row2.getDynamicObject("realcard");
            String bizStatus = realCard.getString("bizstatus");
            boolean fromDatabase = bill.getDataEntityState().getFromDatabase();
            if (!"READY".equals(bizStatus) && !fromDatabase) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u5361\u7247\u4e3a\u975e\u5c31\u7eea\u72b6\u6001\u3002", (String)"AssetDeValueValidator_14", (String)"fi-fa-business", (Object[])new Object[0]), seq));
                continue;
            }
            if (hasFutureBizCardIds.contains(realCard.getPkValue())) continue;
            List<String> rowErrorInfo = AssetDeValueValidator.validateEntryRow(seq, row2, assetBook, devaluePeriod);
            if (!rowErrorInfo.isEmpty()) {
                errorInfo.addAll(rowErrorInfo);
            }
            boolean bl = hasInfluenceNext = row2.getDate("bizdate").compareTo(devaluePeriod.getDate("enddate")) > 0;
            if (!hasInfluenceNext) continue;
            needPredictCards.add(realCard.getString("number"));
        }
        if (needPredictCards.size() > 0) {
            Map<String, Map<String, Map<String, Object>>> cardPredictData = new DailyDepreImpl(true, "fa_depreadjustbill", assetBook.getLong("org_id")).predictPeriodDepe(assetBook.getLong("org_id"), assetBook.getLong(Fa.id((String)"depreuse")), assetBook.getDynamicObject("curperiod"), false, false, needPredictCards);
            Map<String, Map<String, Object>> cardMap = cardPredictData.get(assetBook.getLong("org_id") + "_" + assetBook.getLong(Fa.id((String)"depreuse")) + "_" + assetBook.getLong(Fa.id((String)"curperiod")));
            for (int i = 0; i < entry.size(); ++i) {
                BigDecimal maxDevalue;
                int seq = i + 1;
                DynamicObject row3 = (DynamicObject)entry.get(i);
                DynamicObject realCard = row3.getDynamicObject("realcard");
                DynamicObject finCard = row3.getDynamicObject("fincard");
                if (hasFutureBizCardIds.contains(realCard.getPkValue())) continue;
                boolean bl = hasInfluenceNext = row3.getDate("bizdate").compareTo(devaluePeriod.getDate("enddate")) > 0;
                if (!hasInfluenceNext) continue;
                Map<String, Object> cardData = cardMap.get(realCard.getString("number"));
                BigDecimal finCardDevalue = finCard.getBigDecimal("decval");
                BigDecimal finCardOriginVal = finCard.getBigDecimal("originalval");
                BigDecimal finCardPreResidualVal = finCard.getBigDecimal("preresidualval");
                BigDecimal entryDevalue = row3.getBigDecimal("decval");
                BigDecimal predictaccumdepre = finCard.getBigDecimal("accumdepre");
                if (cardData != null) {
                    predictaccumdepre = (BigDecimal)cardData.get("accumdepre");
                }
                if (entryDevalue.compareTo(maxDevalue = finCardOriginVal.subtract(predictaccumdepre).subtract(finCardDevalue).subtract(finCardPreResidualVal)) <= 0) continue;
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%1$s\u884c\uff1a\u4e1a\u52a1\u65e5\u671f\u4e3a\u4e0b\u671f\uff0c\u672c\u671f\u53ef\u5f55\u5165\u6700\u5927\u53ef\u51cf\u503c\u91d1\u989d\u4e3a%2$s\u3002", (String)"AssetDeValueValidator_15", (String)"fi-fa-business", (Object[])new Object[0]), seq, maxDevalue));
            }
        }
        return errorInfo;
    }

    private static List<String> validateEntryRow(int seq, DynamicObject row, DynamicObject assetBook, DynamicObject devaluePeriod) {
        long devaluePeriodId;
        ArrayList<String> errorInfo = new ArrayList<String>();
        DynamicObject realCard = row.getDynamicObject("realcard");
        DynamicObject finCard = row.getDynamicObject("fincard");
        if (finCard == null) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u8d22\u52a1\u5361\u7247\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\u3002", (String)"AssetDeValueValidator_16", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            return errorInfo;
        }
        BigDecimal finCardDevalue = finCard.getBigDecimal("decval");
        BigDecimal finCardNetAmount = finCard.getBigDecimal("netamount");
        BigDecimal finCardPreResidualVal = finCard.getBigDecimal("preresidualval");
        BigDecimal monthDepre = finCard.getBigDecimal("monthdepre");
        BigDecimal entryDevalue = row.getBigDecimal("decval");
        DynamicObject baseCurrency = assetBook.getDynamicObject("basecurrency");
        DynamicObject policyEntry = AssetPolicyUtil.getByBookAndCat(assetBook.getPkValue(), realCard.get("assetcat_id"));
        String devaluePolicy = policyEntry.getString("decpolicy");
        boolean existHisDevalue = AssetDeValueValidator.existHisDevalue(realCard.getPkValue(), assetBook.getPkValue(), devaluePeriod.getPkValue());
        if (DevaluePolicy.NOT_DEVALUE.getValue().equals(devaluePolicy)) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u6839\u636e\u51cf\u503c\u653f\u7b56\uff0c\u8be5\u7c7b\u522b\u7684\u5361\u7247\u4e0d\u5141\u8bb8\u51cf\u503c\u3002", (String)"AssetDeValueValidator_17", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            return errorInfo;
        }
        if (DevaluePolicy.NOT_REVERSAL.getValue().equals(devaluePolicy) && entryDevalue.compareTo(BigDecimal.ZERO) < 0) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u6839\u636e\u51cf\u503c\u653f\u7b56\uff0c\u8be5\u7c7b\u522b\u7684\u5361\u7247\u4e0d\u5141\u8bb8\u8f6c\u56de\u3002", (String)"AssetDeValueValidator_18", (String)"fi-fa-business", (Object[])new Object[0]), seq));
        }
        if (DevaluePolicy.LESS_EQUALS_ACCUM_DEVALUE.getValue().equals(devaluePolicy) && entryDevalue.compareTo(BigDecimal.ZERO) < 0) {
            if (!existHisDevalue) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u6ca1\u6709\u5386\u53f2\u51cf\u503c\uff0c\u4e0d\u80fd\u8f6c\u56de\u3002", (String)"AssetDeValueValidator_19", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            } else if (finCardDevalue.add(entryDevalue).compareTo(BigDecimal.ZERO) < 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%1$s\u884c\uff1a\u6839\u636e\u51cf\u503c\u653f\u7b56\uff0c\u672c\u671f\u8f6c\u56de\u7684\u51cf\u503c\u4e0d\u80fd\u8d85\u8fc7%2$s\u3002", (String)"AssetDeValueValidator_20", (String)"fi-fa-business", (Object[])new Object[0]), seq, FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrency, (BigDecimal)finCardDevalue.abs())));
            }
        }
        if (DevaluePolicy.LESS_EQUALS_NET_WORTH.getValue().equals(devaluePolicy) && entryDevalue.compareTo(BigDecimal.ZERO) < 0) {
            if (!existHisDevalue) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u6ca1\u6709\u5386\u53f2\u51cf\u503c\uff0c\u4e0d\u80fd\u8f6c\u56de\u3002", (String)"AssetDeValueValidator_19", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            } else {
                BigDecimal preNetAmount;
                HashMap<Object, Object> cardMap = new HashMap<Object, Object>(4);
                Object firstDevaluePeriodId = AssetDeValueValidator.queryFirstDevaluePeriod(realCard.getPkValue(), devaluePeriod.getPkValue());
                cardMap.put(realCard.getLong("masterid"), firstDevaluePeriodId);
                DepreBook bookBox = new DepreBook(assetBook);
                Map<Object, BigDecimal> returnCardMap = bookBox.calcNetAmountWithoutDecval(cardMap);
                BigDecimal preNetAmountNoDevalue = returnCardMap.get(realCard.get("masterid"));
                long bizPeriodId = finCard.getLong("bizperiod_id");
                if (bizPeriodId == (Long)devaluePeriod.getPkValue()) {
                    String assetNumber = finCard.getString("number");
                    DynamicObject preFinCard = AssetDeValueValidator.queryPreFinCard(assetBook, bizPeriodId, assetNumber);
                    preNetAmount = preFinCard.getBigDecimal("netamount");
                } else {
                    preNetAmount = finCard.getBigDecimal("netamount");
                }
                BigDecimal devalueLimit = preNetAmountNoDevalue.subtract(preNetAmount);
                if (entryDevalue.abs().compareTo(devalueLimit.abs()) > 0) {
                    logger.info(String.format("\u8d22\u52a1\u5361\u7247\u7f16\u7801: %s, \u4e0a\u671f\u6ca1\u6709\u786e\u8ba4\u51cf\u503c\u635f\u5931\u65f6\u7684\u51c0\u989d: %s, \u4e0a\u671f\u786e\u8ba4\u4e86\u51cf\u503c\u635f\u5931\u7684\u51c0\u989d: %s, \u6309\u8d26\u9762\u51c0\u503c\u8ba1\u7b97\u7684\u6700\u9ad8\u9650\u989d: %s\u3002", finCard.getString("number"), preNetAmountNoDevalue, preNetAmount, devalueLimit));
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%1$s\u884c\uff1a\u6839\u636e\u51cf\u503c\u653f\u7b56\uff0c\u672c\u671f\u8f6c\u56de\u7684\u51cf\u503c\u4e0d\u80fd\u8d85\u8fc7%2$s\u3002", (String)"AssetDeValueValidator_20", (String)"fi-fa-business", (Object[])new Object[0]), seq, FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrency, (BigDecimal)devalueLimit.abs())));
                }
            }
        }
        if (entryDevalue.compareTo(BigDecimal.ZERO) == 0) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u672c\u671f\u51cf\u503c\u4e0d\u80fd\u4e3a0\u3002", (String)"AssetDeValueValidator_21", (String)"fi-fa-business", (Object[])new Object[0]), seq));
        }
        boolean hasInfluenceNext = row.getDate("bizdate").compareTo(devaluePeriod.getDate("enddate")) > 0;
        long cardBizPeriod = finCard.getLong("bizperiod_id");
        if (cardBizPeriod < (devaluePeriodId = devaluePeriod.getLong("id"))) {
            monthDepre = BigDecimal.ZERO;
        }
        if (!hasInfluenceNext && entryDevalue.add(finCardPreResidualVal).compareTo(finCardNetAmount.add(monthDepre)) > 0) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u672c\u671f\u51cf\u503c\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u51c0\u989d\u51cf\u51c0\u6b8b\u503c\u3002", (String)"AssetDeValueValidator_22", (String)"fi-fa-business", (Object[])new Object[0]), seq));
        }
        return errorInfo;
    }

    private static List<String> validatePeriodConsistency(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>();
        DynamicObject devaluePeriod = bill.getDynamicObject("devalueperiod");
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject depreUse = bill.getDynamicObject("depreuse");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", depreUse.getPkValue()), new QFilter("status", "=", (Object)BillStatus.C.toString())};
        DynamicObject assetBooks = FaAssetBookDaoFactory.getInstance().queryOne(filters);
        if (assetBooks == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u542f\u7528\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"AssetDeValueValidator_23", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        DynamicObject currentPeriod = assetBooks.getDynamicObject("curperiod");
        if (devaluePeriod.getLong("id") != currentPeriod.getLong("id")) {
            errorInfo.add(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u5f53\u671f\u7684\u51cf\u503c\u5355\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"AssetDeValueValidator_24", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static List<String> validateCardBizFinish(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>();
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("changebillentry");
        for (int i = 0; i < entry.size(); ++i) {
            int seq = i + 1;
            DynamicObject row = (DynamicObject)entry.get(i);
            DynamicObject realCard = row.getDynamicObject("realcard");
            String bizStatus = realCard.getString("bizstatus");
            if ("READY".equals(bizStatus)) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u5b9e\u7269\u5361\u7247\u4e3a\u975e\u5c31\u7eea\u72b6\u6001\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5b8c\u6210\u76f8\u5173\u4e1a\u52a1\u3002", (String)"AssetDeValueValidator_25", (String)"fi-fa-business", (Object[])new Object[0]), seq));
        }
        return errorInfo;
    }

    private static List<String> compareFieldValuesForAudit(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("changebillentry");
        for (DynamicObject entryEntity : entries) {
            String compfieldsv = entryEntity.getString("compfieldsv");
            CompFieldsValuesPo compFieldsValuesPo = CompFieldsValuesUtils.convert(compfieldsv);
            if (compFieldsValuesPo == null || !compFieldsValuesPo.getStyle().equals("S1")) continue;
            BigDecimal originalval = compFieldsValuesPo.getOriginalval();
            BigDecimal decval = compFieldsValuesPo.getDecval();
            BigDecimal preresidualval = compFieldsValuesPo.getPreresidualval();
            BigDecimal originalval_db = entryEntity.getBigDecimal("fincard.originalval");
            BigDecimal decval_db = entryEntity.getBigDecimal("fincard.decval");
            BigDecimal preresidualval_db = entryEntity.getBigDecimal("fincard.preresidualval");
            String number = entryEntity.getString("realcard.number");
            if (originalval.compareTo(originalval_db) != 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u51cf\u503c\u524d\u539f\u503c\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u539f\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\u3002", (String)"AssetDeValueValidator_26", (String)"fi-fa-business", (Object[])new Object[0]), number));
                continue;
            }
            if (preresidualval.compareTo(preresidualval_db) != 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u51cf\u503c\u524d\u6b8b\u503c\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u6b8b\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\u3002", (String)"AssetDeValueValidator_27", (String)"fi-fa-business", (Object[])new Object[0]), number));
                continue;
            }
            if (decval.compareTo(decval_db) == 0) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u51cf\u503c\u524d\u201c\u51cf\u503c\u51c6\u5907\u201d\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u201c\u51cf\u503c\u51c6\u5907\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\u3002", (String)"AssetDeValueValidator_28", (String)"fi-fa-business", (Object[])new Object[0]), number));
        }
        return errorInfo;
    }

    private static List<String> compareFieldValuesForUnAudit(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("changebillentry");
        for (DynamicObject entryEntity : entries) {
            String compfieldsv = entryEntity.getString("compfieldsv");
            CompFieldsValuesPo compFieldsValuesPo = CompFieldsValuesUtils.convert(compfieldsv);
            if (compFieldsValuesPo == null || !compFieldsValuesPo.getStyle().equals("S1")) continue;
            BigDecimal originalval = compFieldsValuesPo.getOriginalval();
            BigDecimal decval = compFieldsValuesPo.getDecval();
            BigDecimal preresidualval = compFieldsValuesPo.getPreresidualval();
            BigDecimal originalval_db = entryEntity.getBigDecimal("fincard.originalval");
            BigDecimal decval_db = entryEntity.getBigDecimal("fincard.decval");
            BigDecimal preresidualval_db = entryEntity.getBigDecimal("fincard.preresidualval");
            BigDecimal billDecval = entryEntity.getBigDecimal("decval");
            String number = entryEntity.getString("realcard.number");
            if (originalval.compareTo(originalval_db) != 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u51cf\u503c\u540e\u539f\u503c\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u539f\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\u3002", (String)"AssetDeValueValidator_29", (String)"fi-fa-business", (Object[])new Object[0]), number));
                continue;
            }
            if (preresidualval.compareTo(preresidualval_db) != 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u51cf\u503c\u540e\u6b8b\u503c\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u6b8b\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\u3002", (String)"AssetDeValueValidator_30", (String)"fi-fa-business", (Object[])new Object[0]), number));
                continue;
            }
            if (decval.compareTo(decval_db.subtract(billDecval)) == 0) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u51cf\u503c\u540e\u51cf\u503c\u51c6\u5907\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u51cf\u503c\u51c6\u5907\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\u3002", (String)"AssetDeValueValidator_31", (String)"fi-fa-business", (Object[])new Object[0]), number));
        }
        return errorInfo;
    }

    private static Tuple<String, Set<Object>> checkFutureBiz(DynamicObject bill) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("changebillentry");
        Set<Object> realCardIds = entry.stream().map(v -> v.getDynamicObject("realcard").getLong("id")).collect(Collectors.toSet());
        DynamicObject org = bill.getDynamicObject("org");
        Date bizDate = bill.getDate("businessdate");
        FutureBizChecker checker = new FutureBizChecker(null, org.getPkValue(), realCardIds, bizDate, BusyTypeDetailEnum.FIN_CHG, (Long)bill.getLong("depreuse.id"));
        Optional<String> futureCheckResult = checker.check();
        if (futureCheckResult.isPresent()) {
            Set<Object> hasFutureBizCardIds = checker.checkAndReturnRealCard();
            return new Tuple((Object)futureCheckResult.get(), hasFutureBizCardIds);
        }
        return null;
    }

    private static DynamicObject queryAssetBook(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject depreUse = bill.getDynamicObject("depreuse");
        return FaAssetBookDaoFactory.getInstance().queryOne(new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", depreUse.getPkValue()), new QFilter("status", "=", (Object)BillStatus.C.toString())});
    }

    private static boolean existHisDevalue(Object realCardId, Object assetBookId, Object devaluePeriodId) {
        QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "=", realCardId), new QFilter("assetbook", "=", assetBookId), new QFilter("bizperiod", "<=", devaluePeriodId), new QFilter("endperiod", ">", devaluePeriodId), new QFilter("decval", ">", (Object)0)};
        return QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])filters);
    }

    private static Object queryFirstDevaluePeriod(Object realCardId, Object devaluePeriodId) {
        String selectField = "devalueperiod";
        QFilter[] filters = new QFilter[]{new QFilter("changebillentry.realcard", "=", realCardId), new QFilter("devalueperiod", "<", devaluePeriodId)};
        String orderBy = "devalueperiod asc";
        DynamicObject[] devalue = BusinessDataServiceHelper.load((String)"fa_asset_devalue", (String)selectField, (QFilter[])filters, (String)orderBy);
        if (devalue.length == 0) {
            return null;
        }
        return devalue[0].getDynamicObject("devalueperiod").getPkValue();
    }

    private static DynamicObject queryPreFinCard(DynamicObject assetBook, Object bizPeriod, String assetNumber) {
        String selectField = "netamount";
        Long orgId = assetBook.getDynamicObject("org").getLong("id");
        Long depreUseId = assetBook.getDynamicObject("depreuse").getLong("id");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("endperiod", "=", bizPeriod), new QFilter("number", "=", (Object)assetNumber)};
        return QueryServiceHelper.queryOne((String)"fa_card_fin", (String)selectField, (QFilter[])filters);
    }

    public static String validateFutureRealChange(DynamicObject bill) {
        Long orgId2 = bill.getDynamicObject("org").getLong("id");
        DynamicObject assetBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg(orgId2);
        DynamicObject curPeriodDy = assetBook.getDynamicObject("curperiod");
        Date endDate = curPeriodDy.getDate("enddate");
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("changebillentry");
        HashMap<Long, String> realId2numberMap = new HashMap<Long, String>(1, 1.0f);
        for (DynamicObject entryDy : entry) {
            realId2numberMap.put(entryDy.getLong(Fa.id((String)"realcard")), entryDy.getString("realcard.number"));
        }
        Set<String> billNos = FaChangeBillUtil.getGenVoucherChangeBillNo(orgId2, endDate, realId2numberMap.keySet());
        if (billNos != null && billNos.size() > 0) {
            String errorInfo = String.format(ResManager.loadKDString((String)"\u5361\u7247\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u53d8\u66f4\u5355%s\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"AssetDeValueValidator_32", (String)"fi-fa-business", (Object[])new Object[0]), billNos.toString());
            return errorInfo;
        }
        Set<String> billNumbers = FaChangeBillUtil.checkhaveFutureRealChangeBill(orgId2, endDate, realId2numberMap);
        if (billNumbers != null && billNumbers.size() > 0) {
            String errorInfo = String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801%s\u5b58\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\uff0c\u5f00\u542f\"\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\"\u76f8\u5e94\u53c2\u6570\u6216\u5220\u9664\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u3002", (String)"AssetDeValueValidator_33", (String)"fi-fa-business", (Object[])new Object[0]), billNumbers.toString());
            return errorInfo;
        }
        return null;
    }
}

