/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;

public class SourceFlagDataAssetValidator
extends AbstractValidator {
    private final String entryName;
    private final String realCard;
    private final String entryRealCard;

    public SourceFlagDataAssetValidator(String entryName, String realCard, String realCardFieldName) {
        this.entryName = entryName;
        this.realCard = realCard;
        this.entryRealCard = realCardFieldName;
    }

    public void validate() {
        QFilter sourceFlagFilter;
        QFilter idFilter;
        String selector;
        DynamicObjectCollection realCards;
        ArrayList realCardIdList = new ArrayList(16);
        HashMap<ExtendedDataEntity, List> entityMap = new HashMap<ExtendedDataEntity, List>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDataEntity().getDynamicObjectCollection(this.entryName);
            ArrayList<Long> realCardIds = new ArrayList<Long>(16);
            if (!StringUtils.isEmpty((String)this.realCard)) {
                if (dataEntity.getDataEntity().getDynamicObject(this.realCard) == null) continue;
                realCardIds.add(dataEntity.getDataEntity().getDynamicObject(this.realCard).getLong("id"));
            }
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (null == dynamicObject.getDynamicObject(this.entryRealCard)) continue;
                realCardIds.add(dynamicObject.getDynamicObject(this.entryRealCard).getLong("masterid"));
            }
            entityMap.put(dataEntity, realCardIds);
            realCardIdList.addAll(realCardIds);
        }
        if (!CollectionUtils.isEmpty(realCardIdList) && (realCards = QueryServiceHelper.query((String)"fa_card_real", (String)(selector = "id,number"), (QFilter[])new QFilter[]{idFilter = new QFilter("id", "in", realCardIdList), sourceFlagFilter = new QFilter("sourceflag", "=", (Object)SourceFlagEnum.DATAASSET.name())})) != null && realCards.size() > 0) {
            HashMap<Long, String> realCardMap = new HashMap<Long, String>(realCards.size());
            for (DynamicObject dynamicObject : realCards) {
                realCardMap.put(Long.parseLong(dynamicObject.get("id").toString()), dynamicObject.getString("number"));
            }
            entityMap.forEach((k, v) -> {
                for (Long realCardId : v) {
                    if (!realCardMap.containsKey(realCardId)) continue;
                    this.addErrorMessage((ExtendedDataEntity)k, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%s]\u5efa\u5361\u65b9\u5f0f\u4e3a\u3010\u6570\u636e\u5361\u7247\u3011\uff0c\u4e0d\u652f\u6301\u505a\u8be5\u4e1a\u52a1\u3002", (String)"SourceFlagDataAssetValidator_0", (String)"fi-fa-business", (Object[])new Object[0]), realCardMap.get(realCardId)));
                }
            });
        }
    }
}

