/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator.lease;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.enums.lease.InterestAmortizeSchema;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.enums.lease.LeaseContractRentSettleStatus;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.enums.lease.PayFrequency;
import kd.fi.fa.business.lease.LeaseContractCal;
import kd.fi.fa.business.lease.LeaseFutureBizChecker;
import kd.fi.fa.business.lease.model.PayRuleCompareResult;
import kd.fi.fa.business.lease.utils.LeaseChangeUtil;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.business.validator.lease.LeaseContractValidator;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class LeaseChangeBillValidator {
    private static final Log logger = LogFactory.getLog(LeaseChangeBillValidator.class);
    private static final Set<String> EFFECTIVE_FIN_ITEMS = new HashSet<String>(){
        {
            this.add("payruleentryentity");
            this.add("leaseenddate");
            this.add("discountrate");
            this.add("leaser");
        }
    };

    public static List<String> validate4Save(DynamicObject bill) {
        DynamicObject leaseContract;
        ArrayList<String> errorInfo = new ArrayList<String>(2);
        String billNo = bill.getString("billno");
        if (StringUtils.isBlank((CharSequence)billNo)) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7f16\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseChangeBillValidator_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((leaseContract = bill.getDynamicObject("leasecontract")) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u539f\u5408\u540c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseChangeBillValidator_1", (String)"fi-fa-business", (Object[])new Object[0]));
        } else {
            String bizStatus = leaseContract.getString("bizstatus");
            boolean fromDatabase = bill.getDataEntityState().getFromDatabase();
            if (!fromDatabase && !LeaseContractBizStatus.A.name().equals(bizStatus)) {
                errorInfo.add(ResManager.loadKDString((String)"\u201c\u539f\u5408\u540c\u201d\u4e1a\u52a1\u72b6\u6001\u4e0d\u662f\u201c\u6b63\u5e38\u201d\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LeaseChangeBillValidator_2", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
        DynamicObjectCollection changeItems = bill.getDynamicObjectCollection("changeitems");
        if (changeItems.isEmpty()) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u9879\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseChangeBillValidator_3", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        LeaseChangeBillValidator.vadateChangeItemInDbIsChanged(bill, errorInfo);
        return errorInfo;
    }

    private static void vadateChangeItemInDbIsChanged(DynamicObject bill, List<String> errorInfo) {
        if (bill == null) {
            return;
        }
        Object id = bill.getPkValue();
        if (id == null || (Long)id == 0L) {
            return;
        }
        boolean isExistedBill = QueryServiceHelper.exists((String)"fa_lease_change_bill", (Object)id);
        if (!isExistedBill) {
            return;
        }
        DynamicObject changeBillInDb = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fa_lease_change_bill", (String)"changeitems");
        HashSet<Object> itemsSetInDb = new HashSet<Object>(8);
        DynamicObjectCollection itemsInDb = changeBillInDb.getDynamicObjectCollection("changeitems");
        for (DynamicObject items1 : itemsInDb) {
            DynamicObject item = items1.getDynamicObject("fbasedataid");
            itemsSetInDb.add(item.getPkValue());
        }
        DynamicObjectCollection items = bill.getDynamicObjectCollection("changeitems");
        HashSet<Object> itemsSet = new HashSet<Object>(8);
        for (DynamicObject item1 : items) {
            DynamicObject item = item1.getDynamicObject("fbasedataid");
            itemsSet.add(item.getPkValue());
        }
        itemsSetInDb.removeAll(itemsSet);
        if (itemsSetInDb.size() > 0) {
            Map changItemsDyMap = BusinessDataServiceHelper.loadFromCache((Object[])itemsSetInDb.toArray(new Object[1]), (String)"fa_change_item");
            Set alsterSet = changItemsDyMap.values().stream().map(t -> t.getString("name")).collect(Collectors.toSet());
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58\u7684\u53d8\u66f4\u5355\u4e0d\u80fd\u5220\u9664\u53d8\u66f4\u9879%1$s\u3002", (String)"LeaseChangeBillValidator_4", (String)"fi-fa-business", (Object[])new Object[0]), alsterSet.toString()));
        }
    }

    public static List<String> validate4Submit(DynamicObject bill, DynamicObject aftContract, DynamicObject oriLeaseContract) {
        List<String> errorInfo = LeaseChangeBillValidator.validate4Save(bill);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        if (aftContract == null) {
            aftContract = bill.getDynamicObject("changebakcontract");
            aftContract = LeaseChangeBillValidator.reloadContractFromCache(aftContract.getPkValue());
        }
        errorInfo.addAll(LeaseChangeBillValidator.checkLeaseInitEnable(bill));
        errorInfo.addAll(LeaseChangeBillValidator.checkLeaseContactAllowsChange(bill));
        errorInfo.addAll(LeaseChangeBillValidator.checkContractChangeInfo(bill, aftContract, oriLeaseContract));
        errorInfo.addAll(LeaseChangeBillValidator.checkForFinChanged(bill));
        errorInfo.addAll(LeaseChangeBillValidator.checkAmortizationPeriodIsNull(bill));
        errorInfo.addAll(LeaseChangeBillValidator.checkAmortizeDateAftEffectiveDate(bill));
        return errorInfo;
    }

    public static List<String> validate4Audit(DynamicObject bill) {
        List<String> errorInfo = LeaseChangeBillValidator.checkLeaseInitEnable(bill);
        errorInfo.addAll(LeaseChangeBillValidator.checkForFinChanged(bill));
        return errorInfo;
    }

    public static List<String> validate4Push(DynamicObject bill) {
        DynamicObject mainBookNext;
        DynamicObject aftContract;
        Long orgId;
        DynamicObject mainBookByOrg;
        ArrayList<String> errorInfo = new ArrayList<String>(8);
        String leaseChangeBillNo = bill.getString("billno");
        String billStatus = bill.getString("billstatus");
        if (!"C".equals(billStatus)) {
            return errorInfo;
        }
        String pushStatus = bill.getString("pushstatus");
        if ("C".equals(pushStatus)) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u5b58\u5728\u5173\u8054\u5355\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u4e0b\u63a8\u3002", (String)"LeaseChangeBillValidator_5", (String)"fi-fa-business", (Object[])new Object[0]), leaseChangeBillNo));
            return errorInfo;
        }
        if ("B".equals(pushStatus)) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u4e0b\u63a8\u6807\u8bc6\u4e3a\u65e0\u9700\u4e0b\u63a8\uff0c\u4e0d\u80fd\u4e0b\u63a8\u3002", (String)"LeaseChangeBillValidator_6", (String)"fi-fa-business", (Object[])new Object[0]), leaseChangeBillNo));
            return errorInfo;
        }
        long leaseContractId = bill.getLong(Fa.id((String)"leasecontract"));
        Date effectiveDate = bill.getDate("effectivedate");
        Date audiDate = bill.getDate("auditdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("leasecontract", "=", (Object)leaseContractId), new QFilter("auditdate", "<", (Object)audiDate), new QFilter("pushstatus", "=", (Object)"A")};
        boolean existsNeedPush = QueryServiceHelper.exists((String)"fa_lease_change_bill", (QFilter[])qFilters);
        if (existsNeedPush) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u5bf9\u5e94\u7684\u5408\u540c\u5b58\u5728\u5386\u53f2\u53d8\u66f4\u751f\u6548\u7684\u79df\u8d41\u53d8\u66f4\u5355\u672a\u4e0b\u63a8\u3002", (String)"LeaseChangeBillValidator_7", (String)"fi-fa-business", (Object[])new Object[0]), leaseChangeBillNo));
        }
        if ((mainBookByOrg = FaUtils.getMainBookByOrg(orgId = Long.valueOf((aftContract = bill.getDynamicObject("aftcontract")).getLong(Fa.id((String)"org"))))) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u7684\u4e3b\u8d26\u7c3f\u3002", (String)"LeaseChangeBillValidator_8", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        if ("B".equals(mainBookByOrg.get("status"))) {
            errorInfo.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u7684\u4e3b\u8d26\u7c3f\u672a\u542f\u7528\u3002", (String)"LeaseChangeBillValidator_9", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        Long periodId = mainBookByOrg.getLong("curperiod");
        if (periodId > 0L) {
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
            long leaseContractMasterId = aftContract.getLong("masterid");
            DynamicObject realCard = QueryServiceHelper.queryOne((String)"fa_card_real", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("isbak", "in", (Object)false), new QFilter("srcbillid", "=", (Object)leaseContractMasterId)});
            if (realCard == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c\u5173\u8054\u7684\u8d44\u4ea7\u5361\u7247\u4e22\u5931\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LeaseChangeBillValidator_10", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            Long masterId = realCard.getLong("masterid");
            Date endDate = period.getDate("enddate");
            QFilter[] qFinFilter = new QFilter[]{new QFilter("finaccountdate", ">", (Object)endDate), new QFilter("realcardmasterid", "=", (Object)masterId)};
            boolean exists = QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])qFinFilter);
            if (exists) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u5361\u7247\uff0c\u4e0d\u80fd\u4e0b\u63a8\u3002", (String)"LeaseChangeBillValidator_11", (String)"fi-fa-business", (Object[])new Object[0]), leaseChangeBillNo));
                return errorInfo;
            }
        }
        if ((mainBookNext = FaBizUtils.queryNeighborPeriod(periodId, 1)) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e3b\u8d26\u7c3f\u7684\u4e0b\u4e00\u671f\u95f4\uff0c\u8bf7\u5148\u7ef4\u62a4\u671f\u95f4\u6570\u636e\u3002", (String)"LeaseChangeBillValidator_12", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        Date mainBookEndDateNext = mainBookNext.getDate("enddate");
        if (mainBookEndDateNext.before(effectiveDate)) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u53d8\u66f4\u751f\u6548\u65e5\u8d85\u8fc7\u4e3b\u8d26\u7c3f\u7684\u4e0b\u671f\u7ed3\u675f\u65e5\uff0c\u4e0d\u80fd\u4e0b\u63a8\u3002", (String)"LeaseChangeBillValidator_13", (String)"fi-fa-business", (Object[])new Object[0]), leaseChangeBillNo));
        }
        return errorInfo;
    }

    public static List<String> validate4UnAudit(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(4);
        if (!LeaseChangeBillValidator.checkContractBizStatus(bill)) {
            errorInfo.add(ResManager.loadKDString((String)"\u5408\u540c\u4e1a\u52a1\u72b6\u6001\u4e0d\u662f\u201c\u6b63\u5e38\u201d\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LeaseChangeBillValidator_14", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (LeaseChangeBillValidator.checkLeaseChangeBillIsPush(bill)) {
            errorInfo.add(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LeaseChangeBillValidator_15", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (LeaseChangeBillValidator.isEffectiveFinInfo(bill)) {
            if (LeaseChangeBillValidator.checkRentSettleHasVoucherAfterAmortizationDate(bill)) {
                errorInfo.add(ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u540e\u644a\u9500\u4e0e\u8ba1\u606f\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LeaseChangeBillValidator_16", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            errorInfo.addAll(LeaseChangeBillValidator.checkPayPlanIsPushOrPaid(bill));
        }
        if (LeaseChangeBillValidator.checkFutureLeaseChange(bill)) {
            errorInfo.add(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u672a\u6765\u751f\u6548\u7684\u79df\u8d41\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LeaseChangeBillValidator_17", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static List<String> checkLeaseContactAllowsChange(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(8);
        errorInfo.addAll(LeaseChangeBillValidator.checkEffectiveDateRange(bill));
        errorInfo.addAll(LeaseChangeBillValidator.checkChangeItems(bill));
        if (LeaseChangeBillValidator.checkFutureLeaseChange(bill)) {
            errorInfo.add(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f53\u5929\u6216\u672a\u6765\u751f\u6548\u7684\u79df\u8d41\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LeaseChangeBillValidator_18", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        errorInfo.addAll(LeaseChangeBillValidator.checkContractIsPushAndCardStatus(bill));
        return errorInfo;
    }

    private static List<String> checkContractChangeInfo(DynamicObject bill, DynamicObject aftContract, DynamicObject oriLeaseContract) {
        List<String> contractSubmitValidateResult;
        ArrayList<String> errorInfo = new ArrayList<String>(8);
        if (LeaseChangeBillValidator.checkIsExemptChanged(bill, aftContract)) {
            errorInfo.add(ResManager.loadKDString((String)"\u5408\u540c\u662f\u5426\u8c41\u514d\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LeaseChangeBillValidator_19", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (LeaseChangeBillValidator.checkExemptPropertyError(aftContract, oriLeaseContract)) {
            errorInfo.add(ResManager.loadKDString((String)"\u539f\u5408\u540c\u4e3a\u8c41\u514d\u5408\u540c\uff0c\u4e0d\u80fd\u53d8\u66f4\u4e3a\u9002\u7528\u79df\u8d41\u671f(\u6708)\u5927\u4e8e12\u4e2a\u6708\u3002", (String)"LeaseChangeBillValidator_43", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (!(contractSubmitValidateResult = LeaseContractValidator.validateContractForSubmit(aftContract)).isEmpty()) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u7684\u5408\u540c\u4fe1\u606f\u5b58\u5728\u4ee5\u4e0b\u95ee\u9898\uff0c\u8bf7\u4fee\u6539\uff1a%s", (String)"LeaseChangeBillValidator_20", (String)"fi-fa-business", (Object[])new Object[0]), String.join((CharSequence)"", contractSubmitValidateResult)));
        } else {
            DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
            String rentStatus = leaseContract.getString("rentsettlestatus");
            if (LeaseContractRentSettleStatus.A.name().equals(rentStatus)) {
                errorInfo.add(ResManager.loadKDString((String)"\u5408\u540c\u672a\u8ba1\u606f\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LeaseChangeBillValidator_21", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (LeaseChangeUtil.isEffectPayPlan(bill)) {
                LeaseUtil.generatePayPlan4Chg(aftContract, oriLeaseContract);
                LeaseUtil.calLeaseContractAmount4Submit(aftContract);
                errorInfo.addAll(LeaseChangeBillValidator.isPayRuleChangedBeforeEffectiveDate(bill, aftContract, oriLeaseContract));
                errorInfo.addAll(LeaseChangeBillValidator.checkRentSettleStatusChanged(bill, aftContract));
            }
            errorInfo.addAll(LeaseChangeBillValidator.checkHasChanged(bill, aftContract));
        }
        return errorInfo;
    }

    private static List<String> checkForFinChanged(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(4);
        if (!LeaseChangeBillValidator.isEffectiveFinInfo(bill)) {
            return errorInfo;
        }
        errorInfo.addAll(LeaseChangeBillValidator.checkRentSettleHasVoucher4Submit(bill));
        errorInfo.addAll(LeaseChangeBillValidator.checkPayPlanIsPushOrPaid(bill));
        return errorInfo;
    }

    private static boolean isEffectiveFinInfo(DynamicObject bill) {
        Set<String> changeFields = LeaseChangeUtil.getChangeFields(bill);
        changeFields.retainAll(EFFECTIVE_FIN_ITEMS);
        return !changeFields.isEmpty();
    }

    private static List<String> checkAmortizeDateAftEffectiveDate(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        Date effectiveDate = bill.getDate("effectivedate");
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        leaseContract = BusinessDataServiceHelper.loadSingleFromCache((Object)leaseContract.getPkValue(), (String)"fa_lease_contract");
        DynamicObject org = leaseContract.getDynamicObject("org");
        String interestAmortizeSchema = SystemParamHelper.getStringParam("interest_amortize_schema", (Long)org.getPkValue(), InterestAmortizeSchema.A.name());
        if (InterestAmortizeSchema.A.name().equals(interestAmortizeSchema)) {
            return errorInfo;
        }
        ArrayList<Date> payDateList = new ArrayList<Date>();
        DynamicObjectCollection payPlanEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        for (DynamicObject row : payPlanEntry) {
            DynamicObject payItem;
            String acctClass;
            Date planPayDate = row.getDate("planpaydate");
            if (DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) >= 0 || !"A".equals(acctClass = (payItem = row.getDynamicObject("plan_payitem")).getString("accountingclass"))) continue;
            Date planStartDate = row.getDate("plan_startdate");
            Date planEndDate = row.getDate("plan_enddate");
            DynamicObject payRuleRow = LeaseUtil.getPayRuleRow(leaseContract, payItem.getLong("id"), planStartDate);
            String frequency = payRuleRow.getString("frequency");
            if (PayFrequency.F.name().equals(frequency)) continue;
            String payPoint = payRuleRow.getString("paypoint");
            int relativePayDate = payRuleRow.getInt("relativepaydate");
            Date startDate = planStartDate;
            while (DateUtil.compareDate((Date)startDate, (Date)planEndDate) <= 0) {
                Date endDate = DateUtil.addNaturalMonth((Date)startDate, (int)1);
                if (DateUtil.compareDate((Date)(endDate = DateUtil.addDay((Date)endDate, (int)-1)), (Date)planEndDate) > 0) {
                    endDate = planEndDate;
                }
                Date payDate = LeaseUtil.calPlanPayDate(startDate, endDate, payPoint, relativePayDate);
                startDate = DateUtil.addDay((Date)endDate, (int)1);
                if (DateUtil.compareDate((Date)payDate, (Date)effectiveDate) < 0) continue;
                payDateList.add(payDate);
            }
        }
        if (!payDateList.isEmpty()) {
            Date lastAmortizeDate = (Date)payDateList.stream().max(DateUtil::compareDate).get();
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u5212\u4ed8\u6b3e\u65e5\u5728\u53d8\u66f4\u751f\u6548\u65e5\u4e4b\u524d\uff0c\u4f46\u644a\u9500\u5230\u53d8\u66f4\u751f\u6548\u65e5\u4e4b\u540e\u7684\u4ed8\u6b3e\u8ba1\u5212\uff0c\u8bf7\u8c03\u6574\u53d8\u66f4\u751f\u6548\u65e5\u5230[%s]\u4e4b\u540e\u3002", (String)"LeaseChangeBillValidator_22", (String)"fi-fa-business", (Object[])new Object[0]), DateUtil.getShortDate().format(lastAmortizeDate)));
        }
        return errorInfo;
    }

    private static List<String> checkLeaseInitEnable(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        DynamicObject leaseInit = LeaseChangeBillValidator.getLeaseInitFromCache(bill);
        if (leaseInit == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u7684\u79df\u8d41\u521d\u59cb\u5316\u3002", (String)"LeaseChangeBillValidator_23", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        String status = leaseInit.getString("status");
        boolean enable = leaseInit.getBoolean("enable");
        if (!BillStatus.C.name().equals(status) || !enable) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u6838\u7b97\u7ec4\u7ec7\u7684\u79df\u8d41\u521d\u59cb\u5316\u3002", (String)"LeaseChangeBillValidator_24", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static List<String> checkEffectiveDateRange(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        String sourceType = leaseContract.getString("sourcetype");
        Date sysSwitchDate = leaseContract.getDate("sysswitchdate");
        Date initConfirmDate = leaseContract.getDate("initconfirmdate");
        Date leaseEndDate = leaseContract.getDate("leaseenddate");
        Date effectiveDate = bill.getDate("effectivedate");
        if (LeaseContractSourceType.A.name().equals(sourceType)) {
            if (effectiveDate.compareTo(initConfirmDate) < 0 || effectiveDate.compareTo(leaseEndDate) > 0) {
                errorInfo.add(ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u751f\u6548\u65e5\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u539f\u5408\u540c\u201c\u521d\u59cb\u786e\u8ba4\u65e5\u201d\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u539f\u5408\u540c\u201c\u79df\u8d41\u7ed3\u675f\u65e5\u201d\u3002", (String)"LeaseChangeBillValidator_25", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        } else if (effectiveDate.compareTo(sysSwitchDate) < 0 || effectiveDate.compareTo(leaseEndDate) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u751f\u6548\u65e5\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u539f\u5408\u540c\u201c\u7cfb\u7edf\u5207\u6362\u65e5\u201d\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u539f\u5408\u540c\u201c\u79df\u8d41\u7ed3\u675f\u65e5\u201d\u3002", (String)"LeaseChangeBillValidator_26", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static List<String> checkChangeItems(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        boolean isExempt = leaseContract.getBoolean("isexempt");
        Set<String> changeFields = LeaseChangeUtil.getChangeFields(bill);
        if (isExempt && changeFields.contains("discountrate")) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u53d8\u66f4\u5e74\u6298\u73b0\u7387\u3002", (String)"LeaseChangeBillValidator_27", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static boolean checkFutureLeaseChange(DynamicObject bill) {
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        Date effectiveDate = bill.getDate("effectivedate");
        return LeaseFutureBizChecker.existFutureLeaseChangeBill(bill.getPkValue(), leaseContract.getPkValue(), effectiveDate);
    }

    private static List<String> checkContractIsPushAndCardStatus(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        boolean isExempt = leaseContract.getBoolean("isexempt");
        if (isExempt) {
            return errorInfo;
        }
        QFilter[] realCardFilters = new QFilter[]{new QFilter("srcbillid", "=", leaseContract.getPkValue()), new QFilter("isbak", "=", (Object)Boolean.FALSE)};
        DynamicObject realCard = QueryServiceHelper.queryOne((String)"fa_card_real", (String)"id", (QFilter[])realCardFilters);
        if (realCard == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u5408\u540c\u672a\u4e0b\u63a8\u751f\u6210\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LeaseChangeBillValidator_28", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        QFilter finCardFilter = new QFilter("realcard", "=", (Object)realCard.getLong("id"));
        DynamicObject finCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)"billstatus", (QFilter[])finCardFilter.toArray());
        if (finCard == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u5408\u540c\u4e0b\u63a8\u7684\u5b9e\u7269\u5361\u7247\u672a\u751f\u6210\u8d22\u52a1\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LeaseChangeBillValidator_29", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        String billStatus = finCard.getString("billstatus");
        if (!BillStatus.C.name().equals(billStatus)) {
            errorInfo.add(ResManager.loadKDString((String)"\u5408\u540c\u4e0b\u63a8\u7684\u8d22\u52a1\u5361\u7247\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LeaseChangeBillValidator_30", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        return errorInfo;
    }

    private static boolean checkIsExemptChanged(DynamicObject bill, DynamicObject aftContract) {
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        boolean isExempt = leaseContract.getBoolean("isexempt");
        boolean aftIsExempt = aftContract.getBoolean("isexempt");
        return isExempt ^ aftIsExempt;
    }

    private static List<String> checkHasChanged(DynamicObject bill, DynamicObject aftContract) {
        Date effectiveDate;
        PayRuleCompareResult compareResult;
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        leaseContract = LeaseChangeBillValidator.reloadContractFromCache(leaseContract.getPkValue());
        Set<String> changeFields = LeaseChangeUtil.getChangeFields(bill);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"fa_lease_contract");
        ArrayList<String> noChangedFields = new ArrayList<String>(changeFields.size());
        for (String field : changeFields) {
            DynamicProperty property = entityType.getProperty(field);
            if (property instanceof EntryProp) continue;
            boolean isDiff = false;
            if (property instanceof DateProp) {
                Date aftDate;
                Date befDate = leaseContract.getDate(field);
                isDiff = DateUtil.compareDate((Date)befDate, (Date)(aftDate = aftContract.getDate(field))) == 0;
            } else if (property instanceof BasedataProp) {
                long aftPropId;
                long befPropId = leaseContract.getLong(field + "_id");
                isDiff = befPropId == (aftPropId = aftContract.getLong(field + "_id"));
            } else if (property instanceof TextProp) {
                String befString = leaseContract.getString(field);
                String aftString = aftContract.getString(field);
                isDiff = Objects.equals(befString, aftString);
            } else if (property instanceof DecimalProp) {
                BigDecimal befDecimal = leaseContract.getBigDecimal(field);
                befDecimal = befDecimal == null ? BigDecimal.ZERO : befDecimal;
                BigDecimal aftDecimal = aftContract.getBigDecimal(field);
                aftDecimal = aftDecimal == null ? BigDecimal.ZERO : aftDecimal;
                isDiff = befDecimal.compareTo(aftDecimal) == 0;
            } else if (property instanceof LongProp) {
                long aft;
                long bef = leaseContract.getLong(field);
                boolean bl = isDiff = bef == (aft = aftContract.getLong(field));
            }
            if (!isDiff) continue;
            noChangedFields.add(property.getDisplayName().getLocaleValue());
        }
        if (changeFields.contains("payruleentryentity") && (compareResult = LeaseChangeUtil.comparePayRule(leaseContract, aftContract, effectiveDate = bill.getDate("effectivedate"))).getChangedPayItemIds().isEmpty()) {
            noChangedFields.add(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219", (String)"LeaseChangeBillValidator_31", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (!noChangedFields.isEmpty()) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d8\u66f4\u9879\u6ca1\u6709\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u4fee\u6539\u5bf9\u5e94\u7684\u5b57\u6bb5\u6216\u79fb\u9664\u8be5\u53d8\u66f4\u9879\uff1a%s\u3002", (String)"LeaseChangeBillValidator_32", (String)"fi-fa-business", (Object[])new Object[0]), String.join((CharSequence)", ", noChangedFields)));
        }
        return errorInfo;
    }

    private static List<String> isPayRuleChangedBeforeEffectiveDate(DynamicObject bill, DynamicObject aftContract, DynamicObject oriLeaseContract) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        Date effectiveDate = bill.getDate("effectivedate");
        PayRuleCompareResult compareResult = LeaseChangeUtil.comparePayRule(oriLeaseContract, aftContract, effectiveDate);
        if (compareResult.isChangedBeforeEffective()) {
            Set<String> planNumberSet = compareResult.getChangedPlanNumberBeforeEffective();
            String planNumbers = planNumberSet.stream().sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u4e4b\u524d\u7684\u4ed8\u6b3e\u89c4\u5219\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\uff0c\u8bf7\u6838\u5bf9\u5177\u4f53\u7684\u4ed8\u6b3e\u8ba1\u5212\uff1a%s\u3002", (String)"LeaseChangeBillValidator_33", (String)"fi-fa-business", (Object[])new Object[0]), planNumbers));
        }
        return errorInfo;
    }

    private static List<String> checkRentSettleStatusChanged(DynamicObject bill, DynamicObject aftContract) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        leaseContract = LeaseChangeBillValidator.reloadContractFromCache(leaseContract.getPkValue());
        boolean befNeedRentSettle = LeaseUtil.isNeedRentSettle(leaseContract);
        boolean aftNeedRentSettle = LeaseUtil.isNeedRentSettle(aftContract);
        if (befNeedRentSettle && !aftNeedRentSettle) {
            errorInfo.add(ResManager.loadKDString((String)"\u53d8\u66f4\u524d\u5408\u540c\u9700\u8981\u8ba1\u606f\uff0c\u4e0d\u80fd\u53d8\u66f4\u4e3a\u65e0\u9700\u8ba1\u606f\u7684\u5408\u540c\u3002", (String)"LeaseChangeBillValidator_34", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static List<String> checkRentSettleHasVoucher4Submit(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        DynamicObject leaseInit = LeaseChangeBillValidator.getLeaseInitFromCache(bill);
        Date endDate = leaseInit.getDate("curperiod.enddate");
        Date beginDate = leaseInit.getDate("curperiod.begindate");
        Date effectiveDate = bill.getDate("effectivedate");
        boolean isFutureEffective = DateUtil.compareShortDate((Date)effectiveDate, (Date)endDate) > 0;
        Date checkStartDate = isFutureEffective ? effectiveDate : beginDate;
        long leaseContractId = bill.getLong(Fa.id((String)"leasecontract"));
        boolean hasVoucher = LeaseChangeBillValidator.checkRentSettleHasVoucherAfterDate(leaseContractId, checkStartDate);
        if (hasVoucher) {
            if (isFutureEffective) {
                errorInfo.add(ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u6240\u5728\u671f\u95f4\u53ca\u540e\u7eed\u671f\u95f4\u7684\u8ba1\u606f\u4e0e\u644a\u9500\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LeaseChangeBillValidator_36", (String)"fi-fa-business", (Object[])new Object[0]));
            } else {
                errorInfo.add(ResManager.loadKDString((String)"\u4e3b\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u53ca\u540e\u7eed\u671f\u95f4\u7684\u8ba1\u606f\u4e0e\u644a\u9500\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LeaseChangeBillValidator_37", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
        return errorInfo;
    }

    private static boolean checkRentSettleHasVoucherAfterDate(long leaseContractId, Date date) {
        QFilter[] filters = new QFilter[]{new QFilter("leasecontract", "=", (Object)leaseContractId), new QFilter("settledate", ">=", (Object)date)};
        DynamicObjectCollection rentSettle = QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)"id", (QFilter[])filters);
        List<Object> rentSettleIds = rentSettle.stream().map(v -> v.get("id")).collect(Collectors.toList());
        return FaDepreUtil.hashVouncherV2(rentSettleIds, "fa_lease_rent_settle");
    }

    private static List<String> checkPayPlanIsPushOrPaid(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        Date effectiveDate = bill.getDate("effectivedate");
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        leaseContract = LeaseChangeBillValidator.reloadContractFromCache(leaseContract.getPkValue());
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        boolean findErrData = false;
        for (DynamicObject row : planEntry) {
            Date planPayDate = row.getDate("planpaydate");
            if (DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) < 0) continue;
            BigDecimal realPayAmount = row.getBigDecimal("realpayamount");
            if (BigDecimal.ZERO.compareTo(realPayAmount) != 0) {
                findErrData = true;
                break;
            }
            boolean isPush = BFTrackerServiceHelper.isPush((String)"fa_lease_pay_plan", (Long)((Long)row.getPkValue()));
            if (!isPush) continue;
            findErrData = true;
            break;
        }
        if (findErrData) {
            errorInfo.add(ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u540e\u4ed8\u6b3e\u8ba1\u5212\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u6216\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e3a0\u3002", (String)"LeaseChangeBillValidator_38", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static boolean checkContractBizStatus(DynamicObject bill) {
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        String bizStatus = leaseContract.getString("bizstatus");
        return LeaseContractBizStatus.A.name().equals(bizStatus);
    }

    private static boolean checkLeaseChangeBillIsPush(DynamicObject bill) {
        return "C".equals(bill.getString("pushstatus"));
    }

    private static boolean checkRentSettleHasVoucherAfterAmortizationDate(DynamicObject bill) {
        Date amortizationDate = bill.getDate("amortizationdate");
        long leaseContractId = bill.getLong(Fa.id((String)"leasecontract"));
        return LeaseChangeBillValidator.checkRentSettleHasVoucherAfterDate(leaseContractId, amortizationDate);
    }

    private static List<String> checkAmortizationPeriodIsNull(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        long leaseContractId = bill.getLong(Fa.id((String)"leasecontract"));
        QFilter[] rentSettleFilters = new QFilter[]{new QFilter("leasecontract", "=", (Object)leaseContractId), new QFilter("amortizationperiod", "=", (Object)0L)};
        boolean existsRentSettle = QueryServiceHelper.exists((String)"fa_lease_rent_settle", (QFilter[])rentSettleFilters);
        if (existsRentSettle) {
            errorInfo.add(ResManager.loadKDString((String)"\u5b58\u5728\u644a\u9500\u4e0e\u8ba1\u606f\u7684\u201c\u644a\u9500\u671f\u95f4\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4\u5e76\u5347\u7ea7\u6570\u636e\u3002", (String)"LeaseChangeBillValidator_39", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        QFilter[] interestDetailFilters = new QFilter[]{new QFilter("leasecontract", "=", (Object)leaseContractId), new QFilter(Fa.dot((String[])new String[]{"detailentry", "amortizationperiod"}), "=", (Object)0L)};
        boolean existsInterestDetail = QueryServiceHelper.exists((String)"fa_interest_detail", (QFilter[])interestDetailFilters);
        if (existsInterestDetail) {
            errorInfo.add(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u606f\u660e\u7ec6\u7684\u201c\u644a\u9500\u671f\u95f4\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4\u5e76\u5347\u7ea7\u6570\u636e\u3002", (String)"LeaseChangeBillValidator_40", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        return errorInfo;
    }

    private static DynamicObject getLeaseInitFromCache(DynamicObject bill) {
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        long orgId = leaseContract.getLong(Fa.id((String)"org"));
        QFilter[] filter = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        String fields = Fa.comma((String[])new String[]{"enable", "status", "curperiod.begindate", "curperiod.enddate"});
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fa_lease_init", (String)fields, (QFilter[])filter);
    }

    private static DynamicObject reloadContractFromCache(Object pk) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"fa_lease_contract");
    }

    private static boolean checkExemptPropertyError(DynamicObject aftContract, DynamicObject oriLeaseContract) {
        DynamicObjectWrapper wrapper;
        Boolean isExempt4Cal;
        boolean oriLeaseIsExempt = oriLeaseContract.getBoolean("isexempt");
        return oriLeaseIsExempt && (isExempt4Cal = LeaseContractCal.getIsExempt(wrapper = new DynamicObjectWrapper(aftContract))) == false;
    }
}

