/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator.lease;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.enums.lease.TransitionPlan;
import kd.fi.fa.business.lease.LeaseFutureBizChecker;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.model.LeaseTerminationParam;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class TerminationValidator {
    private final List<LeaseTerminationParam> params;

    public TerminationValidator(List<LeaseTerminationParam> params) {
        this.params = params;
    }

    public List<String> validate() {
        List<String> errorInfo = this.validateMustInput();
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo.addAll(this.validateData());
        errorInfo.addAll(this.validateLeaseChangePush());
        errorInfo.addAll(this.checkAmortizationPeriodIsNull());
        return errorInfo.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private List<String> validateMustInput() {
        ArrayList<String> errorInfo = new ArrayList<String>(16);
        if (this.params == null || this.params.isEmpty()) {
            errorInfo.add(ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u5408\u540c\u3002", (String)"TerminationValidator_0", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        int seq = 1;
        for (LeaseTerminationParam param : this.params) {
            long changeModeId;
            Date leaseTerminationDate;
            long contractId = param.getContractId();
            if (contractId == 0L) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u79df\u8d41\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TerminationValidator_1", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            }
            if ((leaseTerminationDate = param.getTerminationDate()) == null) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u79df\u8d41\u7ec8\u6b62\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TerminationValidator_2", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            }
            if ((changeModeId = param.getChangeModeId()) == 0L) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u51cf\u5c11\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TerminationValidator_3", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            }
            ++seq;
        }
        return errorInfo;
    }

    private List<String> validateData() {
        ArrayList<String> errorInfo = new ArrayList<String>(16);
        Set<Long> contractIdSet = this.params.stream().map(LeaseTerminationParam::getContractId).collect(Collectors.toSet());
        String contractFields = Fa.comma((String[])new String[]{"id", "org", "leasetermstartdate", "leaseenddate", "sysswitchdate", "assetqtycreate", "isexempt", "transitionplan", "sourcetype", "initconfirmdate"});
        DynamicObjectCollection contracts = QueryServiceHelper.query((String)"fa_lease_contract", (String)contractFields, (QFilter[])new QFilter("id", "in", contractIdSet).toArray());
        Map<Long, DynamicObject> contractMap = contracts.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        if (!contractMap.keySet().containsAll(contractIdSet)) {
            contractIdSet.removeAll(contractMap.keySet());
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5408\u540cid\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5408\u540c\u6570\u636e\uff1a%s\u3002", (String)"TerminationValidator_4", (String)"fi-fa-business", (Object[])new Object[0]), contractIdSet.toArray()));
            return errorInfo;
        }
        Set<Long> orgIdSet = contracts.stream().map(v -> v.getLong("org")).collect(Collectors.toSet());
        Map<Long, Date> endDateMap = this.getMainBookByOrgIds(orgIdSet);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"fa_lease_contract", (Long[])contractIdSet.toArray(new Long[0]));
        Map initTargetBills = BFTrackerServiceHelper.findTargetBills((String)"fa_lease_contract_init", (Long[])contractIdSet.toArray(new Long[0]));
        HashSet cardIds = new HashSet(contractIdSet.size());
        if (targetBills.get("fa_card_real") != null) {
            cardIds.addAll((Collection)targetBills.get("fa_card_real"));
        }
        if (initTargetBills.get("fa_card_real") != null) {
            cardIds.addAll((Collection)initTargetBills.get("fa_card_real"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", cardIds), new QFilter("bizstatus", "!=", (Object)BizStatusEnum.READY.name())};
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"srcbillid", (QFilter[])filters);
        Set unReadyContractIds = realCards.stream().map(v -> v.getLong("srcbillid")).collect(Collectors.toSet());
        int seq = 1;
        for (LeaseTerminationParam param : this.params) {
            boolean checkLeaseTermStartDate;
            long contractId = param.getContractId();
            DynamicObject leaseContract = contractMap.get(contractId);
            Date leaseTermStartDate = leaseContract.getDate("leasetermstartdate");
            Date leaseEndDate = leaseContract.getDate("leaseenddate");
            long orgId = leaseContract.getLong("org");
            Date curPeriodEndDate = endDateMap.get(orgId);
            int assetQtyCreate = leaseContract.getInt("assetqtycreate");
            boolean isExempt = leaseContract.getBoolean("isexempt");
            String transitionPlan = leaseContract.getString("transitionplan");
            String sourceType = leaseContract.getString("sourcetype");
            Date initConfirmDate = leaseContract.getDate("initconfirmdate");
            Date sysSwitchDate = leaseContract.getDate("sysswitchdate");
            Date leaseTerminationDate = param.getTerminationDate();
            Date renewalEndDate = param.getRenewalEndDate();
            boolean bl = checkLeaseTermStartDate = LeaseContractSourceType.A.name().equals(sourceType) && (TransitionPlan.A.name().equals(transitionPlan) || TransitionPlan.C.name().equals(transitionPlan));
            if (checkLeaseTermStartDate) {
                if (DateUtil.compareDate((Date)leaseTerminationDate, (Date)leaseTermStartDate) < 0) {
                    String leaseTermStartDateStr = DateUtil.getShortDate().format(leaseTermStartDate);
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u201c\u79df\u8d41\u7ec8\u6b62\u65e5\u201d\u5fc5\u987b\u5728\u79df\u8d41\u671f\u5f00\u59cb\u65e5[%2$s]\u4e4b\u540e\u3002", (String)"TerminationValidator_5", (String)"fi-fa-business", (Object[])new Object[0]), seq, leaseTermStartDateStr));
                }
            } else if (DateUtil.compareDate((Date)leaseTerminationDate, (Date)initConfirmDate) < 0) {
                String initConfirmDateStr = DateUtil.getShortDate().format(initConfirmDate);
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u201c\u79df\u8d41\u7ec8\u6b62\u65e5\u201d\u5fc5\u987b\u5728\u521d\u59cb\u786e\u8ba4\u65e5[%2$s]\u4e4b\u540e\u3002", (String)"TerminationValidator_6", (String)"fi-fa-business", (Object[])new Object[0]), seq, initConfirmDateStr));
            }
            if (DateUtil.compareDate((Date)leaseTerminationDate, (Date)curPeriodEndDate) > 0) {
                String curPeriodEndDateStr = DateUtil.getShortDate().format(curPeriodEndDate);
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u201c\u79df\u8d41\u7ec8\u6b62\u65e5\u201d\u4e0d\u80fd\u5927\u4e8e\u4e3b\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u7ed3\u675f\u65e5[%2$s]\u3002", (String)"TerminationValidator_7", (String)"fi-fa-business", (Object[])new Object[0]), seq, curPeriodEndDateStr));
            }
            if (LeaseContractSourceType.B.name().equals(sourceType) && DateUtil.compareDate((Date)leaseTerminationDate, (Date)sysSwitchDate) < 0) {
                String sysSwitchDateStr = DateUtil.formatToString((Date)sysSwitchDate);
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u521d\u59cb\u5316\u5408\u540c\u7684\u201c\u79df\u8d41\u7ec8\u6b62\u65e5\u201d\u4e0d\u80fd\u65e9\u4e8e\u7cfb\u7edf\u5207\u6362\u65e5[%2$s]\u3002", (String)"TerminationValidator_8", (String)"fi-fa-business", (Object[])new Object[0]), seq, sysSwitchDateStr));
            }
            if (renewalEndDate != null) {
                if (!LeaseUtil.isExpirationTermination(leaseEndDate, leaseTerminationDate)) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u63d0\u524d\u7ec8\u6b62\u7684\u5408\u540c\u4e0d\u80fd\u5f55\u5165\u201c\u7eed\u79df\u7ed3\u675f\u65e5\u201d\u3002", (String)"TerminationValidator_9", (String)"fi-fa-business", (Object[])new Object[0]), seq));
                } else if (DateUtil.compareDate((Date)renewalEndDate, (Date)leaseTerminationDate) <= 0) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u201c\u7eed\u79df\u7ed3\u675f\u65e5\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u79df\u8d41\u7ec8\u6b62\u65e5\u201d\u3002", (String)"TerminationValidator_10", (String)"fi-fa-business", (Object[])new Object[0]), seq));
                }
            }
            if (unReadyContractIds.contains(contractId)) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5408\u540c\u4e0b\u63a8\u7684\u5361\u7247\u4e3a\u975e\u5c31\u7eea\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u7ec8\u6b62\u79df\u8d41\u3002", (String)"TerminationValidator_11", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            }
            if (!isExempt && assetQtyCreate > 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5408\u540c\u672a\u4e0b\u63a8\u751f\u6210\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u7ec8\u6b62\u79df\u8d41\u3002", (String)"TerminationValidator_12", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            }
            HashSet<String> includeItemNumbers = new HashSet<String>(4);
            includeItemNumbers.add("discountrate");
            includeItemNumbers.add("payruleentryentity");
            if (LeaseFutureBizChecker.existFutureLeaseChangeBill(null, contractId, leaseTerminationDate, includeItemNumbers)) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5408\u540c\u5b58\u5728\u540e\u7eed\u5f71\u54cd\u8d22\u52a1\u4fe1\u606f\u7684\u79df\u8d41\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u7ec8\u6b62\u79df\u8d41\u3002", (String)"TerminationValidator_13", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            }
            ++seq;
        }
        return errorInfo;
    }

    private List<String> validateLeaseChangePush() {
        ArrayList<String> errorInfo = new ArrayList<String>(16);
        List contractIds = this.params.stream().map(LeaseTerminationParam::getContractId).collect(Collectors.toList());
        DynamicObjectCollection leaseChangeBills = QueryServiceHelper.query((String)"fa_lease_change_bill", (String)"leasecontract", (QFilter[])new QFilter[]{new QFilter("leasecontract", "in", contractIds), new QFilter("pushstatus", "=", (Object)"A")});
        Set needPushContractIds = leaseChangeBills.stream().map(v -> v.getLong("leasecontract")).collect(Collectors.toSet());
        for (int i = 0; i < this.params.size(); ++i) {
            LeaseTerminationParam param = this.params.get(i);
            long contractId = param.getContractId();
            if (!needPushContractIds.contains(contractId)) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5408\u540c\u5b58\u5728\u672a\u4e0b\u63a8\u7684\u79df\u8d41\u53d8\u66f4\u5355\uff0c\u8bf7\u5148\u4e0b\u63a8\u3002", (String)"TerminationValidator_14", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
        }
        return errorInfo;
    }

    private List<String> checkAmortizationPeriodIsNull() {
        QFilter[] interestDetailFilters;
        DynamicObject interestDetail;
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        List contractIds = this.params.stream().map(LeaseTerminationParam::getContractId).collect(Collectors.toList());
        QFilter[] rentSettleFilters = new QFilter[]{new QFilter("leasecontract", "in", contractIds), new QFilter("amortizationperiod", "=", (Object)0L)};
        DynamicObject rentSettle = QueryServiceHelper.queryOne((String)"fa_lease_rent_settle", (String)"leasecontract", (QFilter[])rentSettleFilters);
        if (rentSettle != null) {
            long existsNullPeriodContractId = rentSettle.getLong("leasecontract");
            for (int i = 0; i < this.params.size(); ++i) {
                LeaseTerminationParam param = this.params.get(i);
                long contractId = param.getContractId();
                if (contractId != existsNullPeriodContractId) continue;
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5b58\u5728\u644a\u9500\u4e0e\u8ba1\u606f\u7684\u201c\u644a\u9500\u671f\u95f4\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4\u5e76\u5347\u7ea7\u6570\u636e\u3002", (String)"TerminationValidator_15", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
                return errorInfo;
            }
        }
        if ((interestDetail = QueryServiceHelper.queryOne((String)"fa_interest_detail", (String)"leasecontract", (QFilter[])(interestDetailFilters = new QFilter[]{new QFilter("leasecontract", "in", contractIds), new QFilter(Fa.dot((String[])new String[]{"detailentry", "amortizationperiod"}), "=", (Object)0L)}))) != null) {
            long existsNullPeriodContractId = interestDetail.getLong("leasecontract");
            for (int i = 0; i < this.params.size(); ++i) {
                LeaseTerminationParam param = this.params.get(i);
                long contractId = param.getContractId();
                if (contractId != existsNullPeriodContractId) continue;
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5b58\u5728\u8ba1\u606f\u660e\u7ec6\u7684\u201c\u644a\u9500\u671f\u95f4\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4\u5e76\u5347\u7ea7\u6570\u636e\u3002", (String)"TerminationValidator_16", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
                return errorInfo;
            }
        }
        return errorInfo;
    }

    private Map<Long, Date> getMainBookByOrgIds(Set<Long> orgIdSet) {
        QFilter[] filters = new QFilter[]{new QFilter("ismainbook", "=", (Object)true), new QFilter("org", "in", orgIdSet)};
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"org, curperiod.enddate enddate", (QFilter[])filters);
        return assetBooks.stream().collect(Collectors.toMap(v -> v.getLong("org"), v -> v.getDate("enddate")));
    }
}

